package com.system.constants;

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.system.dao.KingDeeCommonConfigMapper;
import com.system.transfer.kingdee.KingDeeCommonConfigListOutVoRecords;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Inori
 */
@Component
public class KingDeeCommonSyncConstants {

    private Map<Integer, Map<String, Map<String, String>>> map = new ConcurrentHashMap<>();

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;


    @PostConstruct
    public void init() {
        List<KingDeeCommonConfigListOutVoRecords> recordsList = kingDeeCommonConfigMapper.kingDeeCommonConfigList(3);
        this.map = GetMap(recordsList);
    }


    public Map<Integer, Map<String, Map<String, String>>> GetMap(List<KingDeeCommonConfigListOutVoRecords> recordsList) {
        Map<Integer, Map<String, Map<String, String>>> map = new ConcurrentHashMap<>();
        if (!CollectionUtils.isEmpty(recordsList)) {
            List<Integer> idList = recordsList.stream().map(KingDeeCommonConfigListOutVoRecords::getId).collect(Collectors.toList());
            List<Map<String, Object>> fieldMappingList = kingDeeCommonConfigMapper.kingDeeFieldMappingList(idList);

            List<Integer> keyList = recordsList.stream().map(KingDeeCommonConfigListOutVoRecords::getPlatformProductRelationId).distinct().collect(Collectors.toList());
            for (Integer key : keyList) {
                map.put(key, new ConcurrentHashMap<>(5));
                Map<String, Map<String, String>> config = map.get(key);

                List<KingDeeCommonConfigListOutVoRecords> temp01List = recordsList.stream().filter(m -> key.equals(m.getPlatformProductRelationId())).collect(Collectors.toList());
                for (KingDeeCommonConfigListOutVoRecords records : temp01List) {
                    List<Map<String, Object>> temp02List = fieldMappingList.stream().filter(m -> records.getId().equals(m.get("id"))).collect(Collectors.toList());
                    config.put(records.getSFormId(), this.encapsulationKingDeeFiledConfig(records, temp02List));
                }
            }
        }

        return map;
    }

    public List<Map<String, String>> get(String sFormId) {
        List<Map<String, String>> configList = new ArrayList<>();
        for (Map.Entry<Integer, Map<String, Map<String, String>>> entry : this.map.entrySet()) {
            Map<String, Map<String, String>> temp = entry.getValue();

            Map<String, String> result = temp.get(sFormId);
            if (!CollectionUtils.isEmpty(result)) {
                configList.add(result);
            }
        }
        return configList;
    }

    public void refresh(Integer id, String sFormId) {
        KingDeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(id);

        Map<String, Map<String, String>> temp = this.map.get(records.getPlatformProductRelationId());
        if (!CollectionUtils.isEmpty(temp)) {
            temp.remove(sFormId);
            List<Map<String, Object>> tempList = kingDeeCommonConfigMapper.kingDeeFieldMappingList(Stream.of(records.getId()).collect(Collectors.toList()));
            temp.put(records.getSFormId(), this.encapsulationKingDeeFiledConfig(records, tempList));
        }
    }

    public Map<String, String> encapsulationKingDeeFiledConfig(KingDeeCommonConfigListOutVoRecords records, List<Map<String, Object>> tempList) {
        Map<String, String> temp = new HashMap<>(6);
        temp.put("productId", records.getPlatformProductRelationId().toString());
        temp.put("sFormId", records.getSFormId());
        temp.put("docType", records.getDocType());
        temp.put("name", records.getName());
        temp.put("direction", records.getDirection());
        temp.put("primaryKeyField", records.getPrimaryKeyField());
        temp.put("entryPrimaryKeyField", records.getEntryPrimaryKeyField());
        temp.put("mesEntryName", records.getMesEntryName());
        temp.put("plugInUrl", records.getPlugInUrl());
        temp.put("customSql", records.getCustomSql());
        temp.put("kingDeeFiledDetail", JsonUtil.toString(tempList));
        return temp;
    }

    /**
     * 封装金蝶字段
     */
    public static Map<String, String> encapsulationKingDeeField(List<Map<String, String>> fieldList) {
        Map<String, String> key = new LinkedHashMap<>();
        for (Map<String, String> map : fieldList) {
            String kingDeeField = map.get("kingdeeField");
            String retrievalField = map.get("retrievalField");
            if (StringUtil.isNotBlank(retrievalField)) {
                kingDeeField = kingDeeField + "." + retrievalField;
            }
            key.put(kingDeeField, kingDeeField);
        }
        return key;
    }

    /**
     * 封装第三方字段
     */
    public static void encapsulationThirdPartyField(List<Object> entry, List<Map<String, String>> fieldList, Map<String, Object> map, List<Map<String, Object>> imsList) {
        for (int i = 0; i < fieldList.size(); i++) {
            map.put(fieldList.get(i).get("thirdPartyField"), entry.get(i));
        }

    }

    /**
     * 封装第三方字段,有覆盖风险遗弃
     */
    @Deprecated
    public static void encapsulationThirdPartyFieldOld(List<List<Object>> list, List<Map<String, String>> fieldList, Map<String, Object> map, List<Map<String, Object>> imsList) {
        for (List<Object> objectList : list) {
            for (int i = 0; i < fieldList.size(); i++) {
                map.put(fieldList.get(i).get("thirdPartyField"), objectList.get(i));
            }
        }
    }

    /**
     * 封装第三方字段
     */
    public static void encapsulationThirdPartyFieldBySql(List<Object> dataList, List<Map<String, String>> fieldList, Map<String, Object> map) {
        List<Map<String, Object>> imsList = new ArrayList<>();
        for (Object object : dataList) {
            Map<String, Object> temp = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);

            Map<String, Object> request = new LinkedHashMap<>();
            for (Map<String, String> temp02Map : fieldList) {
                if (Constants.TRUE.equals(temp02Map.get("isEntryField"))) {
                    request.put(temp02Map.get("thirdPartyField"), temp.get(temp02Map.get("kingdeeField")));
                } else {
                    map.put(temp02Map.get("thirdPartyField"), temp.get(temp02Map.get("kingdeeField")));
                }
            }
            if (!CollectionUtils.isEmpty(request)) {
                imsList.add(request);
            }
        }
        map.put("children", imsList);
    }


}
