package com.system.controller;

import com.system.service.IFormTableStructureService;
import com.system.transfer.configure.FormTableStructureConfigRefreshInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "表单配置")
@RestController
@RequestMapping("/api")
public class FormTableStructureController {

    @Autowired
    private IFormTableStructureService formTableStructureService;


    @ApiOperation("表单配置刷新")
    @PostMapping("/form/table/structure/config/refresh")
    public RestResponse formTableStructureConfigRefresh(@RequestBody FormTableStructureConfigRefreshInVo inVo) {
        formTableStructureService.formTableStructureConfigRefresh(inVo);
        return RestResponse.success();
    }


}
