package com.system.utils;

import com.system.transfer.configure.TableStructureCreateInVoRecords;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
public class TableStructureUtil {

    public static List<TableStructureCreateInVoRecords> getFieldList(String json) {
        List<TableStructureCreateInVoRecords> recordsList = new ArrayList<>();

        Map<String, Object> map = JsonUtil.toMap(json, String.class, Object.class);

        String listJson = JsonUtil.toString(map.get("list"));
        List<Object> objectList = JsonUtil.toList(listJson, Object.class);
        for (Object object : objectList) {
            TableStructureCreateInVoRecords records = new TableStructureCreateInVoRecords();

            Map<String, Object> temp = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);
            records.setKey((String) temp.get("key"));
            records.setDbFieldName((String) temp.get("dbFieldName"));
            records.setDbFieldDefault("NULL");
            records.setDbFieldComment("'" + temp.get("dbFieldComment") + "'");

            recordsList.add(records);
        }

        return recordsList;
    }


}
