package com.system.service.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.system.constants.KingDeeCommonSyncConstants;
import com.system.dao.KingDeeCommonConfigMapper;
import com.system.dao.SynchronizationRecordsMapper;
import com.system.kingdee.KingDeeCommonSyncApi;
import com.system.kingdee.KingDeeSynchronizationApi;
import com.system.service.IKingDeeCommonSyncService;
import com.system.service.ISynchronizationService;
import com.system.transfer.kingdee.KingDeeCommonConfigListOutVoRecords;
import com.system.transfer.kingdee.SynchronizationRecordsListOutVoRecords;
import com.system.utils.SnowFlakeIdUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.PostConstruct;

/**
 * @author Inori
 */
@Service
public class SynchronizationServiceImpl implements ISynchronizationService {

    private ExecutorService threadPool = new ThreadPoolExecutor(5, 5,
            0L,
            TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<>(1024),
            new ThreadFactoryBuilder().setNameFormat("sync-pool-%d").build(),
            new ThreadPoolExecutor.AbortPolicy());

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;
    
    @Autowired
    private KingDeeCommonSyncApi kingDeeCommonSyncApi;
    
    @Autowired
    private IKingDeeCommonSyncService kingDeeCommonSyncService;

    @Autowired
    private KingDeeSynchronizationApi kingDeeSynchronizationApi;

    @Autowired
    private KingDeeCommonSyncConstants kingDeeCommonSyncConstants;

    @Autowired
    private SynchronizationRecordsMapper synchronizationRecordsMapper;

    @Override
    public void kingdeeSynchronization() {
        threadPool.execute(this::synchronization);
    }

    @Override
    public void kingdeeManualSynchronization() {
        threadPool.execute(() -> {
            List<SynchronizationRecordsListOutVoRecords> recordsList = synchronizationRecordsMapper.synchronizationRecordsListByStatus(Stream.of(1, 2).collect(Collectors.toList()));

            for (SynchronizationRecordsListOutVoRecords records : recordsList) {
                if (!"LQKJ_IMSSync".equals(records.getSFormId())) {
                    kingDeeCommonSyncService.synchronization(records.getId(), records.getSFormId(), records.getDataId(), records.getEntryId());
                }
            }
        });
    }

    @Override
    public void  manualSynchronizationByParam(String docType) {
    	
    	List<KingDeeCommonConfigListOutVoRecords> records = kingDeeCommonConfigMapper.getKingDeeCommonConfigByDocType(docType);
    	for(KingDeeCommonConfigListOutVoRecords record:records)
    	{
    		if(record.getOperation() == 4)
    		{
    			pullDatas(record);
    		}
    	}
    }
    
    /**
     * 拉去数据
     */
    private void pullDatas(KingDeeCommonConfigListOutVoRecords record)
    {
    	List<Integer> ids = new ArrayList<Integer>();
    	ids.add(record.getId());
    	
    	List<Map<String, Object>> fieldMappings = kingDeeCommonConfigMapper.kingDeeFieldMappingList(ids);
    	List<Map<String, String>> fieldMaps = new ArrayList<Map<String,String>>();
        String queueId = SnowFlakeIdUtil.generateId().toString();
        for(Map<String, Object> fieldMapping:fieldMappings)
        {
        	Map<String, String> fieldMap = new HashMap<String, String>();
        	fieldMaps.add(fieldMap);
        	for(Map.Entry<String, Object> fieldEntry :fieldMapping.entrySet())
        	{
        		fieldMap.put(fieldEntry.getKey(), fieldEntry.getValue() == null?"":fieldEntry.getValue().toString());
        	}
        }

        Map<String, String> config = kingDeeCommonSyncConstants.encapsulationKingDeeFiledConfig(record, fieldMappings);
    	
        Map<String, String> where = new HashMap<String, String>();
        where.put("1", "1");
        
        List<Map<String, Object>> request = kingDeeCommonSyncApi.synchronization(config, queueId, fieldMaps, where);
    	int i = 0;
    }

    @Transactional(rollbackFor = Exception.class)
    public void synchronization() {
        List<Map<String, Object>> tempList = kingDeeSynchronizationApi.synchronization();

        if (!CollectionUtils.isEmpty(tempList)) {
            synchronizationRecordsMapper.synchronizationRecordsTempCreate(tempList);
        }

        List<String> objectList = tempList.stream().filter(m -> !"LQKJ_IMSSync".equals(m.get("sFormId"))).map(m -> String.valueOf(m.get("fid"))).collect(Collectors.toList());
        List<Map<String, Object>> dataList = new ArrayList<>();

        for (String fid : objectList) {
            //将金蝶云的数据同步该成1
            Map<String, Object> result = new HashMap<>(3);
            result.put("FID", fid);
            result.put("F_LQKJ_SyncCheck", "1");
            result.put("F_LQKJ_SyndDatetime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            dataList.add(result);
        }
        //修改金蝶云是否同步
        kingDeeSynchronizationApi.batchAdd(dataList);

        List<Map<String, Object>> mapList = synchronizationRecordsMapper.synchronizationRecordsTempList();
        if (!CollectionUtils.isEmpty(mapList)) {
            synchronizationRecordsMapper.synchronizationRecordsCreate(mapList);

            List<Integer> idList = mapList.stream().map(m -> Integer.parseInt(m.get("id").toString())).collect(Collectors.toList());
            synchronizationRecordsMapper.synchronizationRecordsTempDelete(idList);
        }

        threadPool.execute(() -> {
            List<SynchronizationRecordsListOutVoRecords> recordsList = synchronizationRecordsMapper.synchronizationRecordsListByStatus(Stream.of(0).collect(Collectors.toList()));
            List<Integer> idList = recordsList.stream().map(SynchronizationRecordsListOutVoRecords::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idList)) {
                synchronizationRecordsMapper.synchronizationRecordsUpdateByIdList(idList);
            }

            for (SynchronizationRecordsListOutVoRecords records : recordsList) {
                if (!"LQKJ_IMSSync".equals(records.getSFormId())) {
                    kingDeeCommonSyncService.synchronization(records.getId(), records.getSFormId(), records.getDataId(), records.getEntryId());
                }
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
            }
        });
    }


}
