package com.system.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.system.constants.KingDeeCommonSyncConstants;
import com.system.constants.KingDeeConstants;
import com.system.dao.DatabaseTableMapper;
import com.system.dao.SynchronizationRecordsMapper;
import com.system.kingdee.KingDeeCommonSyncApi;
import com.system.service.IKingDeeCommonSyncService;
import com.system.transfer.configure.TableStructureListOutVoRecords;
import com.system.transfer.kingdee.SynchronizationRecordsUpdateInVo;
import com.system.utils.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class KingDeeCommonSyncServiceImpl implements IKingDeeCommonSyncService {

    @Autowired
    private KingDeeCommonSyncConstants kingDeeCommonSyncConstants;

    @Autowired
    private KingDeeCommonSyncApi kingDeeCommonSyncApi;

    @Autowired
    private DatabaseTableMapper databaseTableMapper;

    @Autowired
    private SynchronizationRecordsMapper synchronizationRecordsMapper;

    @Autowired
    private ProductLogUtil productLogUtil;


    @Override
    public void synchronization(Integer id, String sFormId, String dataId, String entryId) {
        System.out.println("id"+id);
        System.out.println("sFormId"+sFormId);
        System.out.println("dataId"+dataId);
        System.out.println("entryId"+entryId);
        //查询表单配置
        List<Map<String, String>> configList = kingDeeCommonSyncConstants.get(sFormId);
        if (CollectionUtils.isEmpty(configList)) {
            synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, SnowFlakeIdUtil.generateId().toString(), "sFormId为: " + sFormId + " 的表单配置不存在", 2));
            return;
        }

        for (Map<String, String> config : configList) {
            String queueId = SnowFlakeIdUtil.generateId().toString();

            List<Object> objectList = JsonUtil.toList(config.get("kingDeeFiledDetail"), Object.class);
            List<Map<String, String>> fieldList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, String.class)).collect(Collectors.toList());

            List<Map<String, Object>> request = new ArrayList<>();
            List<Object> dataList = new ArrayList<>();

            String customSql = config.get("customSql");
            String primaryKeyField = config.get("primaryKeyField");
            if (StringUtil.isNotBlank(customSql)) {
                List<Object> tempList = this.encapsulationGetBySql(config, queueId, id, customSql, dataId, entryId);
                if (!CollectionUtils.isEmpty(tempList)) {
                    dataList.addAll(tempList);

                    Map<String, Object> response = new LinkedHashMap<>();
                    KingDeeCommonSyncConstants.encapsulationThirdPartyFieldBySql(dataList, fieldList, response);
                    request.add(response);
                    System.out.println("response===="+response);
                    kingDeeCommonSyncApi.databaseTableDataCreateBySql(config.get("docType"), queueId, dataList, fieldList, primaryKeyField);
                }

                System.out.println("request1===="+request);
            } else {
                //设置需要同步的主键
                Map<String, String> where = new HashMap<>(1);
                where.put(config.get("primaryKeyField"), dataId.toString());
                String entryPrimaryKeyField = config.get("entryPrimaryKeyField");
                if (StringUtil.isNotBlank(entryPrimaryKeyField)) {
                    if (StringUtil.isNotNull(entryId)) {
                        where.put(entryPrimaryKeyField, entryId.toString());
                    }
                }

                request = kingDeeCommonSyncApi.synchronization(config, queueId, fieldList, where);
                System.out.println("request2===="+request);
                if (request.get(0).containsKey(Constants.FALSE)) {
                    synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, queueId, request.get(0).get(Constants.FALSE).toString(), 2));
                    return;
                }
            }

            String plugInUrl = config.get("plugInUrl");
            if (StringUtil.isNotBlank(plugInUrl)) {
                List<Map<String, Object>> tempList = this.encapsulationGetByHttp(config, queueId, id, plugInUrl, request, dataList);
                if (!CollectionUtils.isEmpty(tempList)) {
                    System.out.println("tempList===="+tempList);
                    request = tempList;
                }
                System.out.println("request3===="+request);
            }

            this.encapsulationRequest(config, queueId, id, request);

            //TODO 上传附件
        }
    }

    /**
     * 查询 SQL
     */
    private List<Object> encapsulationGetBySql(Map<String, String> config, String queueId, Integer id, String customSql, String dataId, String entryId) {
        customSql = customSql.replaceAll("@" + config.get("primaryKeyField"), String.valueOf(dataId));
        customSql = customSql.replaceAll("@" + config.get("entryPrimaryKeyField"), String.valueOf(entryId));
        //DES加密
        String request = DesHelperUtil.encrypt(customSql, StandardCharsets.UTF_8, "MES&&DES");
        String customSqlResult = kingDeeCommonSyncApi.kingDeeGetBySql(config, queueId, config.get("name") + "执行SQL", request);

        Map<String, Object> temp = JsonUtil.toMap(customSqlResult, String.class, Object.class);
        if (!CollectionUtils.isEmpty(temp)) {
            if (temp.containsKey(KingDeeConstants.CODE_NAME) && KingDeeConstants.SUCCESS_CODE.equals(temp.get(KingDeeConstants.CODE_NAME))) {
                List<Object> dataList = JsonUtil.toList(JsonUtil.toString(temp.get("data")), Object.class);
                if (!CollectionUtils.isEmpty(dataList)) {
                    return dataList;
                }
            } else {
                synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, queueId, customSqlResult, 2));
                return new ArrayList<>();
            }
        } else {
            synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, queueId, customSqlResult, 2));
            return new ArrayList<>();
        }

        return new ArrayList<>();
    }

    /**
     * 查询 HTTP
     */
    private List<Map<String, Object>> encapsulationGetByHttp(Map<String, String> config, String queueId, Integer id, String plugInUrl, List<Map<String, Object>> request, List<Object> dataList) {
        Map<String, Object> data = new HashMap<>(1);
        if (!CollectionUtils.isEmpty(dataList)) {
            data.put("data", dataList);
        } else {
            data.put("data", request);
        }
        String response = kingDeeCommonSyncApi.sendPlugInUnit(plugInUrl, JsonUtil.toString(data));
        productLogUtil.productHttpLogCreate(Integer.valueOf(config.get("productId")), queueId, id, config.get("name") + "执行插件", config.get("docType"), config.get("direction"), JsonUtil.toString(data), response);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map) && KingDeeConstants.SUCCESS_CODE.equals(map.get(KingDeeConstants.CODE_NAME))) {
            List<Object> tempList = JsonUtil.toList(JsonUtil.toString(map.get(KingDeeConstants.DATA_NAME)), Object.class);
            return tempList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class)).collect(Collectors.toList());
        }

        return new ArrayList<>();
    }
    
    /**
     * Unicode转 汉字字符串
     *
     * @param str
     *            \u6728
     * @return '木' 26408
     */
    public static String unicodeToString(String str) {

      Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
      Matcher matcher = pattern.matcher(str);
      char ch;
      while (matcher.find()) {
        // group 6728
        String group = matcher.group(2);
        // ch:'木' 26408
        ch = (char) Integer.parseInt(group, 16);
        // group1 \u6728
        String group1 = matcher.group(1);
        str = str.replace(group1, ch + "");
      }
      return str;
    }

    
    /**
     * 同步至第三方
     */
    private void encapsulationRequest(Map<String, String> config, String queueId, Integer id, List<Map<String, Object>> dataList) {
        for(Map<String, Object> curData:dataList){
            curData.put("docType",config.get("docType"));
            System.out.println("curData"+curData);
            String response = kingDeeCommonSyncApi.sendThirdParty(JsonUtil.toString(curData));
            response = unicodeToString(response);

            //记录第三方日志
            productLogUtil.productHttpLogCreate(Integer.valueOf(config.get("productId")), queueId, id, config.get("name"), config.get("docType"), config.get("direction"), JsonUtil.toString(curData), response);

            TableStructureListOutVoRecords records = databaseTableMapper.tableStructureOne(config.get("docType"));
            Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
            if (!CollectionUtils.isEmpty(map)) {
                if (!KingDeeConstants.SUCCESS_CODE.equals(map.get(KingDeeConstants.CODE_NAME))) {
                    if (StringUtil.isNotNull(records)) {
                        kingDeeCommonSyncApi.databaseTableDataDelete(records.getDbTableName(), queueId);
                    }
                }
                if (KingDeeConstants.OVERTIME_CODE.equals(map.get(KingDeeConstants.CODE_NAME))) {
                    Thread.currentThread().interrupt();
                }
            } else {
                if (StringUtil.isNotNull(records)) {
                    kingDeeCommonSyncApi.databaseTableDataDelete(records.getDbTableName(), queueId);
                }
            }
        }
    }
}

