package com.system.kingdee;

import com.system.api.KingDeeApi;
import com.system.constants.KingDeeCommonSyncConstants;
import com.system.dao.DatabaseTableMapper;
import com.system.transfer.configure.TableStructureCreateInVoRecords;
import com.system.transfer.configure.TableStructureListOutVoRecords;
import com.system.utils.DesHelperUtil;
import com.system.utils.JsonUtil;
import com.system.utils.KingDeeUtil;
import com.system.utils.StringUtil;
import com.system.utils.TableStructureUtil;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class KingDeeCommonSyncApi {

    @Autowired
    private KingDeeApi kingDeeApi;

    @Autowired
    private DatabaseTableMapper databaseTableMapper;

    @Autowired
    private KingDeeCommonSyncApi kingDeeCommonSyncApi;


    /**
     * 获取金蝶云数据
     */
    public List<Map<String, Object>> synchronization(Map<String, String> config, String queueId, List<Map<String, String>> fieldList, Map<String, String> where) {
        
    	String customSql = config.get("customSql");
    	Map<String, String> key = KingDeeCommonSyncConstants.encapsulationKingDeeField(fieldList);
        String primaryKeyField = config.get("primaryKeyField");
    	
    	if(StringUtils.isBlank(customSql))
    	{
	        key.put(primaryKeyField, primaryKeyField);
	        List<List<Object>> result = kingDeeApi.synchronization(config, queueId, key, where);
	        this.databaseTableDataCreate(config.get("docType"), queueId, result, key, primaryKeyField);
	        return encapsulationIms(config.get("mesEntryName"), queueId, result, fieldList);
    	}
    	else
    	{
            TableStructureListOutVoRecords records = databaseTableMapper.tableStructureOne(config.get("docType"));
	        String request = DesHelperUtil.encrypt(customSql, StandardCharsets.UTF_8, "MES&&DES");
	        String customSqlResult = kingDeeCommonSyncApi.kingDeeGetBySql(config, queueId, config.get("name") + "执行SQL", request);
	        Map<String, Object> temp = JsonUtil.toMap(customSqlResult, String.class, Object.class);
	        List<Map<String, Object>> tempList = (List<Map<String, Object>>)temp.get("data");
            this.createData(queueId, records, tempList, primaryKeyField);
	        return new ArrayList();
    	}

    }

    /**
     * 封装第三方字段
     */
    private List<Map<String, Object>> encapsulationIms(String mesEntryName, String queueId, List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, Object>> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {

            String errorName = "Errors";
            if (!list.get(0).get(0).toString().contains(errorName)) {
                for (List<Object> entry : list) {
                    Map<String, Object> map = new HashMap<>(fieldList.size());
                    List<Map<String, Object>> mesList = new ArrayList<>();
                    map.put("QUEUE_ID", queueId);

                    KingDeeCommonSyncConstants.encapsulationThirdPartyField(entry, fieldList, map, mesList);

                    if (!CollectionUtils.isEmpty(mesList)) {
                        map.put(mesEntryName, mesList);
                    }
                    result.add(map);
                }
            }
        } else {
            //如果有错误信息则返回
            String message = KingDeeUtil.getMessage(list.get(0).get(0));

            Map<String, Object> resultMap = new HashMap<>(1);
            resultMap.put("false", message);
            result.add(resultMap);
        }
        return result;
    }

    /**
     * 数据库表数据创建
     */
    private void databaseTableDataCreate(String docType, String queueId, List<List<Object>> dataList, Map<String, String> fieldList, String primaryKeyField) {
        System.out.println("databaseTableDataCreate======");
        TableStructureListOutVoRecords records = databaseTableMapper.tableStructureOne(docType);
        if (StringUtil.isNotNull(records)) {
            if (!CollectionUtils.isEmpty(dataList)) {
                String errorName = "Errors";
                if (!dataList.get(0).get(0).toString().contains(errorName)) {
                    List<Map<String, Object>> response = new ArrayList<>();
                    for (List<Object> data : dataList) {
                        Map<String, Object> request = new LinkedHashMap<>();
                        int i = 0;
                        for (Map.Entry<String, String> field : fieldList.entrySet()) {
                            request.put(field.getKey(), data.get(i));
                            i++;
                        }
                        request.put("queue_id", queueId);
                        response.add(request);
                    }

                    this.createData(queueId, records, response, primaryKeyField);
                }
            }
        }
    }

    /**
     * SQL查询结果: 数据库表数据创建
     */
    public void databaseTableDataCreateBySql(String docType, String queueId, List<Object> dataList, List<Map<String, String>> fieldList, String primaryKeyField) {
        System.out.println("databaseTableDataCreateBySql======");
        TableStructureListOutVoRecords records = databaseTableMapper.tableStructureOne(docType);
        if (StringUtil.isNotNull(records)) {
            List<Map<String, Object>> response = new ArrayList<>();

            for (Object object : dataList) {
                Map<String, Object> map = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);

                Map<String, Object> request = new LinkedHashMap<>();
                for (Map<String, String> temp : fieldList) {
                    request.put(temp.get("thirdPartyField"), map.get(temp.get("kingdeeField")));
                }
                request.put("queue_id", queueId);
                response.add(request);
            }

            this.createData(queueId, records, response, primaryKeyField);
        }
    }

    private void createData(String queueId, TableStructureListOutVoRecords records, List<Map<String, Object>> dataList, String primaryKeyField) {
        List<TableStructureCreateInVoRecords> recordsList = TableStructureUtil.getFieldList(records.getFormJson());
        List<String> dbFieldList = recordsList.stream().map(TableStructureCreateInVoRecords::getDbFieldName).collect(Collectors.toList());

        List<Map<String, Object>> tempList = new ArrayList<>();
        List<Object> ids = new ArrayList();
        for (Map<String, Object> data : dataList) {
            Map<String, Object> map = new LinkedHashMap<>();
            for (String fieldName : dbFieldList) {
                map.put(fieldName, data.get(fieldName));
                if (fieldName.equalsIgnoreCase(primaryKeyField)) {
                    ids.add(data.get(fieldName));
                }
            }
            tempList.add(map);
        }
        System.out.println("");
        System.out.println("dataList : " + dataList);
        System.out.println("records.getDbTableName() : " + records.getDbTableName());
        System.out.println("primaryKeyField : " + primaryKeyField);
        System.out.println("ids : " + ids);
        System.out.println("");
        if (!ids.isEmpty()) {
            databaseTableMapper.databaseTableDataDeleteByprimaryKeyField(records.getDbTableName(), primaryKeyField, ids);
        }
        if (!CollectionUtils.isEmpty(tempList)) {
            try {
                databaseTableMapper.databaseTableDataCreate(records.getDbTableName(), dbFieldList, tempList);
            } catch (Exception e) {
                System.out.println("数据库表: " + records.getDbTableName() + " 唯一标识: " + queueId + " 的数据创建失败");
            }
        }
    }

    /**
     * 数据库表数据删除
     */
    public void databaseTableDataDelete(String dbTableName, String queueId) {
        databaseTableMapper.databaseTableDataDelete(dbTableName, queueId);
    }

    public String sendThirdParty(String data) {
        return kingDeeApi.sendThirdParty(data, 1);
    }

    public String sendPlugInUnit(String plugInUrl, String data) {
        return kingDeeApi.sendPlugInUnit(plugInUrl, data, 1);
    }

    public String kingDeeGetBySql(Map<String, String> config, String queueId, String name, String request) {
        return kingDeeApi.kingDeeSelectBySql(config, queueId, request);
    }


}
