package com.system.service.impl;

import com.system.constants.Constants;
import com.system.constants.KingDeeCommonPushConstants;
import com.system.constants.KingDeeConstants;
import com.system.kingdee.KingDeeCommonPushApi;
import com.system.scheduler.KingDeeLoginScheduler;
import com.system.service.IKingDeeCommonPushService;
import com.system.transfer.kingdee.KingDeeUpdateThirdDataInVo;
import com.system.utils.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class KingDeeCommonPushServiceImpl implements IKingDeeCommonPushService {

    @Autowired
    private KingDeeCommonPushApi kingDeeCommonPushApi;

    @Autowired
    private KingDeeCommonPushConstants kingDeeCommonPushConstants;

    @Autowired
    private KingDeeLoginScheduler kingDeeLoginScheduler;

    @Autowired
    private ProductLogUtil productLogUtil;


    @Override
    public Object kingDeeUpdateThirdData(KingDeeUpdateThirdDataInVo inVo) {
        long start = System.currentTimeMillis();
        System.out.println("======kingDeeUpdateThirdData===inVo"+inVo);
        //记录IMS日志
        String queueId = String.valueOf(inVo.getData().get(0).get("QUEUE_ID"));
        if (productLogUtil.isExist(queueId) != 0) {
            return PushResultUtil.encapsulationTo(KingDeeConstants.ERROR_CODE, "操作失败! QUEUE_ID为: " + queueId + "的唯一标识已存在", new ArrayList<>());
        }
        Integer curId = 0;
        //读取配置
        List<Map<String, String>> configs = kingDeeCommonPushConstants.get(inVo.getDocType());
        List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for(Map<String, String> config:configs)
        {
	        if (CollectionUtils.isEmpty(config)) {
	            return PushResultUtil.encapsulationTo(KingDeeConstants.ERROR_CODE, "操作失败! 第三方标识为: " + inVo.getDocType() + " 的MES-ERP标识不存在", new ArrayList<>());
	        }
	
	        String sFormId = config.get("sFormId");
	        String fathersFormId = config.get("fathersFormId");
	        String fatherEntryName = config.get("fatherEntryName");
	        String pushRule = config.get("pushRule");
	        String isInTransaction = config.get("isInTransaction");
	        String isAutoPerform = config.get("isAutoPerform");
	        String name = StringUtil.isNotBlank(config.get("name")) ? config.get("name") : "自定义下推金蝶日志";
	        String kingDeeFiledDetail = config.get("kingDeeFiledDetail");
	        String plugInUrl = config.get("plugInUrl");
	        String customSql = config.get("customSql");
	
	        if(inVo.getData().size() == 0) 
	        {
	        	return PushResultUtil.encapsulationTo(KingDeeConstants.ERROR_CODE, "操作失败! 第三方标识为: " + inVo.getDocType() + " 的MES-ERP标识没有任何数据", new ArrayList<>());
	        }
	        Integer id = productLogUtil.productLogCreate(Integer.valueOf(config.get("productId")), queueId, name, config.get("docType"), config.get("direction"), JsonUtil.toString(inVo), "", 0, 0);
	
	        //是否执行插件
	        if (StringUtil.isNotBlank(plugInUrl)) {
	            long startTime = System.currentTimeMillis();
	            String response = kingDeeCommonPushApi.sendPlugInUnit(plugInUrl, JsonUtil.toString(inVo));
	
	            Integer costTime = Integer.valueOf(String.valueOf((System.currentTimeMillis() - startTime)));
	            productLogUtil.productLogCreate(Integer.valueOf(config.get("productId")), queueId, name + "执行插件", config.get("docType"), config.get("direction"), JsonUtil.toString(inVo), response, 1, costTime);
	
	            Map<String, Object> temp = JsonUtil.toMap(response, String.class, Object.class);
	            if (temp.containsKey(KingDeeConstants.CODE_NAME) && !KingDeeConstants.ERROR_CODE.equals(temp.get(KingDeeConstants.CODE_NAME))) {
	                if (temp.containsKey(KingDeeConstants.DATA)) {
	                    List<Object> objectList = JsonUtil.toList(JsonUtil.toString(temp.get("data")), Object.class);
	                    List<Map<String, Object>> dataList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class)).collect(Collectors.toList());
	                    if (!CollectionUtils.isEmpty(dataList)) {
	                        inVo.setData(dataList);
	                    }
	                }
	            } else {
	                Object result = PushResultUtil.encapsulationTo(KingDeeConstants.ERROR_CODE, "操作失败! docType为: " + inVo.getDocType() + " 的标识执行插件请求错误 " + temp.get("resultMsg"), new ArrayList<>());
	                productLogUtil.productLogUpdate(id, JsonUtil.toString(result), Integer.valueOf(String.valueOf((System.currentTimeMillis() - start))));
	                return result;
	            }
	        }
	
	        //是否执行SQL
	        if (StringUtil.isNotBlank(customSql)) {
	            return this.implementSql(inVo, config, queueId, id, start, customSql);
	        }
	
	        //保存
	        List<String> fatherEntryIdList = new ArrayList<>();
	        if (StringUtil.isNotBlank(fathersFormId)) {
	            fatherEntryIdList = inVo.getData().stream().filter(m -> m.containsKey("ERP_SIC")).map(m -> String.valueOf(m.get("ERP_SIC"))).collect(Collectors.toList());
	        }
	        Map<String, Object> data = new LinkedHashMap<>();
	        this.encapsulationData(data, "FormId", sFormId);
	        this.encapsulationData(data, "ConvertRule", pushRule);
	        this.encapsulationData(data, "SrcFormId", fathersFormId);
	        this.encapsulationData(data, "SrcEntryKey", fatherEntryName);
	        this.encapsulationData(data, "SrcIds", fatherEntryIdList);
	        this.encapsulationData(data, "IsInTransaction", "1".equals(isInTransaction));
	        this.encapsulationData(data, "isAutoSubmit", this.getIsAutoSubmit(Integer.valueOf(isAutoPerform)));
	        results.add(this.encapsulationRequest(inVo, config, queueId, id, start, kingDeeFiledDetail, data));
	        curId = id; 
        }

        Object result = PushResultUtil.encapsulationsTo(KingDeeConstants.SUCCESS_CODE, "", KingDeeUtil.getPushResultMap(results), results);

        long costTime = System.currentTimeMillis() - start;
        productLogUtil.productLogUpdate(curId, JsonUtil.toString(result), Integer.valueOf(String.valueOf(costTime)));
        return result;
    }

    /**
     * 封装请求及返回值
     */
    private Map<String, Object> encapsulationRequest(KingDeeUpdateThirdDataInVo inVo, Map<String, String> config, String queueId, Integer id, Long start, String kingDeeFiledDetail, Map<String, Object> data) {
        List<Object> objectList = JsonUtil.toList(kingDeeFiledDetail, Object.class);
        List<Map<String, String>> fieldList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, String.class)).collect(Collectors.toList());
        Map<String, Object> temp = new HashMap();
    	List<Map<String, Object>> dataList = inVo.getData();
        if("BAS_PreBaseDataTwo".equalsIgnoreCase(config.get("sFormId")))
        {
        	for(Map<String, Object> curData:dataList)
        	{
        		List<Map<String, Object>> curDataList = new ArrayList();
        		curDataList.add(curData);
            	temp = sendDataToKingdee(config, queueId, curDataList, fieldList, data);
        	}
        }
        else
        {
        	temp = sendDataToKingdee(config, queueId, dataList, fieldList, data);
        }


        return temp;
    }
    
    /**
     * 把数据发送给金蝶
     */
    private Map<String, Object> sendDataToKingdee(Map<String, String> config, String queueId, List<Map<String, Object>> dataList, List<Map<String, String>> fieldList, Map<String, Object> data)
    {        
        HashSet<String> attachments = new HashSet<String>();
    	String addTwo = kingDeeCommonPushApi.kingDeeUpdateThirdData(config, queueId, config.get("name"), dataList, fieldList, data, attachments);

	    Map<String, Object> temp = JsonUtil.toMap(addTwo, String.class, Object.class);
	    if (!CollectionUtils.isEmpty(temp) && KingDeeConstants.NOT_LOGGED_IN_CODE.equals(temp.get(KingDeeConstants.CODE_NAME))) {
	        kingDeeLoginScheduler.configureTasks();
	        addTwo = kingDeeCommonPushApi.kingDeeUpdateThirdData(config, queueId, config.get("name") + "重新登陆请求", dataList, fieldList, data, attachments);
	        temp = JsonUtil.toMap(addTwo, String.class, Object.class);
	    }
        System.out.println("========1:"+temp);
	    if(!CollectionUtils.isEmpty(temp) && KingDeeConstants.SUCCESS_CODE.equals(temp.get(KingDeeConstants.CODE_NAME)))
	    {
            System.out.println("========2:"+temp);
			for(Map<String, Object> resultData: (List<Map<String, Object>>)temp.get("resultData"))
			{
                System.out.println("========3:"+resultData);
				if(attachments.size() > 0)
				{
                    System.out.println("========4:"+attachments);
	    			int curId = Integer.parseInt(resultData.get("id").toString());
	            	for(String attachment:attachments)
	            	{
                        System.out.println("========5:"+attachment);
                        System.out.println("========6:"+curId);
	            		 kingDeeCommonPushApi.uploadAttachment(attachment, curId);
	            	}
				}
			}
	    }
	    
	    return temp;
    }

    private Object implementSql(KingDeeUpdateThirdDataInVo inVo, Map<String, String> config, String queueId, Integer id, Long start, String customSql) {
        String kingDeeSql = "";
        for (Map<String, Object> temp : inVo.getData()) {
            for (Map.Entry<String, Object> entry : temp.entrySet()) {
                if (customSql.contains("@" + entry.getKey())) {
                    kingDeeSql = customSql.replaceAll("@" + entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
        }

        if (StringUtil.isBlank(kingDeeSql)) {
            kingDeeSql = customSql;
        }
        //DES加密
        String request = DesHelperUtil.encrypt(kingDeeSql, StandardCharsets.UTF_8, "MES&&DES");
        String result = kingDeeCommonPushApi.kingDeeUpdateBySql(config, queueId, config.get("name") + "执行SQL", request);
        long costTime = System.currentTimeMillis() - start;

        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (map.containsKey(KingDeeConstants.CODE_NAME) && !KingDeeConstants.ERROR_CODE.equals(map.get(KingDeeConstants.CODE_NAME))) {
            Object object = PushResultUtil.encapsulationTo(KingDeeConstants.SUCCESS_CODE, "SQL执行成功", new ArrayList<>());
            productLogUtil.productLogUpdate(id, JsonUtil.toString(object), Integer.valueOf(String.valueOf(costTime)));
            return object;
        } else {
            String message = "";
            if (map.containsKey(KingDeeConstants.MSG_NAME)) {
                message = StringUtil.replaceBlank(String.valueOf(map.get(KingDeeConstants.MSG_NAME)));
            }
            Object object = PushResultUtil.encapsulationTo(KingDeeConstants.ERROR_CODE, "SQL执行失败 " + message, new ArrayList<>());
            productLogUtil.productLogUpdate(id, JsonUtil.toString(object), Integer.valueOf(String.valueOf(costTime)));
            return object;
        }
    }

    private void encapsulationData(Map<String, Object> data, String key, Object value) {
        if (value instanceof ArrayList) {
            if (!CollectionUtils.isEmpty(JsonUtil.toList(JsonUtil.toString(value), Object.class))) {
                data.put(key, value);
            }
        } else {
            if (StringUtil.isNotBlank(String.valueOf(value))) {
                data.put(key, value);
            }
        }
    }

    private String getIsAutoSubmit(Integer isAutoPerform) {
        String isAutoSubmit = "";
        if (Constants.ZERO.equals(isAutoPerform)) {
            isAutoSubmit = "draft";
        } else if (Constants.ONE.equals(isAutoPerform)) {
            isAutoSubmit = "save";
        } else if (Constants.TWO.equals(isAutoPerform)) {
            isAutoSubmit = "submit";
        } else if (Constants.THREE.equals(isAutoPerform)) {
            isAutoSubmit = "auto";
        }
        return isAutoSubmit;
    }


}
