package com.system.dao;

import com.system.transfer.kingdee.KingDeeCommonConfigListOutVoRecords;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
public interface KingDeeCommonConfigMapper {

    /**
     * 金蝶通用配置列表
     *
     * @param operation 操作(1-查询 2-创建/更新 3-同步)
     * @return 列表
     */
    List<KingDeeCommonConfigListOutVoRecords> kingDeeCommonConfigList(Integer operation);

    /**
     * 金蝶通用查询配置列表
     *
     * @return 列表
     */
    List<KingDeeCommonConfigListOutVoRecords> kingDeeCommonConfigGetList();

    /**
     * 金蝶通用配置
     *
     * @param id ID
     * @return 金蝶通用配置
     */
    KingDeeCommonConfigListOutVoRecords getKingDeeCommonConfigById(Integer id);
    
    /**
     * 类型
     * @param docType
     * @return
     */
    List<KingDeeCommonConfigListOutVoRecords> getKingDeeCommonConfigByDocType(String docType);

    /**
     * 金蝶通用配置字段映射列表
     *
     * @param idList ID列表
     * @return 字段映射列表
     */
    List<Map<String, Object>> kingDeeFieldMappingList(@Param("idList") List<Integer> idList);


}
