package com.system.kingdee;

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.system.api.KingDeeApi;
import com.system.dao.DatabaseTableMapper;
import com.system.dao.KingDeeCommonConfigMapper;
import com.system.transfer.configure.TableStructureListOutVoRecords;
import com.system.transfer.kingdee.KingDeeCommonConfigListOutVoRecords;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.Map.Entry;

import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

/**
 * @author Inori
 */
@Component
public class KingDeeCommonPushApi {

    @Autowired
    private KingDeeApi kingDeeApi;

    @Autowired
    private DatabaseTableMapper databaseTableMapper;

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;
    
    
    public String kingDeeUpdateThirdData(Map<String, String> config, String queueId, String name, List<Map<String, Object>> dataList, List<Map<String, String>> fieldList, Map<String, Object> data,HashSet<String> attachments) {
        data.put("Model", thirdPartyFieldToKingDee(dataList, fieldList, config.get("entryName"), attachments));
        return kingDeeApi.kingDeeDataPush(config, queueId, name, data);
    }
    
    public String uploadAttachment(String attachment, long Id)
    {
    	return kingDeeApi.uploadAttachment(attachment, Id);
    }

    /**
     * thirdPartyField字段转换成金蝶云待添加(其实都是下推后修改)字段
     */
    public Map<String, Object> thirdPartyFieldToKingDee(List<Map<String, Object>> dataList, List<Map<String, String>> fieldList, String entryName, HashSet<String> attachments) {
        Map<String, Object> modelMap = new LinkedHashMap<>(2);
        List<Map<String, Object>> list = new ArrayList<>();
        for (Map<String, Object> map : dataList) {
            Map<String, Object> entityMap = new LinkedHashMap<>(10);
            Map<String, Map<String, Object>> mapBillDatas = new HashMap();

            for (Map<String, String> field : fieldList) {
            	String fieldType = field.get("fieldType");
            	if(fieldType.equals("附件"))
            	{
            		attachments.add((String) map.get(field.get("thirdPartyField")));
            		continue;
            	}
                if (Constants.TRUE.equals(field.get("isEntryField"))) {
                    this.populateThirdPartyData(entityMap, map, field, mapBillDatas);
                    if (map.containsKey("ERP_SIC")) {
                        entityMap.put("ERP_SIC", map.get("ERP_SIC"));
                    }
                    if (map.containsKey("MES_CODE")) {
                        entityMap.put("MES_CODE", map.get("MES_CODE"));
                    }
                } else {
                    this.populateThirdPartyData(modelMap, map, field, mapBillDatas);
                }
            }
            
            SetMapFields(mapBillDatas);
            
            list.add(entityMap);
        }
        modelMap.put(entryName, list);

        return modelMap;
    }
    
    /**
     * 设置Map字段
     * @param mapBillDatas
     */
    private void SetMapFields(Map<String, Map<String, Object>> mapBillDatas)
    {
    	for(Entry<String, Map<String, Object>> mapBillData:mapBillDatas.entrySet())
    	{
    		String mapBill = mapBillData.getKey();
    		Map<String, Object> mapValue = mapBillData.getValue();
    		Map<String, Object> mapEntity = (Map<String, Object>)mapValue.get("mapEntity");
    		String kingDeeField = (String)mapValue.get("kingDeeField");
    		Map<String, Object> fieldValues = (Map<String, Object>)mapValue.get("fieldValues");

        	List<KingDeeCommonConfigListOutVoRecords> records = kingDeeCommonConfigMapper.getKingDeeCommonConfigByDocType(mapBill);
        	if(records.size() > 0)
        	{
        		KingDeeCommonConfigListOutVoRecords kingDeeCommonConfig = records.get(0);            	
            	String primaryKeyField = kingDeeCommonConfig.getPrimaryKeyField();//需要获取的字段

            	List<String> wheres = new ArrayList<String>();
            	for(Entry<String, Object> fieldValue:fieldValues.entrySet())
            	{
                	wheres.add("" + fieldValue.getKey() + "=" + "'" + fieldValue.getValue() + "'");
            	}

            	List<String> fields = new ArrayList<String>();
            	fields.add(primaryKeyField);
            	TableStructureListOutVoRecords tableStructureListOutVoRecords = databaseTableMapper.tableStructureOne(mapBill);
            	
            	if(!Constants.NULL.equals(tableStructureListOutVoRecords))
            	{
            		String dbTableName = tableStructureListOutVoRecords.getDbTableName();
	            	List<Object> datas = databaseTableMapper.getDynamicTableDatas(dbTableName, fields, wheres);
	            	if(datas.size() > 0)
	            	{
	                    SetKingdeeValue(mapEntity, kingDeeField, primaryKeyField, datas.get(0));
	            	}
            	}
        	}
    	}
    }

    private void populateThirdPartyData(Map<String, Object> temp, Map<String, Object> map, Map<String, String> field, Map<String, Map<String, Object>> mapBillDatas) {
        String kingDeeField = field.get("kingdeeField");
        String thirdPartyField = field.get("thirdPartyField");
        String retrievalField = field.get("retrievalField");
        String mapBill = field.get("mapBill");
        
        String defaultValue = field.get("defaultValue");
        
        if(StringUtil.isBlank(thirdPartyField))
        {
        	SetDefaultValue(temp, defaultValue, retrievalField, kingDeeField);
	        return;
        }

        Object curValue = ExcuteScript(thirdPartyField, map);
        

        if(Constants.NULL.equals(curValue))
        {
        	SetDefaultValue(temp, defaultValue, retrievalField, kingDeeField);
	        return;
        }
        
        if(StringUtil.isNotBlank(mapBill))
        {
        	Map<String, Object> fieldValues;
        	if(!mapBillDatas.containsKey(mapBill))
        	{
        		Map<String, Object> mapBillData = new HashMap<String, Object>();
        		mapBillDatas.put(mapBill, mapBillData);
        		mapBillData.put("mapEntity", temp);
        		mapBillData.put("kingDeeField", kingDeeField);
        		fieldValues = new HashMap();
        		mapBillData.put("fieldValues", fieldValues);
        	}
        	else
        	{
        		Map<String, Object> mapBillData = mapBillDatas.get(mapBill);
        		fieldValues = (Map<String, Object>)mapBillData.get("fieldValues");
        	}
        	fieldValues.put(retrievalField, curValue);
        	return;
        }
        
        SetKingdeeValue(temp, kingDeeField, retrievalField, curValue);
    }
    
    private void SetDefaultValue(Map<String, Object> temp, String defaultValue, String retrievalField, String kingDeeField)
    {
        if(!StringUtil.isNotBlank(defaultValue))
        {
            if (StringUtil.isNotBlank(retrievalField)) {
                temp.put(kingDeeField, new HashMap<String, Object>(1) {{
                    put(retrievalField, defaultValue);
                }});
            } else {
                temp.put(kingDeeField, defaultValue);
            }
        }
    }
    
    private void SetKingdeeValue(Map<String, Object> temp, String kingDeeField, String retrievalField, Object curValue)
    {
        if (!Constants.NULL.equals(curValue)) {
            if (StringUtil.isNotBlank(retrievalField)) {
                temp.put(kingDeeField, new HashMap<String, Object>(1) {{
                    put(retrievalField, curValue);
                }});
            } else {
                temp.put(kingDeeField, curValue);
            }
        }
    }
    
    private Object ExcuteScript(String thirdPartyField, Object value)
    {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = engineManager.getEngineByName("JavaScript");
        
        try { 
        	List<Object> valuesList = new ArrayList<Object>();
        	Map<String,Object> curValue = (Map<String,Object>)value;
        	
        	List<String> keys = new ArrayList();
        	List<Object> values = new ArrayList();
        	
        	Boolean isContained = false;
        	for(Map.Entry<String, Object> curEntry :curValue.entrySet())
        	{
        		if(thirdPartyField.contains(curEntry.getKey()))
        		{
        			keys.add(curEntry.getKey());
        			values.add(curEntry.getValue());
        			isContained = true;
        		}
        	}
        	
        	if(!isContained) return "";
        	
            String Script = 
            		"function getfieldValue("+ String.join(",", keys) + "){ return " + thirdPartyField + "}"
            		+ "";
            Object result = scriptEngine.eval(Script);
            Invocable in = (Invocable) scriptEngine;
            result = in.invokeFunction("getfieldValue", values.toArray());
			return result;
		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return value;
    }

    public String kingDeeUpdateBySql(Map<String, String> config, String queueId, String name, String request) {
        return kingDeeApi.kingDeeUpdateBySql(config, queueId, request);
    }

    public String sendPlugInUnit(String plugInUrl, String json) {
        return kingDeeApi.sendPlugInUnit(plugInUrl, json, 1);
    }


}
