package com.system.controller;

import com.system.service.ISynchronizationService;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api("金蝶同步")
@RestController
@RequestMapping("/api")
public class KingDeeSyncController {

    @Autowired
    private ISynchronizationService synchronizationService;


    @ApiOperation("金蝶同步")
    @GetMapping("/kingdee/synchronization")
    public RestResponse kingdeeSynchronization() {
        synchronizationService.kingdeeSynchronization();
        return RestResponse.success();
    }

    @ApiOperation("手动同步")
    @GetMapping("/kingdee/manual/synchronization")
    public RestResponse manualSynchronization() {
        synchronizationService.kingdeeManualSynchronization();
        return RestResponse.success();
    }

    @ApiOperation("手动同步（带参数）")
    @PostMapping("/kingdee/manual/synchronizationByParam")
    public RestResponse manualSynchronizationByParam(@RequestBody Map<String, String> docTypeMap) {
        synchronizationService.manualSynchronizationByParam(docTypeMap.get("docType"));
        return RestResponse.success();
    }

}
