package com.system.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.system.constants.Constants;
import com.system.constants.KingDeeConstants;
import com.system.dao.InitConnectParamMapper;
import com.system.exception.KingDeeConnectException;
import com.system.model.DelayedElement;
import com.system.model.InitConnectParam;
import com.system.utils.HttpUtil;
import com.system.utils.JsonUtil;
import com.system.utils.ProductLogUtil;
import com.system.utils.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

/**
 * @author Inori
 */
@Slf4j
@Component
public class KingDeeApi {

    private final String serviceNameTable = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutDataSet,LQKJ.WebApi.Stub";

    private final String serviceNameMap = "LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub";

    private final String updateService = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutBatch,LQKJ.WebApi.Stub";

    private final String upAttachment = "LQKJ.WebApi.Stub.CustomWebApiService.HttpDownloadFile,LQKJ.WebApi.Stub";

    private ExecutorService threadPool = new ThreadPoolExecutor(10, 10,
            0L,
            TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<Runnable>(1024),
            new ThreadFactoryBuilder().setNameFormat("env-pool-%d").build(),
            new ThreadPoolExecutor.AbortPolicy());

    private static final String LOGIN_MESSAGE = "金蝶服务器连接异常";

    public static InitConnectParam initConnectParam;

    public static String receiveAddress;

    public boolean flag = false;

    public static KingDeeK3CloudApi kingDeeK3CloudApi;

    @Autowired
    private InitConnectParamMapper initConnectParamMapper;

    @Autowired
    private ProductLogUtil productLogUtil;


    @PostConstruct
    public void init() {
        initConnectParam = initConnectParamMapper.selectOne(new QueryWrapper<InitConnectParam>().last("LIMIT 1"));
        if (StringUtil.isNotNull(initConnectParam)) {
            receiveAddress = initConnectParam.getReceiveAddress();
            kingDeeK3CloudApi = new KingDeeK3CloudApi(initConnectParam.getK3CloudUrl());
        }
    }

    public InitConnectParam getInitConnectParam() {
        return initConnectParam;
    }

    public void setInitConnectParam(InitConnectParam initConnectParam) {
        KingDeeApi.initConnectParam = initConnectParam;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public KingDeeK3CloudApi getKingDeeK3CloudApi() {
        return kingDeeK3CloudApi;
    }

    public void setKingDeeK3CloudApi(KingDeeK3CloudApi kingDeeK3CloudApi) {
        KingDeeApi.kingDeeK3CloudApi = kingDeeK3CloudApi;
    }

    public String getReceiveAddress() {
        return receiveAddress;
    }

    public void setReceiveAddress(String receiveAddress) {
        KingDeeApi.receiveAddress = receiveAddress;
    }

    private String stringKey(Map<String, String> map) {
        StringBuilder keys = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(keys)) {
                keys.append(", ").append(entry.getKey());
            } else {
                keys = new StringBuilder(entry.getKey());
            }
        }
        if (StringUtil.isNotBlank(keys.toString())) {
            return "\"FieldKeys\":\"" + keys.toString() + "\"";
        }
        return "";
    }

    private String stringWhere(Map<String, String> map) {
        StringBuilder where = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(where)) {
                where.append(" AND ").append(entry.getKey()).append("='").append(entry.getValue()).append("'");
            } else {
                where = new StringBuilder(entry.getKey() + "='" + entry.getValue() + "'");
            }
        }
        if (StringUtil.isNotBlank(where.toString())) {
            return ",\"FilterString\":\"" + where.toString() + "\"";
        }
        return "";
    }

    /**
     * 查询单据体
     */
    public List<List<Object>> getKingDeeData(Map<String, String> config, String queueId, Map<String, String> key, Map<String, String> where) {
        try {
            if (this.flag) {
                String request = "{\"FormId\":\"" + config.get("sFormId") + "\"," + stringKey(key) + stringWhere(where) + "}";
                System.out.println("================content==============" + request + "=================content===================");
                List<List<Object>> response = kingDeeK3CloudApi.executeBillQuery(request);
                //记录查询金蝶云数据的请求及响应信息
                if (StringUtil.isNotBlank(config.get(Constants.NAME))) {
                    productLogUtil.productSyncLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), request, response);
                }
                return response;
            } else {
                throw new KingDeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (StringUtil.isNotNull(config.get(Constants.NAME))) {
                productLogUtil.productSyncErrorLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), "", LOGIN_MESSAGE);
            }
            throw new KingDeeConnectException(LOGIN_MESSAGE);
        }
    }

    /**
     * 金蝶同步
     */
    public List<List<Object>> synchronization(Map<String, String> config, String queueId, Map<String, String> key, Map<String, String> where) {
        try {
            if (this.flag) {
                String request = "{\"FormId\":\"" + config.get("sFormId") + "\"," + stringKey(key) + stringWhere(where) + "}";
                System.out.println("================content==============" + request + "=================content===================");
                List<List<Object>> response = kingDeeK3CloudApi.executeBillQuery(request);
                //记录查询金蝶云数据的请求及响应信息
                productLogUtil.productSyncLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), request, response);

                return response;
            } else {
                throw new KingDeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            productLogUtil.productSyncErrorLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), "", LOGIN_MESSAGE);
            throw new KingDeeConnectException(LOGIN_MESSAGE);
        }
    }

    /**
     * 上传附件
     *
     * @param attachment
     * @param Id
     * @return
     */
    public String uploadAttachment(String attachment, long Id) {
        Map<String, Object> data = new HashMap<String, Object>();
        System.out.println("=========上传附件.receiveAddress" + receiveAddress);
        System.out.println("=========上传附件.receiveAddress.split" + receiveAddress.split("/wx/"));
        data.put("url", receiveAddress.split("/wx/")[0] + attachment);
        data.put("id", Id);
        Map<String, Object> requestData = new HashMap<String, Object>();
        requestData.put("http", data);
        String response = "";
        try {
            response = kingDeeK3CloudApi.execute(upAttachment, data, String.class);
            System.out.println("=========附件response" + response + "=========");
        } catch (Exception e) {
            e.printStackTrace();
            //productLogUtil.productSyncErrorLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), "", LOGIN_MESSAGE);
        }

        return response;
    }

    /**
     * 创建/更新
     */
    public String kingDeeDataPush(Map<String, String> config, String queueId, String name, Map<String, Object> data) {
        try {
            if (this.flag) {
                String response = kingDeeK3CloudApi.executeObject("LQKJ.WebApi.Stub.CustomWebApiService.PushAndSave,LQKJ.WebApi.Stub", data, String.class);
                //记录下推金蝶云数据的请求及响应信息
                productLogUtil.productPushLogCreate(Integer.valueOf(config.get("productId")), queueId, name, config.get("docType"), config.get("direction"), JsonUtil.toString(data), response);

                return response;
            } else {
                throw new KingDeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            productLogUtil.productSyncErrorLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), "", LOGIN_MESSAGE);
            throw new KingDeeConnectException(LOGIN_MESSAGE);
        }
    }

    /**
     * 创建/更新
     */
    public String kingDeeDataPush(Map<String, Object> data) {
        try {
            if (this.flag) {
                String response = kingDeeK3CloudApi.executeObject("LQKJ.WebApi.Stub.CustomWebApiService.PushAndSave,LQKJ.WebApi.Stub", data, String.class);


                return response;
            } else {
                throw new KingDeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new KingDeeConnectException(LOGIN_MESSAGE);
        }
    }

    /**
     * 创建/更新 SQL
     */
    public String kingDeeUpdateBySql(Map<String, String> config, String queueId, String request) {
        return kingDeeSql(config, queueId, request, updateService);
    }

    /**
     * 查询 SQL
     */
    public String kingDeeSelectBySql(Map<String, String> config, String queueId, String request) {
        return kingDeeSql(config, queueId, request, serviceNameMap);
    }

    private String kingDeeSql(Map<String, String> config, String queueId, String request, String serviceName) {
        try {
            if (this.flag) {
                String response = kingDeeK3CloudApi.execute(serviceName, new Object[]{request}, String.class);

                //记录SQL查询金蝶数据的请求及响应信息
                productLogUtil.productSqlLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), JsonUtil.toString(request), response);

                return response;
            } else {
                throw new KingDeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            productLogUtil.productSyncErrorLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), "", LOGIN_MESSAGE);
            throw new KingDeeConnectException(LOGIN_MESSAGE);
        }
    }

    /**
     * 批量保存
     */
    public void batchAdd(String sFormId, String json) {
        try {
            if (this.flag) {
                String content = "{\"Model\":" + json + "}";
                kingDeeK3CloudApi.batchSave(sFormId, content);
            } else {
                throw new KingDeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new KingDeeConnectException(LOGIN_MESSAGE);
        }
    }

    public String sendThirdParty(String data, int index) {
        try {
            System.out.println("receiveAddress=======" + receiveAddress);
            System.out.println("data=======" + data);
            return HttpUtil.httpPost(this.receiveAddress, data).getBody();
        } catch (Exception e) {
            e.printStackTrace();
            if (index != 0) {
                this.sendThirdParty(data, index - 1);
            } else {
                HttpUtil.httpGet("http://integrate-system:8090/integrate/api/turn/off/synchronization");

                DelayQueue<DelayedElement> delayQueue = new DelayQueue<>();
                threadPool.execute(() -> {
                    //take方法将阻塞线程
                    delayQueue.add(new DelayedElement(60));

                    try {
                        delayQueue.take();
                    } catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }

                    HttpUtil.httpGet("http://integrate-system:8090/integrate/api/start/synchronization");
                });
            }

            Map<String, Object> map = new HashMap<>(2);
            map.put("resultCode", KingDeeConstants.OVERTIME_CODE);
            map.put("resultMsg", "第三方请求超时");
            return JsonUtil.toString(map);
        }
    }

    public String sendPlugInUnit(String plugInUrl, String json, Integer index) {
        try {
            return HttpUtil.httpPost(plugInUrl, json).getBody();
        } catch (Exception e) {
            if (index != 0) {
                this.sendPlugInUnit(plugInUrl, json, index - 1);
            }

            Map<String, Object> map = new HashMap<>(2);
            map.put("resultCode", KingDeeConstants.ERROR_CODE);
            map.put("resultMsg", "插件请求超时");
            return JsonUtil.toString(map);
        }
    }


}

