package com.system.constants;

import com.system.dao.DatabaseTableMapper;
import com.system.transfer.configure.TableStructureListOutVoRecords;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Inori
 */
@Component
public class FormTableStructureConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private DatabaseTableMapper databaseTableMapper;


    @PostConstruct
    public void init() {
        /*List<TableStructureListOutVoRecords> recordsList = databaseTableMapper.tableStructureList();
        for (TableStructureListOutVoRecords records : recordsList) {
            this.map.put(records.getFormId(), this.encapsulationFormTable(records));
        }*/
    }

    public Map<String, String> get(String formId) {
        return this.map.get(formId);
    }

    public void refresh(String formId) {
        this.map.remove(formId);

        TableStructureListOutVoRecords records = databaseTableMapper.tableStructureOne(formId);
        if (StringUtil.isNotNull(records)) {
            this.map.put(records.getFormId(), this.encapsulationFormTable(records));
        }
    }

    private Map<String, String> encapsulationFormTable(TableStructureListOutVoRecords records) {
        Map<String, String> temp = new HashMap<>(6);
        temp.put("formId", records.getFormId());
        temp.put("dbTableName", records.getDbTableName());
        temp.put("dbTableCommon", records.getDbTableComment());
        temp.put("formJson", records.getFormJson());
        return temp;
    }


}
