package com.system.constants;

import com.system.dao.KingDeeCommonConfigMapper;
import com.system.transfer.kingdee.KingDeeCommonConfigListOutVoRecords;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Inori
 */
@Component
public class KingDeeCommonPushConstants {

    private Map<String, List<Map<String, String>>> map = new ConcurrentHashMap<>();

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;


    @PostConstruct
    public void init() {
        List<KingDeeCommonConfigListOutVoRecords> recordsList = kingDeeCommonConfigMapper.kingDeeCommonConfigList(2);
        if (!CollectionUtils.isEmpty(recordsList)) {
            List<Integer> idList = recordsList.stream().map(KingDeeCommonConfigListOutVoRecords::getId).collect(Collectors.toList());
            List<Map<String, Object>> fieldMappingList = kingDeeCommonConfigMapper.kingDeeFieldMappingList(idList);
            for (KingDeeCommonConfigListOutVoRecords records : recordsList) {
                List<Map<String, Object>> tempList = fieldMappingList.stream().filter(m -> records.getId().equals(m.get("id"))).collect(Collectors.toList());
                List<Map<String, String>> curRecordsList;
                if(this.map.containsKey(records.getDocType()))
                {
                	curRecordsList = this.map.get(records.getDocType());
                }
                else
                {
                	curRecordsList = new ArrayList<Map<String, String>>();
                    this.map.put(records.getDocType(), curRecordsList);
                }
                curRecordsList.add(this.encapsulationKingDeeFieldConfig(records, tempList));
            }
        }
    }

    public List<Map<String, String>> get(String formId) {
        if (CollectionUtils.isEmpty(this.map)) {
            return new ArrayList<Map<String, String>>();
        }
        return this.map.get(formId);
    }

    public void refresh(Integer id, String docType) {
        this.map.clear();
        this.init();
    }

    private Map<String, String> encapsulationKingDeeFieldConfig(KingDeeCommonConfigListOutVoRecords records, List<Map<String, Object>> tempList) {
        Map<String, String> temp = new HashMap<>(10);
        temp.put("productId", records.getPlatformProductRelationId().toString());
        temp.put("docType", records.getDocType());
        temp.put("sFormId", records.getSFormId());
        temp.put("name", records.getName());
        temp.put("direction", records.getDirection());
        temp.put("entryName", records.getEntryName());
        temp.put("fathersFormId", records.getFathersFormId());
        temp.put("fatherEntryName", records.getFatherEntryName());
        temp.put("pushRule", records.getPushRule());
        temp.put("isInTransaction", String.valueOf(records.getIsInTransaction()));
        temp.put("isAutoPerform", String.valueOf(records.getIsAutoPerform()));
        temp.put("plugInUrl", records.getPlugInUrl());
        temp.put("customSql", records.getCustomSql());
        temp.put("kingDeeFiledDetail", JsonUtil.toString(tempList));
        return temp;
    }


}
