package com.system.controller;

import com.system.service.IKingDeeCommonPushService;
import com.system.transfer.kingdee.KingDeeUpdateThirdDataInVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "金蝶更新数据")
@RestController
@RequestMapping("/api")
public class KingDeePushController {

    @Autowired
    private IKingDeeCommonPushService kingDeeCommonPushService;


    @ApiOperation("金蝶下推创建")
    @PostMapping("/kingdee/updateThirdData")
    public Object kingDeeUpdateThirdData(@RequestBody @Validated KingDeeUpdateThirdDataInVo inVo) {
        return kingDeeCommonPushService.kingDeeUpdateThirdData(inVo);
    }


}
