package com.system.dao;

import com.system.transfer.kingdee.SynchronizationRecordsDeleteInVo;
import com.system.transfer.kingdee.SynchronizationRecordsListOutVoRecords;
import com.system.transfer.kingdee.SynchronizationRecordsUpdateInVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
public interface SynchronizationRecordsMapper {

    /**
     * 金蝶同步记录列表
     *
     * @param statusList 状态列表
     * @return 同步记录
     */
    List<SynchronizationRecordsListOutVoRecords> synchronizationRecordsListByStatus(@Param("statusList") List<Integer> statusList);

    /**
     * 金蝶同步临时记录创建
     *
     * @param tempList 数据
     */
    void synchronizationRecordsTempCreate(@Param("tempList") List<Map<String, Object>> tempList);

    /**
     * 金蝶同步临时记录列表
     *
     * @return 列表
     */
    List<Map<String, Object>> synchronizationRecordsTempList();

    /**
     * 金蝶同步记录创建
     *
     * @param tempList 数据
     */
    void synchronizationRecordsCreate(@Param("tempList") List<Map<String, Object>> tempList);

    /**
     * 根据ID删除数据
     *
     * @param idList ID列表
     */
    void synchronizationRecordsTempDelete(@Param("idList") List<Integer> idList);

    /**
     * 根据ID更新金蝶同步记录状态
     *
     * @param idList ID列表
     */
    void synchronizationRecordsUpdateByIdList(@Param("idList") List<Integer> idList);

    /**
     * 金蝶同步记录更新
     *
     * @param inVo 条件
     */
    void synchronizationRecordsUpdate(SynchronizationRecordsUpdateInVo inVo);

    /**
     * 金蝶同步记录删除
     *
     * @param inVo 条件
     */
    void synchronizationRecordsDelete(SynchronizationRecordsDeleteInVo inVo);


}
