package com.system.service.impl;

import com.system.constants.KingDeeCommonGetConstants;
import com.system.kingdee.KingDeeCommonGetApi;
import com.system.service.IKingDeeCommonGetService;
import com.system.transfer.kingdee.KingDeeDataListInVo;
import com.system.transfer.response.RestResponse;
import com.system.utils.JsonUtil;
import com.system.utils.ProductLogUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class KingDeeCommonGetServiceImpl implements IKingDeeCommonGetService {

    @Autowired
    private KingDeeCommonGetConstants kingDeeCommonGetConstants;

    @Autowired
    private KingDeeCommonGetApi kingDeeCommonGetApi;

    @Autowired
    private ProductLogUtil productLogUtil;


    @Override
    public RestResponse kingDeeDataList(KingDeeDataListInVo inVo) {
        long start = System.currentTimeMillis();
        String queueId = inVo.getQueueId();

        Map<String, String> config = kingDeeCommonGetConstants.get(inVo.getDocType());
        if (CollectionUtils.isEmpty(config)) {
            return RestResponse.fail("自定义查询失败! docType为: " + inVo.getDocType() + " 的表单ERP-MES标识不存在");
        }

        Integer id = productLogUtil.productLogCreate(Integer.valueOf(config.get("productId")), queueId, config.get("name"), config.get("docType"), config.get("direction"), JsonUtil.toString(inVo.getData()), "", 0, 0);

        List<Object> tempList = JsonUtil.toList(config.get("kingDeeFiledDetail"), Object.class);
        List<Map<String, String>> fieldList = tempList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, String.class)).collect(Collectors.toList());

        Map<String, String> where = new HashMap<>(5);
        if (!CollectionUtils.isEmpty(inVo.getData())) {
            for (Map.Entry<String, Object> entry : inVo.getData().entrySet()) {
                where.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }

        List<Map<String, Object>> response = kingDeeCommonGetApi.getKingDeeData(config, queueId, fieldList, where);
        long costTime = System.currentTimeMillis() - start;
        if (!CollectionUtils.isEmpty(response)) {
            String temp = "false";
            if (response.get(0).containsKey(temp)) {
                productLogUtil.productLogUpdate(id, JsonUtil.toString(response), String.valueOf(response.get(0).get(temp)), Integer.valueOf(String.valueOf(costTime)));
                return RestResponse.fail(String.valueOf(response.get(0).get(temp)));
            }
        }
        productLogUtil.productLogUpdate(id, JsonUtil.toString(response), "", Integer.valueOf(String.valueOf(costTime)));
        return RestResponse.success(response);
    }


}
