package com.system.oauth.system.controller;


import com.system.framework.core.response.StarBosResult;
import com.system.framework.core.utils.AuthUtils;
import com.system.oauth.system.entity.UserMessage;
import com.system.oauth.system.model.RegisterModel;
import com.system.oauth.system.service.ISysPermissionService;
import com.system.oauth.system.service.IUserMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.List;

@Api(tags = "ApiUser")
@Slf4j
@RestController
@RequestMapping("/user")
//@CrossOrigin
public class ApiUserController {
    @Autowired
    private ISysPermissionService permissionService;
    @Autowired
    private IUserMessageService userMessageService;

    @ApiOperation(value = "注册", httpMethod = "POST", produces = "", notes = "注册账号并生成用户")
    @PostMapping("/register")
    public StarBosResult<?> register(@Valid @RequestBody RegisterModel param) {
        log.info("\r\n" + param);
        // 1. 保存账户信息
        Long uid = userMessageService.save(param);

        return StarBosResult.ok(uid, "新增成功");
    }

    //获取菜单
//    @NoRepeatSubmit
    @ApiOperation(value = "当前用户-获取菜单", httpMethod = "POST", produces = "", notes = "当前用户-获取菜单")
    @PostMapping("/getMenuList")
    public StarBosResult<Object> getRoutes() {
        //    通过请求头的Authorization jwt获取用户账号id
        return StarBosResult.ok(permissionService.getUserMenu(Integer.valueOf(AuthUtils.getAccountId())), "获取成功");
    }

    @GetMapping("image")
    public void execute(HttpServletRequest httpServletRequest,
                        HttpServletResponse httpServletResponse) {

// img为图片的二进制流
        try {
            File file = new File("static/image/1.jpg");
            FileInputStream fis;
            fis = new FileInputStream(file);

            long size = file.length();
            byte[] temp = new byte[(int) size];
            fis.read(temp, 0, (int) size);
            fis.close();
            byte[] data = temp;
            httpServletResponse.setContentType("image/jpg");
            OutputStream out = httpServletResponse.getOutputStream();
            out.write(data);
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    //获取用户信息
//    @NoRepeatSubmit
    @ApiOperation(value = "当前用户-获取信息", httpMethod = "POST", produces = "", notes = "当前用户-获取信息")
    @PostMapping("/getUserInfo")
    public StarBosResult<?> getUserInfo() {
        StarBosResult<UserMessage> result = new StarBosResult<>();
        try {
            Integer id = Integer.valueOf(AuthUtils.getAccountId());//用户id
//            System.out.println(id);
            UserMessage byId = userMessageService.getById(id);
            List<String> permissionList = permissionService.getPermissionList(id);

            byId.setRoles(permissionList);
            result.setCode(200);
            result.setData(byId);
            result.setMsg("获取成功");
        } catch (Exception e) {
            result.error500("获取失败！");
            log.error(e.getMessage(), e);
        }
        return result;
    }

}
