package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.constants.Constants;
import com.system.constants.RsaKeyConstant;
import com.system.dao.LicInfoMapper;
import com.system.dao.LicVerificationMapper;
import com.system.serivce.ILicVerificationService;
import com.system.transfer.lic.LicInfoListOutVoRecords;
import com.system.transfer.response.RestResponse;
import com.system.transfer.verification.*;
import com.system.utils.JsonUtil;
import com.system.utils.RsaUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class LicVerificationServiceImpl implements ILicVerificationService {

    @Autowired
    private LicVerificationMapper licVerificationMapper;

    @Autowired
    private LicInfoMapper licInfoMapper;

    @Autowired
    private RsaKeyConstant rsaKeyConstant;


    @Override
    public LicOnlineVerificationLogListOutVo licOnlineVerificationLogList(LicOnlineVerificationLogListInVo inVo) {
        Page<LicOnlineVerificationLogListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<LicOnlineVerificationLogListOutVoRecords> recordsList = licVerificationMapper.licOnlineVerificationLogList(inVo);

        LicOnlineVerificationLogListOutVo outVo = new LicOnlineVerificationLogListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public LicOnlineVerificationLogDetailOutVo licOnlineVerificationLogDetail(LicOnlineVerificationLogDetailInVo inVo) {
        return licVerificationMapper.licOnlineVerificationLogDetail(inVo);
    }

    @Override
    public void licOnlineVerificationLogDelete(LicOnlineVerificationLogDeleteInVo inVo) {
        licVerificationMapper.licOnlineVerificationLogDelete(inVo);
    }

    @Override
    public RestResponse licOnlineVerification(LicOnlineVerificationInVo inVo) {
        String data;
        try {
            data = RsaUtil.decryptByPrivateKey(inVo.getData(), rsaKeyConstant.getPrivateKey());
        } catch (Exception e) {
            e.printStackTrace();
            return RestResponse.fail("Lic文件信息解密失败");
        }

        LicOnlineVerificationLogCreateInVo request = new LicOnlineVerificationLogCreateInVo();
        RestResponse response;

        Map<String, Object> map = JsonUtil.toMap(data, String.class, Object.class);
        request.setMacAddress(String.valueOf(map.get("macAddress")));
        request.setRequest(data);
        if (!CollectionUtils.isEmpty(map)) {
            response = this.purchaseToResult(map);
            request.setResponse(JsonUtil.toString(response));

            if (response.getCode() == RestResponse.CODE_SUCCESS) {
                request.setFlag(1);
            } else {
                request.setFlag(0);
                request.setMessage(response.getMessage());
            }
        } else {
            response = RestResponse.fail("Lic文件信息错误");

            request.setFlag(0);
            request.setMessage(response.getMessage());
            request.setResponse(JsonUtil.toString(response));
        }

        licVerificationMapper.licOnlineVerificationLogCreate(request);
        return response;
    }

    private RestResponse purchaseToResult(Map<String, Object> map) {
        LicInfoListOutVoRecords records = licInfoMapper.getLicInfoByMacAddress(String.valueOf(map.get("macAddress")));
        if (StringUtil.isNull(records)) {
            return RestResponse.fail("MAC地址不存在");
        }

        if (LocalDate.now().isAfter(LocalDate.parse(records.getFileEffectiveTime(), DateTimeFormatter.ofPattern(Constants.TIME_FORMAT)))) {
            return RestResponse.fail("Lic文件已过期");
        }

        return RestResponse.success();
    }


}
