package com.system.constants;

import com.system.utils.FileUtil;
import lombok.Data;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author Inori
 */
@Data
@Component
public class RsaKeyConstant {

    /**
     * 公钥
     */
    private String publicKey;

    /**
     * 私钥
     */
    private String privateKey;


    @PostConstruct
    public void init() {
        try {
            ClassPathResource pubClassPath = new ClassPathResource("key/" + "publicKey.pub");
            if (pubClassPath.exists()) {
                InputStream inputStream = pubClassPath.getInputStream();
                publicKey = FileUtil.read(inputStream);
                inputStream.close();
            }

            ClassPathResource priClassPath = new ClassPathResource("key/" + "privateKey.pri");
            if (priClassPath.exists()) {
                InputStream inputStream = priClassPath.getInputStream();
                privateKey = FileUtil.read(inputStream);
                inputStream.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


}
