package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.lic.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface LicInfoMapper {

    /**
     * Lic信息列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<LicInfoListOutVoRecords> licInfoList(@Param("page") Page<LicInfoListOutVoRecords> page, @Param("inVo") LicInfoListInVo inVo);

    /**
     * Lic信息创建
     *
     * @param inVo 条件
     */
    void licInfoCreate(LicInfoCreateInVo inVo);

    /**
     * Lic信息更新
     *
     * @param inVo 条件
     */
    void licInfoUpdate(LicInfoUpdateInVo inVo);

    /**
     * Lic信息删除
     *
     * @param inVo 条件
     */
    void licInfoDelete(LicInfoDeleteInVo inVo);

    /**
     * 根据MAC地址查询Lic信息
     *
     * @param macAddress MAC地址
     * @return Lic信息
     */
    LicInfoListOutVoRecords getLicInfoByMacAddress(String macAddress);

    /**
     * 根据tenantId地址查询Lic信息
     *
     * @param macAddress MAC地址
     * @return Lic信息
     */
    LicInfoListOutVoRecords getLicInfoByTenantId(String tenantId);

    /**
     * 根据id查询Lic信息
     *
     * @param macAddress MAC地址
     * @return Lic信息
     */
    LicInfoListOutVoRecords getLicInfoById(Integer id);
}
