package com.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@TableName("t_docker_image")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "docker镜像表", description = "私有镜像")
public class DockerImage implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "镜像名")
    @TableField(value = "`name`")
    private String name;

    @ApiModelProperty(value = "服务路径")
    private String contextPath;

    @ApiModelProperty(value = "描述")
    @TableField(value = "`describe`")
    private String describe;
}
