package com.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@TableName("t_docker_image_version")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "docker镜像版本表", description = "私有镜像版本")
public class DockerImageVersion implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "镜像id")
    private Integer imageId;

    @ApiModelProperty(value = "版本")
    private String version;
}
