package com.system.oauth.system.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@TableName("sys_role_permission")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@AllArgsConstructor
@NoArgsConstructor
public class SysRolePermission implements Serializable {
    private static final long serialVersionUID = 1L;
    @ExcelProperty(value = "主键")
    @TableId(type = IdType.AUTO)
    private String id;
    @ExcelProperty(value = "角色id")
    private String roleId;
    @ExcelProperty(value = "权限id")
    private String permId;

    public SysRolePermission(String roleId, String permissionId) {
        this.roleId = roleId;
        this.permId = permissionId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }

    public String getId() {
        return id;
    }

    public String getRoleId() {
        return roleId;
    }

    public String getPermId() {
        return permId;
    }
}
