package com.system.oauth.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.system.oauth.system.entity.SysRole;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface SysRoleMapper extends BaseMapper<SysRole> {
    /**
     * @Author scott
     * @Date 2022/12/13 16:12
     * @Description: 根据用户查询角色
     */
    @Select("SELECT sys_role.* FROM sys_role right join sys_user_role on sys_role.id = sys_user_role.role_id WHERE sys_user_role.user_id = #{user_id}")
    List<SysRole> selectByUserId(@Param("user_id") Integer userId);
    /**
     * @Author scott
     * @Date 2022/12/13 16:12
     * @Description: 根据用户id查询角色id
     */
    @Select("SELECT sys_role.id FROM sys_role right join sys_user_role on sys_role.id = sys_user_role.role_id WHERE sys_user_role.user_id = #{user_id}")
    List<String> selectRoleByUserId(@Param("user_id") Long userId);
    /**
     * @Author scott
     * @Date 2022/12/13 16:12
     * @Description: 删除角色与用户关系
     */
    @Delete("delete from sys_user_role where role_id = #{roleId}")
    void deleteRoleUserRelation(@Param("roleId") String roleId);

    /**
     * @Author scott
     * @Date 2022/12/13 16:12
     * @Description: 删除角色与权限关系
     */
    @Delete("delete from sys_role_permission where role_id = #{roleId}")
    void deleteRolePermissionRelation(@Param("roleId") String roleId);
}
