/*
SQLyog Community v13.1.6 (64 bit)
MySQL - 8.0.26 : Database - db_lic
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
/*Table structure for table `a` */

DROP TABLE IF EXISTS `a`;

CREATE TABLE `a` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `queue_id` varchar(255) NOT NULL COMMENT '唯一标识',
  `a` varchar(255) DEFAULT NULL COMMENT 'a',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='1';

/*Data for the table `a` */

/*Table structure for table `oauth_client_details` */

DROP TABLE IF EXISTS `oauth_client_details`;

CREATE TABLE `oauth_client_details` (
  `client_id` varchar(256) NOT NULL,
  `resource_ids` varchar(256) DEFAULT NULL,
  `client_secret` varchar(256) DEFAULT NULL,
  `scope` varchar(256) DEFAULT NULL,
  `authorized_grant_types` varchar(256) DEFAULT NULL,
  `web_server_redirect_uri` varchar(256) DEFAULT NULL,
  `authorities` varchar(256) DEFAULT NULL,
  `access_token_validity` int DEFAULT NULL,
  `refresh_token_validity` int DEFAULT NULL,
  `additional_information` varchar(4096) DEFAULT NULL,
  `autoapprove` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*Data for the table `oauth_client_details` */

insert  into `oauth_client_details`(`client_id`,`resource_ids`,`client_secret`,`scope`,`authorized_grant_types`,`web_server_redirect_uri`,`authorities`,`access_token_validity`,`refresh_token_validity`,`additional_information`,`autoapprove`) values 
('auth-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,NULL,NULL,NULL,NULL),
('codegenerator-client',NULL,'$2a$10$pKOYERvA7GXe9nsY6arlauD87nnG5OriMJCOlVOOOzqI0AMKDP/hK','all','authorization_code,refresh_token,password',NULL,NULL,3600,36000,NULL,'1'),
('user-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,7200,36000,NULL,'1');

/*Table structure for table `ora_receivebill` */

DROP TABLE IF EXISTS `ora_receivebill`;

CREATE TABLE `ora_receivebill` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `queue_id` varchar(255) NOT NULL COMMENT '唯一标识',
  `FSupplierId` varchar(255) DEFAULT NULL COMMENT '供应商',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='收料通知单';

/*Data for the table `ora_receivebill` */

/*Table structure for table `qrtz_blob_triggers` */

DROP TABLE IF EXISTS `qrtz_blob_triggers`;

CREATE TABLE `qrtz_blob_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `BLOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_blob_triggers` */

/*Table structure for table `qrtz_calendars` */

DROP TABLE IF EXISTS `qrtz_calendars`;

CREATE TABLE `qrtz_calendars` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `CALENDAR_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`CALENDAR_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_calendars` */

/*Table structure for table `qrtz_cron_triggers` */

DROP TABLE IF EXISTS `qrtz_cron_triggers`;

CREATE TABLE `qrtz_cron_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `CRON_EXPRESSION` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TIME_ZONE_ID` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_cron_triggers` */

insert  into `qrtz_cron_triggers`(`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`,`CRON_EXPRESSION`,`TIME_ZONE_ID`) values 
('DefaultQuartzScheduler','com.system.quartz.job.SynchronizationJob','DEFAULT','0 */1  * * * ?','Asia/Shanghai');

/*Table structure for table `qrtz_fired_triggers` */

DROP TABLE IF EXISTS `qrtz_fired_triggers`;

CREATE TABLE `qrtz_fired_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `ENTRY_ID` varchar(95) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `INSTANCE_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `FIRED_TIME` bigint NOT NULL,
  `SCHED_TIME` bigint NOT NULL,
  `PRIORITY` int NOT NULL,
  `STATE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `IS_NONCONCURRENT` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `REQUESTS_RECOVERY` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`ENTRY_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_fired_triggers` */

/*Table structure for table `qrtz_job_details` */

DROP TABLE IF EXISTS `qrtz_job_details`;

CREATE TABLE `qrtz_job_details` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `JOB_CLASS_NAME` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `IS_DURABLE` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `IS_NONCONCURRENT` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `IS_UPDATE_DATA` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_job_details` */

insert  into `qrtz_job_details`(`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`,`DESCRIPTION`,`JOB_CLASS_NAME`,`IS_DURABLE`,`IS_NONCONCURRENT`,`IS_UPDATE_DATA`,`REQUESTS_RECOVERY`,`JOB_DATA`) values 
('DefaultQuartzScheduler','com.system.quartz.job.SynchronizationJob','DEFAULT',NULL,'com.system.quartz.job.SynchronizationJob','0','0','0','0','\0sr\0org.quartz.JobDataMap迩\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap](\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap.(v\n\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap`\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0	parametert\0\0x\0');

/*Table structure for table `qrtz_locks` */

DROP TABLE IF EXISTS `qrtz_locks`;

CREATE TABLE `qrtz_locks` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `LOCK_NAME` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`LOCK_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_locks` */

insert  into `qrtz_locks`(`SCHED_NAME`,`LOCK_NAME`) values 
('DefaultQuartzScheduler','STATE_ACCESS'),
('DefaultQuartzScheduler','TRIGGER_ACCESS');

/*Table structure for table `qrtz_paused_trigger_grps` */

DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;

CREATE TABLE `qrtz_paused_trigger_grps` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_paused_trigger_grps` */

/*Table structure for table `qrtz_scheduler_state` */

DROP TABLE IF EXISTS `qrtz_scheduler_state`;

CREATE TABLE `qrtz_scheduler_state` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `INSTANCE_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `LAST_CHECKIN_TIME` bigint NOT NULL,
  `CHECKIN_INTERVAL` bigint NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`INSTANCE_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_scheduler_state` */

insert  into `qrtz_scheduler_state`(`SCHED_NAME`,`INSTANCE_NAME`,`LAST_CHECKIN_TIME`,`CHECKIN_INTERVAL`) values 
('DefaultQuartzScheduler','01761f9c48a51671443289780',1681184898532,10000);

/*Table structure for table `qrtz_simple_triggers` */

DROP TABLE IF EXISTS `qrtz_simple_triggers`;

CREATE TABLE `qrtz_simple_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `REPEAT_COUNT` bigint NOT NULL,
  `REPEAT_INTERVAL` bigint NOT NULL,
  `TIMES_TRIGGERED` bigint NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_simple_triggers` */

/*Table structure for table `qrtz_simprop_triggers` */

DROP TABLE IF EXISTS `qrtz_simprop_triggers`;

CREATE TABLE `qrtz_simprop_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `STR_PROP_1` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `STR_PROP_2` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `STR_PROP_3` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `INT_PROP_1` int DEFAULT NULL,
  `INT_PROP_2` int DEFAULT NULL,
  `LONG_PROP_1` bigint DEFAULT NULL,
  `LONG_PROP_2` bigint DEFAULT NULL,
  `DEC_PROP_1` decimal(13,4) DEFAULT NULL,
  `DEC_PROP_2` decimal(13,4) DEFAULT NULL,
  `BOOL_PROP_1` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `BOOL_PROP_2` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_simprop_triggers` */

/*Table structure for table `qrtz_triggers` */

DROP TABLE IF EXISTS `qrtz_triggers`;

CREATE TABLE `qrtz_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `NEXT_FIRE_TIME` bigint DEFAULT NULL,
  `PREV_FIRE_TIME` bigint DEFAULT NULL,
  `PRIORITY` int DEFAULT NULL,
  `TRIGGER_STATE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `TRIGGER_TYPE` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `START_TIME` bigint NOT NULL,
  `END_TIME` bigint DEFAULT NULL,
  `CALENDAR_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `MISFIRE_INSTR` smallint DEFAULT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `SCHED_NAME` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `qrtz_job_details` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `qrtz_triggers` */

insert  into `qrtz_triggers`(`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`,`JOB_NAME`,`JOB_GROUP`,`DESCRIPTION`,`NEXT_FIRE_TIME`,`PREV_FIRE_TIME`,`PRIORITY`,`TRIGGER_STATE`,`TRIGGER_TYPE`,`START_TIME`,`END_TIME`,`CALENDAR_NAME`,`MISFIRE_INSTR`,`JOB_DATA`) values 
('DefaultQuartzScheduler','com.system.quartz.job.SynchronizationJob','DEFAULT','com.system.quartz.job.SynchronizationJob','DEFAULT',NULL,1681184940000,1681184880000,5,'WAITING','CRON',1671594011000,0,NULL,0,'');

/*Table structure for table `sys_depart` */

DROP TABLE IF EXISTS `sys_depart`;

CREATE TABLE `sys_depart` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '父机构ID',
  `depart_name` varchar(100) NOT NULL COMMENT '机构/部门名称',
  `description` varchar(128) DEFAULT NULL COMMENT '描述',
  `depart_order` int DEFAULT '0' COMMENT '排序',
  `org_category` varchar(10) NOT NULL DEFAULT '1' COMMENT '机构类别 1组织机构，2岗位',
  `org_type` varchar(10) DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) NOT NULL COMMENT '机构编码',
  `status` varchar(1) DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_depart_org_code` (`org_code`) USING BTREE,
  KEY `index_depart_parent_id` (`parent_id`) USING BTREE,
  KEY `index_depart_depart_order` (`depart_order`) USING BTREE,
  KEY `index_depart_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='组织机构表';

/*Data for the table `sys_depart` */

/*Table structure for table `sys_fill_rule` */

DROP TABLE IF EXISTS `sys_fill_rule`;

CREATE TABLE `sys_fill_rule` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_sys_fill_rule_code` (`rule_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_fill_rule` */

insert  into `sys_fill_rule`(`id`,`rule_name`,`rule_code`,`rule_class`,`rule_params`,`update_by`,`update_time`,`create_by`,`create_time`) values 
('1202551334738382850','机构编码生成','org_num_role','com.starbos.cloud.oauth.system.rule.OrgCodeRule','{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}','admin','2022-05-18 12:00:20','admin','2022-05-18 12:00:12');

/*Table structure for table `sys_permission` */

DROP TABLE IF EXISTS `sys_permission`;

CREATE TABLE `sys_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编码',
  `fsort` bigint DEFAULT NULL COMMENT '排序',
  `type` int NOT NULL DEFAULT '1' COMMENT '菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)',
  `perm_tag` varchar(128) NOT NULL COMMENT '表单key',
  `path` varchar(258) NOT NULL COMMENT '路径',
  `component` varchar(64) DEFAULT '' COMMENT '组件',
  `title` varchar(32) NOT NULL COMMENT '菜单名称',
  `icon` varchar(32) DEFAULT '' COMMENT '菜单图标',
  `parent_id` bigint NOT NULL DEFAULT '0' COMMENT '父节点',
  `is_leaf` tinyint(1) DEFAULT '1' COMMENT '是否叶子节点:    1:是   0:不是',
  `sort_no` double(8,2) DEFAULT NULL COMMENT '菜单排序',
  `fremarks` varchar(128) DEFAULT '' COMMENT '备注',
  `fstatus` varchar(1) DEFAULT '1' COMMENT '状态',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tag` (`perm_tag`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_permission` */

insert  into `sys_permission`(`id`,`fsort`,`type`,`perm_tag`,`path`,`component`,`title`,`icon`,`parent_id`,`is_leaf`,`sort_no`,`fremarks`,`fstatus`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,0,0,'system','/system','Layout','系统管理','Setting',0,0,0.00,'','','2022-08-01 09:50:54','','2022-03-31 17:21:29',''),
(2,0,1,'menu','/menu','/system/menuManage','菜单管理','',1,1,2.00,'','','2022-08-01 11:27:13','','2022-03-31 18:19:39',''),
(3,0,1,'role','/role','/system/roleManage','角色管理','',1,1,3.00,'','','2022-08-01 11:27:14','','2022-04-02 17:16:42',''),
(4,0,1,'user','/user','/system/userManage','用户管理','',1,1,4.00,'','','2022-08-08 09:47:47','','2022-04-15 10:45:07',''),
(5,NULL,0,'business','/business','Layout','业务管理','Setting',0,0,1.00,'','1','2022-09-16 09:26:17','','2022-09-16 09:24:46',''),
(6,NULL,1,'licInformation','/licInformation','/business/licInformation','Lic信息','',5,1,0.00,'','1','2022-09-16 09:26:17','','2022-09-16 09:26:17',''),
(7,NULL,1,'onlineVerification','/onlineVerification','/business/onlineVerification','Lic在线验证','',5,1,1.00,'','1','2022-09-16 09:28:26','','2022-09-16 09:28:09',''),
(8,NULL,1,'imageService','/imageService','/imageService/index','镜像','',5,1,0.00,'','1','2023-12-22 15:23:57','','2023-12-22 15:23:57','');

/*Table structure for table `sys_role` */

DROP TABLE IF EXISTS `sys_role`;

CREATE TABLE `sys_role` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_code` varchar(64) DEFAULT NULL,
  `role_Name` varchar(64) NOT NULL,
  `role_Desc` varchar(64) NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_role` */

insert  into `sys_role`(`id`,`role_code`,`role_Name`,`role_Desc`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,'admin','管理员','管理员','2022-04-21 11:32:51','admin','2022-03-31 17:21:29','');

/*Table structure for table `sys_role_permission` */

DROP TABLE IF EXISTS `sys_role_permission`;

CREATE TABLE `sys_role_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_id` bigint NOT NULL,
  `perm_id` bigint NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_role_prem_id` (`role_id`,`perm_id`),
  KEY `idx_perm_id` (`perm_id`),
  KEY `idx_role_id` (`perm_id`),
  CONSTRAINT `sys_role_permission_ibfk_1` FOREIGN KEY (`perm_id`) REFERENCES `sys_permission` (`id`),
  CONSTRAINT `sys_role_permission_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_role_permission` */

insert  into `sys_role_permission`(`id`,`role_id`,`perm_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,1,1,'2022-08-01 09:52:02','','2022-08-01 09:52:02',''),
(2,1,2,'2022-08-01 09:52:03','','2022-08-01 09:52:03',''),
(3,1,3,'2022-08-01 09:52:05','','2022-08-01 09:52:05',''),
(4,1,4,'2022-08-01 09:52:06','','2022-08-01 09:52:06',''),
(5,1,5,'2022-09-16 09:25:12','','2022-09-16 09:25:12',''),
(6,1,6,'2022-09-16 09:26:49','','2022-09-16 09:26:49',''),
(7,1,7,'2022-09-16 09:28:39','','2022-09-16 09:28:39',''),
(8,1,8,'2023-12-22 15:24:10','','2023-12-22 15:24:10','');

/*Table structure for table `sys_sms` */

DROP TABLE IF EXISTS `sys_sms`;

CREATE TABLE `sys_sms` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `es_title` varchar(100) DEFAULT NULL COMMENT '消息标题',
  `es_type` varchar(1) DEFAULT NULL COMMENT '发送方式：1短信 2邮件 3微信',
  `es_receiver` varchar(50) DEFAULT NULL COMMENT '接收人',
  `es_param` varchar(1000) DEFAULT NULL COMMENT '发送所需参数Json格式',
  `es_content` longtext COMMENT '推送内容',
  `es_send_time` datetime DEFAULT NULL COMMENT '推送时间',
  `es_send_status` varchar(1) DEFAULT NULL COMMENT '推送状态 0未推送 1推送成功 2推送失败 -1失败不再发送',
  `es_send_num` int DEFAULT NULL COMMENT '发送次数 超过5次不再发送',
  `es_result` varchar(255) DEFAULT NULL COMMENT '推送失败原因',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_type` (`es_type`) USING BTREE,
  KEY `index_receiver` (`es_receiver`) USING BTREE,
  KEY `index_sendtime` (`es_send_time`) USING BTREE,
  KEY `index_status` (`es_send_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms` */

/*Table structure for table `sys_sms_template` */

DROP TABLE IF EXISTS `sys_sms_template`;

CREATE TABLE `sys_sms_template` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `template_name` varchar(50) DEFAULT NULL COMMENT '模板标题',
  `template_code` varchar(32) NOT NULL COMMENT '模板CODE',
  `template_type` varchar(1) NOT NULL COMMENT '模板类型：1短信 2邮件 3微信',
  `template_content` varchar(1000) NOT NULL COMMENT '模板内容',
  `template_test_json` varchar(1000) DEFAULT NULL COMMENT '模板测试json',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_templatecode` (`template_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms_template` */

/*Table structure for table `sys_user` */

DROP TABLE IF EXISTS `sys_user`;

CREATE TABLE `sys_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL COMMENT '账号',
  `realname` varchar(50) DEFAULT '' COMMENT '真名',
  `password` varchar(64) NOT NULL COMMENT '密码',
  `create_Date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_Login_Time` date DEFAULT NULL COMMENT '最后登录时间',
  `enabled` int DEFAULT '0',
  `account_Non_Expired` int DEFAULT '0',
  `account_Non_Locked` int DEFAULT '0',
  `credentials_Non_Expired` int DEFAULT '0',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_account_username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_user` */

insert  into `sys_user`(`id`,`username`,`realname`,`password`,`create_Date`,`last_Login_Time`,`enabled`,`account_Non_Expired`,`account_Non_Locked`,`credentials_Non_Expired`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,'admin','张三','$2a$10$6Lx/bmiLraMqI/MwE3d0y.B7fMjNkS2mN4M8o9sANbxCOw2Js2hiq','2021-11-13 00:00:00','2022-03-01',1,1,1,1,'2022-03-31 17:21:29','','2022-03-31 17:21:29','');

/*Table structure for table `sys_user_depart` */

DROP TABLE IF EXISTS `sys_user_depart`;

CREATE TABLE `sys_user_depart` (
  `ID` bigint NOT NULL COMMENT 'id',
  `user_id` bigint DEFAULT NULL COMMENT '用户id',
  `dep_id` varchar(32) DEFAULT NULL COMMENT '部门id',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_depart_groupk_userid` (`user_id`) USING BTREE,
  KEY `index_depart_groupkorgid` (`dep_id`) USING BTREE,
  KEY `index_depart_groupk_uidanddid` (`user_id`,`dep_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_user_depart` */

/*Table structure for table `sys_user_message` */

DROP TABLE IF EXISTS `sys_user_message`;

CREATE TABLE `sys_user_message` (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `avatar` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71' COMMENT '头像url',
  `introduction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户介绍',
  `fauth_account` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '账号',
  `fenglish_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `fwork_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工号',
  `fdept` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `fphone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机',
  `fmail` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `fwork_addr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工作地点',
  `fposition` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职位',
  `finduction_date` datetime DEFAULT NULL COMMENT '入职日期',
  `fstate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '状态',
  `fdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `fcreator` varchar(67) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `idx_auth_account` (`fauth_account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/*Data for the table `sys_user_message` */

insert  into `sys_user_message`(`user_id`,`name`,`avatar`,`introduction`,`fauth_account`,`fenglish_name`,`fwork_no`,`fdept`,`fphone`,`fmail`,`fwork_addr`,`fposition`,`finduction_date`,`fstate`,`fdate`,`fcreator`) values 
(1,'张三','https://ss0.baidu.com/94o3dSag_xI4khGko9WTAnF6hhy/baike/s=220/sign=92f3220861d0f703e2b292de38fb5148/37d3d539b6003af32267a87f362ac65c1138b6cb.jpg','','admin','admin','114514','','','114514@homo.com','123','','2022-04-12 00:00:00','困','2022-04-02 00:00:00','');

/*Table structure for table `sys_user_role` */

DROP TABLE IF EXISTS `sys_user_role`;

CREATE TABLE `sys_user_role` (
  `user_id` bigint DEFAULT NULL,
  `role_id` bigint DEFAULT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  KEY `FK_Reference_1` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `FK_Reference_1` FOREIGN KEY (`user_id`) REFERENCES `sys_user` (`id`),
  CONSTRAINT `sys_user_role_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_user_role` */

insert  into `sys_user_role`(`user_id`,`role_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,1,'2022-06-08 14:22:02','','2022-06-08 14:22:02','');

/*Table structure for table `t_docker_image` */

DROP TABLE IF EXISTS `t_docker_image`;

CREATE TABLE `t_docker_image` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(64) NOT NULL,
  `context_path` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `describe` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb3;

/*Data for the table `t_docker_image` */

insert  into `t_docker_image`(`id`,`name`,`context_path`,`describe`) values 
(7,'all-product-mysql','',''),
(8,'all-product-redis','',''),
(9,'lowcodeplatform-system','',''),
(10,'lowcodeplatform-portal','*',''),
(11,'integration-system','',''),
(12,'integration-portal','',''),
(13,'erp-system','',''),
(14,'wms-system','',''),
(15,'integration-kis-adapter','',''),
(16,'integration-tianbao-adapter','',''),
(17,'integration-erptianbao-adapter','',''),
(18,'integration-tonghang-adapter','',''),
(19,'integration-kingdee-adapter','',''),
(21,'bojarcrm-adapter','',''),
(22,'fw-oa-adapter','',''),
(23,'integration-tillersystems-adapter','','意善门店'),
(24,'integration-prestashop-adapter','','意善商城'),
(25,'integration-kingdeestar-adapter','','意善星辰'),
(26,'integration-cbs-adapter','',''),
(27,'integration-crm-adapter','',''),
(28,'sql-adapter','',''),
(29,'integration-appleerp-adapter','','良堃apple适配器'),
(30,'common-kingdeestar-adapter','','通用金蝶云星辰适配器'),
(31,'comman-adapter','',''),
(32,'sf-adapter','','数夫'),
(33,'mock-system','','mock系统模块'),
(34,'wx-adapter','','WX待办'),
(35,'integration-annaspeakscm-adapter','','安漾适配器'),
(36,'dingtalk-adapter','','钉钉适配器'),
(37,'integration-ibmmq-adapter','','ibmmq'),
(38,'integration-tianbaov2-adapter','',''),
(39,'jst-adapter','','聚水谭适配器'),
(40,'mock-portal','',''),
(41,'wms-portal','',''),
(42,'pcoa-adapter','','');

/*Table structure for table `t_docker_image_version` */

DROP TABLE IF EXISTS `t_docker_image_version`;

CREATE TABLE `t_docker_image_version` (
  `id` int NOT NULL AUTO_INCREMENT,
  `image_id` int NOT NULL,
  `version` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb3;

/*Data for the table `t_docker_image_version` */

insert  into `t_docker_image_version`(`id`,`image_id`,`version`) values 
(7,7,'latest'),
(8,8,'5.0'),
(9,9,'latest'),
(11,10,'latest'),
(12,11,'latest'),
(13,12,'latest'),
(14,13,'latest'),
(15,14,'latest'),
(16,15,'latest'),
(17,16,'latest'),
(18,17,'latest'),
(19,18,'latest'),
(20,19,'latest'),
(23,21,'latest'),
(24,22,'latest'),
(25,23,'latest'),
(26,24,'latest'),
(28,25,'latest'),
(29,26,'latest'),
(30,27,'latest'),
(31,28,'latest'),
(32,29,'latest'),
(33,30,'latest'),
(34,31,'latest'),
(36,32,'latest'),
(37,33,'latest'),
(38,34,'latest'),
(40,35,'latest'),
(41,36,'latest'),
(42,37,'latest'),
(43,38,'latest'),
(45,39,'latest'),
(46,40,'latest'),
(48,41,'latest'),
(50,42,'latest'),
(51,11,'beta');

/*Table structure for table `t_schedule_trigger` */

DROP TABLE IF EXISTS `t_schedule_trigger`;

CREATE TABLE `t_schedule_trigger` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cron` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `status` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `job_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `job_name` (`job_name`,`job_group`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `t_schedule_trigger` */

/*Table structure for table `t_schedule_trigger_param` */

DROP TABLE IF EXISTS `t_schedule_trigger_param`;

CREATE TABLE `t_schedule_trigger_param` (
  `param_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `value` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `schedule_trigger_id` int NOT NULL,
  PRIMARY KEY (`param_id`) USING BTREE,
  KEY `schedule_trigger_id` (`schedule_trigger_id`) USING BTREE,
  CONSTRAINT `t_schedule_trigger_param_ibfk_1` FOREIGN KEY (`schedule_trigger_id`) REFERENCES `t_schedule_trigger` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC;

/*Data for the table `t_schedule_trigger_param` */

/*Table structure for table `tb_form_table_structure` */

DROP TABLE IF EXISTS `tb_form_table_structure`;

CREATE TABLE `tb_form_table_structure` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `form_id` varchar(64) NOT NULL COMMENT '表单标识',
  `db_table_name` varchar(128) NOT NULL COMMENT '数据库表名',
  `db_table_comment` varchar(128) NOT NULL COMMENT '数据库表注释',
  `form_json` longtext NOT NULL COMMENT '前端表单Json',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC COMMENT='表单表结构表';

/*Data for the table `tb_form_table_structure` */

insert  into `tb_form_table_structure`(`id`,`form_id`,`db_table_name`,`db_table_comment`,`form_json`,`create_time`,`update_time`) values 
(18,'a','a','1','{\"config\":{\"size\":\"default\",\"hideRequiredAsterisk\":false,\"labelWidth\":100,\"labelPosition\":\"right\",\"dbTableComment\":\"1\",\"dbTableName\":\"a\",\"formId\":\"a\"},\"list\":[{\"label\":\"唯一标识\",\"type\":\"input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"placeholder\":\"\",\"maxlength\":null,\"prefix\":\"\",\"suffix\":\"\",\"prepend\":\"\",\"append\":\"\",\"disabled\":false,\"clearable\":false,\"readonly\":false,\"rules\":{\"trigger\":\"blur\",\"enum\":\"\",\"message\":\"\",\"pattern\":\"\",\"required\":false,\"type\":\"any\"}},\"key\":\"2c37b3b9c20543a481c0c6ee37e62387\",\"model\":\"queue_id\",\"rules\":[],\"dbFieldName\":\"queue_id\",\"dbFieldComment\":\"唯一标识\"},{\"label\":\"a\",\"type\":\"input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"placeholder\":\"\",\"maxlength\":null,\"prefix\":\"\",\"suffix\":\"\",\"prepend\":\"\",\"append\":\"\",\"disabled\":false,\"clearable\":false,\"readonly\":false,\"rules\":{\"trigger\":\"blur\",\"enum\":\"\",\"message\":\"\",\"pattern\":\"\",\"required\":false,\"type\":\"any\"}},\"key\":\"a40c514ef8264885ab51e1fa1754e7ae\",\"model\":\"a\",\"rules\":[],\"dbFieldName\":\"a\",\"dbFieldComment\":\"a\"}]}','2022-12-13 11:09:15','2022-12-13 11:09:15'),
(20,'ora_ReceiveBill','ora_receivebill','收料通知单','{\"config\":{\"size\":\"default\",\"hideRequiredAsterisk\":false,\"labelWidth\":100,\"labelPosition\":\"right\",\"dbTableComment\":\"收料通知单\",\"dbTableName\":\"ora_receivebill\",\"formId\":\"ora_ReceiveBill\"},\"list\":[{\"label\":\"唯一标识\",\"type\":\"input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"placeholder\":\"\",\"maxlength\":null,\"prefix\":\"\",\"suffix\":\"\",\"prepend\":\"\",\"append\":\"\",\"disabled\":false,\"clearable\":false,\"readonly\":false,\"rules\":{\"trigger\":\"blur\",\"enum\":\"\",\"message\":\"\",\"pattern\":\"\",\"required\":false,\"type\":\"any\"}},\"key\":\"4f2cb2dd76a348c693a48d26ab3e6366\",\"model\":\"queue_id\",\"rules\":[],\"dbFieldName\":\"queue_id\",\"dbFieldComment\":\"唯一标识\"},{\"label\":\"供应商\",\"type\":\"input\",\"options\":{\"width\":\"100%\",\"defaultValue\":\"\",\"placeholder\":\"\",\"maxlength\":null,\"prefix\":\"\",\"suffix\":\"\",\"prepend\":\"\",\"append\":\"\",\"disabled\":false,\"clearable\":false,\"readonly\":false,\"rules\":{\"trigger\":\"blur\",\"enum\":\"\",\"message\":\"\",\"pattern\":\"\",\"required\":false,\"type\":\"any\"}},\"key\":\"c4db23c495bf4347bea1fc317043a0f5\",\"model\":\"FSupplierId\",\"rules\":[],\"dbFieldName\":\"FSupplierId\",\"dbFieldComment\":\"供应商\"}]}','2022-12-13 11:13:46','2022-12-13 11:13:46');

/*Table structure for table `tb_init_connect_param` */

DROP TABLE IF EXISTS `tb_init_connect_param`;

CREATE TABLE `tb_init_connect_param` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `k3_cloud_url` varchar(64) NOT NULL COMMENT '金蝶地址',
  `dbid` varchar(64) NOT NULL COMMENT '金蝶账套',
  `uid` varchar(64) NOT NULL COMMENT '用户名',
  `pwd` varchar(64) NOT NULL COMMENT '密码',
  `lang` int NOT NULL COMMENT '端口',
  `is_auto_submit` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否提交审核',
  `third_party_url` varchar(128) NOT NULL COMMENT '第三方路径',
  `duration` int DEFAULT '1' COMMENT '定时任务时长/分钟',
  `lic_cipher_text` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'lic密文',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='金蝶配置表';

/*Data for the table `tb_init_connect_param` */

insert  into `tb_init_connect_param`(`id`,`k3_cloud_url`,`dbid`,`uid`,`pwd`,`lang`,`is_auto_submit`,`third_party_url`,`duration`,`lic_cipher_text`,`create_time`,`update_time`) values 
(1,'https://basicsemi.ik3cloud.com/k3cloud/','20210526143446196','wusiyuan','123!iopjkl',2052,0,'http://192.168.50.213:8060/api/updateImsData',1,NULL,'2022-07-20 11:35:18','2022-12-21 11:40:08');

/*Table structure for table `tb_kingdee_common_config` */

DROP TABLE IF EXISTS `tb_kingdee_common_config`;

CREATE TABLE `tb_kingdee_common_config` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `s_form_id` varchar(64) NOT NULL COMMENT '金蝶标识',
  `doc_type` varchar(64) NOT NULL COMMENT '第三方标识',
  `name` varchar(64) NOT NULL COMMENT '日志名称',
  `flag` tinyint NOT NULL COMMENT '配置方向（-1-ERP/MES 1-MES/ERP）',
  `primary_key_field` varchar(64) DEFAULT NULL COMMENT '单据主键字段',
  `entry_primary_key_field` varchar(64) DEFAULT NULL COMMENT '单据分录主键字段',
  `mes_entry_name` varchar(64) DEFAULT NULL COMMENT 'MES分录标识',
  `entry_name` varchar(64) DEFAULT NULL COMMENT '分录标识',
  `fathers_form_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '源单标识',
  `father_entry_name` varchar(64) DEFAULT NULL COMMENT '源单分录标识',
  `push_rule` varchar(64) DEFAULT NULL COMMENT '下推规则',
  `link_fs_id_name` varchar(64) DEFAULT NULL COMMENT '子源单行内码',
  `is_in_transaction` tinyint(1) DEFAULT NULL COMMENT '是否在事务中',
  `is_auto_perform` tinyint(1) DEFAULT '3' COMMENT '执行步骤（0-暂存，1-保存，2-提交，3-审核）',
  `kingdee_filed_detail` longtext NOT NULL COMMENT '金蝶字段相关明细',
  `plug_in_url` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '插件地址',
  `custom_sql` text COMMENT '自定义Sql',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='金蝶通用配置表';

/*Data for the table `tb_kingdee_common_config` */

insert  into `tb_kingdee_common_config`(`id`,`s_form_id`,`doc_type`,`name`,`flag`,`primary_key_field`,`entry_primary_key_field`,`mes_entry_name`,`entry_name`,`fathers_form_id`,`father_entry_name`,`push_rule`,`link_fs_id_name`,`is_in_transaction`,`is_auto_perform`,`kingdee_filed_detail`,`plug_in_url`,`custom_sql`,`create_time`,`update_time`) values 
(1,'BD_Supplier','BS_SUP','供应商',-1,'FSupplierId','','bs_sup_dt','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"sup_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"供应商名称\",\"thirdPartyField\":\"sup_name\"},{\"isDetailField\":false,\"erpName\":\"国家\",\"kingdeeField\":\"FCountry\",\"type\":\"文本\",\"mesName\":\"国家编码\",\"thirdPartyField\":\"country_code\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":true,\"erpName\":\"联系人\",\"kingdeeField\":\"FContact\",\"type\":\"文本\",\"mesName\":\"联系人\",\"thirdPartyField\":\"contacts_user\"},{\"isDetailField\":true,\"erpName\":\"电话\",\"kingdeeField\":\"FTel\",\"type\":\"数值\",\"mesName\":\"联系电话\",\"thirdPartyField\":\"contacts_phone\"},{\"isDetailField\":true,\"erpName\":\"默认联系人\",\"kingdeeField\":\"FContactIsDefault\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"默认联系人\",\"thirdPartyField\":\"FContactIsDefault\"}]','','','2022-08-03 09:23:03','2022-10-27 17:33:47'),
(2,'BD_Customer','BS_CUST','客户',-1,'FCUSTID',NULL,'','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"客户编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"客户编码\",\"thirdPartyField\":\"cust_code\"},{\"isDetailField\":false,\"erpName\":\"客户名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"客户名称\",\"thirdPartyField\":\"cust_name\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":false,\"erpName\":\"备注\",\"kingdeeField\":\"FDescription\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"}]','','','2022-08-03 09:57:34','2022-08-30 17:45:59'),
(4,'BD_STOCK','BS_STORE','仓库',-1,'FStockId',NULL,'','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"store_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"仓库名称\",\"thirdPartyField\":\"store_name\"},{\"isDetailField\":false,\"erpName\":\"库存状态类型\",\"kingdeeField\":\"FStockStatusType\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"仓库类型\",\"thirdPartyField\":\"store_type\"}]','','','2022-08-03 09:59:00','2022-08-30 17:46:00'),
(5,'BD_MATERIAL','BS_MTRL','物料',-1,'FMATERIALID','','','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"物料编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"group_code\"},{\"isDetailField\":false,\"erpName\":\"物料编码\",\"kingdeeField\":\"FOldNumber\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"mtrl_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"物料名称\",\"thirdPartyField\":\"mtrl_name\"},{\"isDetailField\":false,\"erpName\":\"规格型号\",\"kingdeeField\":\"FSpecification\",\"type\":\"文本\",\"mesName\":\"物料规格\",\"thirdPartyField\":\"mtrl_desc\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":false,\"erpName\":\"最小包装数\",\"kingdeeField\":\"FMinPackCount\",\"type\":\"数值\",\"mesName\":\"最小包装数\",\"thirdPartyField\":\"pack_qty\"},{\"isDetailField\":false,\"erpName\":\"基本单位\",\"kingdeeField\":\"FBaseUnitId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"单位\",\"thirdPartyField\":\"munit\"},{\"isDetailField\":false,\"erpName\":\"物料状态\",\"kingdeeField\":\"F_ora_Assistant\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料状态\",\"thirdPartyField\":\"mtrl_status\"},{\"isDetailField\":false,\"erpName\":\"组织\",\"kingdeeField\":\"FUseOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"组织代码\",\"thirdPartyField\":\"org_id\"},{\"isDetailField\":false,\"erpName\":\"描述\",\"kingdeeField\":\"F_ORA_TEXT1\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料描述\",\"thirdPartyField\":\"mtrl_miaoshu\"}]','','','2022-08-03 11:39:26','2022-11-08 15:44:28'),
(6,'ENG_BOM','BS_BOM','物料清单',-1,'FID',NULL,'bs_bom_mtrl','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"父项集团编码\",\"kingdeeField\":\"FMATERIALID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"父项集团编码\",\"thirdPartyField\":\"prod_code\"},{\"isDetailField\":false,\"erpName\":\"父项公司编码\",\"kingdeeField\":\"F_ora_BaseProperty1\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"父项物料编码\",\"thirdPartyField\":\"fprod_code\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"启用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":true,\"erpName\":\"子项物料编码\",\"kingdeeField\":\"FMATERIALIDCHILD\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\" mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"公司物料编码\",\"kingdeeField\":\"F_ora_BaseProperty2\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"子项MES物料编码\",\"thirdPartyField\":\"mes_mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FMEMO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"},{\"isDetailField\":true,\"erpName\":\"是否主料\",\"kingdeeField\":\"FIskeyItem\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"是否主料\",\"thirdPartyField\":\"is_main\"},{\"isDetailField\":true,\"erpName\":\"用量分母\",\"kingdeeField\":\"FDENOMINATOR\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"用量分母\",\"thirdPartyField\":\"dosage\"},{\"isDetailField\":true,\"erpName\":\"点位\",\"kingdeeField\":\"FPOSITIONNO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"点位\",\"thirdPartyField\":\"point_str\"},{\"isDetailField\":true,\"erpName\":\"主料编码\",\"kingdeeField\":\"main_code\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"主料编码\",\"thirdPartyField\":\"main_code\"},{\"isDetailField\":true,\"erpName\":\"层级\",\"kingdeeField\":\"Lev\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"层级\",\"thirdPartyField\":\"Lev\"}]','http://192.168.50.211:9090/semiconductor/api/materials/list/plug','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,a.FREPLACEGROUP as xc,\n1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=@FID) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,c.FREPLACEGROUP  as xc,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  ,a.FREPLACEGROUP \n from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,\nstepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z order by Lev,FSEQ,xc','2022-08-03 11:41:54','2022-10-13 17:07:00'),
(7,'PUR_PurchaseOrder','SM_PO','采购订单',-1,'FID','','sm_po_dt','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"单据编号\",\"kingdeeField\":\"FBillNo\",\"type\":\"FNumber\",\"mesName\":\"采购订单编码\",\"thirdPartyField\":\"po_code\"},{\"isDetailField\":false,\"erpName\":\"采购日期\",\"kingdeeField\":\"FDate\",\"type\":\"文本\",\"mesName\":\"日期\",\"thirdPartyField\":\"indate\"},{\"isDetailField\":false,\"erpName\":\"供应商\",\"kingdeeField\":\"FSupplierId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"sup_code\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"采购数量\",\"kingdeeField\":\"FQty\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"m_qty\"},{\"isDetailField\":true,\"erpName\":\"数量\",\"kingdeeField\":\"FPlanQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"交货数量\",\"thirdPartyField\":\"ro_qty\"},{\"isDetailField\":true,\"erpName\":\"采购单位\",\"kingdeeField\":\"FUnitID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"采购单位\",\"thirdPartyField\":\"po_unit\"},{\"isDetailField\":true,\"erpName\":\"税额\",\"kingdeeField\":\"FEntryTaxAmount\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"税额\",\"thirdPartyField\":\"tax\"},{\"isDetailField\":true,\"erpName\":\"价税合计\",\"kingdeeField\":\"FAllAmount\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"价税合计\",\"thirdPartyField\":\"totalmoney\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntryNote\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"},{\"isDetailField\":true,\"erpName\":\"分录主键\",\"kingdeeField\":\"FPOOrderEntry_FEntryID\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"ERP行内码\",\"thirdPartyField\":\"ERP_SIC\"},{\"isDetailField\":true,\"erpName\":\"规格型号\",\"kingdeeField\":\"FModel\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料规格\",\"thirdPartyField\":\"po_mtrl_descs\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"F_ora_BaseProperty\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"ma_code\"},{\"isDetailField\":true,\"erpName\":\"业务关闭\",\"kingdeeField\":\"FMRPCloseStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"业务关闭\",\"thirdPartyField\":\"CloseStatus\"},{\"isDetailField\":true,\"erpName\":\"关闭状态\",\"kingdeeField\":\"FCloseStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"订单关闭状态\",\"thirdPartyField\":\"FCloseStatus\"}]','','','2022-08-03 12:00:05','2022-10-27 17:36:18'),
(10,'STK_MisDelivery','BS0043','其他出库',-1,'FID','','dtl','','','','','',1,3,'[{\"isDetailField\":true,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"发货仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"其他出库单号\",\"thirdPartyField\":\"REF_TRX_CODE\"}]','','','2022-08-03 17:10:19','2023-02-21 13:16:15'),
(11,'PRD_PPBOM','WMS0004','生产用料清单',1,'','','','FEntity','','','','',0,1,'[{\"isDetailField\":true,\"erpName\":\"货主类型\",\"kingdeeField\":\"FOwnerTypeId\",\"indexField\":\"\",\"type\":\"基础资料\",\"mesName\":\"货主类型\",\"thirdPartyField\":\"SHIPPER_TYPE\"},{\"isDetailField\":true,\"erpName\":\"货主\",\"kingdeeField\":\"FOwnerID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"货主\",\"thirdPartyField\":\"SHIPPER_ID\"},{\"isDetailField\":true,\"erpName\":\"子项物料编码\",\"kingdeeField\":\"FMaterialID2\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"标准用量\",\"kingdeeField\":\"FStdQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"用量\",\"thirdPartyField\":\"DOSAGE\"},{\"isDetailField\":true,\"erpName\":\"需求数量\",\"kingdeeField\":\"FNeedQty2\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"净需求数量\",\"thirdPartyField\":\"NN_QTY\"},{\"isDetailField\":true,\"erpName\":\"应发数量\",\"kingdeeField\":\"FMustQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"实际需求数量\",\"thirdPartyField\":\"TN_QTY\"},{\"isDetailField\":true,\"erpName\":\"位置号\",\"kingdeeField\":\"FPositionNO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"位置号\",\"thirdPartyField\":\"POINT_STR\"},{\"isDetailField\":false,\"erpName\":\"数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"计划数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"生产订单编号\",\"kingdeeField\":\"FMOBillNO1\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"生产订单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"行内码\",\"kingdeeField\":\"FEntryID\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"行内码\",\"thirdPartyField\":\"ERP_SIC\"},{\"isDetailField\":false,\"erpName\":\"主键\",\"kingdeeField\":\"FID\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"主键\",\"thirdPartyField\":\"ERP_FID\"},{\"isDetailField\":false,\"erpName\":\"生产订单行号\",\"kingdeeField\":\"FMoEntrySeq1\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"生产订单行号\",\"thirdPartyField\":\"MO_SEQ\"},{\"isDetailField\":true,\"erpName\":\"MES主键\",\"kingdeeField\":\"F_LQKJ_Code\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"MES主键\",\"thirdPartyField\":\"MES_CODE\"}]','http://192.168.50.211:9090/semiconductor/api/production/material/list/plug','','2022-08-03 17:25:24','2022-11-24 09:59:40'),
(12,'PRD_MO','WMS0002','生产订单',1,'',NULL,'','FTreeEntity','','1','','',1,2,'[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"生产订单编号\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"GROUP_ID\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"计划开工时间\",\"kingdeeField\":\"FPlanStartDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"计划开始时间\",\"thirdPartyField\":\"PB_DATE\"},{\"isDetailField\":true,\"erpName\":\"计划完工时间\",\"kingdeeField\":\"FPlanFinishDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"计划结束时间\",\"thirdPartyField\":\"PE_DATE\"},{\"isDetailField\":false,\"erpName\":\"单据日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"单据日期\",\"thirdPartyField\":\"PRD_DATE\"},{\"isDetailField\":true,\"erpName\":\"单位\",\"kingdeeField\":\"FUnitId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"单位\",\"thirdPartyField\":\"MUNIT\"},{\"isDetailField\":true,\"erpName\":\"生产车间\",\"kingdeeField\":\"FWorkShopID\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"生产车间\",\"thirdPartyField\":\"FWorkShopID\"},{\"isDetailField\":false,\"erpName\":\"基本单位数量\",\"kingdeeField\":\"FBaseSNQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"基本单位数量\",\"thirdPartyField\":\"FBaseSNQty\"},{\"isDetailField\":true,\"erpName\":\"MES主键\",\"kingdeeField\":\"F_LQKJ_Code\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"MES主键\",\"thirdPartyField\":\"MES_CODE\"}]','','','2022-08-03 17:54:41','2022-10-19 17:14:33'),
(13,'PRD_PickMtrl','WMS0003','生产领料单',1,'',NULL,'','FEntity','PRD_PPBOM','FEntity','PRD_IssueMtrl2PickMtrl','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FActualQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyMemo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"},{\"isDetailField\":true,\"erpName\":\"工单编码\",\"kingdeeField\":\"FEntrySrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"}]','http://192.168.50.211:9090/semiconductor/api/production/picking/plug','','2022-08-03 18:15:17','2022-10-19 17:15:11'),
(14,'PRD_FeedMtrl','BS0040','生产补料单',1,'',NULL,'','FEntity','PRD_PPBOM','FEntity','PRD_PPBOM2FEEDMTRL','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FActualQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyDescription\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"},{\"isDetailField\":true,\"erpName\":\"工单编码\",\"kingdeeField\":\"FEntrySrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"申请数量\",\"kingdeeField\":\"FAppQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"申请数量\",\"thirdPartyField\":\"QUANTITY\"}]','http://192.168.50.211:9090/semiconductor/api/production/picking/plug','','2022-08-03 18:21:58','2022-10-19 17:15:21'),
(15,'PRD_ReturnMtrl','BS0050','生产退料单',1,'',NULL,'','FEntity','PRD_PPBOM','FEntity','PRD_PPBOM2RETURNMTRL','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实退数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"系统源单编码\",\"kingdeeField\":\"FSrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyMemo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"}]','http://192.168.50.211:9090/semiconductor/api/production/picking/plug','','2022-08-03 18:26:16','2022-10-19 17:15:27'),
(16,'PRD_MO','BS0057','生产订单关闭',1,'',NULL,'','FEntryId','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"MES状态\",\"kingdeeField\":\"F_LQKJ_MESStates\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"MES状态\",\"thirdPartyField\":\"F_LQKJ_MESStates\"}]','','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = @MES_CODE','2022-08-03 18:31:01','2022-08-30 17:46:04'),
(17,'PRD_INSTOCK','BS0055','生产入库单',1,'',NULL,'','FEntity','PRD_MO','FTreeEntity','PRD_MO2INSTOCK','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"生产订单编码\",\"kingdeeField\":\"FMoBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"ERP_MO\"},{\"isDetailField\":true,\"erpName\":\"生产订单行号\",\"kingdeeField\":\"FMoEntrySeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"生产订单行号\",\"thirdPartyField\":\"ERP_SEQ\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FRealQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"入库组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"入库组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FStockerId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"USER_CODE\"}]','http://192.168.50.211:9090/semiconductor/api/production/warehousing/plug','','2022-08-03 18:37:47','2022-10-21 11:17:33'),
(18,'STK_OEMInStock','BS0004','受托加工材料入库单',1,'',NULL,'','FBillEntry','','','','',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":false,\"erpName\":\"客户\",\"kingdeeField\":\"FCustId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"客户编码\",\"thirdPartyField\":\"CUST_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"收货仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量(基本单位)\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"库存状态\",\"kingdeeField\":\"FStockStatusId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"库存状态\",\"thirdPartyField\":\"STOCK_TYPE\"}]','','','2022-08-03 18:42:44','2022-10-19 17:15:46'),
(19,'STK_InStock','WMS0012','采购入库单',1,'','','','FInStockEntry','PUR_ReceiveBill','FDetailEntity','PUR_ReceiveBill-STK_InStock','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"入库日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FRealQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"源单编码\",\"kingdeeField\":\"FSRCBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"采购单号\",\"thirdPartyField\":\"PO_CODE\"},{\"isDetailField\":true,\"erpName\":\"行号\",\"kingdeeField\":\"FSeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"采购行号\",\"thirdPartyField\":\"PO_SEQ\"},{\"isDetailField\":false,\"erpName\":\"收料部门\",\"kingdeeField\":\"FSTOCKDEPTID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"收料部门\",\"thirdPartyField\":\"STOCKDEP\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FSTOCKERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"STOCKUSER\"}]','','','2022-08-03 18:49:25','2022-12-13 14:09:13'),
(20,'PUR_MRB','BS0045','采购退料单',1,'','','','FPURMRBENTRY','STK_InStock','FInStockEntry','STK_InStock-PUR_MRB','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"退料日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实退数量\",\"kingdeeField\":\"FRMREALQTY\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"退料类型\",\"kingdeeField\":\"FMRTYPE\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"退料类型\",\"thirdPartyField\":\"FMRTYPE1\"},{\"isDetailField\":true,\"erpName\":\"仓库编码\",\"kingdeeField\":\"FSTOCKID\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"源单编码\",\"kingdeeField\":\"FSRCBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"采购入库单号\",\"thirdPartyField\":\"PO_CODE\"},{\"isDetailField\":true,\"erpName\":\"行号\",\"kingdeeField\":\"FSeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"采购入库单行号\",\"thirdPartyField\":\"PO_SEQ\"}]','','','2022-08-03 18:55:10','2022-12-16 17:38:02'),
(21,'STK_MISCELLANEOUS','BS0022','其他入库',1,'',NULL,'','FEntity','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"供应商\",\"kingdeeField\":\"FSUPPLIERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"SUP_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMATERIALID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":false,\"erpName\":\"库存组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"库存组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FSTOCKERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"实收数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"收货仓库\",\"kingdeeField\":\"FSTOCKID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"收货仓库\",\"thirdPartyField\":\"STORE_CODE\"}]','','','2022-08-03 19:00:38','2022-08-30 17:46:07'),
(22,'STK_StockCountGain','BS0028','盘点盘盈单',-1,'FID',NULL,'','FBillEntry','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"盘点数量\",\"kingdeeField\":\"FCountQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"库存组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"备注\",\"kingdeeField\":\"FNoteHead\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"}]','','','2022-08-03 19:05:00','2022-08-30 17:46:07'),
(23,'STK_StockCountLoss','BS0029','盘点盘亏单',-1,'FID',NULL,'','FBillEntry','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"盘点数量\",\"kingdeeField\":\"FCountQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"}]','','','2022-08-03 19:10:16','2022-08-30 17:46:08'),
(24,'STK_TransferDirect','BS0030','直接调拨单',1,'','','','FBillEntry','','','','',1,2,'[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"直接调拨单编码\",\"thirdPartyField\":\"FBillNo\"},{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"调出仓库\",\"kingdeeField\":\"FSrcStockId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"调出仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"调拨数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"调入仓库\",\"kingdeeField\":\"FDestStockId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"调入仓库编码\",\"thirdPartyField\":\"TO_STORE_CODE\"},{\"isDetailField\":false,\"erpName\":\"调出货主类型\",\"kingdeeField\":\"FOwnerTypeOutIdHead\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"调出货主类型\",\"thirdPartyField\":\"SHIPPER_TYPE\"},{\"isDetailField\":false,\"erpName\":\"调出货主\",\"kingdeeField\":\"FOwnerOutIdHead\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"调出货主\",\"thirdPartyField\":\"SHIPPER_ID\"},{\"isDetailField\":false,\"erpName\":\"申请人\",\"kingdeeField\":\"F_ora_Base\",\"indexField\":\"FStaffNumber\",\"type\":\"基础资料\",\"mesName\":\"申请人\",\"thirdPartyField\":\"F_ora_Base\"},{\"isDetailField\":false,\"erpName\":\"单据类型\",\"kingdeeField\":\"FBILLTYPEID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"单据类型\",\"thirdPartyField\":\"FBILLTYPEID\"},{\"isDetailField\":false,\"erpName\":\"业务类型\",\"kingdeeField\":\"FBIZTYPE\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"业务类型\",\"thirdPartyField\":\"FBIZTYPE\"}]','','','2022-08-03 19:16:51','2023-04-03 09:03:43'),
(64,'PUR_ReceiveBill','BS_Receive','收料通知单',-1,'FID','FDetailEntity_FEntryID','bs_rec_dt','','','ERP_SIC','',NULL,1,3,'[{\"isDetailField\":false,\"erpName\":\"供应商\",\"kingdeeField\":\"FSupplierId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"供应商\",\"thirdPartyField\":\"FSupplierId\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"FMaterialId\"},{\"isDetailField\":true,\"erpName\":\"物料名称\",\"kingdeeField\":\"FMaterialName\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料名称\",\"thirdPartyField\":\"FMaterialName\"},{\"isDetailField\":true,\"erpName\":\"物料规格\",\"kingdeeField\":\"FMateriaModel\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料规格\",\"thirdPartyField\":\"FMateriaModel\"},{\"isDetailField\":true,\"erpName\":\"交货数量\",\"kingdeeField\":\"FActReceiveQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"交货数量\",\"thirdPartyField\":\"FActReceiveQty\"},{\"isDetailField\":true,\"erpName\":\"价税合计\",\"kingdeeField\":\"FAllAmount\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"价税合计\",\"thirdPartyField\":\"FAllAmount\"},{\"isDetailField\":true,\"erpName\":\"税额\",\"kingdeeField\":\"FEntryTaxAmount\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"税额\",\"thirdPartyField\":\"FEntryTaxAmount\"},{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"单据编码\",\"thirdPartyField\":\"FBillNo\"},{\"isDetailField\":false,\"erpName\":\"整单关闭状态\",\"kingdeeField\":\"FCloseStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"整单关闭状态\",\"thirdPartyField\":\"FCloseStatus\"},{\"isDetailField\":true,\"erpName\":\"单据行状态\",\"kingdeeField\":\"FENTRYSTATUS\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"单据行状态\",\"thirdPartyField\":\"FENTRYSTATUS\"},{\"isDetailField\":true,\"erpName\":\"分录id\",\"kingdeeField\":\"FDetailEntity_FEntryID\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"分录id\",\"thirdPartyField\":\"ERP_SIC\"},{\"isDetailField\":true,\"erpName\":\"订单单号\",\"kingdeeField\":\"FORDERBILLNO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"订单单号\",\"thirdPartyField\":\"FORDERBILLNO\"}]','','','2022-12-13 11:13:46','2023-02-13 09:19:22');

/*Table structure for table `tb_kingdee_common_config_bk` */

DROP TABLE IF EXISTS `tb_kingdee_common_config_bk`;

CREATE TABLE `tb_kingdee_common_config_bk` (
  `id` int NOT NULL DEFAULT '0' COMMENT '主键id',
  `s_form_id` varchar(64) NOT NULL COMMENT '金蝶标识',
  `doc_type` varchar(64) NOT NULL COMMENT '第三方标识',
  `name` varchar(64) NOT NULL COMMENT '日志名称',
  `flag` tinyint NOT NULL COMMENT '配置方向（-1-ERP/MES 1-MES/ERP）',
  `primary_key_field` varchar(64) DEFAULT NULL COMMENT '单据主键字段',
  `entry_primary_key_field` varchar(64) DEFAULT NULL COMMENT '单据分录主键字段',
  `mes_entry_name` varchar(64) DEFAULT NULL COMMENT 'MES分录标识',
  `entry_name` varchar(64) DEFAULT NULL COMMENT '分录标识',
  `fathers_form_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '源单标识',
  `father_entry_name` varchar(64) DEFAULT NULL COMMENT '源单分录标识',
  `push_rule` varchar(64) DEFAULT NULL COMMENT '下推规则',
  `link_fs_id_name` varchar(64) DEFAULT NULL COMMENT '子源单行内码',
  `is_in_transaction` tinyint(1) DEFAULT NULL COMMENT '是否在事务中',
  `is_auto_perform` tinyint(1) DEFAULT '3' COMMENT '执行步骤（0-暂存，1-保存，2-提交，3-审核）',
  `kingdee_filed_detail` longtext NOT NULL COMMENT '金蝶字段相关明细',
  `plug_in_url` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '插件地址',
  `custom_sql` text COMMENT '自定义Sql',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/*Data for the table `tb_kingdee_common_config_bk` */

insert  into `tb_kingdee_common_config_bk`(`id`,`s_form_id`,`doc_type`,`name`,`flag`,`primary_key_field`,`entry_primary_key_field`,`mes_entry_name`,`entry_name`,`fathers_form_id`,`father_entry_name`,`push_rule`,`link_fs_id_name`,`is_in_transaction`,`is_auto_perform`,`kingdee_filed_detail`,`plug_in_url`,`custom_sql`,`create_time`,`update_time`) values 
(1,'BD_Supplier','BS_SUP','供应商',-1,'FSupplierId','','bs_sup_dt','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"sup_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"供应商名称\",\"thirdPartyField\":\"sup_name\"},{\"isDetailField\":false,\"erpName\":\"国家\",\"kingdeeField\":\"FCountry\",\"type\":\"文本\",\"mesName\":\"国家编码\",\"thirdPartyField\":\"country_code\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":true,\"erpName\":\"联系人\",\"kingdeeField\":\"FContact\",\"type\":\"文本\",\"mesName\":\"联系人\",\"thirdPartyField\":\"contacts_user\"},{\"isDetailField\":true,\"erpName\":\"电话\",\"kingdeeField\":\"FTel\",\"type\":\"数值\",\"mesName\":\"联系电话\",\"thirdPartyField\":\"contacts_phone\"},{\"isDetailField\":true,\"erpName\":\"默认联系人\",\"kingdeeField\":\"FContactIsDefault\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"默认联系人\",\"thirdPartyField\":\"FContactIsDefault\"}]','','','2022-08-03 09:23:03','2022-10-27 17:33:47'),
(2,'BD_Customer','BS_CUST','客户',-1,'FCUSTID',NULL,'','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"客户编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"客户编码\",\"thirdPartyField\":\"cust_code\"},{\"isDetailField\":false,\"erpName\":\"客户名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"客户名称\",\"thirdPartyField\":\"cust_name\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":false,\"erpName\":\"备注\",\"kingdeeField\":\"FDescription\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"}]','','','2022-08-03 09:57:34','2022-08-30 17:45:59'),
(4,'BD_STOCK','BS_STORE','仓库',-1,'FStockId',NULL,'','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"store_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"仓库名称\",\"thirdPartyField\":\"store_name\"},{\"isDetailField\":false,\"erpName\":\"库存状态类型\",\"kingdeeField\":\"FStockStatusType\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"仓库类型\",\"thirdPartyField\":\"store_type\"}]','','','2022-08-03 09:59:00','2022-08-30 17:46:00'),
(5,'BD_MATERIAL','BS_MTRL','物料',-1,'FMATERIALID','','','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"物料编码\",\"kingdeeField\":\"FNumber\",\"type\":\"文本\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"group_code\"},{\"isDetailField\":false,\"erpName\":\"物料编码\",\"kingdeeField\":\"FOldNumber\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"mtrl_code\"},{\"isDetailField\":false,\"erpName\":\"名称\",\"kingdeeField\":\"FName\",\"type\":\"文本\",\"mesName\":\"物料名称\",\"thirdPartyField\":\"mtrl_name\"},{\"isDetailField\":false,\"erpName\":\"规格型号\",\"kingdeeField\":\"FSpecification\",\"type\":\"文本\",\"mesName\":\"物料规格\",\"thirdPartyField\":\"mtrl_desc\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"type\":\"文本\",\"mesName\":\"禁用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":false,\"erpName\":\"最小包装数\",\"kingdeeField\":\"FMinPackCount\",\"type\":\"数值\",\"mesName\":\"最小包装数\",\"thirdPartyField\":\"pack_qty\"},{\"isDetailField\":false,\"erpName\":\"基本单位\",\"kingdeeField\":\"FBaseUnitId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"单位\",\"thirdPartyField\":\"munit\"},{\"isDetailField\":false,\"erpName\":\"物料状态\",\"kingdeeField\":\"F_ora_Assistant\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料状态\",\"thirdPartyField\":\"mtrl_status\"},{\"isDetailField\":false,\"erpName\":\"组织\",\"kingdeeField\":\"FUseOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"组织代码\",\"thirdPartyField\":\"org_id\"},{\"isDetailField\":false,\"erpName\":\"描述\",\"kingdeeField\":\"F_ORA_TEXT1\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料描述\",\"thirdPartyField\":\"mtrl_miaoshu\"}]','','','2022-08-03 11:39:26','2022-11-08 15:44:28'),
(6,'ENG_BOM','BS_BOM','物料清单',-1,'FID',NULL,'bs_bom_mtrl','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"父项集团编码\",\"kingdeeField\":\"FMATERIALID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"父项集团编码\",\"thirdPartyField\":\"prod_code\"},{\"isDetailField\":false,\"erpName\":\"父项公司编码\",\"kingdeeField\":\"F_ora_BaseProperty1\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"父项物料编码\",\"thirdPartyField\":\"fprod_code\"},{\"isDetailField\":false,\"erpName\":\"禁用状态\",\"kingdeeField\":\"FForbidStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"启用状态\",\"thirdPartyField\":\"flag\"},{\"isDetailField\":true,\"erpName\":\"子项物料编码\",\"kingdeeField\":\"FMATERIALIDCHILD\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\" mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"公司物料编码\",\"kingdeeField\":\"F_ora_BaseProperty2\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"子项MES物料编码\",\"thirdPartyField\":\"mes_mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FMEMO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"},{\"isDetailField\":true,\"erpName\":\"是否主料\",\"kingdeeField\":\"FIskeyItem\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"是否主料\",\"thirdPartyField\":\"is_main\"},{\"isDetailField\":true,\"erpName\":\"用量分母\",\"kingdeeField\":\"FDENOMINATOR\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"用量分母\",\"thirdPartyField\":\"dosage\"},{\"isDetailField\":true,\"erpName\":\"点位\",\"kingdeeField\":\"FPOSITIONNO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"点位\",\"thirdPartyField\":\"point_str\"},{\"isDetailField\":true,\"erpName\":\"主料编码\",\"kingdeeField\":\"main_code\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"主料编码\",\"thirdPartyField\":\"main_code\"},{\"isDetailField\":true,\"erpName\":\"层级\",\"kingdeeField\":\"Lev\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"层级\",\"thirdPartyField\":\"Lev\"}]','http://192.168.50.211:9090/semiconductor/api/materials/list/plug','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,a.FREPLACEGROUP as xc,\n1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=@FID) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,c.FREPLACEGROUP  as xc,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  ,a.FREPLACEGROUP \n from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,\nstepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z order by Lev,FSEQ,xc','2022-08-03 11:41:54','2022-10-13 17:07:00'),
(7,'PUR_PurchaseOrder','SM_PO','采购订单',-1,'FID','','sm_po_dt','','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"单据编号\",\"kingdeeField\":\"FBillNo\",\"type\":\"FNumber\",\"mesName\":\"采购订单编码\",\"thirdPartyField\":\"po_code\"},{\"isDetailField\":false,\"erpName\":\"采购日期\",\"kingdeeField\":\"FDate\",\"type\":\"文本\",\"mesName\":\"日期\",\"thirdPartyField\":\"indate\"},{\"isDetailField\":false,\"erpName\":\"供应商\",\"kingdeeField\":\"FSupplierId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"sup_code\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"mtrl_code\"},{\"isDetailField\":true,\"erpName\":\"采购数量\",\"kingdeeField\":\"FQty\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"m_qty\"},{\"isDetailField\":true,\"erpName\":\"数量\",\"kingdeeField\":\"FPlanQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"交货数量\",\"thirdPartyField\":\"ro_qty\"},{\"isDetailField\":true,\"erpName\":\"采购单位\",\"kingdeeField\":\"FUnitID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"采购单位\",\"thirdPartyField\":\"po_unit\"},{\"isDetailField\":true,\"erpName\":\"税额\",\"kingdeeField\":\"FEntryTaxAmount\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"税额\",\"thirdPartyField\":\"tax\"},{\"isDetailField\":true,\"erpName\":\"价税合计\",\"kingdeeField\":\"FAllAmount\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"价税合计\",\"thirdPartyField\":\"totalmoney\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntryNote\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"remark\"},{\"isDetailField\":true,\"erpName\":\"分录主键\",\"kingdeeField\":\"FPOOrderEntry_FEntryID\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"ERP行内码\",\"thirdPartyField\":\"ERP_SIC\"},{\"isDetailField\":true,\"erpName\":\"规格型号\",\"kingdeeField\":\"FModel\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料规格\",\"thirdPartyField\":\"po_mtrl_descs\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"F_ora_BaseProperty\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"ma_code\"},{\"isDetailField\":true,\"erpName\":\"业务关闭\",\"kingdeeField\":\"FMRPCloseStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"业务关闭\",\"thirdPartyField\":\"CloseStatus\"},{\"isDetailField\":true,\"erpName\":\"关闭状态\",\"kingdeeField\":\"FCloseStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"订单关闭状态\",\"thirdPartyField\":\"FCloseStatus\"}]','','','2022-08-03 12:00:05','2022-10-27 17:36:18'),
(10,'STK_MisDelivery','BS0043','其他出库',-1,'FID',NULL,'','','','','','',1,3,'[{\"isDetailField\":true,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"发货仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"其他出库单号\",\"thirdPartyField\":\"REF_TRX_CODE\"}]','','','2022-08-03 17:10:19','2022-08-30 17:46:02'),
(11,'PRD_PPBOM','WMS0004','生产用料清单',1,'','','','FEntity','','','','',0,1,'[{\"isDetailField\":true,\"erpName\":\"货主类型\",\"kingdeeField\":\"FOwnerTypeId\",\"indexField\":\"\",\"type\":\"基础资料\",\"mesName\":\"货主类型\",\"thirdPartyField\":\"SHIPPER_TYPE\"},{\"isDetailField\":true,\"erpName\":\"货主\",\"kingdeeField\":\"FOwnerID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"货主\",\"thirdPartyField\":\"SHIPPER_ID\"},{\"isDetailField\":true,\"erpName\":\"子项物料编码\",\"kingdeeField\":\"FMaterialID2\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"标准用量\",\"kingdeeField\":\"FStdQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"用量\",\"thirdPartyField\":\"DOSAGE\"},{\"isDetailField\":true,\"erpName\":\"需求数量\",\"kingdeeField\":\"FNeedQty2\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"净需求数量\",\"thirdPartyField\":\"NN_QTY\"},{\"isDetailField\":true,\"erpName\":\"应发数量\",\"kingdeeField\":\"FMustQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"实际需求数量\",\"thirdPartyField\":\"TN_QTY\"},{\"isDetailField\":true,\"erpName\":\"位置号\",\"kingdeeField\":\"FPositionNO\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"位置号\",\"thirdPartyField\":\"POINT_STR\"},{\"isDetailField\":false,\"erpName\":\"数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"计划数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"生产订单编号\",\"kingdeeField\":\"FMOBillNO1\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"生产订单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"行内码\",\"kingdeeField\":\"FEntryID\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"行内码\",\"thirdPartyField\":\"ERP_SIC\"},{\"isDetailField\":false,\"erpName\":\"主键\",\"kingdeeField\":\"FID\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"主键\",\"thirdPartyField\":\"ERP_FID\"},{\"isDetailField\":false,\"erpName\":\"生产订单行号\",\"kingdeeField\":\"FMoEntrySeq1\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"生产订单行号\",\"thirdPartyField\":\"MO_SEQ\"},{\"isDetailField\":true,\"erpName\":\"MES主键\",\"kingdeeField\":\"F_LQKJ_Code\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"MES主键\",\"thirdPartyField\":\"MES_CODE\"}]','http://192.168.50.211:9090/semiconductor/api/production/material/list/plug','','2022-08-03 17:25:24','2022-11-24 09:59:40'),
(12,'PRD_MO','WMS0002','生产订单',1,'',NULL,'','FTreeEntity','','1','','',1,2,'[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"生产订单编号\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"集团编码\",\"thirdPartyField\":\"GROUP_ID\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"计划开工时间\",\"kingdeeField\":\"FPlanStartDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"计划开始时间\",\"thirdPartyField\":\"PB_DATE\"},{\"isDetailField\":true,\"erpName\":\"计划完工时间\",\"kingdeeField\":\"FPlanFinishDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"计划结束时间\",\"thirdPartyField\":\"PE_DATE\"},{\"isDetailField\":false,\"erpName\":\"单据日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"单据日期\",\"thirdPartyField\":\"PRD_DATE\"},{\"isDetailField\":true,\"erpName\":\"单位\",\"kingdeeField\":\"FUnitId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"单位\",\"thirdPartyField\":\"MUNIT\"},{\"isDetailField\":true,\"erpName\":\"生产车间\",\"kingdeeField\":\"FWorkShopID\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"生产车间\",\"thirdPartyField\":\"FWorkShopID\"},{\"isDetailField\":false,\"erpName\":\"基本单位数量\",\"kingdeeField\":\"FBaseSNQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"基本单位数量\",\"thirdPartyField\":\"FBaseSNQty\"},{\"isDetailField\":true,\"erpName\":\"MES主键\",\"kingdeeField\":\"F_LQKJ_Code\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"MES主键\",\"thirdPartyField\":\"MES_CODE\"}]','','','2022-08-03 17:54:41','2022-10-19 17:14:33'),
(13,'PRD_PickMtrl','WMS0003','生产领料单',1,'',NULL,'','FEntity','PRD_PPBOM','FEntity','PRD_IssueMtrl2PickMtrl','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FActualQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyMemo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"},{\"isDetailField\":true,\"erpName\":\"工单编码\",\"kingdeeField\":\"FEntrySrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"}]','http://192.168.50.211:9090/semiconductor/api/production/picking/plug','','2022-08-03 18:15:17','2022-10-19 17:15:11'),
(14,'PRD_FeedMtrl','BS0040','生产补料单',1,'',NULL,'','FEntity','PRD_PPBOM','FEntity','PRD_PPBOM2FEEDMTRL','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实发数量\",\"kingdeeField\":\"FActualQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyDescription\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"},{\"isDetailField\":true,\"erpName\":\"工单编码\",\"kingdeeField\":\"FEntrySrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"申请数量\",\"kingdeeField\":\"FAppQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"申请数量\",\"thirdPartyField\":\"QUANTITY\"}]','http://192.168.50.211:9090/semiconductor/api/production/picking/plug','','2022-08-03 18:21:58','2022-10-19 17:15:21'),
(15,'PRD_ReturnMtrl','BS0050','生产退料单',1,'',NULL,'','FEntity','PRD_PPBOM','FEntity','PRD_PPBOM2RETURNMTRL','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实退数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"系统源单编码\",\"kingdeeField\":\"FSrcBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"备注\",\"kingdeeField\":\"FEntrtyMemo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"}]','http://192.168.50.211:9090/semiconductor/api/production/picking/plug','','2022-08-03 18:26:16','2022-10-19 17:15:27'),
(16,'PRD_MO','BS0057','生产订单关闭',1,'',NULL,'','FEntryId','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"MO_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"MES状态\",\"kingdeeField\":\"F_LQKJ_MESStates\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"MES状态\",\"thirdPartyField\":\"F_LQKJ_MESStates\"}]','','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = @MES_CODE','2022-08-03 18:31:01','2022-08-30 17:46:04'),
(17,'PRD_INSTOCK','BS0055','生产入库单',1,'',NULL,'','FEntity','PRD_MO','FTreeEntity','PRD_MO2INSTOCK','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"生产订单编码\",\"kingdeeField\":\"FMoBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"工单编码\",\"thirdPartyField\":\"ERP_MO\"},{\"isDetailField\":true,\"erpName\":\"生产订单行号\",\"kingdeeField\":\"FMoEntrySeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"生产订单行号\",\"thirdPartyField\":\"ERP_SEQ\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FRealQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"入库组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"入库组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FStockerId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"USER_CODE\"}]','http://192.168.50.211:9090/semiconductor/api/production/warehousing/plug','','2022-08-03 18:37:47','2022-10-21 11:17:33'),
(18,'STK_OEMInStock','BS0004','受托加工材料入库单',1,'',NULL,'','FBillEntry','','','','',1,2,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":false,\"erpName\":\"客户\",\"kingdeeField\":\"FCustId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"客户编码\",\"thirdPartyField\":\"CUST_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"收货仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量(基本单位)\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"库存状态\",\"kingdeeField\":\"FStockStatusId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"库存状态\",\"thirdPartyField\":\"STOCK_TYPE\"}]','','','2022-08-03 18:42:44','2022-10-19 17:15:46'),
(19,'STK_InStock','WMS0012','采购入库单',1,'','','','FInStockEntry','PUR_ReceiveBill','FDetailEntity','PUR_ReceiveBill-STK_InStock','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"入库日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FRealQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"源单编码\",\"kingdeeField\":\"FSRCBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"采购单号\",\"thirdPartyField\":\"PO_CODE\"},{\"isDetailField\":true,\"erpName\":\"行号\",\"kingdeeField\":\"FSeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"采购行号\",\"thirdPartyField\":\"PO_SEQ\"},{\"isDetailField\":false,\"erpName\":\"收料部门\",\"kingdeeField\":\"FSTOCKDEPTID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"收料部门\",\"thirdPartyField\":\"STOCKDEP\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FSTOCKERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"STOCKUSER\"}]','','','2022-08-03 18:49:25','2022-12-13 14:09:13'),
(20,'PUR_MRB','BS0045','采购退料单',1,'','','','FPURMRBENTRY','STK_InStock','FInStockEntry','STK_InStock-PUR_MRB','ERP_SIC',1,2,'[{\"isDetailField\":false,\"erpName\":\"退料日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实退数量\",\"kingdeeField\":\"FRMREALQTY\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"退料类型\",\"kingdeeField\":\"FMRTYPE\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"退料类型\",\"thirdPartyField\":\"FMRTYPE1\"},{\"isDetailField\":true,\"erpName\":\"仓库编码\",\"kingdeeField\":\"FSTOCKID\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"源单编码\",\"kingdeeField\":\"FSRCBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"采购入库单号\",\"thirdPartyField\":\"PO_CODE\"},{\"isDetailField\":true,\"erpName\":\"行号\",\"kingdeeField\":\"FSeq\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"采购入库单行号\",\"thirdPartyField\":\"PO_SEQ\"}]','','','2022-08-03 18:55:10','2022-12-16 17:38:02'),
(21,'STK_MISCELLANEOUS','BS0022','其他入库',1,'',NULL,'','FEntity','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"供应商\",\"kingdeeField\":\"FSUPPLIERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"供应商编码\",\"thirdPartyField\":\"SUP_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMATERIALID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":false,\"erpName\":\"库存组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"库存组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"仓管员\",\"kingdeeField\":\"FSTOCKERID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓管员\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"实收数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"实收数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"收货仓库\",\"kingdeeField\":\"FSTOCKID\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"收货仓库\",\"thirdPartyField\":\"STORE_CODE\"}]','','','2022-08-03 19:00:38','2022-08-30 17:46:07'),
(22,'STK_StockCountGain','BS0028','盘点盘盈单',-1,'FID',NULL,'','FBillEntry','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"盘点数量\",\"kingdeeField\":\"FCountQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":false,\"erpName\":\"库存组织\",\"kingdeeField\":\"FStockOrgId\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"组织\",\"thirdPartyField\":\"ORG_ID\"},{\"isDetailField\":false,\"erpName\":\"备注\",\"kingdeeField\":\"FNoteHead\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"备注\",\"thirdPartyField\":\"REMARK\"}]','','','2022-08-03 19:05:00','2022-08-30 17:46:07'),
(23,'STK_StockCountLoss','BS0029','盘点盘亏单',-1,'FID',NULL,'','FBillEntry','','','','',1,3,'[{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":true,\"erpName\":\"仓库\",\"kingdeeField\":\"FStockId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"盘点数量\",\"kingdeeField\":\"FCountQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"}]','','','2022-08-03 19:10:16','2022-08-30 17:46:08'),
(24,'STK_TransferDirect','BS0030','直接调拨单',1,'','','','FBillEntry','','','','',1,1,'[{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"直接调拨单编码\",\"thirdPartyField\":\"FBillNo\"},{\"isDetailField\":false,\"erpName\":\"日期\",\"kingdeeField\":\"FDate\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"交易时间\",\"thirdPartyField\":\"TRX_DATE\"},{\"isDetailField\":false,\"erpName\":\"创建人\",\"kingdeeField\":\"FCreatorId\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"操作人编码\",\"thirdPartyField\":\"USER_CODE\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"MTRL_CODE\"},{\"isDetailField\":true,\"erpName\":\"调出仓库\",\"kingdeeField\":\"FSrcStockId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"调出仓库编码\",\"thirdPartyField\":\"STORE_CODE\"},{\"isDetailField\":true,\"erpName\":\"调拨数量\",\"kingdeeField\":\"FQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"数量\",\"thirdPartyField\":\"QUANTITY\"},{\"isDetailField\":true,\"erpName\":\"调入仓库\",\"kingdeeField\":\"FDestStockId\",\"indexField\":\"Fnumber\",\"type\":\"基础资料\",\"mesName\":\"调入仓库编码\",\"thirdPartyField\":\"TO_STORE_CODE\"},{\"isDetailField\":false,\"erpName\":\"调出货主类型\",\"kingdeeField\":\"FOwnerTypeOutIdHead\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"调出货主类型\",\"thirdPartyField\":\"SHIPPER_TYPE\"},{\"isDetailField\":false,\"erpName\":\"调出货主\",\"kingdeeField\":\"FOwnerOutIdHead\",\"indexField\":\"FNumber\",\"type\":\"基础资料\",\"mesName\":\"调出货主\",\"thirdPartyField\":\"SHIPPER_ID\"},{\"isDetailField\":false,\"erpName\":\"申请人\",\"kingdeeField\":\"F_ora_Base\",\"indexField\":\"FStaffNumber\",\"type\":\"基础资料\",\"mesName\":\"申请人\",\"thirdPartyField\":\"F_ora_Base\"}]','','','2022-08-03 19:16:51','2022-11-24 10:17:44'),
(64,'PUR_ReceiveBill','BS_Receive','收料通知单',-1,'FID','FDetailEntity_FEntryID','','','','ERP_SIC','',NULL,1,3,'[{\"isDetailField\":false,\"erpName\":\"供应商\",\"kingdeeField\":\"FSupplierId\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"供应商\",\"thirdPartyField\":\"FSupplierId\"},{\"isDetailField\":true,\"erpName\":\"物料编码\",\"kingdeeField\":\"FMaterialId\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料编码\",\"thirdPartyField\":\"FMaterialId\"},{\"isDetailField\":true,\"erpName\":\"物料名称\",\"kingdeeField\":\"FMaterialName\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料名称\",\"thirdPartyField\":\"FMaterialName\"},{\"isDetailField\":true,\"erpName\":\"物料规格\",\"kingdeeField\":\"FMateriaModel\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"物料规格\",\"thirdPartyField\":\"FMateriaModel\"},{\"isDetailField\":true,\"erpName\":\"交货数量\",\"kingdeeField\":\"FActReceiveQty\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"交货数量\",\"thirdPartyField\":\"FActReceiveQty\"},{\"isDetailField\":true,\"erpName\":\"价税合计\",\"kingdeeField\":\"FAllAmount\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"价税合计\",\"thirdPartyField\":\"FAllAmount\"},{\"isDetailField\":true,\"erpName\":\"税额\",\"kingdeeField\":\"FEntryTaxAmount\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"税额\",\"thirdPartyField\":\"FEntryTaxAmount\"},{\"isDetailField\":false,\"erpName\":\"单据编码\",\"kingdeeField\":\"FBillNo\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"单据编码\",\"thirdPartyField\":\"FBillNo\"},{\"isDetailField\":false,\"erpName\":\"整单关闭状态\",\"kingdeeField\":\"FCloseStatus\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"整单关闭状态\",\"thirdPartyField\":\"FCloseStatus\"},{\"isDetailField\":true,\"erpName\":\"单据行状态\",\"kingdeeField\":\"FENTRYSTATUS\",\"indexField\":\"\",\"type\":\"文本\",\"mesName\":\"单据行状态\",\"thirdPartyField\":\"FENTRYSTATUS\"},{\"isDetailField\":true,\"erpName\":\"分录id\",\"kingdeeField\":\"FDetailEntity_FEntryID\",\"indexField\":\"\",\"type\":\"数值\",\"mesName\":\"分录id\",\"thirdPartyField\":\"ERP_SIC\"}]','','','2022-12-13 11:13:46','2022-12-19 17:44:17');

/*Table structure for table `tb_kingdee_log` */

DROP TABLE IF EXISTS `tb_kingdee_log`;

CREATE TABLE `tb_kingdee_log` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) NOT NULL COMMENT '业务名称',
  `queue_id` varchar(128) NOT NULL COMMENT '唯一标识',
  `request` longtext COMMENT '请求参数',
  `flag` tinyint(1) DEFAULT '1' COMMENT '是否成功（0-失败，1-成功）',
  `response` longtext COMMENT '响应信息',
  `message` longtext COMMENT '错误原因',
  `cost_time` int DEFAULT '0' COMMENT '耗时（毫秒）',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_queue_id` (`queue_id`),
  KEY `index_create_time` (`create_time`)
) ENGINE=InnoDB AUTO_INCREMENT=7615 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='金蝶日志记录表';

/*Data for the table `tb_kingdee_log` */

insert  into `tb_kingdee_log`(`id`,`name`,`queue_id`,`request`,`flag`,`response`,`message`,`cost_time`,`create_time`,`update_time`) values 
(381,'生产订单','213c32123121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T17:01:38.180338+08:00\"}],\"resultData\":[]}','请重新登录！',218,'2022-08-19 01:02:41','2022-08-19 01:02:41'),
(382,'生产订单重新登陆请求','213c32123121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T17:01:38.7740907+08:00\"}],\"resultData\":[]}','请重新登录！',207,'2022-08-19 01:02:41','2022-08-19 01:02:41'),
(383,'生产订单','213c329123121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T17:32:53.1904304+08:00\"}],\"resultData\":[]}','请重新登录！',230,'2022-08-19 01:33:56','2022-08-19 01:33:56'),
(384,'生产订单重新登陆请求','213c329123121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T17:32:53.7998615+08:00\"}],\"resultData\":[]}','请重新登录！',218,'2022-08-19 01:33:56','2022-08-19 01:33:56'),
(385,'生产订单','213c3298123121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T17:43:48.4369941+08:00\"}],\"resultData\":[]}','请重新登录！',200,'2022-08-19 01:44:51','2022-08-19 01:44:51'),
(386,'生产订单重新登陆请求','213c3298123121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T17:43:49.6127443+08:00\"}],\"resultData\":[]}','请重新登录！',225,'2022-08-19 01:44:52','2022-08-19 01:44:52'),
(387,'生产订单','213c32988123121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T17:52:28.2863036+08:00\"}],\"resultData\":[]}','请重新登录！',219,'2022-08-19 01:53:31','2022-08-19 01:53:31'),
(388,'生产订单重新登陆请求','213c32988123121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T17:52:28.854658+08:00\"}],\"resultData\":[]}','请重新登录！',197,'2022-08-19 01:53:31','2022-08-19 01:53:31'),
(390,'生产订单','213c329c121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T18:03:47.0759874+08:00\"}],\"resultData\":[]}','请重新登录！',212,'2022-08-19 02:04:49','2022-08-19 02:04:49'),
(391,'生产订单重新登陆请求','213c329c121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-18T18:03:47.6541245+08:00\"}],\"resultData\":[]}','请重新登录！',210,'2022-08-19 02:04:50','2022-08-19 02:04:50'),
(393,'生产订单','213c3c29c121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T09:00:40.5361837+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',9475,'2022-08-19 09:00:41','2022-08-19 09:00:41'),
(394,'生产订单','213c3c2d9c121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T09:04:28.5164378+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',352,'2022-08-19 09:04:29','2022-08-19 09:04:29'),
(395,'生产订单','213c3c2dc9c121','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A0020204-000124\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T09:05:31.1892839+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',387,'2022-08-19 09:05:32','2022-08-19 09:05:32'),
(396,'生产订单','213c3c2dc9c131','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"610011\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T09:58:41.6311569+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',355,'2022-08-19 09:58:43','2022-08-19 09:58:43'),
(397,'生产订单','213c3c2dc9c141','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A20010\"},\"FQty\":123,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T09:59:46.6300195+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',353,'2022-08-19 09:59:48','2022-08-19 09:59:48'),
(398,'生产订单','213c3c2dc9c151','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A20010\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"KWZS0001\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T10:01:53.0352577+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',434,'2022-08-19 10:01:54','2022-08-19 10:01:54'),
(399,'生产订单','213c3c2dc9c161','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A20010\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T10:03:48.9795222+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',370,'2022-08-19 10:03:50','2022-08-19 10:03:50'),
(400,'生产订单','213c3c2dc9c171','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A20030\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T10:04:58.0145607+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',365,'2022-08-19 10:04:59','2022-08-19 10:04:59'),
(401,'生产订单','213c3c2dc9c181','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-17 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"A20030\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-17 00:00:00\",\"FPlanFinishDate\":\"2022-08-17 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T10:11:28.5836661+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',340,'2022-08-19 10:11:30','2022-08-19 10:11:30'),
(402,'生产订单','213c3c2dc9c1891','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-20 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"B20010\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-20 00:00:00\",\"FPlanFinishDate\":\"2022-08-20 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T10:13:32.1813223+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"},{\"code\":null,\"msg\":\"单据体第1行，计划开工时间,计划完工时间没有落在生产组织关联的工作日历的生产日上\"}]}','保存失败',390,'2022-08-19 10:13:33','2022-08-19 10:13:33'),
(403,'生产订单','213c3c2dc9c1991','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"B20010\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T10:13:54.4645292+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',386,'2022-08-19 10:13:55','2022-08-19 10:13:55'),
(404,'生产订单','213c3c2dc9c1291','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"B20010\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"},\"FBaseSNQty\":20}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"给字段(FBaseSNQty)设置值(20):寻找实体上BaseSNQty对应的属性描述符失败，实体不存在此属性！[EntityType：TreeEntity Propeyties:Id Seq ParentRowId RowExpandType RowId MaterialId_Id MaterialId ProductType Qty PlanFinishDate PlanStartDate Lot_Id Lot Lot_Text MTONo ProjectNo BaseUnitQty Group BomId_Id BomId RoutingId_Id RoutingId YieldRate StockInLimitH StockInLimitL StockInQuaSelAuxQty StockInQuaSelQty StockInFailSelQty StockInFailSelAuxQty StockInQuaQty StockInQuaAuxQty StockInFailQty StockInFailAuxQty StockInOrgId_Id StockInOrgId StockId_Id StockId StockLocId_Id StockLocId OperId ProcessId_Id ProcessId CostRate MultiLanguageText Memo PlanConfirmDate ScheduleDate ConveyDate StartDate FinishDate CloseDate CostDate CreateType SrcBillId SrcBillEntryId SaleOrderId SaleOrderNo SaleOrderEntryId RequestOrgId_Id RequestOrgId RepQuaSelQty RepFailQty RepQuaSelAuxQty RepQuaAuxQty RepFailAuxQty RepQuaQty Status UnitId_Id UnitId BaseUnitId_Id BaseUnitId AuxPropId_Id AuxPropId BaseStockInLimitH BaseStockInLimitL StockInUlRatio SrcBillType SrcBillNo SrcBillEntrySeq SaleOrderEntrySeq BaseYieldQty CopyEntryId IsSuspend StockInLlRatio BFLowId_Id BFLowId RepFailSelQty RepFailSelAuxQty WorkShopID_Id WorkShopID ReqType Priority StockReady BaseStockReady BaseScrapQty ScrapQty BaseRepairQty RepairQty BaseStockInScrapSelQty StockInScrapSelQty BaseStockInScrapQty StockInScrapQty InStockOwnerTypeId InStockOwnerId_Id InStockOwnerId InStockType CheckProduct OutPutOptQueue BaseRptFinishQty RptFinishQty QAIP YieldQty ISBACKFLUSH NoStockInQty BaseNoStockInQty ReqSrc ForceCloserId_Id ForceCloserId REMWorkShopId_Id REMWorkShopId ScheduleSeq ScheduleStartTime ScheduleFinishTime CloseType ScheduleProcSplit SNUnitID_Id SNUnitID SNQty ReStkQty BaseReStkQty ReStkQuaQty BaseReStkQuaQty ReStkFailQty BaseReStkFailQty ReStkScrapQty BaseReStkScrapQty PickMtlQty BasePickMtlQty ISNEWLC PickMtrlStatus BaseIssueQty IssueQty SrcSplitBillNo SrcSplitSeq SrcSplitEntryId SrcSplitId MOChangeFlag SrcBomEntryId ReStkReMadeQty BaseReStkReMadeQty BaseReMadeQty ReMadeQty BaseStockInReMadeQty StockInReMadeQty BaseStockInReMadeSelQty StockInReMadeSelQty CloseReason BaseScheduledQtySum ScheduledQtySum ScheduleStatus IsFirstInspect FirstInspectStatus ConfirmId_Id ConfirmId ReleaseId_Id ReleaseId StartID_Id StartID FinishId_Id FinishId IsMRP BaseSampleDamageQty SampleDamageQty ISENABLESCHEDULE PathEntryId PPBOMENTRYID BOMENTRYID SrcFormID MatchQty InvMatchQty CompleteCon FRemarks MatchDate NOTECOBY F_LQKJ_MESStates SerialSubEntity FTREEENTITY_Link ]\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-19T10:16:21.7299891+08:00\"},{\"stage\":\"加载数据完成\",\"pointTime\":\"2022-08-19T10:16:21.8237272+08:00\"}],\"resultData\":[]}','给字段(FBaseSNQty)设置值(20):寻找实体上BaseSNQty对应的属性描述符失败，实体不存在此属性！[EntityType：TreeEntity Propeyties:Id Seq ParentRowId RowExpandType RowId MaterialId_Id MaterialId ProductType Qty PlanFinishDate PlanStartDate Lot_Id Lot Lot_Text MTONo ProjectNo BaseUnitQty Group BomId_Id BomId RoutingId_Id RoutingId YieldRate StockInLimitH StockInLimitL StockInQuaSelAuxQty StockInQuaSelQty StockInFailSelQty StockInFailSelAuxQty StockInQuaQty StockInQuaAuxQty StockInFailQty StockInFailAuxQty StockInOrgId_Id StockInOrgId StockId_Id StockId StockLocId_Id StockLocId OperId ProcessId_Id ProcessId CostRate MultiLanguageText Memo PlanConfirmDate ScheduleDate ConveyDate StartDate FinishDate CloseDate CostDate CreateType SrcBillId SrcBillEntryId SaleOrderId SaleOrderNo SaleOrderEntryId RequestOrgId_Id RequestOrgId RepQuaSelQty RepFailQty RepQuaSelAuxQty RepQuaAuxQty RepFailAuxQty RepQuaQty Status UnitId_Id UnitId BaseUnitId_Id BaseUnitId AuxPropId_Id AuxPropId BaseStockInLimitH BaseStockInLimitL StockInUlRatio SrcBillType SrcBillNo SrcBillEntrySeq SaleOrderEntrySeq BaseYieldQty CopyEntryId IsSuspend StockInLlRatio BFLowId_Id BFLowId RepFailSelQty RepFailSelAuxQty WorkShopID_Id WorkShopID ReqType Priority StockReady BaseStockReady BaseScrapQty ScrapQty BaseRepairQty RepairQty BaseStockInScrapSelQty StockInScrapSelQty BaseStockInScrapQty StockInScrapQty InStockOwnerTypeId InStockOwnerId_Id InStockOwnerId InStockType CheckProduct OutPutOptQueue BaseRptFinishQty RptFinishQty QAIP YieldQty ISBACKFLUSH NoStockInQty BaseNoStockInQty ReqSrc ForceCloserId_Id ForceCloserId REMWorkShopId_Id REMWorkShopId ScheduleSeq ScheduleStartTime ScheduleFinishTime CloseType ScheduleProcSplit SNUnitID_Id SNUnitID SNQty ReStkQty BaseReStkQty ReStkQuaQty BaseReStkQuaQty ReStkFailQty BaseReStkFailQty ReStkScrapQty BaseReStkScrapQty PickMtlQty BasePickMtlQty ISNEWLC PickMtrlStatus BaseIssueQty IssueQty SrcSplitBillNo SrcSplitSeq SrcSplitEntryId SrcSplitId MOChangeFlag SrcBomEntryId ReStkReMadeQty BaseReStkReMadeQty BaseReMadeQty ReMadeQty BaseStockInReMadeQty StockInReMadeQty BaseStockInReMadeSelQty StockInReMadeSelQty CloseReason BaseScheduledQtySum ScheduledQtySum ScheduleStatus IsFirstInspect FirstInspectStatus ConfirmId_Id ConfirmId ReleaseId_Id ReleaseId StartID_Id StartID FinishId_Id FinishId IsMRP BaseSampleDamageQty SampleDamageQty ISENABLESCHEDULE PathEntryId PPBOMENTRYID BOMENTRYID SrcFormID MatchQty InvMatchQty CompleteCon FRemarks MatchDate NOTECOBY F_LQKJ_MESStates SerialSubEntity FTREEENTITY_Link ]',399,'2022-08-19 10:16:23','2022-08-19 10:16:23'),
(405,'生产订单','213c3c2dc9c8291','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FBaseSNQty\":20,\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"B20010\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"给字段(FBaseSNQty)设置值(20):寻找实体上BaseSNQty对应的属性描述符失败，实体不存在此属性！[EntityType：PRD_MO Propeyties:Id FFormId BillNo DocumentStatus ApproverId_Id ApproverId ApproveDate ModifierId_Id ModifierId CreateDate CreatorId_Id CreatorId ModifyDate CancelDate CANCELER_Id CANCELER CancelStatus MultiLanguageText Description BillType_Id BillType Trustteed WorkShopID_Id WorkShopID PrdOrgId_Id PrdOrgId PlannerID_Id PlannerID Date OwnerTypeId OwnerId_Id OwnerId WorkGroupId_Id WorkGroupId BusinessType IsRework IsEntrust ENTrustOrgId_Id ENTrustOrgId PPBOMType IssueMtrl IsQCMO TreeEntity ScheduledEntity BOS_ConvertTakeDataInfo ]\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-19T10:16:53.2260778+08:00\"},{\"stage\":\"加载数据完成\",\"pointTime\":\"2022-08-19T10:16:53.5385613+08:00\"}],\"resultData\":[]}','给字段(FBaseSNQty)设置值(20):寻找实体上BaseSNQty对应的属性描述符失败，实体不存在此属性！[EntityType：PRD_MO Propeyties:Id FFormId BillNo DocumentStatus ApproverId_Id ApproverId ApproveDate ModifierId_Id ModifierId CreateDate CreatorId_Id CreatorId ModifyDate CancelDate CANCELER_Id CANCELER CancelStatus MultiLanguageText Description BillType_Id BillType Trustteed WorkShopID_Id WorkShopID PrdOrgId_Id PrdOrgId PlannerID_Id PlannerID Date OwnerTypeId OwnerId_Id OwnerId WorkGroupId_Id WorkGroupId BusinessType IsRework IsEntrust ENTrustOrgId_Id ENTrustOrgId PPBOMType IssueMtrl IsQCMO TreeEntity ScheduledEntity BOS_ConvertTakeDataInfo ]',513,'2022-08-19 10:16:54','2022-08-19 10:16:54'),
(406,'生产订单','214c3c2dc9c8291','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"B20010\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T10:17:15.0122016+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',347,'2022-08-19 10:17:16','2022-08-19 10:17:16'),
(407,'生产订单','214c3c2dc9c8391','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T10:22:14.8225406+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-19T10:22:14.8498676+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T10:22:14.9641208+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T10:22:14.9651141+08:00\"}],\"resultData\":[{\"code\":\"MO000055\",\"msg\":null}]}',NULL,1120,'2022-08-19 10:22:16','2022-08-19 10:22:16'),
(408,'生产订单','21c3c2dc9c8291','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"B20010\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T11:09:18.0225873+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',6196,'2022-08-19 11:09:19','2022-08-19 11:09:19'),
(409,'生产订单','21c3c2dc9c8w291','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T11:10:42.2149051+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-19T11:10:42.2305215+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T11:10:42.4180325+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T11:10:42.4180325+08:00\"}],\"resultData\":[{\"code\":\"MO000056\",\"msg\":null}]}',NULL,1946,'2022-08-19 11:10:43','2022-08-19 11:10:43'),
(410,'生产订单','21c3c2dc9c8w2391','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"MTRL_ID\":\"A20010\",\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T15:05:29.8622255+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',357,'2022-08-19 15:05:31','2022-08-19 15:05:31'),
(411,'生产订单','21c3c2dc9c9w2391','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"MTRL_ID\":\"A20010\",\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T15:06:26.5292301+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',341,'2022-08-19 15:06:27','2022-08-19 15:06:27'),
(412,'生产订单','21c3c3dc9c9w2391','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T15:11:03.7097589+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',330,'2022-08-19 15:11:05','2022-08-19 15:11:05'),
(413,'生产订单','21c4c3dc9c9w2391','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":\"0000000538\",\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"给字段(FMaterialId)设置值(0000000538):【字段Key：FMaterialId，字段名：物料编码】格式错误，不能转换为字典类型（Json格式中{}表示字典）\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-19T15:11:31.6452607+08:00\"},{\"stage\":\"加载数据完成\",\"pointTime\":\"2022-08-19T15:11:31.7273075+08:00\"}],\"resultData\":[]}','给字段(FMaterialId)设置值(0000000538):【字段Key：FMaterialId，字段名：物料编码】格式错误，不能转换为字典类型（Json格式中{}表示字典）',289,'2022-08-19 15:11:33','2022-08-19 15:11:33'),
(414,'生产订单','41c4c3dc9c9w2391','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T15:12:18.6941551+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-19T15:12:18.7254041+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T15:12:19.2097778+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T15:12:19.2097778+08:00\"}],\"resultData\":[{\"code\":\"MO000057\",\"msg\":null}]}',NULL,3818,'2022-08-19 15:12:20','2022-08-19 15:12:20'),
(415,'生产订单','708e3cfd-4e0a-4b8d-a7ce-98a885e355a7','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-19T15:57:27.7823638+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-19T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-20T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T15:57:37.0737902+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',753,'2022-08-19 15:57:38','2022-08-19 15:57:38'),
(416,'生产订单','41c4c3dc9c92w2391','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"001\"},\"FDate\":\"2022-08-19 00:00:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":20,\"FPlanStartDate\":\"2022-08-19 00:00:00\",\"FPlanFinishDate\":\"2022-08-19 00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000011\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T15:58:10.3247872+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-19T15:58:10.3403985+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T15:58:10.5503575+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T15:58:10.5503575+08:00\"}],\"resultData\":[{\"code\":\"MO000058\",\"msg\":null}]}',NULL,1303,'2022-08-19 15:58:12','2022-08-19 15:58:12'),
(417,'生产订单','58420ec7-2a3c-4012-a379-76cc39b8f65b','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-19T15:59:51.7858362+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-19T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-20T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T15:59:53.5190078+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-19T15:59:53.550261+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T15:59:53.6586286+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T15:59:53.6586286+08:00\"}],\"resultData\":[{\"code\":\"MO000059\",\"msg\":null}]}',NULL,956,'2022-08-19 15:59:55','2022-08-19 15:59:55'),
(418,'生产订单','29f1c62b-8a67-4058-891a-7487a9972387','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-19T16:00:39.6846845+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-19T00:00:00\",\"FPlanFinishDate\":\"2022-08-21T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T16:00:41.2426443+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-19T16:00:41.2738653+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T16:00:41.3676566+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T16:00:41.3676566+08:00\"}],\"resultData\":[{\"code\":\"MO000060\",\"msg\":null}]}',NULL,932,'2022-08-19 16:00:42','2022-08-19 16:00:42'),
(419,'生产订单','a19ddcce-6005-4703-b4d9-9d096476aa2a','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-19T16:12:43.4237492+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-19T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-20T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T16:12:45.2667355+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-19T16:12:45.282383+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T16:12:45.4035045+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T16:12:45.4035045+08:00\"}],\"resultData\":[{\"code\":\"MO000061\",\"msg\":null}]}',NULL,1075,'2022-08-19 16:12:46','2022-08-19 16:12:46'),
(420,'生产订单','01149184-e188-4ce6-90cc-c323dee0f30f','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2234005\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-19T18:00:54.9174521+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-19T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-21T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-19T18:00:58.8376341+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-19T18:00:58.8532737+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T18:00:59.2126395+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-19T18:00:59.2126395+08:00\"}],\"resultData\":[{\"code\":\"WO2234005\",\"msg\":null}]}',NULL,3407,'2022-08-19 18:00:59','2022-08-19 18:00:59'),
(423,'生产领料单','ab142312105524613','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100795\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T11:51:49.2524393+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8,\"FEntrtyMemo\":\"备注备注备注\",\"FEntrySrcBillNo\":\"PPBOM00000105\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：单据状态 等于 已审核\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-22T15:11:19.8584735+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：单据状态 等于 已审核\r\n',2819,'2022-08-22 15:11:24','2022-08-22 15:11:24'),
(424,'生产领料单','ab142312105534613','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100795\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T11:51:49.2524393+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8,\"FEntrtyMemo\":\"备注备注备注\",\"FEntrySrcBillNo\":\"PPBOM00000105\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:12:01.4297632+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"生产领料单对应的生产订单WO2234005第1行的业务状态不为 下达、开工或完工，生产领料单保存不成功！\"}]}','保存失败',1092,'2022-08-22 15:12:03','2022-08-22 15:12:03'),
(425,'生产领料单','ab142322105534613','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100795\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T11:51:49.2524393+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8,\"FEntrtyMemo\":\"备注备注备注\",\"FEntrySrcBillNo\":\"PPBOM00000105\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"审核失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:13:56.7148189+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T15:13:56.7470398+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:13:59.2763121+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"更新库存出现异常情况，更新库存不成功！\"}]}','审核失败',3542,'2022-08-22 15:14:01','2022-08-22 15:14:01'),
(426,'生产领料单','ab142323105534613','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100795\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T11:51:49.2524393+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8,\"FEntrtyMemo\":\"备注备注备注\",\"FEntrySrcBillNo\":\"PPBOM00000105\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"审核失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:17:21.2957499+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T15:17:21.316278+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:17:21.7596744+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"更新库存出现异常情况，更新库存不成功！\"}]}','审核失败',1107,'2022-08-22 15:17:23','2022-08-22 15:17:23'),
(427,'生产领料单','ab142333105534613','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100795\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T11:51:49.2524393+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8,\"FEntrtyMemo\":\"备注备注备注\",\"FEntrySrcBillNo\":\"PPBOM00000105\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:19:31.727344+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T15:19:31.7429529+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:19:32.181429+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000074\",\"msg\":null}]}',NULL,1040,'2022-08-22 15:19:34','2022-08-22 15:19:34'),
(428,'生产用料清单','ccb12f181-9f173-4b1b-a121a14d-1','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":1,\"FID\":100113,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2234005\"},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"3.016\",\"FMoBillNo1\":\"WO2234005\",\"FEntryID\":100805}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:20:10.7302545+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"不允许删除已经下推的数据行\"}]}','保存失败',1058,'2022-08-22 15:20:12','2022-08-22 15:20:12'),
(429,'生产补料单','5678789954688124540','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100795\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-13\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24,\"FEntrtyDescription\":\"备注备注备注\",\"FEntrySrcBillNo\":\"PPBOM00000105\",\"FAppQty\":2}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:21:07.4040514+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"生产补料单第1行对应的生产订单第1行的下达日期大于生产补料单的单据日期，生产补料单保存不成功！\"}]}','保存失败',773,'2022-08-22 15:21:09','2022-08-22 15:21:09'),
(430,'生产订单','36af4c7b-5f51-4aa1-984b-da46f1414f8e','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235001\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-22T15:22:13.5466881+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-22T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-25T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:22:16.7771025+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T15:22:16.8083282+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:22:17.0739932+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:22:17.0739932+08:00\"}],\"resultData\":[{\"code\":\"WO2235001\",\"msg\":null}]}',NULL,3139,'2022-08-22 15:22:19','2022-08-22 15:22:19'),
(431,'生产用料清单','b71c7ad9-0cd1-43e7-aa24-9fef143c6b8e','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":1,\"FID\":100114,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235001\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:28:38.1536943+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000106\",\"msg\":null}]}',NULL,918,'2022-08-22 15:28:40','2022-08-22 15:28:40'),
(432,'生产订单','11a59ccf-1a18-4c57-a6ab-72cf43dbab9d','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235002\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-22T15:37:19.8482905+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-22T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-24T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:37:20.9093738+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T15:37:20.9250016+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:37:21.2218959+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:37:21.2218959+08:00\"}],\"resultData\":[{\"code\":\"WO2235002\",\"msg\":null}]}',NULL,1048,'2022-08-22 15:37:23','2022-08-22 15:37:23'),
(433,'生产用料清单','f7fc0061-20bc-49ab-802c-8768874d4bede8','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":1,\"FID\":100115,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235002\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:44:49.8280469+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000107\",\"msg\":null}]}',NULL,715,'2022-08-22 15:44:51','2022-08-22 15:44:51'),
(434,'生产订单','d205fbdb-a983-47f9-bfb9-b46088b7a5aa','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235003\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-22T15:46:47.7797906+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-22T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-24T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T15:46:51.173695+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T15:46:51.1981001+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:46:51.4940369+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T15:46:51.4940369+08:00\"}],\"resultData\":[{\"code\":\"WO2235003\",\"msg\":null}]}',NULL,3543,'2022-08-22 15:46:53','2022-08-22 15:46:53'),
(435,'生产用料清单','172bd037-d456-4c14-9f36-c245ea171305d','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":1,\"FID\":100116,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235003\"},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FMoBillNo1\":\"WO2235003\"},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"72\",\"FMoBillNo1\":\"WO2235003\"},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"FMoBillNo1\":\"WO2235003\"},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235003\"},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235003\"},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235003\"},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1140\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100837},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"84\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100832},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"29\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100833},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100836},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"40\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100834},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100840},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100835},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100838},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100839},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"3.016\",\"FMoBillNo1\":\"WO2235003\",\"FEntryID\":100841}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T16:00:54.1311856+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000108\",\"msg\":null}]}',NULL,1613,'2022-08-22 16:00:56','2022-08-22 16:00:56'),
(436,'生产订单','712bbdca-6ff5-4ba3-8235-63fc29cfdde8','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235004\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-22T16:06:03.781145+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-22T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-25T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T16:06:05.0842384+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T16:06:05.1154664+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T16:06:05.5061079+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T16:06:05.5061079+08:00\"}],\"resultData\":[{\"code\":\"WO2235004\",\"msg\":null}]}',NULL,1386,'2022-08-22 16:06:07','2022-08-22 16:06:07'),
(437,'生产用料清单','5f2b619d-fe48-48ce-a9eb-92f6d3a59f92','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":1,\"FID\":100117,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235004\"},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FMoBillNo1\":\"WO2235004\"},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"72\",\"FMoBillNo1\":\"WO2235004\"},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"FMoBillNo1\":\"WO2235004\"},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235004\"},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235004\"},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235004\"},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1140\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100855},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"84\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100850},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"29\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100851},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100854},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"40\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100852},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100858},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100853},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100856},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100857},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"3.016\",\"FMoBillNo1\":\"WO2235004\",\"FEntryID\":100859}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T16:07:06.5861528+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000109\",\"msg\":null}]}',NULL,975,'2022-08-22 16:07:08','2022-08-22 16:07:08'),
(438,'生产订单','8f0696eb-d196-4378-aa1d-018903a33539','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235005\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-22T16:58:37.044627+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-22T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-23T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T16:58:39.4817627+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T16:58:39.5051816+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T16:58:39.9974165+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T16:58:39.9974165+08:00\"}],\"resultData\":[{\"code\":\"WO2235005\",\"msg\":null}]}',NULL,2591,'2022-08-22 16:58:42','2022-08-22 16:58:42'),
(439,'生产订单','f4f00896-a42e-440f-a6b0-164cc12a5668','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235006\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-22T17:00:34.0644189+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-22T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-23T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:00:35.1272365+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T17:00:35.1584787+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T17:00:35.5178666+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T17:00:35.5178666+08:00\"}],\"resultData\":[{\"code\":\"WO2235006\",\"msg\":null}]}',NULL,1275,'2022-08-22 17:00:37','2022-08-22 17:00:37'),
(440,'生产用料清单','d0fe83a6-45a3-4b41-9138-641105427a85','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":1,\"FID\":100118,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235005\"},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FMoBillNo1\":\"WO2235005\"},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"72\",\"FMoBillNo1\":\"WO2235005\"},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"FMoBillNo1\":\"WO2235005\"},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235005\"},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235005\"},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235005\"},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1140\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100873},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"84\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100868},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"29\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100869},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100872},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"40\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100870},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100876},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100871},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100874},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100875},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"3.016\",\"FMoBillNo1\":\"WO2235005\",\"FEntryID\":100877}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:01:05.745388+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000110\",\"msg\":null}]}',NULL,5993,'2022-08-22 17:01:07','2022-08-22 17:01:07'),
(441,'生产领料单','ab142333121105534613','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100795\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T11:51:49.2524393+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8,\"FEntrtyMemo\":\"备注备注备注\",\"FEntrySrcBillNo\":\"PPBOM00000105\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:06:39.4092981+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T17:06:39.4405617+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T17:06:40.2540089+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000075\",\"msg\":null}]}',NULL,2885,'2022-08-22 17:06:42','2022-08-22 17:06:42'),
(442,'生产领料单','5be1dc59-f455-4810-b875-18d47b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.2598772+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:08:04.2832914+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"明细表体第2,3,4,5,6,7,8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7,8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7,8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',455,'2022-08-22 17:08:06','2022-08-22 17:08:06'),
(443,'生产领料单','5be1dc59-f455-4810-b875-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.2598772+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:10:55.7958393+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"明细表体第2,3,4,5,6,7,8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7,8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7,8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',449,'2022-08-22 17:10:57','2022-08-22 17:10:57'),
(444,'生产领料单','5be1dc59-f455-4810-b8175-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100851\",\"100852\",\"100853\",\"100861\",\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.2598772+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:24:13.6987668+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第5行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第6行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第7行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第8行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第5行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第6行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第7行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第8行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第5行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第6行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第7行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第8行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第5,6,7,8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第5,6,7,8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第5,6,7,8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',452,'2022-08-22 17:24:15','2022-08-22 17:24:15'),
(445,'生产领料单','5be1dc59-f4155-4810-b8175-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100860\",\"100862\",\"100863\",\"100864\",\"100861\",\"100865\",\"100866\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.2598772+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:27:34.2317873+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第5行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第6行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第7行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第5行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第6行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第7行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第5行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第6行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第7行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第5,6,7行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第5,6,7行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第5,6,7行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',459,'2022-08-22 17:27:36','2022-08-22 17:27:36'),
(446,'生产领料单','5be1dc59-f41515-4810-b8175-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100860\",\"100862\",\"100863\",\"100864\",\"100861\",\"100865\",\"100866\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.2598772+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:44:49.2983162+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第5行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第6行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第7行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第5行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第6行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第7行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第5行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第6行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第7行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第5,6,7行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第5,6,7行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第5,6,7行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',530,'2022-08-22 17:44:51','2022-08-22 17:44:51'),
(447,'生产领料单','5be1dc59-f41515-41810-b8175-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.2598772+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:47:50.8158766+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第3行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"明细表体第2,3,4,5,6,7行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',4456,'2022-08-22 17:47:52','2022-08-22 17:47:52'),
(448,'生产领料单','5be1dc59-f411515-41810-b8175-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.2598772+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:49:27.512142+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第3行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"明细表体第2,3,4,5,6,7行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',374,'2022-08-22 17:49:29','2022-08-22 17:49:29'),
(450,'生产领料单','5be1dc59-f411515-41810-b88175-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:52:17.3302678+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第1行物料编码【0000000446】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',425,'2022-08-22 17:52:19','2022-08-22 17:52:19'),
(451,'生产领料单','5be1dc59-f411515-41810-b788175-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:52:41.0529484+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T17:52:41.0685451+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T17:52:41.9366878+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000077\",\"msg\":null}]}',NULL,1697,'2022-08-22 17:52:44','2022-08-22 17:52:44'),
(452,'生产领料单','5be1dc59-f411515-41810-b788275-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:53:25.0558637+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',397,'2022-08-22 17:53:27','2022-08-22 17:53:27'),
(453,'生产领料单','5be1dc59-f411515-41820-b788275-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:53:50.5685498+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',351,'2022-08-22 17:53:52','2022-08-22 17:53:52'),
(454,'生产领料单','5be1dc59-f411515-418120-b788275-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:54:46.1567623+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T17:54:46.1723622+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T17:54:46.609626+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000078\",\"msg\":null}]}',NULL,1058,'2022-08-22 17:54:48','2022-08-22 17:54:48'),
(455,'生产领料单','5be1dc59-f411515-418120-b778275-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T17:55:39.0478997+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',380,'2022-08-22 17:55:41','2022-08-22 17:55:41'),
(456,'生产领料单','5be1dc59-f411515-4181020-b778275-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:05:25.4644724+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',440,'2022-08-22 18:05:27','2022-08-22 18:05:27'),
(457,'生产领料单','5678789954689124540','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:06:34.3335902+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T18:06:34.380467+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T18:06:35.2134679+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000079\",\"msg\":null}]}',NULL,1733,'2022-08-22 18:06:37','2022-08-22 18:06:37'),
(458,'生产领料单','5be1dc59-f411515-418103 0-b778275-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:06:57.6079691+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',380,'2022-08-22 18:06:59','2022-08-22 18:06:59'),
(459,'生产领料单','5be1dc59-f4115145-418103 0-b778275-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:07:30.9331955+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第3行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第3行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第3行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2,3行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2,3行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2,3行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',455,'2022-08-22 18:07:33','2022-08-22 18:07:33'),
(460,'生产领料单','5be1dc59-f4115145-418103 0-b7780275-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:09:22.7857037+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第3行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第3行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"第3行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2,3行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2,3行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2,3行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',362,'2022-08-22 18:09:24','2022-08-22 18:09:24'),
(461,'生产领料单','5be1dc59-f4115145-418103 0-b7115-18d471b0e4bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:09:42.6822024+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T18:09:42.7173871+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T18:09:43.1548475+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000080\",\"msg\":null}]}',NULL,1113,'2022-08-22 18:09:45','2022-08-22 18:09:45'),
(462,'生产补料单','5be1dc59-f4115145-418103 0-b7115-18123bb6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:10:27.1400999+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',919,'2022-08-22 18:10:29','2022-08-22 18:10:29'),
(463,'生产补料单','5be1dc59-f4115145-418103 0-b7115-181231b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:10:38.6879384+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',400,'2022-08-22 18:10:40','2022-08-22 18:10:40'),
(464,'生产补料单','5be1dc59-f4115145-428103 0-b7115-181231b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":100,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:10:46.9867889+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',372,'2022-08-22 18:10:49','2022-08-22 18:10:49'),
(465,'生产补料单','5be1dc59-f4115145-428103 0-b7115-181131b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:11:05.9691635+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',414,'2022-08-22 18:11:08','2022-08-22 18:11:08'),
(466,'生产补料单','5be1dc59-f4115145-418103 0-b7115-181131b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:12:50.6586095+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',440,'2022-08-22 18:12:52','2022-08-22 18:12:52'),
(467,'生产补料单','5be1dc59-f4115145-418103 0-b7115-181141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":50,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:13:04.1342162+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',417,'2022-08-22 18:13:06','2022-08-22 18:13:06'),
(468,'生产补料单','5be1dc59-f4115145-418203 0-b7115-181141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":50,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:16:23.1907387+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',450,'2022-08-22 18:16:25','2022-08-22 18:16:25'),
(469,'生产补料单','5be1dc59-f4115155-418203 0-b7115-181141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":50,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:19:08.03244+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',405,'2022-08-22 18:19:10','2022-08-22 18:19:10'),
(470,'生产补料单','5be1dc59-f4115155-418203 0-b7115-182141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:19:26.1310501+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',375,'2022-08-22 18:19:28','2022-08-22 18:19:28'),
(471,'生产补料单','5be1dc59-f4115155-410203 0-b7115-182141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:20:00.1378991+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',378,'2022-08-22 18:20:02','2022-08-22 18:20:02'),
(472,'生产补料单','5be1dc59-f4115155-410203 0-b7125-182141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:22:02.9042955+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',382,'2022-08-22 18:22:05','2022-08-22 18:22:05'),
(473,'生产领料单','5be1dc59-f4115145-418103 0-b7115-18d471b0e5bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:24:45.3231994+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',380,'2022-08-22 18:24:47','2022-08-22 18:24:47'),
(474,'生产领料单','5be1dc59-f4115145-518103 0-b7115-18d471b0e5bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:25:19.8073987+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-22T18:25:19.8230151+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-22T18:25:20.3425494+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000081\",\"msg\":null}]}',NULL,1347,'2022-08-22 18:25:22','2022-08-22 18:25:22'),
(475,'生产补料单','5be1dc59-f4115155-410203 0-b7125-183141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:27:46.7429205+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',373,'2022-08-22 18:27:48','2022-08-22 18:27:48'),
(476,'生产补料单','5b11dc59-f4115155-410203 0-b7125-183141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:28:09.1716277+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',362,'2022-08-22 18:28:11','2022-08-22 18:28:11'),
(477,'生产补料单','5b11dc59-f4115155-420203 0-b7125-183141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":100,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-22T18:28:16.3942733+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',365,'2022-08-22 18:28:18','2022-08-22 18:28:18'),
(478,'生产补料单','5b12dc59-f4115155-420203 0-b7125-183141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":100,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T08:55:23.4017707+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',5270,'2022-08-23 08:55:25','2022-08-23 08:55:25'),
(479,'生产补料单','5b12dc59-f4115155-430203 0-b7125-183141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:00:52.9446397+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',406,'2022-08-23 09:00:55','2022-08-23 09:00:55'),
(480,'生产补料单','5b12dc59-f4116155-430203 0-b7125-183141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:07:37.0693815+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',474,'2022-08-23 09:07:39','2022-08-23 09:07:39'),
(481,'生产补料单','5b12dc59-f4117155-430203 0-b7125-183141b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:07:47.1640586+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',409,'2022-08-23 09:07:49','2022-08-23 09:07:49'),
(482,'生产补料单','5b12dc59-f4117155-430203 0-b7125-183151b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:10:17.0918248+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T09:10:17.123067+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T09:10:17.6074621+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000005\",\"msg\":null}]}',NULL,1252,'2022-08-23 09:10:20','2022-08-23 09:10:20'),
(483,'生产退料单','17a27c7e-2fd3-4397-8ea1-69ec8d154201','{\"FormId\":\"PRD_ReturnMtrl\",\"ConvertRule\":\"PRD_PPBOM2RETURNMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-23T09:19:40.0288744+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FQty\":1.0,\"FSrcBillNo\":\"PPBOM00000109\",\"FEntrtyMemo\":\"\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:21:56.0251415+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T09:21:56.0563936+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T09:21:56.8689291+08:00\"}],\"resultData\":[{\"code\":\"SCTL00000005\",\"msg\":null}]}',NULL,4521,'2022-08-23 09:21:59','2022-08-23 09:21:59'),
(484,'生产退料单','3435228a-a7c6-4252-93d6-bfc8e46256f0','{\"FormId\":\"PRD_ReturnMtrl\",\"ConvertRule\":\"PRD_PPBOM2RETURNMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-23T09:23:30.6012694+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FQty\":1.0,\"FSrcBillNo\":\"PPBOM00000109\",\"FEntrtyMemo\":\"\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:23:34.0680042+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T09:23:34.0836584+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T09:23:34.6012263+08:00\"}],\"resultData\":[{\"code\":\"SCTL00000006\",\"msg\":null}]}',NULL,1256,'2022-08-23 09:23:37','2022-08-23 09:23:37'),
(485,'生产补料单','5b12dc59-f4117155-430203 0-b71215-183151b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:26:24.770145+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T09:26:24.8013876+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T09:26:25.2867602+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000006\",\"msg\":null}]}',NULL,1243,'2022-08-23 09:26:27','2022-08-23 09:26:27'),
(486,'生产补料单','5009084b-6bd5-49e3-b7b0-0a637f8dc9fa','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-23T09:28:11.0714788+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrtyDescription\":\"\",\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:28:12.6099413+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T09:28:12.6411942+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T09:28:13.0943202+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000007\",\"msg\":null}]}',NULL,1146,'2022-08-23 09:28:15','2022-08-23 09:28:15'),
(487,'生产补料单','5b12dc59-f4117155-430203 0-b7121ew5-183151b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:30:44.8549968+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T09:30:44.8706187+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T09:30:45.3237297+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000008\",\"msg\":null}]}',NULL,1222,'2022-08-23 09:30:47','2022-08-23 09:30:47'),
(488,'生产退料单','5be1dc59-f4115145-518103 0-b7115-18d4we71b0e5bb6','{\"FormId\":\"PRD_ReturnMtrl\",\"ConvertRule\":\"PRD_PPBOM2RETURNMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FQty\":10,\"FSrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FQty\":10,\"FSrcBillNo\":\"PPBOM00000109\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:32:04.9340378+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T09:32:04.9555307+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T09:32:05.4506876+08:00\"}],\"resultData\":[{\"code\":\"SCTL00000007\",\"msg\":null}]}',NULL,1279,'2022-08-23 09:32:07','2022-08-23 09:32:07'),
(489,'生产领料单','697a92a2-50fc-4484-989d-864a62d49acd','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-23T09:39:58.1790614+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T09:40:05.4338995+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"明细表体第2,3,4,5,6,7,8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7,8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7,8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',1019,'2022-08-23 09:40:07','2022-08-23 09:40:07'),
(490,'生产入库单','A564115661498','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100461\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"K0010105-000013\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235004\",\"FRealQty\":16}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-23T09:53:09.0077516+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \r\n',1288,'2022-08-23 09:53:12','2022-08-23 09:53:12'),
(491,'生产入库单','A56411566w1498','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100461\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235004\",\"FRealQty\":16}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-23T09:56:17.530165+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \r\n',265,'2022-08-23 09:56:20','2022-08-23 09:56:20'),
(492,'生产订单关闭执行SQL','1572381924','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = 100127',0,'response_error:发生时间：	2022-08-23 10:15:09\r\n错误编号：	079bfe489bf44ee6ad911b518adef9c6\r\n错误信息：	列名 &#39;F_LQKJ_IMSSTATUS&#39; 无效。\r\n',NULL,267,'2022-08-23 10:15:12','2022-08-23 10:15:12'),
(493,'生产订单关闭执行SQL','15723181924','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = 100127',0,'response_error:发生时间：	2022-08-23 10:15:49\r\n错误编号：	3fb75b7856a54a5f8252cd5b074d5c6c\r\n错误信息：	列名 &#39;F_LQKJ_IMSSTATUS&#39; 无效。\r\n',NULL,213,'2022-08-23 10:15:51','2022-08-23 10:15:51'),
(494,'生产入库单','A56411466w1498','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100131\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235004\",\"FRealQty\":16}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T11:27:25.0525185+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T11:27:25.1306233+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000058”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[3:0000000438,6:0000000453,10:0000000028,11:0000000422,12:0000000423,13:0000000441,14:0000000442]\"}]}','提交失败',969,'2022-08-23 11:27:27','2022-08-23 11:27:27'),
(495,'生产入库单','A56411467w1498','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100131\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235004\",\"FRealQty\":5}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T11:33:02.0181373+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T11:33:02.0962661+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000059”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[3:0000000438,6:0000000453,10:0000000028,11:0000000422,12:0000000423,13:0000000441,14:0000000442]\"}]}','提交失败',774,'2022-08-23 11:33:04','2022-08-23 11:33:04'),
(496,'生产入库单','A56411469w1498','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100131\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235004\",\"FRealQty\":1}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T11:36:47.9056438+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T11:36:47.968122+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000060”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[3:0000000438,6:0000000453,10:0000000028,11:0000000422,12:0000000423,13:0000000441,14:0000000442]\"}]}','提交失败',794,'2022-08-23 11:36:50','2022-08-23 11:36:50'),
(497,'生产领料单','5be1dc59-f4115145-518103 0-b7115-18d471b075bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":40,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"审核失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T12:03:17.4672441+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T12:03:17.4984989+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T12:03:18.5248342+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"更新库存出现异常情况，更新库存不成功！\"}]}','审核失败',2754,'2022-08-23 12:03:21','2022-08-23 12:03:21'),
(498,'生产入库单','A56411467w11498','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100131\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235004\",\"FRealQty\":1}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T16:06:56.0260613+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T16:06:56.1041744+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000061”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[3:0000000438,6:0000000453,10:0000000028,11:0000000422,12:0000000423,13:0000000441,14:0000000442]\"}]}','提交失败',1740,'2022-08-23 16:06:58','2022-08-23 16:06:58'),
(499,'生产入库单','A56411467w12498','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100131\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235004\",\"FRealQty\":1}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T16:10:48.2749039+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T16:10:48.3530147+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000062”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[6:0000000453]\"}]}','提交失败',758,'2022-08-23 16:10:50','2022-08-23 16:10:50'),
(500,'生产入库单','A56411457w12498','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100131\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235004\",\"FRealQty\":1}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-23T16:11:56.6527919+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-23T16:11:56.7778054+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-23T16:11:58.2885602+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000063\",\"msg\":null}]}',NULL,7714,'2022-08-23 16:12:00','2022-08-23 16:12:00'),
(503,'生产领料单','94ec42c0-6504-43f0-9b91-ad59ec72f45a','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T09:07:54.6474647+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T09:10:02.6304996+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"明细表体第2,3,4,5,6,7,8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7,8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2,3,4,5,6,7,8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',7334,'2022-08-24 09:10:05','2022-08-24 09:10:05'),
(504,'生产领料单','5be1dc59-f4115145-we518103 0-b7115-18d471b075bb6','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100850\",\"100850\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":40,\"FEntrySrcBillNo\":\"PPBOM00000109\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":40,\"FEntrySrcBillNo\":\"PPBOM00000109\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T09:10:58.540646+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第2行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第2行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第2行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第2行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第2行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第2行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第2行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',473,'2022-08-24 09:11:01','2022-08-24 09:11:01'),
(505,'生产订单','eda28e95-6422-433a-a8c0-217510b77cb2','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235007\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T10:32:54.708977+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-26T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":308}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T10:34:46.942809+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T10:34:46.9740713+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T10:34:48.3500164+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T10:34:48.3500164+08:00\"}],\"resultData\":[{\"code\":\"WO2235007\",\"msg\":null}]}',NULL,5289,'2022-08-24 10:34:51','2022-08-24 10:34:51'),
(506,'生产用料清单','2ea230b2-eb42-4042-b3e7-b1620c11138219','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":1,\"FID\":100122,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235007\",\"F_LQKJ_Code\":2076}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T10:48:21.7549392+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000112\",\"msg\":null}]}',NULL,933,'2022-08-24 10:48:24','2022-08-24 10:48:24'),
(507,'生产订单','8d50700e-8afd-41a5-939e-e9fc4c0e6bc1','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235008\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T11:13:00.0950567+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-28T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":309}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T11:14:29.8625518+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T11:14:29.8869643+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T11:14:30.2053744+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T11:14:30.2053744+08:00\"}],\"resultData\":[{\"code\":\"WO2235008\",\"msg\":null}]}',NULL,8293,'2022-08-24 11:14:33','2022-08-24 11:14:33'),
(508,'生产用料清单','2ea2b2-eb42-4022-b3e7-b1721c11148229','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":100123,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235008\",\"F_LQKJ_Code\":2076}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T11:24:35.8407862+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000113\",\"msg\":null}]}',NULL,697,'2022-08-24 11:24:38','2022-08-24 11:24:38'),
(509,'生产领料单','94ec42c0-6504-43f0-9b91-ad159e1121c72f45a','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100921\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T09:07:54.5506143+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000113\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T11:47:31.5754737+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T11:47:31.6223473+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T11:47:32.8801527+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000085\",\"msg\":null}]}',NULL,4588,'2022-08-24 11:47:36','2022-08-24 11:47:36'),
(510,'生产补料单','5b12dc59-f4117155-430203 0-b7121ew5-1831511b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100921\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000113\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T11:48:45.5402812+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"},{\"code\":null,\"msg\":\"生产补料单第1行对应的生产订单第1行的下达日期大于生产补料单的单据日期，生产补料单保存不成功！\"}]}','保存失败',857,'2022-08-24 11:48:48','2022-08-24 11:48:48'),
(511,'生产领料单','94ec42c0-6504-43f0-9b91-ad1591e1121c72f45a','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100921\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T09:07:54.5506143+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1090.0,\"FEntrySrcBillNo\":\"PPBOM00000113\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T11:49:50.5694163+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T11:49:50.5918675+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T11:49:51.0450294+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000086\",\"msg\":null}]}',NULL,1112,'2022-08-24 11:49:54','2022-08-24 11:49:54'),
(512,'生产补料单','5b12dc59-f4117155-430203 0-b7121ew5-11831511b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100921\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000113\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T11:50:07.1573677+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"},{\"code\":null,\"msg\":\"生产补料单第1行对应的生产订单第1行的下达日期大于生产补料单的单据日期，生产补料单保存不成功！\"}]}','保存失败',385,'2022-08-24 11:50:10','2022-08-24 11:50:10'),
(513,'生产订单','9e1653a3-644d-43e2-9ecc-68b6ae1a62b8','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235009\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T11:54:34.2987094+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-27T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":310}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T11:54:37.2772844+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T11:54:37.3085251+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T11:54:37.7421049+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T11:54:37.7421049+08:00\"}],\"resultData\":[{\"code\":\"WO2235009\",\"msg\":null}]}',NULL,1466,'2022-08-24 11:54:40','2022-08-24 11:54:40'),
(514,'生产领料单','94ec42c0-6504-43f0-9b91-ad11591e1121c72f45a','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100921\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T09:07:54.5506143+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1090.0,\"FEntrySrcBillNo\":\"PPBOM00000113\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-24T14:22:29.6428229+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\r\n',1211,'2022-08-24 14:22:33','2022-08-24 14:22:33'),
(515,'生产领料单','94ec42c0-6504-43f0-9b91-ad115921e1121c72f45a','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100921\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T09:07:54.5506143+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10.0,\"FEntrySrcBillNo\":\"PPBOM00000113\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-24T14:23:29.3810357+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\r\n',257,'2022-08-24 14:23:32','2022-08-24 14:23:32'),
(516,'生产订单','7d467b97-a662-4904-90e2-292181a93dbc','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235010\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T14:24:30.3517874+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00\",\"FPlanFinishDate\":\"2022-08-28T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":311}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:24:37.4230366+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T14:24:37.4542942+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T14:24:38.9581894+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T14:24:38.9581894+08:00\"}],\"resultData\":[{\"code\":\"WO2235010\",\"msg\":null}]}',NULL,4571,'2022-08-24 14:24:42','2022-08-24 14:24:42'),
(517,'生产用料清单','2ed4d183-d988-4449-9f7f-1d3e61fccd5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":100125,\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235010\",\"F_LQKJ_Code\":2127}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:28:01.7021944+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000115\",\"msg\":null}]}',NULL,946,'2022-08-24 14:28:05','2022-08-24 14:28:05'),
(518,'生产领料单','94ec42c0-6504-43f0-9b91-ad1159121e1121c72f45a','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T09:07:54.5506143+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10.0,\"FEntrySrcBillNo\":\"PPBOM00000115\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:29:12.6933735+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T14:29:12.7246204+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T14:29:14.2803024+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000087\",\"msg\":null}]}',NULL,2632,'2022-08-24 14:29:17','2022-08-24 14:29:17'),
(519,'生产领料单','94ec42c0-6504-43f0-9b91-ad11591211e1121c72f45a','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T09:07:54.5506143+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1656.0,\"FEntrySrcBillNo\":\"PPBOM00000115\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:30:38.7372692+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T14:30:38.7587452+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T14:30:39.3711226+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000088\",\"msg\":null}]}',NULL,1308,'2022-08-24 14:30:42','2022-08-24 14:30:42'),
(520,'生产补料单','5b12dc59-f4117155-430203 0-b7121e1w5-11831511b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-22T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000115\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:31:16.4033447+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"},{\"code\":null,\"msg\":\"生产补料单第1行对应的生产订单第1行的下达日期大于生产补料单的单据日期，生产补料单保存不成功！\"}]}','保存失败',1020,'2022-08-24 14:31:19','2022-08-24 14:31:19'),
(521,'生产补料单','5b12dc59-f4118155-430203 0-b7121e1w5-111831511b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000115\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:37:03.9595828+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',404,'2022-08-24 14:37:07','2022-08-24 14:37:07'),
(522,'生产补料单','5b12dc59-f4118155-430203 0-b7121e1w5-111831611b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000115\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:42:01.0219031+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',417,'2022-08-24 14:42:04','2022-08-24 14:42:04'),
(523,'生产补料单','5b12dc59-f4118155-430203 0-b7121e1w5-111831612b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000115\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:43:36.5697235+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',413,'2022-08-24 14:43:39','2022-08-24 14:43:39'),
(524,'生产补料单','5b12dc59-f4118155-430203 0-b7221e1w5-111831612b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000115\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:43:49.5696849+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"实发数量超过 “Roundup（申请数量/最小发料批量）* 最小发料批量”，生产补料单分录1保存不成功。\"}]}','保存失败',403,'2022-08-24 14:43:52','2022-08-24 14:43:52'),
(525,'生产补料单','5b12dc59-f4118155-430803 0-b7221e1w5-111831612b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FEntrySrcBillNo\":\"PPBOM00000115\",\"FAppQty\":10}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:46:21.6058388+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T14:46:21.6526793+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T14:46:22.3450535+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000010\",\"msg\":null}]}',NULL,1430,'2022-08-24 14:46:25','2022-08-24 14:46:25'),
(526,'生产补料单','5b12dc59-f4118165-430803 0-b7221e1w5-111831612b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FEntrySrcBillNo\":\"PPBOM00000115\",\"FAppQty\":1000}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:46:33.2102805+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T14:46:33.241533+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T14:46:33.6800351+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000011\",\"msg\":null}]}',NULL,1142,'2022-08-24 14:46:37','2022-08-24 14:46:37'),
(527,'生产补料单','5712dc59-f4118155-430203 0-b8221e1w5-111831612b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000115\",\"FAppQty\":10}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:48:06.5167452+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T14:48:06.5441148+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T14:48:07.0548353+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000012\",\"msg\":null}]}',NULL,1329,'2022-08-24 14:48:10','2022-08-24 14:48:10'),
(528,'生产用料清单','2ed4d183-d988-4449-9f8f-1d3e61fccd5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235010\",\"F_LQKJ_Code\":2129},{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMoBillNo1\":\"WO2235010\",\"F_LQKJ_Code\":2128}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:51:13.6281179+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"},{\"code\":null,\"msg\":\"字段“生产订单编号”是必填项\"}]}','保存失败',520,'2022-08-24 14:51:16','2022-08-24 14:51:16'),
(529,'生产用料清单','2ed4d183-d988-4489-9f8f-1d3e61fccd5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMOBillNO\":\"WO2235010\",\"F_LQKJ_Code\":2129},{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMOBillNO\":\"WO2235010\",\"F_LQKJ_Code\":2128}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:53:42.2655812+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"},{\"code\":null,\"msg\":\"字段“生产订单编号”是必填项\"}]}','保存失败',452,'2022-08-24 14:53:45','2022-08-24 14:53:45'),
(530,'生产用料清单','2ed4d183-d988-4489-9f1f-1d3e61fccd5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMOBillNO\":\"WO2235010\",\"F_LQKJ_Code\":2129}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:54:44.4169722+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"},{\"code\":null,\"msg\":\"字段“生产订单编号”是必填项\"}]}','保存失败',351,'2022-08-24 14:54:47','2022-08-24 14:54:47'),
(531,'生产用料清单','2ed4d183-d988-4589-9f1f-1d3e61fccd5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMOBillNO\":\"WO2235010\",\"F_LQKJ_Code\":2129}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:54:51.8261564+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"},{\"code\":null,\"msg\":\"字段“生产订单编号”是必填项\"}]}','保存失败',354,'2022-08-24 14:54:55','2022-08-24 14:54:55'),
(532,'生产用料清单','2ed4d183-d988-4589-9f1f-1d3e71fccd5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMOBillNO\":\"WO2235010\",\"F_LQKJ_Code\":2128}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:57:54.3269846+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"},{\"code\":null,\"msg\":\"字段“生产订单编号”是必填项\"}]}','保存失败',370,'2022-08-24 14:57:57','2022-08-24 14:57:57'),
(533,'生产用料清单','2ed4d183-d988-4589-9f1f-1d3e71fc1d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMOBillNO\":\"WO2235010\",\"F_LQKJ_Code\":2128}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T14:58:16.3142181+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"},{\"code\":null,\"msg\":\"字段“生产订单编号”是必填项\"}]}','保存失败',353,'2022-08-24 14:58:19','2022-08-24 14:58:19'),
(534,'生产订单','e8747904-b932-4395-aa77-c4f515171d3b','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235011\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T15:04:33.8490056+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-28T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":312}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:04:35.1969027+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T15:04:35.2437507+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T15:04:35.7437814+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T15:04:35.7437814+08:00\"}],\"resultData\":[{\"code\":\"WO2235011\",\"msg\":null}]}',NULL,1587,'2022-08-24 15:04:39','2022-08-24 15:04:39'),
(535,'生产用料清单','6bd53ab5-2164-417d-bdbe-573a20b09233','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2144},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2145},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"72\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2146},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2147},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"0\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2148},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"0\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2149},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"0\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2150},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1140\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2151},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"84\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2152},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"29\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2153},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"0\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2154},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"40\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2155},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2156},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"0\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2157},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2158},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2159},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"3.016\",\"FMOBillNO1\":\"WO2235011\",\"F_LQKJ_Code\":2160}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:05:24.203732+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"},{\"code\":null,\"msg\":\"字段“生产订单编号”是必填项\"}]}','保存失败',1537,'2022-08-24 15:05:27','2022-08-24 15:05:27'),
(536,'生产补料单','5712dc59-f4118155-430403 0-b8221e1w5-111831612b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100944\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000115\",\"FAppQty\":10}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:07:38.2846717+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T15:07:38.3159018+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T15:07:38.8139235+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000013\",\"msg\":null}]}',NULL,1303,'2022-08-24 15:07:42','2022-08-24 15:07:42'),
(537,'生产用料清单','2ed4d183-d988-4589-9f1f-1d3e7cfc1d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"FMOBillNO1\":\"WO2235010\",\"F_LQKJ_Code\":2128}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:14:54.2238847+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"},{\"code\":null,\"msg\":\"字段“生产订单编号”是必填项\"}]}','保存失败',373,'2022-08-24 15:14:57','2022-08-24 15:14:57'),
(538,'生产用料清单','2ed4d183-d988-4589-9f1f-1d3e7wdc1d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235010\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2128}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:16:14.6145416+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',377,'2022-08-24 15:16:17','2022-08-24 15:16:17'),
(539,'生产用料清单','2ed4d183-d988-4689-9f1f-1d3e7wdc1d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235010\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2128,\"FUnitID2\":\"pcs\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"给字段(FUnitID2)设置值(pcs):【字段Key：FUnitID2，字段名：子项单位】格式错误，不能转换为字典类型（Json格式中{}表示字典）\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-24T15:19:37.6456306+08:00\"},{\"stage\":\"加载数据完成\",\"pointTime\":\"2022-08-24T15:19:37.7247106+08:00\"}],\"resultData\":[]}','给字段(FUnitID2)设置值(pcs):【字段Key：FUnitID2，字段名：子项单位】格式错误，不能转换为字典类型（Json格式中{}表示字典）',335,'2022-08-24 15:19:41','2022-08-24 15:19:41'),
(540,'生产用料清单','2ed4d183-d488-4689-9f1f-1d3e7wdc1d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235010\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2128,\"FUnitID2\":\"Pcs\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"给字段(FUnitID2)设置值(Pcs):【字段Key：FUnitID2，字段名：子项单位】格式错误，不能转换为字典类型（Json格式中{}表示字典）\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-24T15:21:26.0664518+08:00\"},{\"stage\":\"加载数据完成\",\"pointTime\":\"2022-08-24T15:21:26.1445601+08:00\"}],\"resultData\":[]}','给字段(FUnitID2)设置值(Pcs):【字段Key：FUnitID2，字段名：子项单位】格式错误，不能转换为字典类型（Json格式中{}表示字典）',371,'2022-08-24 15:21:29','2022-08-24 15:21:29'),
(541,'生产用料清单','2ed4d183-d488-4689-9f1f-1d3e7wdCc1d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235010\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2128,\"FUnitID2\":{\"FNumber\":\"Pcs\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:22:54.7235389+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',398,'2022-08-24 15:22:58','2022-08-24 15:22:58'),
(542,'生产用料清单','2ed4d183-d488-4689-9f1f-1d3e7wdC21d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235010\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FUnitID2\":{\"FNumber\":\"Pcs\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2128}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:25:57.956907+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',370,'2022-08-24 15:26:01','2022-08-24 15:26:01'),
(543,'生产用料清单','2ed4d183-d488-4689-9f1f-1d3e7wd31d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235010\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2128}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:29:42.85521+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',375,'2022-08-24 15:29:46','2022-08-24 15:29:46'),
(544,'生产用料清单','2ed4d183-d488-4689-9f1f-113e7wd31d5534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235010\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2128}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:32:20.9292881+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T15:32:20.9917604+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T15:32:21.0854513+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000117\",\"msg\":null}]}',NULL,687,'2022-08-24 15:32:24','2022-08-24 15:32:24'),
(545,'生产用料清单','2ed4d183-d488-4689-9f1f-113e7wd31d4534','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235010\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2128},{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2129}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:32:49.4184983+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T15:32:49.4653711+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T15:32:49.5122444+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000118\",\"msg\":null}]}',NULL,640,'2022-08-24 15:32:52','2022-08-24 15:32:52'),
(546,'生产订单','757adeee-7beb-4172-9e57-ba686d8b494f','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235012\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T15:47:42.2428128+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-31T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":313}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:47:43.6308122+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T15:47:43.6464506+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T15:47:44.1845139+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T15:47:44.1845139+08:00\"}],\"resultData\":[{\"code\":\"WO2235012\",\"msg\":null}]}',NULL,1600,'2022-08-24 15:47:47','2022-08-24 15:47:47'),
(547,'生产用料清单','025fbae9-016e-4621-9e30-ad76a8055fc9','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235012\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2161},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"F_LQKJ_Code\":2162},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"72\",\"F_LQKJ_Code\":2163},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"F_LQKJ_Code\":2164},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2165},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2166},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2167},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1140\",\"F_LQKJ_Code\":2168},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"84\",\"F_LQKJ_Code\":2169},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"29\",\"F_LQKJ_Code\":2170},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2171},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"40\",\"F_LQKJ_Code\":2172},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2173},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2174},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2175},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2176},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"3.016\",\"F_LQKJ_Code\":2177}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:48:15.8153732+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',1098,'2022-08-24 15:48:19','2022-08-24 15:48:19'),
(548,'生产用料清单','0ab8fa3f-49b7-49a6-ad8b-405d9ce5be82','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235012\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2161},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"F_LQKJ_Code\":2162},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"72\",\"F_LQKJ_Code\":2163},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"F_LQKJ_Code\":2164},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2165},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2166},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2167},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1140\",\"F_LQKJ_Code\":2168},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"84\",\"F_LQKJ_Code\":2169},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"29\",\"F_LQKJ_Code\":2170},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2171},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"40\",\"F_LQKJ_Code\":2172},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2173},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2174},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2175},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2176},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"3.016\",\"F_LQKJ_Code\":2177}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T15:53:26.16674+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T15:53:26.2136215+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T15:53:26.2604789+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000120\",\"msg\":null}]}',NULL,1395,'2022-08-24 15:53:29','2022-08-24 15:53:29'),
(549,'生产领料单','31528575-9f2e-4f11-89af-2e39a427da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101017\",\"101019\",\"101020\",\"101021\",\"101018\",\"101020\",\"101022\",\"101023\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:38.5824692+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000120\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:27:57.781771+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【1】行分录字段生产订单分录内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【2】行分录字段生产订单分录内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【3】行分录字段生产订单分录内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【4】行分录字段生产订单分录内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【1】行分录字段生产订单内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【2】行分录字段生产订单内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【3】行分录字段生产订单内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【4】行分录字段生产订单内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第1行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第5行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第6行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第7行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第8行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第5行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第6行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"明细表体第5,6,7,8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第5,6,7,8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第1,2,3,4,5,6,7,8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',5564,'2022-08-24 16:28:01','2022-08-24 16:28:01'),
(550,'生产领料单','31528575-9f2e-4f11-89af-2e39a1427da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101017\",\"101019\",\"101020\",\"101021\",\"101018\",\"101020\",\"101022\",\"101023\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:38.5824692+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":576.0,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":2.08,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":45.6,\"FEntrySrcBillNo\":\"PPBOM00000120\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.64,\"FEntrySrcBillNo\":\"PPBOM00000120\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:28:43.0395072+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第5行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【1】行分录字段生产订单分录内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【2】行分录字段生产订单分录内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【3】行分录字段生产订单分录内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【4】行分录字段生产订单分录内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【1】行分录字段生产订单内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【2】行分录字段生产订单内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【3】行分录字段生产订单内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体实体【明细】第【4】行分录字段生产订单内码输入数值超出限定范围[1---2147483647]\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第1行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第2行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第3行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第4行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第5行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第6行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第5行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第6行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第7行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第8行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第5行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第6行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"明细表体第5,6,7,8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第5,6,7,8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第1,2,3,4,5,6,7,8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',394,'2022-08-24 16:28:46','2022-08-24 16:28:46'),
(551,'生产订单','8f220530-9f9f-4311-a0d4-6f949fef97b0','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235013\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T16:37:13.1429676+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-31T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":314}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:37:17.3508564+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T16:37:17.3664586+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:37:18.6291552+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:37:18.6291552+08:00\"}],\"resultData\":[{\"code\":\"WO2235013\",\"msg\":null}]}',NULL,5156,'2022-08-24 16:37:22','2022-08-24 16:37:22'),
(552,'生产用料清单','1c15fb3f-464d-4170-9618-b61f3bc53edc','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235013\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":100144,\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1666\",\"F_LQKJ_Code\":2178},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"F_LQKJ_Code\":2179},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"72\",\"F_LQKJ_Code\":2180},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"F_LQKJ_Code\":2181},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2182},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2183},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2184},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1140\",\"FEntryID\":101040,\"F_LQKJ_Code\":2185},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"84\",\"FEntryID\":101035,\"F_LQKJ_Code\":2186},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"29\",\"FEntryID\":101036,\"F_LQKJ_Code\":2187},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"0\",\"FEntryID\":101039,\"F_LQKJ_Code\":2188},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"40\",\"FEntryID\":101037,\"F_LQKJ_Code\":2189},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FEntryID\":101043,\"F_LQKJ_Code\":2190},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"0\",\"FEntryID\":101038,\"F_LQKJ_Code\":2191},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FEntryID\":101041,\"F_LQKJ_Code\":2192},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0\",\"FEntryID\":101042,\"F_LQKJ_Code\":2193},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"3.016\",\"FEntryID\":101044,\"F_LQKJ_Code\":2194}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:37:49.8049126+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000121\",\"msg\":null}]}',NULL,1253,'2022-08-24 16:37:53','2022-08-24 16:37:53'),
(553,'生产领料单','31528575-9f2e-4f11-89af-2e319a1427da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101045\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:34.3867617+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1666.0,\"FEntrySrcBillNo\":\"PPBOM00000121\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"审核失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:41:38.6358427+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T16:41:38.6514709+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:41:39.8584789+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"更新库存出现异常情况，更新库存不成功！\"}]}','审核失败',1914,'2022-08-24 16:41:43','2022-08-24 16:41:43'),
(554,'生产领料单','31528575-9f2e-4f11-89af-2e319a11427da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101045\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:34.3867617+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1000.0,\"FEntrySrcBillNo\":\"PPBOM00000121\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:41:59.8028296+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T16:41:59.8340789+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:42:00.3096104+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000090\",\"msg\":null}]}',NULL,1116,'2022-08-24 16:42:03','2022-08-24 16:42:03'),
(555,'生产领料单','31528575-9f2e-4f11-89af-2e319a114271da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101045\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:34.3867617+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":666.0,\"FEntrySrcBillNo\":\"PPBOM00000121\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"审核失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:42:12.9717502+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T16:42:12.9873804+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:42:13.3936088+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"更新库存出现异常情况，更新库存不成功！\"}]}','审核失败',1015,'2022-08-24 16:42:16','2022-08-24 16:42:16'),
(556,'生产领料单','31528575-9f2e-4f31-89af-2e319a114271da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101045\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:34.3867617+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":666.0,\"FEntrySrcBillNo\":\"PPBOM00000121\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:48:07.7684815+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T16:48:07.7840983+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:48:08.2157147+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000092\",\"msg\":null}]}',NULL,1580,'2022-08-24 16:48:11','2022-08-24 16:48:11'),
(557,'生产领料单','31528575-9f2e-4f31-89af-2e1319a114271da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101045\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:34.3867617+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":666.0,\"FEntrySrcBillNo\":\"PPBOM00000121\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-24T16:48:29.6599934+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\r\n',1067,'2022-08-24 16:48:33','2022-08-24 16:48:33'),
(558,'生产领料单','31528575-9f2e-4f31-89af-2e13119a114271da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101035\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:34.3867617+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":84.0,\"FEntrySrcBillNo\":\"PPBOM00000121\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"审核失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:50:32.7127042+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T16:50:32.7449192+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:50:33.1980216+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"更新库存出现异常情况，更新库存不成功！\"}]}','审核失败',1225,'2022-08-24 16:50:36','2022-08-24 16:50:36'),
(559,'生产领料单','31528575-9f2e-4f31-89af-2e13119a1142171da55','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101040\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T16:26:34.3867617+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1140.0,\"FEntrySrcBillNo\":\"PPBOM00000121\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:53:17.5729581+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T16:53:17.5993269+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:53:18.2897949+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000094\",\"msg\":null}]}',NULL,1501,'2022-08-24 16:53:21','2022-08-24 16:53:21'),
(560,'生产补料单','5712dc59-f4118155-430403 0-b8221e1w5-1111831612b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101040\",\"101045\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000121\",\"FAppQty\":10},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10,\"FEntrySrcBillNo\":\"PPBOM00000121\",\"FAppQty\":10}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T16:55:03.9234856+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T16:55:03.9391295+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T16:55:04.4547526+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000014\",\"msg\":null}]}',NULL,1674,'2022-08-24 16:55:07','2022-08-24 16:55:07'),
(561,'生产补料单','5712dc59-f4118155-431403 0-b8221e1w5-1111831612b6','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101040\",\"101045\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000121\",\"FAppQty\":5},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000121\",\"FAppQty\":5}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:02:46.0726501+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:02:46.1029207+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:02:46.621528+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000015\",\"msg\":null}]}',NULL,1306,'2022-08-24 17:02:50','2022-08-24 17:02:50'),
(562,'生产退料单','5712dc59-f4128155-431403 0-b8221e1w5-1111831612b6','{\"FormId\":\"PRD_ReturnMtrl\",\"ConvertRule\":\"PRD_PPBOM2RETURNMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101040\",\"101045\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FQty\":5,\"FSrcBillNo\":\"PPBOM00000121\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FQty\":5,\"FSrcBillNo\":\"PPBOM00000121\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:03:01.3100137+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:03:01.356868+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:03:02.0785586+08:00\"}],\"resultData\":[{\"code\":\"SCTL00000008\",\"msg\":null}]}',NULL,2546,'2022-08-24 17:03:05','2022-08-24 17:03:05'),
(563,'其他入库','8441114225454d5637','{\"FormId\":\"STK_MISCELLANEOUS\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T11:51:49.2524393+08:00\",\"FSUPPLIERID\":{\"FNumber\":\"21.0001\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FSTOCKERID\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMATERIALID\":{\"FNumber\":\"0000000453\"},\"FQty\":1200,\"FSTOCKID\":{\"FNumber\":\"CK014\"}},{\"FMATERIALID\":{\"FNumber\":\"0000000422\"},\"FQty\":1200,\"FSTOCKID\":{\"FNumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:06:18.4543891+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:06:18.4700035+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:06:18.740453+08:00\"}],\"resultData\":[{\"code\":\"QTRK000012\",\"msg\":null}]}',NULL,932,'2022-08-24 17:06:22','2022-08-24 17:06:22'),
(564,'其他入库','84411142225454d5637','{\"FormId\":\"STK_MISCELLANEOUS\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T11:51:49.2524393+08:00\",\"FSUPPLIERID\":{\"FNumber\":\"21.0001\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FSTOCKERID\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMATERIALID\":{\"FNumber\":\"0000000453\"},\"FQty\":1200,\"FSTOCKID\":{\"FNumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:06:43.8918818+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:06:43.9075013+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:06:44.1359971+08:00\"}],\"resultData\":[{\"code\":\"QTRK000013\",\"msg\":null}]}',NULL,801,'2022-08-24 17:06:47','2022-08-24 17:06:47'),
(565,'生产入库单','A563111557w12599','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100148\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235013\",\"FRealQty\":2}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:19:44.3201139+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:19:44.4294838+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:19:44.9763563+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000066\",\"msg\":null}]}',NULL,1511,'2022-08-24 17:19:48','2022-08-24 17:19:48'),
(566,'受托加工材料入库单','zba1245456543','{\"FormId\":\"STK_OEMInStock\",\"SrcEntryKey\":null,\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-27 16:39:12\",\"FCustId\":{\"FNumber\":\"CUST00001\"},\"FBillEntry\":[{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMaterialId\":{\"FNumber\":\"K0010105-000013\"},\"FQty\":100}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:22:48.7039151+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“库存状态”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"字段“客户”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“收货仓库”是必填项\"},{\"code\":null,\"msg\":\"第1行分录，实收数量（基本单位）必须大于0！\"},{\"code\":null,\"msg\":\"单据货主和保管者必须至少有一项与库存组织一致\"}]}','保存失败',381,'2022-08-24 17:22:52','2022-08-24 17:22:52'),
(567,'受托加工材料入库单','zba1246456543','{\"FormId\":\"STK_OEMInStock\",\"SrcEntryKey\":null,\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-27 16:39:12\",\"FCustId\":{\"FNumber\":\"CUST00001\"},\"FBillEntry\":[{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMaterialId\":{\"FNumber\":\"0000000010\"},\"FQty\":100}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:23:43.8659777+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“库存状态”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"字段“客户”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“收货仓库”是必填项\"}]}','保存失败',422,'2022-08-24 17:23:47','2022-08-24 17:23:47'),
(568,'生产入库单','A563111557w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100148\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235013\",\"FRealQty\":3}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:31:10.6547095+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:31:10.739672+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000067”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[14:0000000442]\"}]}','提交失败',827,'2022-08-24 17:31:14','2022-08-24 17:31:14'),
(569,'生产入库单','A5631115571w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100148\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235013\",\"FRealQty\":1}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:31:42.0688081+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:31:42.1625341+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:31:43.026806+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000068\",\"msg\":null}]}',NULL,1600,'2022-08-24 17:31:46','2022-08-24 17:31:46'),
(570,'生产入库单','A5632115571w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100148\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235013\",\"FRealQty\":1}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:35:21.2591241+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:35:21.3684967+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:35:21.87044+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000069\",\"msg\":null}]}',NULL,1311,'2022-08-24 17:35:25','2022-08-24 17:35:25'),
(571,'生产入库单','A5632115671w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100148\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235013\",\"FRealQty\":10}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:35:31.4037027+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:35:31.46613+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000070”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[14:0000000442]\"}]}','提交失败',745,'2022-08-24 17:35:34','2022-08-24 17:35:34'),
(572,'受托加工材料入库单','zba1256456543','{\"FormId\":\"STK_OEMInStock\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-27 16:39:12\",\"FCustId\":{\"FNumber\":\"CUST00001\"},\"FBillEntry\":[{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMaterialId\":{\"FNumber\":\"0000000010\"},\"FQty\":100,\"FStockStatusId\":{\"FNumber\":\"KCZT08_SYS\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:41:31.908337+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"字段“客户”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“收货仓库”是必填项\"}]}','保存失败',452,'2022-08-24 17:41:35','2022-08-24 17:41:35'),
(573,'受托加工材料入库单','zba1456456543','{\"FormId\":\"STK_OEMInStock\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-27 16:39:12\",\"FCustId\":{\"FNumber\":\"CUST00001\"},\"FBillEntry\":[{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMaterialId\":{\"FNumber\":\"0000000010\"},\"FQty\":100,\"FStockStatusId\":{\"Fnumber\":\"KCZT08_SYS\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:44:15.9540764+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"字段“客户”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“收货仓库”是必填项\"}]}','保存失败',329,'2022-08-24 17:44:19','2022-08-24 17:44:19'),
(574,'生产订单','0884080c-eb2c-4bf7-a6a3-05d596e8dbb5','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235014\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T17:47:21.7635948+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-31T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":315}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:47:22.8866865+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:47:22.9179288+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:47:23.3866637+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:47:23.3866637+08:00\"}],\"resultData\":[{\"code\":\"WO2235014\",\"msg\":null}]}',NULL,1420,'2022-08-24 17:47:26','2022-08-24 17:47:26'),
(575,'生产订单','844d8407-8eaf-4a2c-a2d1-a383fcb2bfc9','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235015\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T17:50:38.7246821+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-31T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":316}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:50:44.629694+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T17:50:44.645299+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:50:44.9021052+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T17:50:44.9021052+08:00\"}],\"resultData\":[{\"code\":\"WO2235015\",\"msg\":null}]}',NULL,5965,'2022-08-24 17:50:48','2022-08-24 17:50:48'),
(576,'生产用料清单','e45ac65e-449c-421e-b54d-344fd287ed5e','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235015\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100146\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"F_LQKJ_Code\":2212},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"F_LQKJ_Code\":2213},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"F_LQKJ_Code\":2214},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"F_LQKJ_Code\":2215},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"F_LQKJ_Code\":2216},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"136.80\",\"F_LQKJ_Code\":2217},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"61.92\",\"F_LQKJ_Code\":2218},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1440\",\"FEntryID\":101069,\"F_LQKJ_Code\":2219},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101064,\"F_LQKJ_Code\":2220},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101065,\"F_LQKJ_Code\":2221},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101068,\"F_LQKJ_Code\":2222},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101066,\"F_LQKJ_Code\":2223},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101072,\"F_LQKJ_Code\":2224},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101067,\"F_LQKJ_Code\":2225},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0.816\",\"FEntryID\":101070,\"F_LQKJ_Code\":2226},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0.816\",\"FEntryID\":101071,\"F_LQKJ_Code\":2227},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"8.016\",\"FEntryID\":101073,\"F_LQKJ_Code\":2228}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T17:51:15.7556618+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000123\",\"msg\":null}]}',NULL,1025,'2022-08-24 17:51:19','2022-08-24 17:51:19'),
(577,'生产入库单','A563211511671w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100150\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-24T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235015\",\"FRealQty\":16}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T18:18:22.8172995+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T18:18:22.8797946+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000071”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[14:0000000442]\"}]}','提交失败',1516,'2022-08-24 18:18:26','2022-08-24 18:18:26'),
(578,'生产订单关闭执行SQL','12121212','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = 100127',0,'response_error:发生时间：	2022-08-24 18:20:42\r\n错误编号：	e5268f85f53e466c8bf3ae69ed82a7c5\r\n错误信息：	列名 &#39;F_LQKJ_IMSSTATUS&#39; 无效。\r\n',NULL,257,'2022-08-24 18:20:45','2022-08-24 18:20:45'),
(579,'受托加工材料入库单','zba14564516543','{\"FormId\":\"STK_OEMInStock\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-27 16:39:12\",\"FCustId\":{\"FNumber\":\"CUST0004\"},\"FBillEntry\":[{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FStockId\":{\"FNumber\":\"CK018\"},\"FMaterialId\":{\"FNumber\":\"0000000440\"},\"FQty\":100,\"FStockStatusId\":{\"Fnumber\":\"KCZT08_SYS\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T18:29:50.5533067+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细信息”第1行字段“收货仓库”是必填项\"}]}','保存失败',1774,'2022-08-24 18:29:54','2022-08-24 18:29:54'),
(580,'采购入库单','abc125416+74','{\"FormId\":\"STK_InStock\",\"ConvertRule\":\"PUR_PurchaseOrder-STK_InStock\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FPOOrderEntry\",\"SrcIds\":[\"460431\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 18:55:32\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FInStockEntry\":[{\"FStockId\":{\"FNumber\":\"CK013\"},\"FRealQty\":3,\"FSRCBillNo\":\"0000001293\",\"FSeq\":\"1\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"源单(PUR_PurchaseOrder)、目标单(STK_InStock)和单据转换(PUR_PurchaseOrder-STK_InStock)，其中有一个参数不正确！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-24T18:34:06.7240473+08:00\"}],\"resultData\":[]}','源单(PUR_PurchaseOrder)、目标单(STK_InStock)和单据转换(PUR_PurchaseOrder-STK_InStock)，其中有一个参数不正确！',727,'2022-08-24 18:34:10','2022-08-24 18:34:10'),
(581,'受托加工材料入库单','zba14564616543','{\"FormId\":\"STK_OEMInStock\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-27 16:39:12\",\"FCustId\":{\"FNumber\":\"CUST0004\"},\"FBillEntry\":[{\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMaterialId\":{\"FNumber\":\"0000000440\"},\"FStockId\":{\"FNumber\":\"CK018\"},\"FQty\":100,\"FStockStatusId\":{\"Fnumber\":\"KCZT01_SYS\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T19:43:20.7107234+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T19:43:20.7419798+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T19:43:21.4763518+08:00\"}],\"resultData\":[{\"code\":\"STCLRK000012\",\"msg\":null}]}',NULL,1525,'2022-08-24 19:43:24','2022-08-24 19:43:24'),
(582,'直接调拨单','A484vf41151dsg746','{\"FormId\":\"STK_TransferDirect\",\"ConvertRule\":\"StkTransferApply-StkTransferDirect\",\"SrcFormId\":\"STK_TRANSFERAPPLY\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100052\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FQty\":1,\"FDestStockId\":{\"Fnumber\":\"CK014\"},\"FSrcBillNo\":\"DBSQ000024\",\"FSeq\":\"1\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"1.用户需有调入库存组织下直接调拨的新增权限；\\r\\n                  \\r\\n2.调拨申请单调拨方向为普通；\\r\\n                  \\r\\n3.调拨申请单已审核、未整单关闭、未行终止、未行业务关闭；\\r\\n                  \\r\\n4.调拨申请单已审核、未整单关闭、未行终止、未行业务关闭；\\r\\n\\r\\n5.申请数量（基本单位）- 普通调出关联数量（基本单位）+ 退货调出数量（基本单位）+ 普通调入途损数量（基本单位）>0\\r\\n                 \\r\\n6.物料已分配到调出和调入组织或由调出或调入组织创建，且已审核、未禁用\\r\\n           \\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：申请数量（基本单位）- 普通调出关联数量（基本单位）+ 退货调出数量（基本单位）+ 普通调入途损数量（基本单位）>0\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-24T19:50:09.1714262+08:00\"}],\"resultData\":[]}','1.用户需有调入库存组织下直接调拨的新增权限；\r\n                  \r\n2.调拨申请单调拨方向为普通；\r\n                  \r\n3.调拨申请单已审核、未整单关闭、未行终止、未行业务关闭；\r\n                  \r\n4.调拨申请单已审核、未整单关闭、未行终止、未行业务关闭；\r\n\r\n5.申请数量（基本单位）- 普通调出关联数量（基本单位）+ 退货调出数量（基本单位）+ 普通调入途损数量（基本单位）>0\r\n                 \r\n6.物料已分配到调出和调入组织或由调出或调入组织创建，且已审核、未禁用\r\n           \r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：申请数量（基本单位）- 普通调出关联数量（基本单位）+ 退货调出数量（基本单位）+ 普通调入途损数量（基本单位）>0\r\n',1417,'2022-08-24 19:50:13','2022-08-24 19:50:13'),
(583,'直接调拨单','A484vf41151dsg1746','{\"FormId\":\"STK_TransferDirect\",\"ConvertRule\":\"StkTransferApply-StkTransferDirect\",\"SrcFormId\":\"STK_TRANSFERAPPLY\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"100052\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"},\"FSrcBillNo\":\"DBSQ000024\",\"FSeq\":\"1\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"1.用户需有调入库存组织下直接调拨的新增权限；\\r\\n                  \\r\\n2.调拨申请单调拨方向为普通；\\r\\n                  \\r\\n3.调拨申请单已审核、未整单关闭、未行终止、未行业务关闭；\\r\\n                  \\r\\n4.调拨申请单已审核、未整单关闭、未行终止、未行业务关闭；\\r\\n\\r\\n5.申请数量（基本单位）- 普通调出关联数量（基本单位）+ 退货调出数量（基本单位）+ 普通调入途损数量（基本单位）>0\\r\\n                 \\r\\n6.物料已分配到调出和调入组织或由调出或调入组织创建，且已审核、未禁用\\r\\n           \\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：申请数量（基本单位）- 普通调出关联数量（基本单位）+ 退货调出数量（基本单位）+ 普通调入途损数量（基本单位）>0\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-24T19:53:06.6019876+08:00\"}],\"resultData\":[]}','1.用户需有调入库存组织下直接调拨的新增权限；\r\n                  \r\n2.调拨申请单调拨方向为普通；\r\n                  \r\n3.调拨申请单已审核、未整单关闭、未行终止、未行业务关闭；\r\n                  \r\n4.调拨申请单已审核、未整单关闭、未行终止、未行业务关闭；\r\n\r\n5.申请数量（基本单位）- 普通调出关联数量（基本单位）+ 退货调出数量（基本单位）+ 普通调入途损数量（基本单位）>0\r\n                 \r\n6.物料已分配到调出和调入组织或由调出或调入组织创建，且已审核、未禁用\r\n           \r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：申请数量（基本单位）- 普通调出关联数量（基本单位）+ 退货调出数量（基本单位）+ 普通调入途损数量（基本单位）>0\r\n',263,'2022-08-24 19:53:09','2022-08-24 19:53:09'),
(584,'直接调拨单','A485vf41151dsg1746','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T19:55:36.8832257+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体实体【明细信息】第【1】行分录，【调出仓库】字段必录\"}]}','保存失败',1412,'2022-08-24 19:55:40','2022-08-24 19:55:40'),
(585,'直接调拨单','A485vf51151dsg1746','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T19:56:22.3684564+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T19:56:22.3997093+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T19:56:25.2883997+08:00\"}],\"resultData\":[{\"code\":\"ZJDB000130\",\"msg\":null}]}',NULL,4082,'2022-08-24 19:56:28','2022-08-24 19:56:28'),
(586,'直接调拨单','A485vf51161dsg1746','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FBillNo\":\"FL-WO2210007\",\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T20:02:26.1798328+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T20:02:26.1954496+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T20:02:26.6485741+08:00\"}],\"resultData\":[{\"code\":\"FL-WO2210007\",\"msg\":null}]}',NULL,1448,'2022-08-24 20:02:29','2022-08-24 20:02:29'),
(587,'生产订单关闭执行SQL','12121312','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = @ERP_SIC',0,'response_error:发生时间：	2022-08-24 20:04:40\r\n错误编号：	123ce8d2e4134c6a9cd0f7735505795d\r\n错误信息：	必须声明标量变量 &quot;@ERP_SIC&quot;。\r\n',NULL,222,'2022-08-24 20:04:43','2022-08-24 20:04:43'),
(588,'生产订单关闭执行SQL','12123312','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = @ERP_SIC',0,'response_error:发生时间：	2022-08-24 20:05:29\r\n错误编号：	0b50f2dee67646a4b297ce13f6d0abf4\r\n错误信息：	必须声明标量变量 &quot;@ERP_SIC&quot;。\r\n',NULL,216,'2022-08-24 20:05:33','2022-08-24 20:05:33'),
(589,'生产订单关闭执行SQL','12123342','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = @ERP_SIC',0,'response_error:发生时间：	2022-08-24 20:13:14\r\n错误编号：	9d51b91c30c64e2eaf7f2286132e23fe\r\n错误信息：	必须声明标量变量 &quot;@ERP_SIC&quot;。\r\n',NULL,217,'2022-08-24 20:13:17','2022-08-24 20:13:17'),
(590,'生产订单关闭执行SQL','12143342','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = 100150',0,'response_error:发生时间：	2022-08-24 20:16:16\r\n错误编号：	c0b34c09bd80489d8727b158ccff1115\r\n错误信息：	列名 &#39;F_LQKJ_IMSSTATUS&#39; 无效。\r\n',NULL,208,'2022-08-24 20:16:20','2022-08-24 20:16:20'),
(591,'生产订单关闭执行SQL','12243342','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = 100150',0,'response_error:发生时间：	2022-08-24 20:16:41\r\n错误编号：	8c8db6cc8f464ed9873366f3f13c762b\r\n错误信息：	列名 &#39;F_LQKJ_IMSSTATUS&#39; 无效。\r\n',NULL,205,'2022-08-24 20:16:45','2022-08-24 20:16:45'),
(592,'生产订单','e991a998-8d3e-4896-bf8f-61a85091d826','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235016\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-24T20:18:07.8511395+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-24T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-30T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":317}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T20:18:10.7904796+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-24T20:18:10.837354+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T20:18:12.0317092+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-24T20:18:12.0317092+08:00\"}],\"resultData\":[{\"code\":\"WO2235016\",\"msg\":null}]}',NULL,3649,'2022-08-24 20:18:15','2022-08-24 20:18:15'),
(593,'生产用料清单','c730289f-ab2e-47cb-b0fc-8d4173517af4','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FMOBillNO1\":\"WO2235016\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100147\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"F_LQKJ_Code\":2229},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"F_LQKJ_Code\":2230},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"F_LQKJ_Code\":2231},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"F_LQKJ_Code\":2232},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"F_LQKJ_Code\":2233},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"136.80\",\"F_LQKJ_Code\":2234},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"61.92\",\"F_LQKJ_Code\":2235},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1440\",\"FEntryID\":101087,\"F_LQKJ_Code\":2236},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101082,\"F_LQKJ_Code\":2237},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101083,\"F_LQKJ_Code\":2238},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101086,\"F_LQKJ_Code\":2239},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101084,\"F_LQKJ_Code\":2240},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101090,\"F_LQKJ_Code\":2241},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101085,\"F_LQKJ_Code\":2242},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0.816\",\"FEntryID\":101088,\"F_LQKJ_Code\":2243},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0.816\",\"FEntryID\":101089,\"F_LQKJ_Code\":2244},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"8.016\",\"FEntryID\":101091,\"F_LQKJ_Code\":2245}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-24T20:18:45.8119407+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000124\",\"msg\":null}]}',NULL,1998,'2022-08-24 20:18:49','2022-08-24 20:18:49'),
(594,'生产订单关闭执行SQL','12253342','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = 100153',0,'response_error:发生时间：	2022-08-24 20:22:37\r\n错误编号：	abf51dddad1e472da76d78fc3e878879\r\n错误信息：	列名 &#39;F_LQKJ_IMSSTATUS&#39; 无效。\r\n',NULL,223,'2022-08-24 20:22:40','2022-08-24 20:22:40'),
(595,'生产订单关闭执行SQL','12353342','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = 100153',0,'response_error:发生时间：	2022-08-24 20:24:10\r\n错误编号：	6a2e4b0141a74c9fa0cdd938a9a9b924\r\n错误信息：	列名 &#39;F_LQKJ_IMSSTATUS&#39; 无效。\r\n',NULL,211,'2022-08-24 20:24:13','2022-08-24 20:24:13'),
(596,'生产订单关闭执行SQL','12353442','UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FEntryId = 100153',0,'response_error:发生时间：	2022-08-24 20:24:57\r\n错误编号：	612f1059eaec4585ad60d0304a80f356\r\n错误信息：	列名 &#39;F_LQKJ_IMSSTATUS&#39; 无效。\r\n',NULL,203,'2022-08-24 20:25:01','2022-08-24 20:25:01'),
(597,'生产订单关闭执行SQL','12353542','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE FEntryId = 100153',1,'1',NULL,222,'2022-08-24 20:26:25','2022-08-24 20:26:25'),
(599,'生产订单关闭执行SQL','13353542','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE FEntryId = @ERP_SIC',0,'response_error:发生时间：	2022-08-25 09:05:47\r\n错误编号：	d07dbeae29bb41c6908ace9e2643d48d\r\n错误信息：	必须声明标量变量 &quot;@ERP_SIC&quot;。\r\n',NULL,324,'2022-08-25 09:05:51','2022-08-25 09:05:51'),
(600,'客户','722587359403511808','{\"FormId\":\"BD_Customer\",\"FieldKeys\":\"FNumber, FName, FForbidStatus, FDescription\",\"FilterString\":\"FCUSTID=\'104068\'\"}',1,'[[\"CUST0001\",\"无锡普诚节能科技产业发展有限公司\",\"A\",\" \"]]',NULL,201,'2022-08-25 09:11:01','2022-08-25 09:11:01'),
(601,'供应商','722587368589037568','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel\",\"FilterString\":\"FSupplierId=\'114731\'\"}',1,'[[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",null,null]]',NULL,203,'2022-08-25 09:11:04','2022-08-25 09:11:04'),
(602,'物料清单执行SQL','722587860564119552','',0,'金蝶服务器地址异常',NULL,193,'2022-08-25 09:13:01','2022-08-25 09:13:01'),
(603,'盘点盘盈单','722589371495026688','{\"FormId\":\"STK_StockCountGain\",\"FieldKeys\":\"FDate, FCreatorId.FNumber, FStockId.FNumber, FMaterialId.FNumber, FCountQty\",\"FilterString\":\"FID=\'100003\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"元数据中标识为FCreatorId的字段上的引用字段FNumber不存在\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":4}}}]]','元数据中标识为FCreatorId的字段上的引用字段FNumber不存在',565,'2022-08-25 09:19:02','2022-08-25 09:19:02'),
(604,'盘点盘亏单','722589623308455936','{\"FormId\":\"STK_StockCountLoss\",\"FieldKeys\":\"FDate, FCreatorId.Fnumber, FStockId.FNumber, FMaterialId.FNumber, FCountQty\",\"FilterString\":\"FID=\'100003\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"元数据中标识为FCreatorId的字段上的引用字段Fnumber不存在\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":4}}}]]','元数据中标识为FCreatorId的字段上的引用字段Fnumber不存在',210,'2022-08-25 09:20:01','2022-08-25 09:20:01'),
(605,'其他出库','722589624201842688','{\"FormId\":\"STK_MisDelivery\",\"FieldKeys\":\"FDate, FCreatorId, FStockId, FMaterialId, FQty, FBillNo\",\"FilterString\":\"FID=\'100295\'\"}',1,'[[\"2022-06-13T00:00:00\",\"130550\",130551,200192,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151207,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151208,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200145,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200146,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151209,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151210,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151211,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151212,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200147,5.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,182930,1.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,119948,2.0,\"QTCK000239\"]]',NULL,212,'2022-08-25 09:20:01','2022-08-25 09:20:01'),
(606,'采购订单','722591888136146944','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus\",\"FilterString\":\"FID=\'100727\'\"}',1,'[[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001235\",73.0,73.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001236\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001237\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001238\",5.0,5.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001239\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"]]',NULL,216,'2022-08-25 09:29:01','2022-08-25 09:29:01'),
(607,'供应商','722592020982337536','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel\",\"FilterString\":\"FSupplierId=\'114731\'\"}',1,'[[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",null,null]]',NULL,204,'2022-08-25 09:29:33','2022-08-25 09:29:33'),
(608,'物料清单执行SQL','722592022194491392','',0,'金蝶服务器地址异常',NULL,213,'2022-08-25 09:29:33','2022-08-25 09:29:33'),
(609,'盘点盘盈单','722592894714580992','{\"FormId\":\"STK_StockCountGain\",\"FieldKeys\":\"FDate, FStockId.FNumber, FMaterialId.FNumber, FCountQty\",\"FilterString\":\"FID=\'100004\'\"}',1,'[[\"2022-08-25T00:00:00\",\"CK003\",\"0000000005\",10.0]]',NULL,228,'2022-08-25 09:33:01','2022-08-25 09:33:01'),
(610,'盘点盘亏单','722593398077198336','{\"FormId\":\"STK_StockCountLoss\",\"FieldKeys\":\"FDate, FStockId.FNumber, FMaterialId.FNumber, FCountQty\",\"FilterString\":\"FID=\'100004\'\"}',1,'[[\"2022-08-25T00:00:00\",\"CK014\",\"0000000422\",6500.0]]',NULL,203,'2022-08-25 09:35:01','2022-08-25 09:35:01'),
(611,'仓库','722593670795038720','{\"FormId\":\"BD_STOCK\",\"FieldKeys\":\"FNumber, FName\",\"FilterString\":\"FStockId=\'107110\'\"}',1,'[[\"CK002\",\"化学品库\"]]',NULL,207,'2022-08-25 09:36:06','2022-08-25 09:36:06'),
(612,'物料','722595914659598336','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount\",\"FilterString\":\"FMATERIALID=\'119440\'\"}',1,'[[\"0000000002\",\"720002\",\"连体防静电服\",\"M\",\"A\",1.0]]',NULL,222,'2022-08-25 09:45:01','2022-08-25 09:45:01'),
(613,'物料清单执行SQL','722596437932576768','',0,'金蝶服务器地址异常',NULL,209,'2022-08-25 09:47:06','2022-08-25 09:47:06'),
(614,'物料清单执行SQL','722597676864311296','',0,'金蝶服务器地址异常',NULL,211,'2022-08-25 09:52:01','2022-08-25 09:52:01'),
(615,'生产订单关闭执行SQL','13355542','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 316',0,'response_error:发生时间：	2022-08-25 09:53:26\r\n错误编号：	f773cb8487b94e4289b172bc8d044c72\r\n错误信息：	列名 &#39;F_LQKJ_Code&#39; 无效。\r\n',NULL,233,'2022-08-25 09:53:30','2022-08-25 09:53:30'),
(616,'物料清单执行SQL','722610259982094336','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',0,'\"java.lang.Class\"',NULL,203,'2022-08-25 10:42:01','2022-08-25 10:42:01'),
(617,'物料清单执行SQL','722610260883869696','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=160787) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',0,'\"java.lang.Class\"',NULL,220,'2022-08-25 10:42:02','2022-08-25 10:42:02'),
(618,'供应商','722611266065600512','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel\",\"FilterString\":\"FSupplierId=\'114731\'\"}',1,'[[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",null,null]]',NULL,208,'2022-08-25 10:46:01','2022-08-25 10:46:01'),
(619,'供应商','722611275347595264','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel\",\"FilterString\":\"FSupplierId=\'160402\'\"}',1,'[[\"26.0005\",\"浙江大学杭州国际科创中心\",\" \",\"A\",null,null]]',NULL,215,'2022-08-25 10:46:03','2022-08-25 10:46:03'),
(620,'物料','722614538008072192','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount\",\"FilterString\":\"FMATERIALID=\'119441\'\"}',1,'[[\"0000000003\",\"720003\",\"连体防静电服\",\"L\",\"A\",1.0]]',NULL,212,'2022-08-25 10:59:01','2022-08-25 10:59:01'),
(621,'物料清单执行SQL','722614539211837440','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',0,'\"java.lang.Class\"',NULL,218,'2022-08-25 10:59:02','2022-08-25 10:59:02'),
(622,'生产补料单','87d8303b-2004-4cfd-b859-55191699d84b','{\"FormId\":\"PRD_FeedMtrl\",\"ConvertRule\":\"PRD_PPBOM2FEEDMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101040\"],\"IsInTransaction\":false,\"Model\":{\"FDate\":\"2022-08-25T13:06:49.268266+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrtyDescription\":\"\",\"FEntrySrcBillNo\":\"PPBOM00000121\",\"FAppQty\":24.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T13:06:57.435695+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-25T13:06:57.4825659+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-25T13:06:59.1749456+08:00\"}],\"resultData\":[{\"code\":\"SCBL00000016\",\"msg\":null}]}',NULL,8665,'2022-08-25 13:07:03','2022-08-25 13:07:03'),
(623,'生产退料单','7a852333-a6b1-44e6-ba80-abb5ef1f6e33','{\"FormId\":\"PRD_ReturnMtrl\",\"ConvertRule\":\"PRD_PPBOM2RETURNMTRL\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101040\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T13:09:41.2706052+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FQty\":1.0,\"FSrcBillNo\":\"PPBOM00000121\",\"FEntrtyMemo\":\"\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T13:09:45.8184604+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-25T13:09:45.8497085+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-25T13:09:46.5381947+08:00\"}],\"resultData\":[{\"code\":\"SCTL00000009\",\"msg\":null}]}',NULL,3160,'2022-08-25 13:09:50','2022-08-25 13:09:50'),
(624,'其他入库','e75f86b9-f3db-46cf-bdd7-c5fbf59a22d6','{\"FormId\":\"STK_MISCELLANEOUS\",\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T13:11:43.2226212+08:00\",\"FSUPPLIERID\":{\"FNumber\":\"21.0001\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FSTOCKERID\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMATERIALID\":{\"FNumber\":\"0000000453\"},\"FQty\":1200.0,\"FSTOCKID\":{\"FNumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T13:11:44.9187672+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-25T13:11:45.0761274+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-25T13:11:45.5139143+08:00\"}],\"resultData\":[{\"code\":\"QTRK000015\",\"msg\":null}]}',NULL,2145,'2022-08-25 13:11:49','2022-08-25 13:11:49'),
(625,'生产订单','9cd8c965-12a5-4f6c-93bc-cb1db2151a89','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235017\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-25T13:26:10.9670886+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-08-25T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-30T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":318}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T13:26:15.5155409+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-25T13:26:15.5624179+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-25T13:26:16.7958537+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-25T13:26:16.7958537+08:00\"}],\"resultData\":[{\"code\":\"WO2235017\",\"msg\":null}]}',NULL,5458,'2022-08-25 13:26:20','2022-08-25 13:26:20'),
(626,'物料清单执行SQL','722659081096859648','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',0,'\"java.lang.Class\"',NULL,191,'2022-08-25 13:56:01','2022-08-25 13:56:01'),
(627,'生产订单关闭执行SQL','13455542','',0,'金蝶服务器地址异常',NULL,275,'2022-08-25 13:58:28','2022-08-25 13:58:28'),
(628,'生产用料清单','ed9274c2-edb7-420f-9470-e89118004532','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FMOBillNO1\":\"WO2235017\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100148\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"F_LQKJ_Code\":2246},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"F_LQKJ_Code\":2247},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"F_LQKJ_Code\":2248},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"2.08\",\"FMustQty\":\"2.08\",\"F_LQKJ_Code\":2249},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"F_LQKJ_Code\":2250},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"45.60\",\"FMustQty\":\"45.60\",\"F_LQKJ_Code\":2251},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"20.64\",\"FMustQty\":\"20.64\",\"F_LQKJ_Code\":2252},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"480\",\"FEntryID\":101105,\"F_LQKJ_Code\":2253},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101100,\"F_LQKJ_Code\":2254},{\"FMaterialID2\":{\"FNumber\":\"0000000657\"},\"FStdQty\":\"\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101101,\"F_LQKJ_Code\":2255},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101104,\"F_LQKJ_Code\":2256},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101102,\"F_LQKJ_Code\":2257},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101108,\"F_LQKJ_Code\":2258},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101103,\"F_LQKJ_Code\":2259},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101106,\"F_LQKJ_Code\":2260},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101107,\"F_LQKJ_Code\":2261},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101109,\"F_LQKJ_Code\":2262}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T14:34:17.4377873+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000125\",\"msg\":null}]}',NULL,1723,'2022-08-25 14:34:21','2022-08-25 14:34:21'),
(629,'物料清单执行SQL','722670656365072384','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',0,'\"java.lang.Class\"',NULL,196,'2022-08-25 14:42:01','2022-08-25 14:42:01'),
(630,'生产入库单','5d3f8b5b-6d59-48d6-93eb-5445f509d1d1','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100154\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T15:17:00.9186025+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235017\",\"FRealQty\":48.0}]}}',0,'response_error:发生时间：	2022-08-25 15:17:08\r\n错误编号：	ed427080d64b47358de7406280482b71\r\n错误信息：	生产入库单SCRK00000072，明细第1行，反写生产订单【WO2235017】，基本单位合格品入库选单数量：合格品入库选单数量+不合格品入库选单数量+报废品入库选单数量+返工品入库选单数量-退库数量不能超过入库上限！\r\n\r\n',NULL,2571,'2022-08-25 15:17:12','2022-08-25 15:17:12'),
(631,'生产入库单','A5632115111671w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100154\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235017\",\"FRealQty\":48}]}}',0,'response_error:发生时间：	2022-08-25 15:21:41\r\n错误编号：	2cb2859111624411afcc295e5c6ccdc1\r\n错误信息：	生产入库单SCRK00000073，明细第1行，反写生产订单【WO2235017】，基本单位合格品入库选单数量：合格品入库选单数量+不合格品入库选单数量+报废品入库选单数量+返工品入库选单数量-退库数量不能超过入库上限！\r\n\r\n',NULL,527,'2022-08-25 15:21:45','2022-08-25 15:21:45'),
(632,'生产入库单','A56321151116711w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100154\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235017\",\"FRealQty\":16}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T15:23:08.3171136+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-25T15:23:08.4264942+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000074”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[7:0000000444,8:0000000445,14:0000000442]\"}]}','提交失败',977,'2022-08-25 15:23:12','2022-08-25 15:23:12'),
(633,'生产入库单','A563211511116711w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100154\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235017\",\"FRealQty\":48}]}}',0,'response_error:发生时间：	2022-08-25 15:24:47\r\n错误编号：	5995eecfd0094ffd9abb2dbf8e7b7d51\r\n错误信息：	生产入库单SCRK00000075，明细第1行，反写生产订单【WO2235017】，基本单位合格品入库选单数量：合格品入库选单数量+不合格品入库选单数量+报废品入库选单数量+返工品入库选单数量-退库数量不能超过入库上限！\r\n\r\n',NULL,525,'2022-08-25 15:24:51','2022-08-25 15:24:51'),
(634,'生产入库单','A5632115111167111w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100154\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235017\",\"FRealQty\":1}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T15:25:01.3785859+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-25T15:25:01.4850784+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-25T15:25:03.9430574+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000076\",\"msg\":null}]}',NULL,3268,'2022-08-25 15:25:07','2022-08-25 15:25:07'),
(635,'生产入库单','A56321151111167111w125199','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100154\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-25T17:07:45.1483541+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2235017\",\"FRealQty\":16}]}}',0,'response_error:发生时间：	2022-08-25 15:44:15\r\n错误编号：	f061316dbff54a41a18cb9b4b53ce7af\r\n错误信息：	生产入库单SCRK00000077，明细第1行，反写生产订单【WO2235017】，基本单位合格品入库选单数量：合格品入库选单数量+不合格品入库选单数量+报废品入库选单数量+返工品入库选单数量-退库数量不能超过入库上限！\r\n\r\n',NULL,585,'2022-08-25 15:44:19','2022-08-25 15:44:19'),
(636,'生产订单关闭执行SQL','13465542','',0,'金蝶服务器地址异常',NULL,232,'2022-08-25 15:45:25','2022-08-25 15:45:25'),
(637,'盘点盘盈单','722690789909270528','{\"FormId\":\"STK_StockCountGain\",\"FieldKeys\":\"FDate, FStockId.FNumber, FMaterialId.FNumber, FCountQty, FStockOrgId, FNoteHead\",\"FilterString\":\"FID=\'100005\'\"}',1,'[[\"2022-08-25T00:00:00\",\"CK004\",\"0000000005\",10.0,1,\" \"]]',NULL,212,'2022-08-25 16:02:01','2022-08-25 16:02:01'),
(638,'供应商','722713690847252480','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel, FContactIsDefault\",\"FilterString\":\"FSupplierId=\'114731\'\"}',1,'[[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",null,null,false]]',NULL,234,'2022-08-25 17:33:01','2022-08-25 17:33:01'),
(639,'供应商','722713941607911424','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel, FContactIsDefault\",\"FilterString\":\"FSupplierId=\'114732\'\"}',1,'[[\"21.0002\",\"江苏富乐华半导体科技股份有限公司\",\" \",\"A\",\"吕慧\",\" \",false]]',NULL,224,'2022-08-25 17:34:01','2022-08-25 17:34:01'),
(640,'供应商','722715200863801344','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel, FContactIsDefault\",\"FilterString\":\"FSupplierId=\'114731\'\"}',1,'[[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",\"吴思源\",\" \",true],[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",\"张三\",\"121212121212\",false]]',NULL,205,'2022-08-25 17:39:01','2022-08-25 17:39:01'),
(641,'供应商','722716207396098048','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel, FContactIsDefault\",\"FilterString\":\"FSupplierId=\'114731\'\"}',1,'[[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",\"吴思源\",\" \",true],[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",\"张三\",\"121212121212\",false],[\"21.0001\",\"ROHM Semiconductor Hong Kong Co., Ltd.\",\" \",\"A\",\"李四\",\"111111\",false]]',NULL,199,'2022-08-25 17:43:01','2022-08-25 17:43:01'),
(642,'客户','722742379832086528','{\"FormId\":\"BD_Customer\",\"FieldKeys\":\"FNumber, FName, FForbidStatus, FDescription\",\"FilterString\":\"FCUSTID=\'104084\'\"}',1,'[[\"CUST0003\",\"社保费\",\"A\",\" \"]]',NULL,206,'2022-08-25 19:27:01','2022-08-25 19:27:01'),
(643,'客户','722743386448269312','{\"FormId\":\"BD_Customer\",\"FieldKeys\":\"FNumber, FName, FForbidStatus, FDescription\",\"FilterString\":\"FCUSTID=\'107458\'\"}',1,'[[\"CUST0004\",\"深圳基本半导体有限公司\",\"A\",\" \"]]',NULL,237,'2022-08-25 19:31:01','2022-08-25 19:31:01'),
(644,'仓库','722745147951091712','{\"FormId\":\"BD_STOCK\",\"FieldKeys\":\"FNumber, FName, FStockStatusType\",\"FilterString\":\"FStockId=\'106664\'\"}',1,'[[\"CK001\",\"成品仓\",\"0,1,2,3,4,5,6,7,8\"]]',NULL,201,'2022-08-25 19:38:01','2022-08-25 19:38:01'),
(645,'物料','722745399697412096','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount, FBaseUnitId.FNumber, F_ora_Assistant.FNumber, FUseOrgId\",\"FilterString\":\"FMATERIALID=\'119439\'\"}',1,'[[\"0000000001\",\"720001\",\"连体防静电服\",\"S\",\"A\",1.0,\"tao\",\"002\",1]]',NULL,243,'2022-08-25 19:39:01','2022-08-25 19:39:01'),
(646,'仓库','722746154726658048','{\"FormId\":\"BD_STOCK\",\"FieldKeys\":\"FNumber, FName, FStockStatusType\",\"FilterString\":\"FStockId=\'106664\'\"}',1,'[[\"CK001\",\"成品仓\",\"0,2,5\"]]',NULL,225,'2022-08-25 19:42:01','2022-08-25 19:42:01'),
(647,'物料','722751187912429568','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount, FBaseUnitId.FNumber, F_ora_Assistant.FNumber, FUseOrgId.FNumber\",\"FilterString\":\"FMATERIALID=\'119439\'\"}',1,'[[\"0000000001\",\"720001\",\"连体防静电服\",\"S\",\"A\",1.0,\"tao\",\"002\",\"WX\"]]',NULL,213,'2022-08-25 20:02:01','2022-08-25 20:02:01'),
(648,'采购订单','722751439457423360','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus\",\"FilterString\":\"FID=\'100727\'\"}',1,'[[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001235\",73.0,73.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001236\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001237\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001238\",5.0,5.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001239\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\"]]',NULL,211,'2022-08-25 20:03:01','2022-08-25 20:03:01'),
(649,'采购订单','722752446241378304','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FEntryID\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"输出的字段FEntryID其在指定实体tempObject上的属性没有找到映射或不是简单属性。 \",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":4}}}]]','输出的字段FEntryID其在指定实体tempObject上的属性没有找到映射或不是简单属性。 ',315,'2022-08-25 20:07:01','2022-08-25 20:07:01'),
(650,'其他出库','722752948375064576','{\"FormId\":\"STK_MisDelivery\",\"FieldKeys\":\"FDate, FCreatorId, FStockId, FMaterialId, FQty, FBillNo\",\"FilterString\":\"FID=\'100295\'\"}',1,'[[\"2022-06-13T00:00:00\",\"130550\",130551,200192,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151207,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151208,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200145,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200146,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151209,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151210,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151211,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151212,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200147,5.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,182930,1.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,119948,2.0,\"QTCK000239\"]]',NULL,217,'2022-08-25 20:09:01','2022-08-25 20:09:01'),
(651,'采购订单','722753452756897792','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID\",\"FilterString\":\"FID=\'100727\'\"}',1,'[[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001235\",73.0,73.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103697],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001236\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103698],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001237\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103699],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001238\",5.0,5.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103700],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001239\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103701]]',NULL,232,'2022-08-25 20:11:01','2022-08-25 20:11:01'),
(652,'其他出库','722754961582264320','{\"FormId\":\"STK_MisDelivery\",\"FieldKeys\":\"FDate, FCreatorId, FStockId, FMaterialId, FQty, FBillNo\",\"FilterString\":\"FID=\'100295\'\"}',1,'[[\"2022-06-13T00:00:00\",\"130550\",130551,200192,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151207,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151208,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200145,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200146,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151209,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151210,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151211,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151212,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200147,5.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,182930,1.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,119948,2.0,\"QTCK000239\"]]',NULL,213,'2022-08-25 20:17:01','2022-08-25 20:17:01'),
(653,'其他出库','722755717857218560','{\"FormId\":\"STK_MisDelivery\",\"FieldKeys\":\"FDate, FCreatorId, FStockId, FMaterialId, FQty, FBillNo\",\"FilterString\":\"FID=\'100295\'\"}',1,'[[\"2022-06-13T00:00:00\",\"130550\",130551,200192,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151207,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151208,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200145,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200146,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151209,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151210,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151211,20.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,151212,10.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,200147,5.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,182930,1.0,\"QTCK000239\"],[\"2022-06-13T00:00:00\",\"130550\",130551,119948,2.0,\"QTCK000239\"]]',NULL,208,'2022-08-25 20:20:01','2022-08-25 20:20:01'),
(654,'采购订单','722763014708858880','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty.FNumber\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"元数据中标识为F_ora_BaseProperty的字段不存在\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":9}}}]]','元数据中标识为F_ora_BaseProperty的字段不存在',1146,'2022-08-25 20:49:02','2022-08-25 20:49:02'),
(655,'采购订单','722763770757320704','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',1,'[[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001235\",73.0,73.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103697,\"500ml/瓶\",\"414078\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001236\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103698,\"500ml/瓶\",\"414079\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001237\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103699,\"500ml/瓶\",\"414080\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001238\",5.0,5.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103700,\"500g/瓶\",\"414081\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001239\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103701,\"500ml/瓶\",\"414082\"]]',NULL,203,'2022-08-25 20:52:01','2022-08-25 20:52:01'),
(656,'采购订单','722765280933253120','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',1,'[[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001235\",73.0,73.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103697,\"500ml/瓶\",\"414078\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001236\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103698,\"500ml/瓶\",\"414079\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001237\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103699,\"500ml/瓶\",\"414080\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001238\",5.0,5.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103700,\"500g/瓶\",\"414081\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001239\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103701,\"500ml/瓶\",\"414082\"]]',NULL,225,'2022-08-25 20:58:01','2022-08-25 20:58:01'),
(657,'采购订单','722766790723309568','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',1,'[[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001235\",73.0,73.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103697,\"500ml/瓶\",\"414078\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001236\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103698,\"500ml/瓶\",\"414079\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001237\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103699,\"500ml/瓶\",\"414080\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001238\",5.0,5.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103700,\"500g/瓶\",\"414081\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001239\",15.0,15.0,114896,0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103701,\"500ml/瓶\",\"414082\"]]',NULL,201,'2022-08-25 21:04:01','2022-08-25 21:04:01'),
(658,'采购订单','722767797352075264','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',1,'[[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001235\",73.0,73.0,\"ping\",0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103697,\"500ml/瓶\",\"414078\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001236\",15.0,15.0,\"ping\",0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103698,\"500ml/瓶\",\"414079\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001237\",15.0,15.0,\"ping\",0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103699,\"500ml/瓶\",\"414080\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001238\",5.0,5.0,\"ping\",0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103700,\"500g/瓶\",\"414081\"],[\"WXCG2206008\",\"2022-06-10T00:00:00\",126226,\"0000001239\",15.0,15.0,\"ping\",0.0,0.0,\"钉钉提单，补ERP单\",\"A\",103701,\"500ml/瓶\",\"414082\"]]',NULL,217,'2022-08-25 21:08:01','2022-08-25 21:08:01'),
(659,'采购入库单','ab1c125416+74','{\"FormId\":\"STK_InStock\",\"ConvertRule\":\"PUR_PurchaseOrder-STK_InStock\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FPOOrderEntry\",\"SrcIds\":[\"460431\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 18:55:32\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FInStockEntry\":[{\"FStockId\":{\"FNumber\":\"CK013\"},\"FRealQty\":3,\"FSRCBillNo\":\"0000001293\",\"FSeq\":\"1\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"源单(PUR_PurchaseOrder)、目标单(STK_InStock)和单据转换(PUR_PurchaseOrder-STK_InStock)，其中有一个参数不正确！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:17:47.2324716+08:00\"}],\"resultData\":[]}','源单(PUR_PurchaseOrder)、目标单(STK_InStock)和单据转换(PUR_PurchaseOrder-STK_InStock)，其中有一个参数不正确！',545,'2022-08-25 21:17:51','2022-08-25 21:17:51'),
(660,'采购入库单','ab11c125416+74','{\"FormId\":\"STK_InStock\",\"ConvertRule\":\"PUR_PurchaseOrder-STK_InStock\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FPOOrderEntry\",\"SrcIds\":[\"460431\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 18:55:32\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FInStockEntry\":[{\"FStockId\":{\"FNumber\":\"CK013\"},\"FRealQty\":3,\"FSRCBillNo\":\"WXCG2206011\",\"FSeq\":\"1\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"源单(PUR_PurchaseOrder)、目标单(STK_InStock)和单据转换(PUR_PurchaseOrder-STK_InStock)，其中有一个参数不正确！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:20:31.7285789+08:00\"}],\"resultData\":[]}','源单(PUR_PurchaseOrder)、目标单(STK_InStock)和单据转换(PUR_PurchaseOrder-STK_InStock)，其中有一个参数不正确！',234,'2022-08-25 21:20:36','2022-08-25 21:20:36'),
(661,'采购入库单','ab111125416+74','{\"FormId\":\"STK_InStock\",\"ConvertRule\":\"PUR_PurchaseOrder-STK_InStock\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FPOOrderEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 18:55:32\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FInStockEntry\":[{\"FStockId\":{\"FNumber\":\"CK013\"},\"FRealQty\":3,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"源单(PUR_PurchaseOrder)、目标单(STK_InStock)和单据转换(PUR_PurchaseOrder-STK_InStock)，其中有一个参数不正确！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:22:08.2742749+08:00\"}],\"resultData\":[]}','源单(PUR_PurchaseOrder)、目标单(STK_InStock)和单据转换(PUR_PurchaseOrder-STK_InStock)，其中有一个参数不正确！',217,'2022-08-25 21:22:12','2022-08-25 21:22:12'),
(662,'采购入库单','ab112125416+74','{\"FormId\":\"STK_InStock\",\"ConvertRule\":\"PUR_PurchaseOrder-STK_InStock\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FPOOrderEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 18:55:32\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FInStockEntry\":[{\"FStockId\":{\"FNumber\":\"CK013\"},\"FRealQty\":3,\"FSRCBillNo\":\"WXCG2206011\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T21:23:21.7879366+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-25T21:23:21.8191918+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-25T21:23:29.4090077+08:00\"}],\"resultData\":[{\"code\":\"WXRK2208001\",\"msg\":null}]}',NULL,10822,'2022-08-25 21:23:33','2022-08-25 21:23:33'),
(663,'采购退料单','A11461212415264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"STK_InStock-PUR_MRB\",\"SrcFormId\":\"STK_InStock\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":1,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.入库单已审核,未作废才能下推\\r\\n\\t\\t\\t\\t\\t\\t  4.入库单关联退料数量小于入库数量\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\t\\t\\t\\t\\t\\t  6.入库单不是由组织间结算生成\\r\\n\\t\\t\\t\\t\\t\\t  7.工废入库、料废入库的入库单不能下推退料单 \\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:30:37.5709009+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.入库单已审核,未作废才能下推\r\n						  4.入库单关联退料数量小于入库数量\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n						  6.入库单不是由组织间结算生成\r\n						  7.工废入库、料废入库的入库单不能下推退料单 \r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\r\n',392,'2022-08-25 21:30:42','2022-08-25 21:30:42'),
(664,'采购退料单','A11461212425264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"STK_InStock-PUR_MRB\",\"SrcFormId\":\"STK_InStock\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.入库单已审核,未作废才能下推\\r\\n\\t\\t\\t\\t\\t\\t  4.入库单关联退料数量小于入库数量\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\t\\t\\t\\t\\t\\t  6.入库单不是由组织间结算生成\\r\\n\\t\\t\\t\\t\\t\\t  7.工废入库、料废入库的入库单不能下推退料单 \\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:34:28.2171884+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.入库单已审核,未作废才能下推\r\n						  4.入库单关联退料数量小于入库数量\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n						  6.入库单不是由组织间结算生成\r\n						  7.工废入库、料废入库的入库单不能下推退料单 \r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\r\n',237,'2022-08-25 21:34:32','2022-08-25 21:34:32'),
(665,'采购退料单','A11461242425264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"STK_InStock-PUR_MRB\",\"SrcFormId\":\"STK_InStock\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.入库单已审核,未作废才能下推\\r\\n\\t\\t\\t\\t\\t\\t  4.入库单关联退料数量小于入库数量\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\t\\t\\t\\t\\t\\t  6.入库单不是由组织间结算生成\\r\\n\\t\\t\\t\\t\\t\\t  7.工废入库、料废入库的入库单不能下推退料单 \\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:41:32.1642425+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.入库单已审核,未作废才能下推\r\n						  4.入库单关联退料数量小于入库数量\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n						  6.入库单不是由组织间结算生成\r\n						  7.工废入库、料废入库的入库单不能下推退料单 \r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\r\n',419,'2022-08-25 21:41:36','2022-08-25 21:41:36'),
(666,'采购退料单','A11561242425264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"STK_InStock-PUR_MRB\",\"SrcFormId\":\"STK_InStock\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.入库单已审核,未作废才能下推\\r\\n\\t\\t\\t\\t\\t\\t  4.入库单关联退料数量小于入库数量\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\t\\t\\t\\t\\t\\t  6.入库单不是由组织间结算生成\\r\\n\\t\\t\\t\\t\\t\\t  7.工废入库、料废入库的入库单不能下推退料单 \\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:42:47.5820708+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.入库单已审核,未作废才能下推\r\n						  4.入库单关联退料数量小于入库数量\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n						  6.入库单不是由组织间结算生成\r\n						  7.工废入库、料废入库的入库单不能下推退料单 \r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\r\n',253,'2022-08-25 21:42:51','2022-08-25 21:42:51'),
(667,'采购退料单','A11571242425264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"STK_InStock-PUR_MRB\",\"SrcFormId\":\"STK_InStock\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.入库单已审核,未作废才能下推\\r\\n\\t\\t\\t\\t\\t\\t  4.入库单关联退料数量小于入库数量\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\t\\t\\t\\t\\t\\t  6.入库单不是由组织间结算生成\\r\\n\\t\\t\\t\\t\\t\\t  7.工废入库、料废入库的入库单不能下推退料单 \\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:44:31.7041312+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.入库单已审核,未作废才能下推\r\n						  4.入库单关联退料数量小于入库数量\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n						  6.入库单不是由组织间结算生成\r\n						  7.工废入库、料废入库的入库单不能下推退料单 \r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\r\n',263,'2022-08-25 21:44:36','2022-08-25 21:44:36'),
(668,'采购退料单','A11571252425264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"STK_InStock-PUR_MRB\",\"SrcFormId\":\"STK_InStock\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.入库单已审核,未作废才能下推\\r\\n\\t\\t\\t\\t\\t\\t  4.入库单关联退料数量小于入库数量\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\t\\t\\t\\t\\t\\t  6.入库单不是由组织间结算生成\\r\\n\\t\\t\\t\\t\\t\\t  7.工废入库、料废入库的入库单不能下推退料单 \\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:47:11.2419129+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.入库单已审核,未作废才能下推\r\n						  4.入库单关联退料数量小于入库数量\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n						  6.入库单不是由组织间结算生成\r\n						  7.工废入库、料废入库的入库单不能下推退料单 \r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1. 物料必须允许退料; 2. 库存基本数量 > 退料关联数量(库存基本); 3.入库类型不为工废入库和料废入库类型\r\n',248,'2022-08-25 21:47:15','2022-08-25 21:47:15'),
(669,'采购退料单','A11571252525264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"STK_InStock\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"源单(STK_InStock)、目标单(PUR_MRB)和单据转换(PUR_PurchaseOrder-PUR_MRB)，其中有一个参数不正确！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:53:12.1968982+08:00\"}],\"resultData\":[]}','源单(STK_InStock)、目标单(PUR_MRB)和单据转换(PUR_PurchaseOrder-PUR_MRB)，其中有一个参数不正确！',222,'2022-08-25 21:53:16','2022-08-25 21:53:16'),
(670,'采购退料单','A11571352525264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.库存可退数量>0 或者 收料可退数量>0\\r\\n\\t\\t\\t\\t\\t\\t  4.物料在目标组织下必须存在且已审核、未禁用\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:54:29.7125351+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.库存可退数量>0 或者 收料可退数量>0\r\n						  4.物料在目标组织下必须存在且已审核、未禁用\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \r\n',307,'2022-08-25 21:54:34','2022-08-25 21:54:34'),
(671,'采购退料单','A115713425264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.库存可退数量>0 或者 收料可退数量>0\\r\\n\\t\\t\\t\\t\\t\\t  4.物料在目标组织下必须存在且已审核、未禁用\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T21:55:08.6041077+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.库存可退数量>0 或者 收料可退数量>0\r\n						  4.物料在目标组织下必须存在且已审核、未禁用\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \r\n',243,'2022-08-25 21:55:12','2022-08-25 21:55:12'),
(672,'采购退料单','A1157134685264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.库存可退数量>0 或者 收料可退数量>0\\r\\n\\t\\t\\t\\t\\t\\t  4.物料在目标组织下必须存在且已审核、未禁用\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T22:06:07.0871144+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.库存可退数量>0 或者 收料可退数量>0\r\n						  4.物料在目标组织下必须存在且已审核、未禁用\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \r\n',600,'2022-08-25 22:06:11','2022-08-25 22:06:11'),
(673,'采购退料单','A1157144685264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206011\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.库存可退数量>0 或者 收料可退数量>0\\r\\n\\t\\t\\t\\t\\t\\t  4.物料在目标组织下必须存在且已审核、未禁用\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T22:06:28.728721+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.库存可退数量>0 或者 收料可退数量>0\r\n						  4.物料在目标组织下必须存在且已审核、未禁用\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \r\n',244,'2022-08-25 22:06:33','2022-08-25 22:06:33'),
(674,'采购退料单','A1157144688264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206008\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.库存可退数量>0 或者 收料可退数量>0\\r\\n\\t\\t\\t\\t\\t\\t  4.物料在目标组织下必须存在且已审核、未禁用\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T22:07:35.7618317+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.库存可退数量>0 或者 收料可退数量>0\r\n						  4.物料在目标组织下必须存在且已审核、未禁用\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \r\n',248,'2022-08-25 22:07:40','2022-08-25 22:07:40'),
(675,'采购退料单','A1157144678264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":5,\"FSRCBillNo\":\"WXCG2206008\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.库存可退数量>0 或者 收料可退数量>0\\r\\n\\t\\t\\t\\t\\t\\t  4.物料在目标组织下必须存在且已审核、未禁用\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T22:08:47.720839+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.库存可退数量>0 或者 收料可退数量>0\r\n						  4.物料在目标组织下必须存在且已审核、未禁用\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \r\n',315,'2022-08-25 22:08:52','2022-08-25 22:08:52'),
(676,'采购退料单','A1157144658264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FInStockEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":2,\"FSRCBillNo\":\"WXCG2206008\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"                  1.用户需有退料组织下退料单的新增权限\\r\\n\\t\\t\\t\\t\\t\\t  2.物料必须允许退料\\r\\n\\t\\t\\t\\t\\t\\t  3.库存可退数量>0 或者 收料可退数量>0\\r\\n\\t\\t\\t\\t\\t\\t  4.物料在目标组织下必须存在且已审核、未禁用\\r\\n\\t\\t\\t\\t\\t\\t  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-25T22:11:45.621121+08:00\"}],\"resultData\":[]}','                  1.用户需有退料组织下退料单的新增权限\r\n						  2.物料必须允许退料\r\n						  3.库存可退数量>0 或者 收料可退数量>0\r\n						  4.物料在目标组织下必须存在且已审核、未禁用\r\n						  5.单据业务流程字段所采用的流程上源单与下推目标单有直接流转关系或是自由流程（业务流程字段为空）\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：1.物料必须允许退料; 2. 库存可退数量 > 0 或者 收料可退数量 > 0 \r\n',328,'2022-08-25 22:11:50','2022-08-25 22:11:50'),
(677,'采购退料单','A1157144758264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FPOOrderEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":1,\"FSRCBillNo\":\"WXCG2206008\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"审核失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-25T22:18:28.8288394+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-25T22:18:28.8523275+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-25T22:18:31.1068702+08:00\"}],\"resultData\":[{\"code\":\"CGTL000007\",\"msg\":null},{\"code\":\"AP_Payable 111030\",\"msg\":\"暂存成功！\\r\\n字段“应付类型”是必填项\\r\\n\"}]}','审核失败',3978,'2022-08-25 22:18:35','2022-08-25 22:18:35'),
(679,'生产订单','82ef456c-8b88-4f1c-a03b-314e41069727','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2235020\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-26T15:42:07.8887317+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-08-26T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-31T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":1},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-26T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-31T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":2}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-26T15:42:24.5840977+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-26T15:42:24.630965+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-26T15:42:26.8116322+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-26T15:42:26.8116322+08:00\"}],\"resultData\":[{\"code\":\"WO2235020\",\"msg\":null}]}',NULL,17377,'2022-08-26 15:42:31','2022-08-26 15:42:31'),
(693,'生产订单','b6fdfecd-e69d-4051-bec0-b4aea6a23313','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236001\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-29T09:00:48.8480442+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-08-29T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-31T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":3},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-29T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-31T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":4}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T09:01:02.3150848+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T09:01:02.3619643+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T09:01:03.9576067+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T09:01:03.9576067+08:00\"}],\"resultData\":[{\"code\":\"WO2236001\",\"msg\":null}]}',NULL,12595,'2022-08-29 09:01:10','2022-08-29 09:01:10'),
(694,'生产订单','0a509d87-f492-4270-8f80-0323b953668b','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236002\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-29T09:07:31.6682703+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-08-29T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-30T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":5},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-29T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-08-30T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":6}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T09:07:35.0668766+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T09:07:35.0981216+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T09:07:35.5356197+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T09:07:35.5356197+08:00\"}],\"resultData\":[{\"code\":\"WO2236002\",\"msg\":null}]}',NULL,1561,'2022-08-29 09:07:41','2022-08-29 09:07:41'),
(695,'生产用料清单','73c4b6ad-1f51-49af-a7ae-969ec659d852','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FMOBillNO1\":\"WO2236002\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100154\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"FEntryID\":101165,\"F_LQKJ_Code\":2331},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101166,\"F_LQKJ_Code\":2332},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101167,\"F_LQKJ_Code\":2333},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"2.08\",\"FMustQty\":\"2.08\",\"FEntryID\":101168,\"F_LQKJ_Code\":2334},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"FEntryID\":101169,\"F_LQKJ_Code\":2335},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"45.60\",\"FMustQty\":\"45.60\",\"FEntryID\":101170,\"F_LQKJ_Code\":2336},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"20.64\",\"FMustQty\":\"20.64\",\"FEntryID\":101171,\"F_LQKJ_Code\":2337},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"480\",\"FEntryID\":101160,\"F_LQKJ_Code\":2338},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101155,\"F_LQKJ_Code\":2339},{\"FMaterialID2\":{\"FNumber\":\"\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"F_LQKJ_Code\":2340},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101159,\"F_LQKJ_Code\":2341},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101157,\"F_LQKJ_Code\":2342},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101163,\"F_LQKJ_Code\":2343},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101158,\"F_LQKJ_Code\":2344},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101161,\"F_LQKJ_Code\":2345},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101162,\"F_LQKJ_Code\":2346},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101164,\"F_LQKJ_Code\":2347}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T09:40:50.0719713+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000130\",\"msg\":null}]}',NULL,2154,'2022-08-29 09:40:56','2022-08-29 09:40:56'),
(696,'直接调拨单','A485vf151161dsg1746','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FBillNo\":\"FL-WO2210007\",\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T10:04:06.1044188+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"违反字段唯一性要求：编码唯一。[FL-WO2210007]在当前系统中已经被使用。\"}]}','保存失败',3141,'2022-08-29 10:04:12','2022-08-29 10:04:12'),
(697,'直接调拨单','A485vf511261dsg1746','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FBillNo\":\"FL-WO2210007\",\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T10:04:22.2938675+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"违反字段唯一性要求：编码唯一。[FL-WO2210007]在当前系统中已经被使用。\"}]}','保存失败',951,'2022-08-29 10:04:28','2022-08-29 10:04:28'),
(698,'直接调拨单','A485vf5112611dsg1746','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FBillNo\":\"FL-WO2210008\",\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T10:05:20.6219973+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T10:05:20.6532372+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T10:05:23.4667136+08:00\"}],\"resultData\":[{\"code\":\"FL-WO2210008\",\"msg\":null}]}',NULL,4135,'2022-08-29 10:05:29','2022-08-29 10:05:29'),
(699,'直接调拨单','A485vf5112q611dsg1746','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FBillNo\":\"FL-WO2210009\",\"FDate\":\"2022-08-25 19:12:12\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000447\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":100,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T10:19:08.1390225+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T10:19:08.155653+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T10:19:08.5462567+08:00\"}],\"resultData\":[{\"code\":\"FL-WO2210009\",\"msg\":null}]}',NULL,1558,'2022-08-29 10:19:14','2022-08-29 10:19:14'),
(700,'直接调拨单','fa800b28-0d3e-4b63-8063-ef37f8e70ec0','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FBillNo\":\"FL-WO2236002\",\"FDate\":\"2022-08-29T10:27:52.9670542+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000452\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":500.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000422\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":252.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000423\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":875.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000441\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":65.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000442\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":25.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000443\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":771.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000451\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":200.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T10:27:57.6513747+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T10:27:57.6670017+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T10:27:58.1122945+08:00\"}],\"resultData\":[{\"code\":\"FL-WO2236002\",\"msg\":null}]}',NULL,2721,'2022-08-29 10:28:04','2022-08-29 10:28:04'),
(701,'生产订单','b6ca18a2-4e51-4c3b-9ca5-abba2ce1d578','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236003\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-29T13:06:01.6582019+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-29T00:00:00\",\"FPlanFinishDate\":\"2022-09-01T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":7},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-29T00:00:00\",\"FPlanFinishDate\":\"2022-09-01T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":8}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T13:06:09.4196639+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T13:06:09.4665347+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T13:06:10.8591344+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T13:06:10.8591344+08:00\"}],\"resultData\":[{\"code\":\"WO2236003\",\"msg\":null}]}',NULL,6719,'2022-08-29 13:06:17','2022-08-29 13:06:17'),
(702,'生产用料清单','0ebeaa2c-daf5-4e91-a79c-8348390f54e8','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FMOBillNO1\":\"WO2236003\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100156\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"0\",\"FEntryID\":101190,\"F_LQKJ_Code\":2348},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"0\",\"FEntryID\":101191,\"F_LQKJ_Code\":2349},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"0\",\"FEntryID\":101192,\"F_LQKJ_Code\":2350},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0\",\"FEntryID\":101193,\"F_LQKJ_Code\":2351},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"0\",\"FEntryID\":101194,\"F_LQKJ_Code\":2352},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"0\",\"FEntryID\":101195,\"F_LQKJ_Code\":2353},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"0\",\"FEntryID\":101196,\"F_LQKJ_Code\":2354},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"30\",\"FMustQty\":\"30\",\"FEntryID\":101185,\"F_LQKJ_Code\":2355},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101180,\"F_LQKJ_Code\":2356},{\"FMaterialID2\":{\"FNumber\":\"\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"F_LQKJ_Code\":2357},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"2\",\"FMustQty\":\"2\",\"FEntryID\":101184,\"F_LQKJ_Code\":2358},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101182,\"F_LQKJ_Code\":2359},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101188,\"F_LQKJ_Code\":2360},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101183,\"F_LQKJ_Code\":2361},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101186,\"F_LQKJ_Code\":2362},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101187,\"F_LQKJ_Code\":2363},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"0.167\",\"FMustQty\":\"0.167\",\"FEntryID\":101189,\"F_LQKJ_Code\":2364}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T13:07:22.9792229+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000132\",\"msg\":null}]}',NULL,1640,'2022-08-29 13:07:29','2022-08-29 13:07:29'),
(703,'生产订单','fa953a3e-dba3-405b-ad5c-9f4626687547','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236004\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-29T14:24:41.9594741+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-08-29T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":9},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-29T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":10}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T14:24:48.1281467+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T14:24:48.1749357+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T14:24:49.0596746+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T14:24:49.0596746+08:00\"}],\"resultData\":[{\"code\":\"WO2236004\",\"msg\":null}]}',NULL,6754,'2022-08-29 14:24:55','2022-08-29 14:24:55'),
(704,'生产用料清单','9a527c56-66cd-4e2e-a100-cf491db01e16','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FMOBillNO1\":\"WO2236004\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100158\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"576\",\"FMustQty\":\"324\",\"FEntryID\":101215,\"F_LQKJ_Code\":2365},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FEntryID\":101216,\"F_LQKJ_Code\":2366},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FEntryID\":101217,\"F_LQKJ_Code\":2367},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"2.08\",\"FMustQty\":\"0\",\"FEntryID\":101218,\"F_LQKJ_Code\":2368},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"576\",\"FMustQty\":\"0\",\"FEntryID\":101219,\"F_LQKJ_Code\":2369},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"45.60\",\"FMustQty\":\"0\",\"FEntryID\":101220,\"F_LQKJ_Code\":2370},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"20.64\",\"FMustQty\":\"0\",\"FEntryID\":101221,\"F_LQKJ_Code\":2371},{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"480\",\"FEntryID\":101210,\"F_LQKJ_Code\":2372},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101205,\"F_LQKJ_Code\":2373},{\"FMaterialID2\":{\"FNumber\":\"\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"F_LQKJ_Code\":2374},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101209,\"F_LQKJ_Code\":2375},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101207,\"F_LQKJ_Code\":2376},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101213,\"F_LQKJ_Code\":2377},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101208,\"F_LQKJ_Code\":2378},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101211,\"F_LQKJ_Code\":2379},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101212,\"F_LQKJ_Code\":2380},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101214,\"F_LQKJ_Code\":2381}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T14:25:26.1054765+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000134\",\"msg\":null}]}',NULL,1695,'2022-08-29 14:25:32','2022-08-29 14:25:32'),
(705,'生产入库单','d228c084-1faf-4ed5-897b-833212fc8fde','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100161\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-29T16:31:14.2340816+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2236002\",\"FRealQty\":48.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T16:31:23.7254216+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T16:31:23.8728843+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T16:31:27.6824872+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000078\",\"msg\":null}]}',NULL,9934,'2022-08-29 16:31:34','2022-08-29 16:31:34'),
(706,'采购退料单','A11571144758264','{\"FormId\":\"PUR_MRB\",\"ConvertRule\":\"PUR_PurchaseOrder-PUR_MRB\",\"SrcFormId\":\"PUR_PurchaseOrder\",\"SrcEntryKey\":\"FPOOrderEntry\",\"SrcIds\":[\"103701\"],\"IsInTransaction\":true,\"Model\":{\"FDate\":\"2022-08-28 17:45:21\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FMRTYPE\":\"B\",\"FPURMRBENTRY\":[{\"FSTOCKID\":{\"Fnumber\":\"CK013\"},\"FRMREALQTY\":1,\"FSRCBillNo\":\"WXCG2206008\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T16:56:43.7910048+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-29T16:56:43.8252001+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-29T16:56:50.9688118+08:00\"}],\"resultData\":[{\"code\":\"CGTL000009\",\"msg\":null}]}',NULL,12003,'2022-08-29 16:56:57','2022-08-29 16:56:57'),
(707,'物料清单执行SQL','724155189675364352','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2}]}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
(708,'物料清单执行SQL','724158712295133184','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2}]}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
(709,'直接调拨单','f6153e88-d669-4645-aade-e7f8c736bae9','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"Model\":{\"FBillNo\":\"FL-WO2236002\",\"FDate\":\"2022-08-29T18:04:35.6797283+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000453\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":500.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000446\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":50.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":48.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-29T18:04:39.6374322+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"违反字段唯一性要求：编码唯一。[FL-WO2236002]在当前系统中已经被使用。\"}]}','保存失败',3288,'2022-08-29 18:04:46','2022-08-29 18:04:46'),
(710,'物料清单执行SQL','724197216165236736','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2}]}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
(711,'物料清单执行SQL','724206527343955968','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,zwl.FOLDNUMBER\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null}]}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
(713,'生产订单','61bf4dfc-f698-49a3-b9f4-373cd08b3435','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236005\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T09:31:34.9188965+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":11},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":12}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T09:31:46.7111804+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-30T09:31:46.7580698+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T09:31:48.3313118+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T09:31:48.3313118+08:00\"}],\"resultData\":[{\"code\":\"WO2236005\",\"msg\":null}]}',NULL,13201,'2022-08-30 09:31:55','2022-08-30 09:31:55'),
(714,'生产用料清单','b229ca8e-16f1-4b2b-9c0b-1a85a9be555f','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FMOBillNO1\":\"WO2236005\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100161\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"576\",\"FMustQty\":\"324\",\"FEntryID\":101240,\"F_LQKJ_Code\":2382},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FEntryID\":101241,\"F_LQKJ_Code\":2383},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FEntryID\":101242,\"F_LQKJ_Code\":2384},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"2.08\",\"FMustQty\":\"0\",\"FEntryID\":101243,\"F_LQKJ_Code\":2385},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"576\",\"FMustQty\":\"0\",\"FEntryID\":101244,\"F_LQKJ_Code\":2386},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"45.60\",\"FMustQty\":\"0\",\"FEntryID\":101245,\"F_LQKJ_Code\":2387},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"20.64\",\"FMustQty\":\"0\",\"FEntryID\":101246,\"F_LQKJ_Code\":2388}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T09:32:18.491465+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',712,'2022-08-30 09:32:25','2022-08-30 09:32:25'),
(715,'生产用料清单','93bfd376-0b8b-40d3-a9be-863bf660d0ee','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FMOBillNO1\":\"WO2236005\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100160\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"0\",\"FEntryID\":101235,\"F_LQKJ_Code\":2389},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"0\",\"FEntryID\":101230,\"F_LQKJ_Code\":2390},{\"FMaterialID2\":{\"FNumber\":\"\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"0\",\"F_LQKJ_Code\":2391},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101234,\"F_LQKJ_Code\":2392},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101232,\"F_LQKJ_Code\":2393},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101238,\"F_LQKJ_Code\":2394},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101233,\"F_LQKJ_Code\":2395},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101236,\"F_LQKJ_Code\":2396},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101237,\"F_LQKJ_Code\":2397},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101239,\"F_LQKJ_Code\":2398}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T09:39:30.7100796+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000136\",\"msg\":null}]}',NULL,1004,'2022-08-30 09:39:37','2022-08-30 09:39:37'),
(716,'生产订单','bfec1e6c-35b9-4924-8e4c-ef0416fa602a','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236006\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T09:49:17.6443582+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":8,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":13},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":24,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":14}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T09:49:18.730306+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-30T09:49:18.745922+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T09:49:19.1521704+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T09:49:19.1521704+08:00\"}],\"resultData\":[{\"code\":\"WO2236006\",\"msg\":null}]}',NULL,1544,'2022-08-30 09:49:26','2022-08-30 09:49:26'),
(717,'生产用料清单','2d1ba6d8-6bcd-4fc9-912f-969cebac591c','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":8,\"FMOBillNO1\":\"WO2236006\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100163\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101258,\"F_LQKJ_Code\":2399},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101259,\"F_LQKJ_Code\":2400},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101260,\"F_LQKJ_Code\":2401},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"1.04\",\"FMustQty\":\"1.04\",\"FEntryID\":101261,\"F_LQKJ_Code\":2402},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101262,\"F_LQKJ_Code\":2403},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"22.80\",\"FMustQty\":\"22.80\",\"FEntryID\":101263,\"F_LQKJ_Code\":2404},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"10.32\",\"FMustQty\":\"10.32\",\"FEntryID\":101264,\"F_LQKJ_Code\":2405}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T09:49:52.63164+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',379,'2022-08-30 09:49:59','2022-08-30 09:49:59'),
(718,'生产用料清单','09462f01-a221-4db6-960d-50ca1afb79f3','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":8,\"FMOBillNO1\":\"WO2236006\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100162\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"240\",\"FMustQty\":\"240\",\"FEntryID\":101253,\"F_LQKJ_Code\":2406},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101248,\"F_LQKJ_Code\":2407},{\"FMaterialID2\":{\"FNumber\":\"\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"F_LQKJ_Code\":2408},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101252,\"F_LQKJ_Code\":2409},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"FEntryID\":101250,\"F_LQKJ_Code\":2410},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"FEntryID\":101256,\"F_LQKJ_Code\":2411},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101251,\"F_LQKJ_Code\":2412},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.136\",\"FMustQty\":\"0.136\",\"FEntryID\":101254,\"F_LQKJ_Code\":2413},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.136\",\"FMustQty\":\"0.136\",\"FEntryID\":101255,\"F_LQKJ_Code\":2414},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"1.336\",\"FMustQty\":\"1.336\",\"FEntryID\":101257,\"F_LQKJ_Code\":2415}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T09:51:31.0602731+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000138\",\"msg\":null}]}',NULL,660,'2022-08-30 09:51:38','2022-08-30 09:51:38'),
(719,'生产订单','6e9d8948-cd90-4ac8-99ce-50d962f7c8ac','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236007\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T10:00:31.6920315+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":6,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-03T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":15},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":18,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-03T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":16}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:00:33.1343075+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-30T10:00:33.1655742+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T10:00:33.6157097+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T10:00:33.6157097+08:00\"}],\"resultData\":[{\"code\":\"WO2236007\",\"msg\":null}]}',NULL,1563,'2022-08-30 10:00:40','2022-08-30 10:00:40'),
(720,'生产用料清单','946b4b3b-55ee-4b0d-bdd3-4657eea6191b','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":6,\"FMOBillNO1\":\"WO2236007\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100165\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"216\",\"FMustQty\":\"216\",\"FEntryID\":101276,\"F_LQKJ_Code\":2416},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101277,\"F_LQKJ_Code\":2417},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101278,\"F_LQKJ_Code\":2418},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.78\",\"FMustQty\":\"0.78\",\"FEntryID\":101279,\"F_LQKJ_Code\":2419},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"216\",\"FMustQty\":\"216\",\"FEntryID\":101280,\"F_LQKJ_Code\":2420},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"17.10\",\"FMustQty\":\"17.10\",\"FEntryID\":101281,\"F_LQKJ_Code\":2421},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"7.74\",\"FMustQty\":\"7.74\",\"FEntryID\":101282,\"F_LQKJ_Code\":2422}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:01:20.0805924+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',378,'2022-08-30 10:01:27','2022-08-30 10:01:27'),
(721,'生产用料清单','946b4b3b-55ee-4b0d-bdd3-4657e1ea6191b','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":6,\"FMOBillNO1\":\"WO2236007\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100165\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"216\",\"FMustQty\":\"216\",\"FEntryID\":101276,\"F_LQKJ_Code\":2416},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101277,\"F_LQKJ_Code\":2417},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101278,\"F_LQKJ_Code\":2418},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.78\",\"FMustQty\":\"0.78\",\"FEntryID\":101279,\"F_LQKJ_Code\":2419},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"216\",\"FMustQty\":\"216\",\"FEntryID\":101280,\"F_LQKJ_Code\":2420},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"17.10\",\"FMustQty\":\"17.10\",\"FEntryID\":101281,\"F_LQKJ_Code\":2421},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"7.74\",\"FMustQty\":\"7.74\",\"FEntryID\":101282,\"F_LQKJ_Code\":2422}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:03:54.0462435+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',375,'2022-08-30 10:04:01','2022-08-30 10:04:01'),
(722,'生产用料清单','df8a531e-ef30-498e-82c4-10b7b6fe4da0','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":6,\"FMOBillNO1\":\"WO2236007\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100164\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"180\",\"FMustQty\":\"180\",\"FEntryID\":101271,\"F_LQKJ_Code\":2423},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101266,\"F_LQKJ_Code\":2424},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"F_LQKJ_Code\":2425},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"12\",\"FMustQty\":\"12\",\"FEntryID\":101270,\"F_LQKJ_Code\":2426},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101268,\"F_LQKJ_Code\":2427},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101274,\"F_LQKJ_Code\":2428},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101269,\"F_LQKJ_Code\":2429},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.102\",\"FMustQty\":\"0.102\",\"FEntryID\":101272,\"F_LQKJ_Code\":2430},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.102\",\"FMustQty\":\"0.102\",\"FEntryID\":101273,\"F_LQKJ_Code\":2431},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"1.002\",\"FMustQty\":\"1.002\",\"FEntryID\":101275,\"F_LQKJ_Code\":2432}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:04:26.9524959+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000140\",\"msg\":null}]}',NULL,871,'2022-08-30 10:04:34','2022-08-30 10:04:34'),
(723,'生产用料清单','946b4b3b-55ee-4b0d-bdd3-41657e1ea6191b','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":6,\"FMOBillNO1\":\"WO2236007\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100165\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"216\",\"FMustQty\":\"216\",\"FEntryID\":101276,\"F_LQKJ_Code\":2416},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101277,\"F_LQKJ_Code\":2417},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101278,\"F_LQKJ_Code\":2418},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.78\",\"FMustQty\":\"0.78\",\"FEntryID\":101279,\"F_LQKJ_Code\":2419},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"216\",\"FMustQty\":\"216\",\"FEntryID\":101280,\"F_LQKJ_Code\":2420},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"17.10\",\"FMustQty\":\"17.10\",\"FEntryID\":101281,\"F_LQKJ_Code\":2421},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"7.74\",\"FMustQty\":\"7.74\",\"FEntryID\":101282,\"F_LQKJ_Code\":2422}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:07:55.1516592+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',370,'2022-08-30 10:08:02','2022-08-30 10:08:02'),
(724,'生产用料清单','946b4b3b-55ee-4b0d-bdd3-41657e11ea6191b','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":6,\"FMOBillNO1\":\"WO2236007\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100165\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"216\",\"FMustQty\":\"216\",\"FEntryID\":101276,\"F_LQKJ_Code\":2416},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101277,\"F_LQKJ_Code\":2417},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101278,\"F_LQKJ_Code\":2418},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.78\",\"FMustQty\":\"0.78\",\"FEntryID\":101279,\"F_LQKJ_Code\":2419},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"216\",\"FMustQty\":\"216\",\"FEntryID\":101280,\"F_LQKJ_Code\":2420},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"17.10\",\"FMustQty\":\"17.10\",\"FEntryID\":101281,\"F_LQKJ_Code\":2421},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"7.74\",\"FMustQty\":\"7.74\",\"FEntryID\":101282,\"F_LQKJ_Code\":2422}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:10:26.7932311+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',367,'2022-08-30 10:10:33','2022-08-30 10:10:33'),
(725,'生产订单','339336ed-fec6-4eb0-a72b-2eb96a09f6df','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236008\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T10:16:47.0754135+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":17},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":18}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:16:53.7178403+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-30T10:16:53.7490648+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T10:16:54.3486729+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T10:16:54.3486729+08:00\"}],\"resultData\":[{\"code\":\"WO2236008\",\"msg\":null}]}',NULL,7234,'2022-08-30 10:17:01','2022-08-30 10:17:01'),
(726,'生产用料清单','5cd59888-6c4e-4db0-a8fe-8bf164d7cedc','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FMOBillNO1\":\"WO2236008\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100167\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101295,\"F_LQKJ_Code\":2433},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101296,\"F_LQKJ_Code\":2434},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101297,\"F_LQKJ_Code\":2435},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0.13\",\"FEntryID\":101298,\"F_LQKJ_Code\":2436},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101299,\"F_LQKJ_Code\":2437},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101300,\"F_LQKJ_Code\":2438},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101301,\"F_LQKJ_Code\":2439}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:17:13.2939783+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',406,'2022-08-30 10:17:20','2022-08-30 10:17:20'),
(727,'生产订单','1d32ffb6-c9f7-4ce5-82e2-009ff48ff486','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236009\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T10:31:04.3723018+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-03T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":19},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-03T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":20}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:31:06.0924566+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-30T10:31:06.1266251+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T10:31:06.6598709+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T10:31:06.6598709+08:00\"}],\"resultData\":[{\"code\":\"WO2236009\",\"msg\":null}]}',NULL,1961,'2022-08-30 10:31:13','2022-08-30 10:31:13'),
(728,'生产用料清单','9eaa035b-5136-4e6d-acb6-eaeb9da95d64','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FMOBillNO1\":\"WO2236009\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100169\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101313,\"F_LQKJ_Code\":2450},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101314,\"F_LQKJ_Code\":2451},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101315,\"F_LQKJ_Code\":2452},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0.13\",\"FEntryID\":101316,\"F_LQKJ_Code\":2453},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101317,\"F_LQKJ_Code\":2454},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101318,\"F_LQKJ_Code\":2455},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101319,\"F_LQKJ_Code\":2456}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T10:31:43.6002823+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',4529,'2022-08-30 10:31:50','2022-08-30 10:31:50'),
(729,'物料清单执行SQL','724426728773718016','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,zwl.FOLDNUMBER\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":null}]}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
(730,'物料清单执行SQL','724449629585477632','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev,ma.FOLDNUMBER  from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1,c.FOLDNUMBER  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,ma.FOLDNUMBER  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,stepCTE.FOLDNUMBER\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n left join (\n select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"FOLDNUMBER\":\"240003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"FOLDNUMBER\":\"220003\"}]}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
(731,'物料清单执行SQL','724485364254445568','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zwl.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null}]}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
(732,'物料清单执行SQL','724494172741636096','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zwl.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":null}]}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
(733,'物料清单执行SQL','724496186552815616','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FNUMBER=stepCTE.FNUMBER',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}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
(734,'物料清单执行SQL','724508516250488832','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FNUMBER=stepCTE.FNUMBER',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}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
(735,'物料清单执行SQL','724510782202253312','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=160787) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000942\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000943\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000943_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20030\"},{\"FMATERIALID\":\"0000000942\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000942_V1.0\",\"FMATERIALIDCHILD\":\"0000000525\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20030\"},{\"FMATERIALID\":\"0000000942\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000942_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20030\"},{\"FMATERIALID\":\"0000000942\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000942_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.050000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20030\"},{\"FMATERIALID\":\"0000000942\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000942_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20030\"},{\"FMATERIALID\":\"0000000942\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000942_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20030\"},{\"FMATERIALID\":\"0000000942\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000942_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20030\"},{\"FMATERIALID\":\"0000000942\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000942_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20030\"}]}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
(736,'物料清单执行SQL','724511032954523648','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=160729) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000875\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"}]}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
(737,'物料清单执行SQL','724511787908272128','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM   where fid=160729) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000875\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000941\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000941_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20020\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\"}]}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
(738,'生产订单关闭执行SQL','134615542','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 315',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":0}','7BC67401201E838F18E96B4C52ACCCF65FF1F8EDD324A58F2A11758875A51A680F92A0A87064175EC1B354279BD151FD651615F6E615FF9F5FAA0807650260200836203B02D0058A',298,'2022-08-30 16:50:44','2022-08-30 16:50:44'),
(739,'物料清单执行SQL','724516569393860608','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FNUMBER=stepCTE.FNUMBER',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}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
(740,'物料清单执行SQL','724517346652917760','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FNUMBER=stepCTE.FNUMBER',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}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
(741,'物料清单执行SQL','724517575921963008','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FNUMBER=stepCTE.FNUMBER',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}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
(742,'生产订单关闭执行SQL','154615542','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 19',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":1}','7BC67401201E838F18E96B4C52ACCCF65FF1F8EDD324A58F2A11758875A51A680F92A0A87064175EC1B354279BD151FD651615F6E615FF9F5FAA08076502602031E59571B51505D9',218,'2022-08-30 17:01:32','2022-08-30 17:01:32'),
(743,'物料清单执行SQL','724518582613643264','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM  where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FNUMBER=stepCTE.FNUMBER',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}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
(744,'物料清单执行SQL','724520344217128960','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FNUMBER=stepCTE.FNUMBER',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}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
(745,'物料清单执行SQL','724522357462077440','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}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
(746,'生产订单','ece55549-b567-4986-8014-45e57e21bae1','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236010\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T17:29:55.8505731+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-04T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":21},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-04T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":22},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":0,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-04T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":23}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T17:29:58.3594699+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“WO2236010”的生产订单，第3行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',2036,'2022-08-30 17:30:05','2022-08-30 17:30:05'),
(747,'生产订单','d561ead4-ff24-4f00-a5ba-678ca21ae9a0','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236011\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T17:31:50.1321521+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-04T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":24},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-04T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":25},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":0,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-04T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":26}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T17:31:50.9512356+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“WO2236011”的生产订单，第3行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',564,'2022-08-30 17:31:58','2022-08-30 17:31:58'),
(748,'生产订单','3d5d5a7e-1d5a-47a9-b334-496c035708cb','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"Model\":{\"FBillNo\":\"WO2236012\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T17:32:46.5708941+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":27},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":28},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":0,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":29}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T17:32:47.5428458+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“WO2236012”的生产订单，第3行分录，生产订单主产品数量和基本单位数量必须大于0！\"}]}','保存失败',528,'2022-08-30 17:32:54','2022-08-30 17:32:54'),
(749,'生产订单','a3f50acb-2fca-4ccd-ac86-1220311bfac23','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"WO2236014\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T17:48:35.8779013+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-07T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":32},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-07T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":33}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T18:05:00.0212501+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-30T18:05:00.068117+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T18:05:01.8904045+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T18:05:01.8904045+08:00\"}],\"resultData\":[{\"code\":\"WO2236014\",\"msg\":null}]}',NULL,5326,'2022-08-30 18:05:09','2022-08-30 18:05:09'),
(750,'生产订单','06ea7b92-1a88-4904-8528-21aa9f230077','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"WO2236015\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T18:05:51.6070085+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-07T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":34},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-07T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":35}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T18:05:56.059359+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-30T18:05:56.0905717+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T18:05:56.4968131+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T18:05:56.4968131+08:00\"}],\"resultData\":[{\"code\":\"WO2236015\",\"msg\":null}]}',NULL,1494,'2022-08-30 18:06:03','2022-08-30 18:06:03'),
(751,'生产用料清单','ba12b8f7-9a29-44f2-af80-ac234f24049d','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FMOBillNO1\":\"WO2236015\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100173\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101349,\"F_LQKJ_Code\":2552},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101350,\"F_LQKJ_Code\":2553},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101351,\"F_LQKJ_Code\":2554},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0.13\",\"FEntryID\":101352,\"F_LQKJ_Code\":2555},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101353,\"F_LQKJ_Code\":2556},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101354,\"F_LQKJ_Code\":2557},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101355,\"F_LQKJ_Code\":2558}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T18:16:51.2190912+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',591,'2022-08-30 18:16:58','2022-08-30 18:16:58'),
(752,'生产用料清单','99924914-1847-4f91-ba90-d7c7759c5963','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FMOBillNO1\":\"WO2236015\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100172\",\"FMoEntrySeq1\":\"1\",\"FUnitID\":{\"FNumber\":\"Pcs\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"30\",\"FMustQty\":\"30\",\"FEntryID\":101344,\"F_LQKJ_Code\":2559},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101339,\"F_LQKJ_Code\":2560},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"F_LQKJ_Code\":2561},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"2\",\"FMustQty\":\"2\",\"FEntryID\":101343,\"F_LQKJ_Code\":2562},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101341,\"F_LQKJ_Code\":2563},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101347,\"F_LQKJ_Code\":2564},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101342,\"F_LQKJ_Code\":2565},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101345,\"F_LQKJ_Code\":2566},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101346,\"F_LQKJ_Code\":2567},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"0.167\",\"FMustQty\":\"0.167\",\"FEntryID\":101348,\"F_LQKJ_Code\":2568}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T18:19:19.1398411+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000148\",\"msg\":null}]}',NULL,1129,'2022-08-30 18:19:26','2022-08-30 18:19:26'),
(753,'生产用料清单','ba12b8f7-9a29-44f2-af80-ac2341f24049d','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FMOBillNO1\":\"WO2236015\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100173\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"m\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101349,\"F_LQKJ_Code\":2552},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101350,\"F_LQKJ_Code\":2553},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101351,\"F_LQKJ_Code\":2554},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0.13\",\"FEntryID\":101352,\"F_LQKJ_Code\":2555},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101353,\"F_LQKJ_Code\":2556},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101354,\"F_LQKJ_Code\":2557},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101355,\"F_LQKJ_Code\":2558}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T18:29:20.4588936+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',423,'2022-08-30 18:29:27','2022-08-30 18:29:27'),
(754,'生产用料清单','ba12b8f7-9a29-44f2-1af80-ac2341f24049d','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FMOBillNO1\":\"WO2236015\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100173\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101349,\"F_LQKJ_Code\":2552},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101350,\"F_LQKJ_Code\":2553},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101351,\"F_LQKJ_Code\":2554},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0.13\",\"FEntryID\":101352,\"F_LQKJ_Code\":2555},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101353,\"F_LQKJ_Code\":2556},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101354,\"F_LQKJ_Code\":2557},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101355,\"F_LQKJ_Code\":2558}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T19:45:22.9558247+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000149\",\"msg\":null}]}',NULL,725,'2022-08-30 19:45:30','2022-08-30 19:45:30'),
(755,'生产订单','1595d4d1-da6c-444c-bbfd-b2680641174a','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"WO2236016\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T19:51:11.2423206+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":36},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":37}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T19:51:13.5268836+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-30T19:51:13.5737517+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T19:51:14.4018981+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-30T19:51:14.4018981+08:00\"}],\"resultData\":[{\"code\":\"WO2236016\",\"msg\":null}]}',NULL,3011,'2022-08-30 19:51:21','2022-08-30 19:51:21'),
(756,'生产用料清单','db931b98-266a-4921-8106-e527b3ec9159','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FMaterialID\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FMOBillNO1\":\"WO2236016\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100175\",\"FMoEntrySeq1\":\"2\",\"FUnitID\":{\"FNumber\":\"米\"},\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101368,\"F_LQKJ_Code\":2569},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101369,\"F_LQKJ_Code\":2570},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101370,\"F_LQKJ_Code\":2571},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0.13\",\"FEntryID\":101371,\"F_LQKJ_Code\":2572},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101372,\"F_LQKJ_Code\":2573},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101373,\"F_LQKJ_Code\":2574},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101374,\"F_LQKJ_Code\":2575}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T19:52:00.8236979+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"字段“单位”是必填项\"}]}','保存失败',397,'2022-08-30 19:52:08','2022-08-30 19:52:08'),
(757,'生产用料清单','d8735cd6-f06d-4a27-b1ac-36e21bae67b6','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236016\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100175\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101368,\"F_LQKJ_Code\":2569},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101369,\"F_LQKJ_Code\":2570},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101370,\"F_LQKJ_Code\":2571},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0.13\",\"FEntryID\":101371,\"F_LQKJ_Code\":2572},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101372,\"F_LQKJ_Code\":2573},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101373,\"F_LQKJ_Code\":2574},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101374,\"F_LQKJ_Code\":2575}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T19:58:39.5070471+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000151\",\"msg\":null}]}',NULL,552,'2022-08-30 19:58:46','2022-08-30 19:58:46'),
(758,'生产用料清单','f25afeeb-5b6d-453d-a388-a81405cf6609','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236016\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100174\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"30\",\"FMustQty\":\"30\",\"FEntryID\":101363,\"F_LQKJ_Code\":2576},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101358,\"F_LQKJ_Code\":2577},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"F_LQKJ_Code\":2578},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"2\",\"FMustQty\":\"2\",\"FEntryID\":101362,\"F_LQKJ_Code\":2579},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101360,\"F_LQKJ_Code\":2580},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101366,\"F_LQKJ_Code\":2581},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101361,\"F_LQKJ_Code\":2582},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101364,\"F_LQKJ_Code\":2583},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101365,\"F_LQKJ_Code\":2584},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"0.167\",\"FMustQty\":\"0.167\",\"FEntryID\":101367,\"F_LQKJ_Code\":2585}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-30T19:58:49.7883038+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000150\",\"msg\":null}]}',NULL,833,'2022-08-30 19:58:57','2022-08-30 19:58:57'),
(759,'物料清单执行SQL','724563629450530816','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":[{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000537\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"B20010\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000446\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":3.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000438\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000439\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240005\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000440\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":6.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240006\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000453\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":30.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"220004\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000445\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260002\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000444\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.021000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"260001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000028\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.166666666666666,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"290001\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000657\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"230008\"},{\"FMATERIALID\":\"0000000538\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000538_V1.0\",\"FMATERIALIDCHILD\":\"0000000437\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":2.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":1,\"F_ora_BaseProperty1\":\"A20010\",\"F_ora_BaseProperty2\":\"240003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000422\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"100001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000423\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"102001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000441\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":1.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210001\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000442\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.043478260869565,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000443\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":12.000000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"210003\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000451\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.950000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220002\"},{\"FMATERIALID\":\"0000000537\",\"FForbidStatus\":\"A\",\"FNumber\":\"0000000537_V1.0\",\"FMATERIALIDCHILD\":\"0000000452\",\"FMEMO\":null,\"FIskeyItem\":null,\"FDENOMINATOR\":\"1\",\"dosage\":0.430000000000000,\"FPOSITIONNO\":\" \",\"Lev\":2,\"F_ora_BaseProperty1\":\"B20010\",\"F_ora_BaseProperty2\":\"220003\"}]}',NULL,224,'2022-08-30 20:04:01','2022-08-30 20:04:01'),
(761,'直接调拨单','e6df1543-446b-40da-8cb1-3a61da4c1c57','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"FL-WO22360161\",\"FDate\":\"2022-08-31T08:51:19.7864108+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000422\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":326.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T08:51:28.1342384+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T08:51:28.1654889+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T08:51:30.2816838+08:00\"}],\"resultData\":[{\"code\":\"FL-WO22360161\",\"msg\":null}]}',NULL,10400,'2022-08-31 08:51:37','2022-08-31 08:51:37'),
(762,'直接调拨单','a7a0909e-2079-4950-9ca5-d30c4ae04a6e','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"FL-WO22360162\",\"FDate\":\"2022-08-31T08:56:35.0091153+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000423\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":386.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000441\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":120.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000442\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":25.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000443\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":1226.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000451\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":200.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000452\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":500.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T08:56:36.030521+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T08:56:36.0539674+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T08:56:36.4192633+08:00\"}],\"resultData\":[{\"code\":\"FL-WO22360162\",\"msg\":null}]}',NULL,2256,'2022-08-31 08:56:43','2022-08-31 08:56:43'),
(763,'生产订单','5411d563-f39a-4c82-a760-365e014d54ed','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236017\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-31T09:09:04.0819489+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":38},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":39}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T09:09:09.9657376+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T09:09:10.0126321+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T09:09:11.7733744+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T09:09:11.7733744+08:00\"}],\"resultData\":[{\"code\":\"WO2236017\",\"msg\":null}]}',NULL,8388,'2022-08-31 09:09:19','2022-08-31 09:09:19'),
(764,'生产订单','a3f50acb-2fca-4cc5d-ac86-1220311bfac23','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236020\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T17:48:35.8779013+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-07T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":32},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-07T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":33}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T09:11:34.8943541+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T09:11:34.92562+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T09:11:35.3484254+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T09:11:35.3484254+08:00\"}],\"resultData\":[{\"code\":\"WO2236020\",\"msg\":null}]}',NULL,1516,'2022-08-31 09:11:42','2022-08-31 09:11:42'),
(765,'生产入库单','4c780067-867d-4c53-a49d-d47307d57d8d','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100190\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T09:56:37.2262717+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2236016\",\"FRealQty\":3.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-31T09:56:37.1252055+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n',1143,'2022-08-31 09:56:45','2022-08-31 09:56:45'),
(766,'生产订单关闭执行SQL','4c780067-567d-41c53-a49d-d47307d57d8d','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 37',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":1}',NULL,215,'2022-08-31 10:03:54','2022-08-31 10:03:54'),
(767,'生产入库单','4c780067-867d-4c53-a49d-d473017d57d8d','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100190\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T09:56:37.2262717+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2236016\",\"FRealQty\":3.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-08-31T10:06:59.9881648+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n',309,'2022-08-31 10:07:07','2022-08-31 10:07:07'),
(768,'生产订单关闭执行SQL','155615642','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 37',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":1}',NULL,211,'2022-08-31 10:12:00','2022-08-31 10:12:00'),
(769,'生产订单关闭执行SQL','165615642','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 37',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":1}',NULL,217,'2022-08-31 10:15:00','2022-08-31 10:15:00'),
(770,'生产入库单','3bbf1b1d-8544-45d5-a43b-1df012000163','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100190\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T10:17:52.5518567+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2236016\",\"FRealQty\":3.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:17:53.5884179+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T10:17:53.7329902+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000079”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[2:0000000423,3:0000000441,5:0000000443,6:0000000451,7:0000000452]\"}]}','提交失败',1607,'2022-08-31 10:18:01','2022-08-31 10:18:01'),
(771,'生产入库单','67bf2e39-013f-45e7-b6f8-f746b0906569','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100190\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T10:21:58.7286305+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2236016\",\"FRealQty\":3.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:21:58.9965304+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T10:21:59.0590224+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000080”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[2:0000000423,3:0000000441,5:0000000443,6:0000000451,7:0000000452]\"}]}','提交失败',749,'2022-08-31 10:22:06','2022-08-31 10:22:06'),
(772,'生产订单','ffb0d2f3-efce-4169-83a6-c934e7e2334e','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236018\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-31T10:24:12.4600249+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-08T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":40},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":9,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-08T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":41}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:24:12.7992454+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T10:24:12.8158645+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T10:24:13.3158594+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T10:24:13.3158594+08:00\"}],\"resultData\":[{\"code\":\"WO2236018\",\"msg\":null}]}',NULL,1674,'2022-08-31 10:24:20','2022-08-31 10:24:20'),
(773,'生产用料清单','8a3592ad-75c1-40c2-a11d-b1326b22426e','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236018\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100181\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"0\",\"FEntryID\":101423,\"F_LQKJ_Code\":2603},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"0\",\"FEntryID\":101424,\"F_LQKJ_Code\":2604},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"0\",\"FEntryID\":101425,\"F_LQKJ_Code\":2605},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.39\",\"FMustQty\":\"0\",\"FEntryID\":101426,\"F_LQKJ_Code\":2606},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"0\",\"FEntryID\":101427,\"F_LQKJ_Code\":2607},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"8.55\",\"FMustQty\":\"0\",\"FEntryID\":101428,\"F_LQKJ_Code\":2608},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"3.87\",\"FMustQty\":\"0\",\"FEntryID\":101429,\"F_LQKJ_Code\":2609}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:24:47.6605481+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000157\",\"msg\":null}]}',NULL,641,'2022-08-31 10:24:55','2022-08-31 10:24:55'),
(774,'生产用料清单','33299491-09b1-4840-a04f-96651565f173','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236018\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100180\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"90\",\"FMustQty\":\"90\",\"FEntryID\":101418,\"F_LQKJ_Code\":2610},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101413,\"F_LQKJ_Code\":2611},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"F_LQKJ_Code\":2612},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101417,\"F_LQKJ_Code\":2613},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101415,\"F_LQKJ_Code\":2614},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101421,\"F_LQKJ_Code\":2615},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101416,\"F_LQKJ_Code\":2616},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.051\",\"FMustQty\":\"0.051\",\"FEntryID\":101419,\"F_LQKJ_Code\":2617},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.051\",\"FMustQty\":\"0.051\",\"FEntryID\":101420,\"F_LQKJ_Code\":2618},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"0.501\",\"FMustQty\":\"0.501\",\"FEntryID\":101422,\"F_LQKJ_Code\":2619}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:25:01.4232534+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000156\",\"msg\":null}]}',NULL,876,'2022-08-31 10:25:09','2022-08-31 10:25:09'),
(775,'生产订单','2573c642-4878-4064-8a89-a74d7fa4e8e1','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236019\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-31T10:27:38.2622168+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":42},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":9,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":43}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:27:38.3947653+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T10:27:38.4104041+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T10:27:38.785397+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T10:27:38.785397+08:00\"}],\"resultData\":[{\"code\":\"WO2236019\",\"msg\":null}]}',NULL,1336,'2022-08-31 10:27:46','2022-08-31 10:27:46'),
(776,'生产订单','3e5061b9-4482-443c-9113-18af3b69a3ec','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236020\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-31T10:28:59.1636766+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":44},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":9,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-02T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":45}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:28:58.8107146+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"违反字段唯一性要求：编码唯一。[WO2236020]在当前系统中已经被使用。\"}]}','保存失败',443,'2022-08-31 10:29:06','2022-08-31 10:29:06'),
(777,'生产用料清单','1219b2e1-4992-4798-9a90-20454b2e4198','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236019\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100183\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101442,\"F_LQKJ_Code\":2620},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101443,\"F_LQKJ_Code\":2621},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101444,\"F_LQKJ_Code\":2622},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.39\",\"FMustQty\":\"0.39\",\"FEntryID\":101445,\"F_LQKJ_Code\":2623},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101446,\"F_LQKJ_Code\":2624},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"8.55\",\"FMustQty\":\"8.55\",\"FEntryID\":101447,\"F_LQKJ_Code\":2625},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"3.87\",\"FMustQty\":\"3.87\",\"FEntryID\":101448,\"F_LQKJ_Code\":2626}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:29:32.7238297+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000159\",\"msg\":null}]}',NULL,474,'2022-08-31 10:29:40','2022-08-31 10:29:40'),
(778,'生产用料清单','d59095c1-1832-4157-b600-d1589210d938','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236019\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100182\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"90\",\"FMustQty\":\"90\",\"FEntryID\":101437,\"F_LQKJ_Code\":2627},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101432,\"F_LQKJ_Code\":2628},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"F_LQKJ_Code\":2629},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101436,\"F_LQKJ_Code\":2630},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101434,\"F_LQKJ_Code\":2631},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101440,\"F_LQKJ_Code\":2632},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"18\",\"FMustQty\":\"18\",\"FEntryID\":101435,\"F_LQKJ_Code\":2633},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.051\",\"FMustQty\":\"0.051\",\"FEntryID\":101438,\"F_LQKJ_Code\":2634},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.051\",\"FMustQty\":\"0.051\",\"FEntryID\":101439,\"F_LQKJ_Code\":2635},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"0.501\",\"FMustQty\":\"0.501\",\"FEntryID\":101441,\"F_LQKJ_Code\":2636}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:29:39.7404292+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000158\",\"msg\":null}]}',NULL,762,'2022-08-31 10:29:47','2022-08-31 10:29:47'),
(779,'直接调拨单','5c19b462-9c42-4f9b-90d8-5debfc95723a','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"FL-WO22360191\",\"FDate\":\"2022-08-31T10:33:57.2825308+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000422\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":288.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000423\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":356.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000441\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":120.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000442\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":12.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000443\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":1351.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000451\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":200.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000452\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":500.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:33:59.0420709+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T10:33:59.057681+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T10:33:59.4326785+08:00\"}],\"resultData\":[{\"code\":\"FL-WO22360191\",\"msg\":null}]}',NULL,2955,'2022-08-31 10:34:07','2022-08-31 10:34:07'),
(780,'生产用料清单','1219b2e1-4942-4798-9a90-20454b2e4198','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236019\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100183\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101442,\"F_LQKJ_Code\":2620},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101443,\"F_LQKJ_Code\":2621},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101444,\"F_LQKJ_Code\":2622},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.39\",\"FMustQty\":\"0.39\",\"FEntryID\":101445,\"F_LQKJ_Code\":2623},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101446,\"F_LQKJ_Code\":2624},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"8.55\",\"FMustQty\":\"8.55\",\"FEntryID\":101447,\"F_LQKJ_Code\":2625},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"3.87\",\"FMustQty\":\"3.87\",\"FEntryID\":101448,\"F_LQKJ_Code\":2626}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:51:33.2367861+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000159\",\"msg\":null}]}',NULL,416,'2022-08-31 10:51:40','2022-08-31 10:51:40'),
(781,'生产用料清单','1219b2e1-4942-5798-9a90-20454b2e4198','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236019\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100183\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101442,\"F_LQKJ_Code\":2620},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101443,\"F_LQKJ_Code\":2621},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101444,\"F_LQKJ_Code\":2622},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.39\",\"FMustQty\":\"0.39\",\"FEntryID\":101445,\"F_LQKJ_Code\":2623},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101446,\"F_LQKJ_Code\":2624},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"8.55\",\"FMustQty\":\"8.55\",\"FEntryID\":101447,\"F_LQKJ_Code\":2625},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"3.88\",\"FMustQty\":\"3.88\",\"FEntryID\":101448,\"F_LQKJ_Code\":2626}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:55:49.6028449+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000159\",\"msg\":null}]}',NULL,543,'2022-08-31 10:55:57','2022-08-31 10:55:57'),
(782,'生产用料清单','1219b3e1-4942-5798-9a90-20454b2e4198','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236019\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100183\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"110\",\"FMustQty\":\"110\",\"FEntryID\":101442,\"F_LQKJ_Code\":2620},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101443,\"F_LQKJ_Code\":2621},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101444,\"F_LQKJ_Code\":2622},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.39\",\"FMustQty\":\"0.39\",\"FEntryID\":101445,\"F_LQKJ_Code\":2623},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101446,\"F_LQKJ_Code\":2624},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"8.55\",\"FMustQty\":\"8.55\",\"FEntryID\":101447,\"F_LQKJ_Code\":2625},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"3.87\",\"FMustQty\":\"3.87\",\"FEntryID\":101448,\"F_LQKJ_Code\":2626}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T10:56:43.7112416+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000159\",\"msg\":null}]}',NULL,474,'2022-08-31 10:56:51','2022-08-31 10:56:51'),
(783,'生产用料清单','1219b3e1-4942-5798-9190-20454b2e4198','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236019\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100183\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101442,\"F_LQKJ_Code\":2620},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101443,\"F_LQKJ_Code\":2621},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101444,\"F_LQKJ_Code\":2622},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"110\",\"FMustQty\":\"110\",\"FEntryID\":101445,\"F_LQKJ_Code\":2623},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101446,\"F_LQKJ_Code\":2624},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"8.55\",\"FMustQty\":\"8.55\",\"FEntryID\":101447,\"F_LQKJ_Code\":2625},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"3.87\",\"FMustQty\":\"3.87\",\"FEntryID\":101448,\"F_LQKJ_Code\":2626}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:00:26.5030734+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000159\",\"msg\":null}]}',NULL,531,'2022-08-31 11:00:34','2022-08-31 11:00:34'),
(784,'生产用料清单','1219b3e1-4952-5798-9190-20454b2e4198','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236019\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100183\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101442,\"F_LQKJ_Code\":2620},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101443,\"F_LQKJ_Code\":2621},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101444,\"F_LQKJ_Code\":2622},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"10\",\"FMustQty\":\"10\",\"FEntryID\":101445,\"F_LQKJ_Code\":2623},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101446,\"F_LQKJ_Code\":2624},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"8.55\",\"FMustQty\":\"8.55\",\"FEntryID\":101447,\"F_LQKJ_Code\":2625},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"3.87\",\"FMustQty\":\"3.87\",\"FEntryID\":101448,\"F_LQKJ_Code\":2626}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:01:40.8038514+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000159\",\"msg\":null}]}',NULL,535,'2022-08-31 11:01:48','2022-08-31 11:01:48'),
(785,'生产用料清单','1219b3e1-4952-5798-9290-20454b2e4198','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":3,\"FMOBillNO1\":\"WO2236019\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100183\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101442,\"F_LQKJ_Code\":2620},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101443,\"F_LQKJ_Code\":2621},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"9\",\"FMustQty\":\"9\",\"FEntryID\":101444,\"F_LQKJ_Code\":2622},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.39\",\"FMustQty\":\"0.39\",\"FEntryID\":101445,\"F_LQKJ_Code\":2623},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"108\",\"FMustQty\":\"108\",\"FEntryID\":101446,\"F_LQKJ_Code\":2624},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"8.55\",\"FMustQty\":\"8.55\",\"FEntryID\":101447,\"F_LQKJ_Code\":2625},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"3.87\",\"FMustQty\":\"3.87\",\"FEntryID\":101448,\"F_LQKJ_Code\":2626}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:02:10.671896+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000159\",\"msg\":null}]}',NULL,478,'2022-08-31 11:02:18','2022-08-31 11:02:18'),
(786,'生产订单','ced32fb8-4993-49da-9932-b61ab15fce07','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236021\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-31T11:18:13.5157487+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":46},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":47}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:18:17.3238135+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T11:18:17.3550731+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T11:18:18.9068126+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T11:18:18.9068126+08:00\"}],\"resultData\":[{\"code\":\"WO2236021\",\"msg\":null}]}',NULL,6180,'2022-08-31 11:18:26','2022-08-31 11:18:26'),
(787,'生产用料清单','e8e0833a-8e42-4f5c-ba92-e94feb2b8f89','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236021\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100185\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101461,\"F_LQKJ_Code\":2654},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101462,\"F_LQKJ_Code\":2655},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101463,\"F_LQKJ_Code\":2656},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"0.13\",\"FMustQty\":\"0.13\",\"FEntryID\":101464,\"F_LQKJ_Code\":2657},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101465,\"F_LQKJ_Code\":2658},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101466,\"F_LQKJ_Code\":2659},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101467,\"F_LQKJ_Code\":2660}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:19:03.6871122+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000161\",\"msg\":null}]}',NULL,607,'2022-08-31 11:19:11','2022-08-31 11:19:11'),
(788,'生产用料清单','0f325761-00ae-4cd0-a4fd-eb0554f7373b','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236021\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100184\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"30\",\"FMustQty\":\"30\",\"FEntryID\":101456,\"F_LQKJ_Code\":2661},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101451,\"F_LQKJ_Code\":2662},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"F_LQKJ_Code\":2663},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"2\",\"FMustQty\":\"2\",\"FEntryID\":101455,\"F_LQKJ_Code\":2664},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101453,\"F_LQKJ_Code\":2665},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101459,\"F_LQKJ_Code\":2666},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101454,\"F_LQKJ_Code\":2667},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101457,\"F_LQKJ_Code\":2668},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101458,\"F_LQKJ_Code\":2669},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"0.167\",\"FMustQty\":\"0.167\",\"FEntryID\":101460,\"F_LQKJ_Code\":2670}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:19:07.0562351+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000160\",\"msg\":null}]}',NULL,804,'2022-08-31 11:19:14','2022-08-31 11:19:14'),
(789,'生产订单','a87d8e2f-e0c4-4566-8d62-4ba6aa30dd7f','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236022\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-31T11:31:48.7122657+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-03T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":48},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":144,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-03T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":49}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:31:49.069622+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T11:31:49.1008634+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T11:31:49.508074+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T11:31:49.508074+08:00\"}],\"resultData\":[{\"code\":\"WO2236022\",\"msg\":null}]}',NULL,1587,'2022-08-31 11:31:57','2022-08-31 11:31:57'),
(790,'生产用料清单','eed615fc-d452-4435-a6f0-3b75c0d45ca2','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":48,\"FMOBillNO1\":\"WO2236022\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100187\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"FEntryID\":101480,\"F_LQKJ_Code\":2671},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101481,\"F_LQKJ_Code\":2672},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101482,\"F_LQKJ_Code\":2673},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"FEntryID\":101483,\"F_LQKJ_Code\":2674},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"FEntryID\":101484,\"F_LQKJ_Code\":2675},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"136.80\",\"FEntryID\":101485,\"F_LQKJ_Code\":2676},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"61.92\",\"FEntryID\":101486,\"F_LQKJ_Code\":2677}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:32:30.0401607+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000163\",\"msg\":null}]}',NULL,542,'2022-08-31 11:32:37','2022-08-31 11:32:37'),
(791,'生产用料清单','a3295140-9536-49d3-9d17-e0d5fbb55db9','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":48,\"FMOBillNO1\":\"WO2236022\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100186\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1440\",\"FEntryID\":101475,\"F_LQKJ_Code\":2678},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101470,\"F_LQKJ_Code\":2679},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"F_LQKJ_Code\":2680},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101474,\"F_LQKJ_Code\":2681},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101472,\"F_LQKJ_Code\":2682},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101478,\"F_LQKJ_Code\":2683},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101473,\"F_LQKJ_Code\":2684},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0.816\",\"FEntryID\":101476,\"F_LQKJ_Code\":2685},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0.816\",\"FEntryID\":101477,\"F_LQKJ_Code\":2686},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"8.016\",\"FEntryID\":101479,\"F_LQKJ_Code\":2687}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:32:33.3614652+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000162\",\"msg\":null}]}',NULL,710,'2022-08-31 11:32:41','2022-08-31 11:32:41'),
(792,'生产入库单','da3c13e8-e3e5-41ae-beba-a8dde0231363','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100204\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T11:41:55.9125729+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2236022\",\"FRealQty\":48.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T11:42:19.4881584+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T11:42:19.6298099+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T11:42:21.5741228+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000081\",\"msg\":null}]}',NULL,3582,'2022-08-31 11:42:29','2022-08-31 11:42:29'),
(793,'生产订单','8d86916b-9956-49a7-ad75-d917efe62acd','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236024\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-31T14:16:30.9691966+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":52},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":144,\"FPlanStartDate\":\"2022-08-31T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-10T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":53}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T14:16:41.1284492+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T14:16:41.1753251+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T14:16:42.6704245+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T14:16:42.6704245+08:00\"}],\"resultData\":[{\"code\":\"WO2236024\",\"msg\":null}]}',NULL,12284,'2022-08-31 14:16:50','2022-08-31 14:16:50'),
(794,'生产用料清单','c06edba1-1154-443c-bd90-2c468c12ed15','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":48,\"FMOBillNO1\":\"WO2236024\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100189\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"5184\",\"FMustQty\":\"5184\",\"FEntryID\":101499,\"F_LQKJ_Code\":2706},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"432\",\"FMustQty\":\"432\",\"FEntryID\":101500,\"F_LQKJ_Code\":2707},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"432\",\"FMustQty\":\"432\",\"FEntryID\":101501,\"F_LQKJ_Code\":2708},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"18.72\",\"FMustQty\":\"18.72\",\"FEntryID\":101502,\"F_LQKJ_Code\":2709},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"5184\",\"FMustQty\":\"5184\",\"FEntryID\":101503,\"F_LQKJ_Code\":2710},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"410.40\",\"FMustQty\":\"410.40\",\"FEntryID\":101504,\"F_LQKJ_Code\":2711},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"185.76\",\"FMustQty\":\"185.76\",\"FEntryID\":101505,\"F_LQKJ_Code\":2712}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T14:17:44.0024495+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000165\",\"msg\":null}]}',NULL,865,'2022-08-31 14:17:51','2022-08-31 14:17:51'),
(795,'生产用料清单','38172985-7779-4e45-96be-f2a8505839d7','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":48,\"FMOBillNO1\":\"WO2236024\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100188\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"1440\",\"FMustQty\":\"1440\",\"FEntryID\":101494,\"F_LQKJ_Code\":2713},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101489,\"F_LQKJ_Code\":2714},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"F_LQKJ_Code\":2715},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101493,\"F_LQKJ_Code\":2716},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101491,\"F_LQKJ_Code\":2717},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101497,\"F_LQKJ_Code\":2718},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101492,\"F_LQKJ_Code\":2719},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0.816\",\"FEntryID\":101495,\"F_LQKJ_Code\":2720},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.816\",\"FMustQty\":\"0.816\",\"FEntryID\":101496,\"F_LQKJ_Code\":2721},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"8.016\",\"FMustQty\":\"8.016\",\"FEntryID\":101498,\"F_LQKJ_Code\":2722},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101488,\"F_LQKJ_Code\":2723}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T14:17:47.7719644+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000164\",\"msg\":null}]}',NULL,994,'2022-08-31 14:17:55','2022-08-31 14:17:55'),
(797,'生产订单','83f52b6e-856d-480b-ac82-d27813768b5a','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236025\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-31T17:16:36.0153609+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-08-31T00:00:00\",\"FPlanFinishDate\":\"2022-09-08T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":54},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-08-31T00:00:00\",\"FPlanFinishDate\":\"2022-09-08T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":55}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T17:16:48.6435637+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-08-31T17:16:48.690424+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T17:16:50.4492321+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-08-31T17:16:50.4492321+08:00\"}],\"resultData\":[{\"code\":\"WO2236025\",\"msg\":null}]}',NULL,14246,'2022-08-31 17:16:58','2022-08-31 17:16:58'),
(798,'生产用料清单','60350cae-e95d-451d-80b9-c57f6c10e54a','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2236025\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100191\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"FEntryID\":101518,\"F_LQKJ_Code\":2724},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101519,\"F_LQKJ_Code\":2725},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101520,\"F_LQKJ_Code\":2726},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"FEntryID\":101521,\"F_LQKJ_Code\":2727},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"FEntryID\":101522,\"F_LQKJ_Code\":2728},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"136.80\",\"FEntryID\":101523,\"F_LQKJ_Code\":2729},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"61.92\",\"FEntryID\":101524,\"F_LQKJ_Code\":2730}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T17:17:12.4901295+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000167\",\"msg\":null}]}',NULL,876,'2022-08-31 17:17:20','2022-08-31 17:17:20'),
(799,'生产用料清单','fc34dbf8-0ac5-4f8e-984e-4b5069abc8c3','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2236025\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100190\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"480\",\"FEntryID\":101513,\"F_LQKJ_Code\":2731},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101508,\"F_LQKJ_Code\":2732},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"F_LQKJ_Code\":2733},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101512,\"F_LQKJ_Code\":2734},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101510,\"F_LQKJ_Code\":2735},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101516,\"F_LQKJ_Code\":2736},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101511,\"F_LQKJ_Code\":2737},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101514,\"F_LQKJ_Code\":2738},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101515,\"F_LQKJ_Code\":2739},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101517,\"F_LQKJ_Code\":2740},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101507,\"F_LQKJ_Code\":2741}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T17:17:16.3865921+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000166\",\"msg\":null}]}',NULL,1116,'2022-08-31 17:17:24','2022-08-31 17:17:24'),
(800,'生产领料单','88008d21-9ee5-4adc-935f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101521\",\"101523\",\"101524\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.3199939+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":30.96,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T17:33:08.1213673+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第8行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第8行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第8行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',1890,'2022-08-31 17:33:15','2022-08-31 17:33:15'),
(801,'生产领料单','88008d21-9ee6-4adc-935f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101521\",\"101523\",\"101524\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.3199939+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":30.96,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T17:35:40.5334195+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第8行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第8行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第8行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第8行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第8行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第8行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第8行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第8行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',448,'2022-08-31 17:35:48','2022-08-31 17:35:48'),
(802,'生产领料单','88008d21-9ee6-4adc-535f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101521\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-08-31T17:39:12.7142973+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据体“明细”第7行字段“物料编码”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“生产订单编号”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“基本单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“主库存单位”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“保管者”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“货主”是必填项\"},{\"code\":null,\"msg\":\"单据体“明细”第7行字段“产品货主”是必填项\"},{\"code\":null,\"msg\":\"第7行分录，货主和保管者至少有一个和发料组织一致！\"},{\"code\":null,\"msg\":\"第7行分录，实发数量不为0，需要录入货主\"},{\"code\":null,\"msg\":\"第7行分录，货主类型、货主必录,请检查!\"},{\"code\":null,\"msg\":\"明细表体第7行对应的生产用料清单分录不存在,无法进行保存操作,请检查数据！\"},{\"code\":null,\"msg\":\"生产领料单第7行的实发数量不为零，基本单位实发数量为零,保存不成功\"},{\"code\":null,\"msg\":\"生产领料单第7行的产品编码为空或与其生产订单分录的物料编码不一致\"}]}','保存失败',432,'2022-08-31 17:39:20','2022-08-31 17:39:20'),
(804,'生产订单','2a9c46fc-a375-4602-9a8d-fbcbd81e846e','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236027\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-01T08:57:46.9697859+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-09-01T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-08T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":56},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-09-01T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-08T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":57}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T08:57:54.4241569+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-01T08:57:54.4866804+08:00\"}],\"resultData\":[]}',NULL,7679,'2022-09-01 08:58:02','2022-09-01 08:58:02'),
(805,'生产用料清单','6c4681e8-f22c-492d-ae45-6529f6e1fb8b','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2236027\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100194\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"FEntryID\":101538,\"F_LQKJ_Code\":2760},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101539,\"F_LQKJ_Code\":2761},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"144\",\"FMustQty\":\"144\",\"FEntryID\":101540,\"F_LQKJ_Code\":2762},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.13\",\"FNeedQty2\":\"6.24\",\"FMustQty\":\"6.24\",\"FEntryID\":101541,\"F_LQKJ_Code\":2763},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"36\",\"FNeedQty2\":\"1728\",\"FMustQty\":\"1728\",\"FEntryID\":101542,\"F_LQKJ_Code\":2764},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"2.85\",\"FNeedQty2\":\"136.80\",\"FMustQty\":\"136.80\",\"FEntryID\":101543,\"F_LQKJ_Code\":2765},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"1.29\",\"FNeedQty2\":\"61.92\",\"FMustQty\":\"61.92\",\"FEntryID\":101544,\"F_LQKJ_Code\":2766}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T08:58:17.6731571+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000169\",\"msg\":null}]}',NULL,1072,'2022-09-01 08:58:26','2022-09-01 08:58:26'),
(806,'生产用料清单','38537923-524e-4442-adc9-1023b0421485','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2236027\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100193\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"480\",\"FEntryID\":101533,\"F_LQKJ_Code\":2767},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101528,\"F_LQKJ_Code\":2768},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"F_LQKJ_Code\":2769},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101532,\"F_LQKJ_Code\":2770},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101530,\"F_LQKJ_Code\":2771},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101536,\"F_LQKJ_Code\":2772},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101531,\"F_LQKJ_Code\":2773},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101534,\"F_LQKJ_Code\":2774},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101535,\"F_LQKJ_Code\":2775},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101537,\"F_LQKJ_Code\":2776},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101527,\"F_LQKJ_Code\":2777}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T08:58:21.4280564+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000168\",\"msg\":null}]}',NULL,991,'2022-09-01 08:58:29','2022-09-01 08:58:29'),
(807,'生产订单','aefbd07f-3d1d-4683-ba4c-ab13b3811e8a','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236028\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-01T09:17:21.5912184+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-09-01T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-28T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":58},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-09-01T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-28T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":59}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:17:23.0864222+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-01T09:17:23.102047+08:00\"}],\"resultData\":[]}',NULL,1276,'2022-09-01 09:17:31','2022-09-01 09:17:31'),
(808,'生产用料清单','3c66fadf-3784-4816-b167-68296af07d4a','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2236028\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100196\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"FEntryID\":101557,\"F_LQKJ_Code\":2778},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101558,\"F_LQKJ_Code\":2779},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101559,\"F_LQKJ_Code\":2780},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.0433\",\"FNeedQty2\":\"2.0784\",\"FMustQty\":\"2.0784\",\"FEntryID\":101560,\"F_LQKJ_Code\":2781},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"FEntryID\":101561,\"F_LQKJ_Code\":2782},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"0.95\",\"FNeedQty2\":\"45.60\",\"FMustQty\":\"45.60\",\"FEntryID\":101562,\"F_LQKJ_Code\":2783},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"20.64\",\"FMustQty\":\"20.64\",\"FEntryID\":101563,\"F_LQKJ_Code\":2784}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:18:00.6813538+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000171\",\"msg\":null}]}',NULL,571,'2022-09-01 09:18:08','2022-09-01 09:18:08'),
(809,'生产用料清单','1663af50-3ed2-48e8-bc74-89821dab84d0','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2236028\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100195\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"480\",\"FEntryID\":101552,\"F_LQKJ_Code\":2785},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101547,\"F_LQKJ_Code\":2786},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"F_LQKJ_Code\":2787},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101551,\"F_LQKJ_Code\":2788},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101549,\"F_LQKJ_Code\":2789},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101555,\"F_LQKJ_Code\":2790},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101550,\"F_LQKJ_Code\":2791},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101553,\"F_LQKJ_Code\":2792},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101554,\"F_LQKJ_Code\":2793},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101556,\"F_LQKJ_Code\":2794},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101546,\"F_LQKJ_Code\":2795}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:18:04.3074538+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000170\",\"msg\":null}]}',NULL,796,'2022-09-01 09:18:12','2022-09-01 09:18:12'),
(810,'直接调拨单','92144e72-28da-42d6-97aa-66408f33dcbc','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"FL-WO22360281\",\"FDate\":\"2022-09-01T09:23:56.5054241+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000422\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":345.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000422\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":294.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000423\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":359.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000441\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":120.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000442\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":25.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000443\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":1311.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000451\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":200.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}},{\"FMaterialId\":{\"Fnumber\":\"0000000452\"},\"FSrcStockId\":{\"Fnumber\":\"CK013\"},\"FQty\":500.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:24:01.923826+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-01T09:24:01.9550738+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-01T09:24:05.2324553+08:00\"}],\"resultData\":[{\"code\":\"FL-WO22360281\",\"msg\":null}]}',NULL,8650,'2022-09-01 09:24:13','2022-09-01 09:24:13'),
(811,'生产领料单','88008d21-9ee6-45dc-535f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101521\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"同步失败，源单分录主键101521, 未下推成功!\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-01T09:36:44.4347311+08:00\"}],\"resultData\":[]}','同步失败，源单分录主键101521, 未下推成功!',2052,'2022-09-01 09:36:54','2022-09-01 09:36:54'),
(812,'生产领料单','88008d21-9ee6-45dc-536f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101521\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"同步失败，源单分录主键101521, 未下推成功!\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-01T09:44:53.9140219+08:00\"}],\"resultData\":[]}','同步失败，源单分录主键101521, 未下推成功!',271,'2022-09-01 09:45:02','2022-09-01 09:45:02'),
(813,'生产领料单','88008d21-9e16-45dc-536f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101522\",\"101519\",\"101521\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:45:26.7196473+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第3行物料编码【0000000441】,第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',651,'2022-09-01 09:45:34','2022-09-01 09:45:34'),
(814,'生产领料单','88009d21-9ee6-45dc-536f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":3.12,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:46:38.3562923+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',430,'2022-09-01 09:46:46','2022-09-01 09:46:46'),
(815,'生产领料单','88009d21-9ee6-46dc-536f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":6,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:48:54.7410395+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',390,'2022-09-01 09:49:02','2022-09-01 09:49:02'),
(816,'生产领料单','88009d21-9e16-46dc-536f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":6,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:49:51.9372935+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',406,'2022-09-01 09:50:00','2022-09-01 09:50:00'),
(817,'生产领料单','88009d21-9e16-46dc-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":6.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:51:36.740878+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',395,'2022-09-01 09:51:44','2022-09-01 09:51:44'),
(818,'生产领料单','88009d21-9e16-461c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":5,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:51:52.0650733+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',373,'2022-09-01 09:52:00','2022-09-01 09:52:00'),
(819,'生产领料单','88019d21-9e16-461c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":1,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:52:17.3463351+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',386,'2022-09-01 09:52:25','2022-09-01 09:52:25'),
(820,'生产领料单','88019d21-9e16-462c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":2,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T09:59:43.4203766+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',390,'2022-09-01 09:59:51','2022-09-01 09:59:51'),
(821,'生产领料单','84019d21-9e16-462c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":1,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:00:04.3344626+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',418,'2022-09-01 10:00:12','2022-09-01 10:00:12'),
(822,'生产领料单','84019d21-9116-462c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101557\",\"101558\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:03.922792+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了2行数据进行下推；\\r\\n2. 有2行数据不满足下推数据筛选条件：单据状态 等于 已审核\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-01T10:05:13.9016468+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了2行数据进行下推；\r\n2. 有2行数据不满足下推数据筛选条件：单据状态 等于 已审核\r\n',320,'2022-09-01 10:05:22','2022-09-01 10:05:22'),
(823,'生产领料单','84019121-9116-462c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101557\",\"101558\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:03.922792+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:06:42.7394342+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"生产领料单第1行对应的生产订单第2行的下达日期大于生产领料单的单据日期，生产领料单保存不成功！\"},{\"code\":null,\"msg\":\"生产领料单第2行对应的生产订单第2行的下达日期大于生产领料单的单据日期，生产领料单保存不成功！\"}]}','保存失败',380,'2022-09-01 10:06:50','2022-09-01 10:06:50'),
(824,'生产领料单','84019121-9116-462c-026f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101557\",\"101558\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-1T17:33:03.922792+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":20.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:07:07.2267649+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-01T10:07:07.2580091+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-01T10:07:08.0861047+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000105\",\"msg\":null}]}',NULL,1612,'2022-09-01 10:07:16','2022-09-01 10:07:16'),
(825,'生产订单','a3f50acb-2fca-4cc2d-ac86-1220311bfac23','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"save\",\"Model\":{\"FBillNo\":\"WO2236099\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-08-30T17:48:35.8779013+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-07T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":51},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-08-30T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-07T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":50}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:09:43.975764+08:00\"}],\"resultData\":[]}',NULL,1097,'2022-09-01 10:09:52','2022-09-01 10:09:52'),
(826,'生产领料单','cbd77a6f-3371-487e-9652-528167a082d5','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101557\",\"101559\",\"101560\",\"101561\",\"101558\",\"101560\",\"101562\",\"101563\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-01T10:14:40.8668087+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":22.8,\"FEntrySrcBillNo\":\"PPBOM00000171\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10.32,\"FEntrySrcBillNo\":\"PPBOM00000171\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"同步失败，源单分录主键101560, 未下推成功!\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-01T10:14:43.024417+08:00\"}],\"resultData\":[]}','同步失败，源单分录主键101560, 未下推成功!',309,'2022-09-01 10:14:51','2022-09-01 10:14:51'),
(827,'生产订单','b7d673d1-ae1d-4bd7-9abb-f27f32380358','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"save\",\"Model\":{\"FBillNo\":\"WO2236029\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-01T10:24:16.3875905+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":8,\"FPlanStartDate\":\"2022-09-01T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-22T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":60},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":24,\"FPlanStartDate\":\"2022-09-01T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-22T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":61}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:24:17.4196814+08:00\"}],\"resultData\":[]}',NULL,1033,'2022-09-01 10:24:25','2022-09-01 10:24:25'),
(828,'生产订单','2567d042-57dc-46f8-83df-f959190192d4','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"save\",\"Model\":{\"FBillNo\":\"WO2236030\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-01T10:26:58.865285+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":8,\"FPlanStartDate\":\"2022-09-01T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-21T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":62},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":24,\"FPlanStartDate\":\"2022-09-01T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-21T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":63}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:26:59.9918612+08:00\"}],\"resultData\":[]}',NULL,1127,'2022-09-01 10:27:08','2022-09-01 10:27:08'),
(829,'生产用料清单','cd0f080f-4ae2-4fad-912d-a03bba6eabb1','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":8,\"FMOBillNO1\":\"WO2236030\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100202\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101612,\"F_LQKJ_Code\":2814},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101613,\"F_LQKJ_Code\":2815},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101614,\"F_LQKJ_Code\":2816},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.0433\",\"FNeedQty2\":\"1.0392\",\"FMustQty\":\"1.0392\",\"FEntryID\":101615,\"F_LQKJ_Code\":2817},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101616,\"F_LQKJ_Code\":2818},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"0.95\",\"FNeedQty2\":\"22.80\",\"FMustQty\":\"22.80\",\"FEntryID\":101617,\"F_LQKJ_Code\":2819},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"10.32\",\"FMustQty\":\"10.32\",\"FEntryID\":101618,\"F_LQKJ_Code\":2820}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:27:23.4429699+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000177\",\"msg\":null}]}',NULL,496,'2022-09-01 10:27:31','2022-09-01 10:27:31'),
(830,'生产用料清单','a61b2877-b623-43dd-969b-7754ab3f2b65','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FQty\":8,\"FMOBillNO1\":\"WO2236030\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100201\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"240\",\"FMustQty\":\"240\",\"FEntryID\":101607,\"F_LQKJ_Code\":2821},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101602,\"F_LQKJ_Code\":2822},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"F_LQKJ_Code\":2823},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101606,\"F_LQKJ_Code\":2824},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"FEntryID\":101604,\"F_LQKJ_Code\":2825},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"FEntryID\":101610,\"F_LQKJ_Code\":2826},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101605,\"F_LQKJ_Code\":2827},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.136\",\"FMustQty\":\"0.136\",\"FEntryID\":101608,\"F_LQKJ_Code\":2828},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.136\",\"FMustQty\":\"0.136\",\"FEntryID\":101609,\"F_LQKJ_Code\":2829},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"1.336\",\"FMustQty\":\"1.336\",\"FEntryID\":101611,\"F_LQKJ_Code\":2830},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101601,\"F_LQKJ_Code\":2831}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:27:27.0221216+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000176\",\"msg\":null}]}',NULL,772,'2022-09-01 10:27:35','2022-09-01 10:27:35'),
(831,'生产领料单','82d7784d-8535-41c8-a55a-568bc68f1b0b','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101612\",\"101614\",\"101615\",\"101616\",\"101613\",\"101615\",\"101617\",\"101618\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-01T10:29:16.8676488+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.5196,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.5196,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":11.4,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5.16,\"FEntrySrcBillNo\":\"PPBOM00000177\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了7行数据进行下推；\\r\\n2. 有7行数据不满足下推数据筛选条件：单据状态 等于 已审核\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-01T10:29:18.9273599+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了7行数据进行下推；\r\n2. 有7行数据不满足下推数据筛选条件：单据状态 等于 已审核\r\n',541,'2022-09-01 10:29:27','2022-09-01 10:29:27'),
(832,'生产领料单','143ff358-c421-432b-ac46-c1973ddbf280','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101612\",\"101614\",\"101615\",\"101616\",\"101613\",\"101615\",\"101617\",\"101618\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-01T10:35:19.6282916+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.5196,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.5196,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":11.4,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5.16,\"FEntrySrcBillNo\":\"PPBOM00000177\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"同步失败，源单分录主键101615, 未下推成功!\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-01T10:35:21.5336207+08:00\"}],\"resultData\":[]}','同步失败，源单分录主键101615, 未下推成功!',298,'2022-09-01 10:35:29','2022-09-01 10:35:29'),
(833,'生产领料单','82d7784d-8535-41c8-a55a-56811bc68f1b0b','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101612\",\"101614\",\"101615\",\"101616\",\"101613\",\"101615\",\"101617\",\"101618\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-01T10:29:16.8676488+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.5196,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.5196,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":11.4,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5.16,\"FEntrySrcBillNo\":\"PPBOM00000177\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"同步失败，源单分录主键101615, 未下推成功!\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-01T10:36:14.6773163+08:00\"}],\"resultData\":[]}','同步失败，源单分录主键101615, 未下推成功!',275,'2022-09-01 10:36:22','2022-09-01 10:36:22'),
(834,'生产领料单','82d5784d-8535-41c8-a55a-56811bc68f1b0b','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101612\",\"101614\",\"101615\",\"101616\",\"101613\",\"101617\",\"101618\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-01T10:29:16.8676488+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.5196,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":11.4,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5.16,\"FEntrySrcBillNo\":\"PPBOM00000177\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:43:21.2111398+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',477,'2022-09-01 10:43:29','2022-09-01 10:43:29'),
(835,'生产领料单','82d6784d-8535-41c8-a55a-56811bc68f1b0b','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101612\",\"101614\",\"101616\",\"101613\",\"101617\",\"101618\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-01T10:29:16.8676488+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":11.4,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5.16,\"FEntrySrcBillNo\":\"PPBOM00000177\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:44:03.5626551+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第3行物料编码【0000000441】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',431,'2022-09-01 10:44:11','2022-09-01 10:44:11'),
(836,'生产领料单','82d1784d-8535-41c8-a55a-56811bc68f1b0b','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101612\",\"101616\",\"101613\",\"101617\",\"101618\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-01T10:29:16.8676488+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":12.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":11.4,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5.16,\"FEntrySrcBillNo\":\"PPBOM00000177\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:44:17.7315785+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第2行物料编码【0000000423】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',518,'2022-09-01 10:44:25','2022-09-01 10:44:25'),
(837,'生产领料单','82d1714d-8535-41c8-a55a-56811bc68f1b0b','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101612\",\"101616\",\"101617\",\"101618\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-01T10:29:16.8676488+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":144.0,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":11.4,\"FEntrySrcBillNo\":\"PPBOM00000177\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":5.16,\"FEntrySrcBillNo\":\"PPBOM00000177\"}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:44:35.4171226+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-01T10:44:35.4415316+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-01T10:44:36.2736086+08:00\"}],\"resultData\":[{\"code\":\"SOUT00000106\",\"msg\":null}]}',NULL,1679,'2022-09-01 10:44:44','2022-09-01 10:44:44'),
(838,'生产领料单','8019d21-9e76-462c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":1,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T10:58:31.0417418+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',5629,'2022-09-01 10:58:39','2022-09-01 10:58:39'),
(848,'生产领料单','8019d21-9e76-472c-526f-8f551e5e4eaa','',0,'金蝶服务器地址异常',NULL,1127,'2022-09-01 11:12:17','2022-09-01 11:12:17'),
(850,'生产领料单','8019d21-9e76-473c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK013\"},\"FActualQty\":0.5,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T11:15:48.036393+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',726,'2022-09-01 11:15:56','2022-09-01 11:15:56'),
(851,'生产领料单','8029d21-9e76-473c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101521\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.5,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T11:16:16.1604034+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第4行物料编码【0000000442】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',377,'2022-09-01 11:16:24','2022-09-01 11:16:24'),
(852,'生产领料单','8039d21-9e76-473c-526f-8f551e5e4eaa','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101518\",\"101520\",\"101522\",\"101519\",\"101523\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-08-31T17:33:04.24934+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":864.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":72.0,\"FEntrySrcBillNo\":\"PPBOM00000167\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":68.4,\"FEntrySrcBillNo\":\"PPBOM00000167\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-01T11:16:28.6291245+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第3行物料编码【0000000441】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',418,'2022-09-01 11:16:36','2022-09-01 11:16:36'),
(854,'生产订单','e84f0a2f-94d1-4666-becf-0c59e6974638','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236031\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-02T15:30:13.9518157+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-09-02T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-20T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":64},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-09-02T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-20T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":65}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T15:30:21.1989435+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-02T15:30:21.2302043+08:00\"}],\"resultData\":[]}',NULL,6631,'2022-09-02 15:30:30','2022-09-02 15:30:30'),
(855,'生产用料清单','9a3f147a-140a-42a9-b231-faa275b2dee5','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2236031\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100204\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"FEntryID\":101631,\"F_LQKJ_Code\":2832},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101632,\"F_LQKJ_Code\":2833},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101633,\"F_LQKJ_Code\":2834},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.0433\",\"FNeedQty2\":\"2.0784\",\"FMustQty\":\"2.0784\",\"FEntryID\":101634,\"F_LQKJ_Code\":2835},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"FEntryID\":101635,\"F_LQKJ_Code\":2836},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"0.95\",\"FNeedQty2\":\"45.60\",\"FMustQty\":\"45.60\",\"FEntryID\":101636,\"F_LQKJ_Code\":2837},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"20.64\",\"FMustQty\":\"20.64\",\"FEntryID\":101637,\"F_LQKJ_Code\":2838}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T15:30:47.7663176+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000179\",\"msg\":null}]}',NULL,900,'2022-09-02 15:30:56','2022-09-02 15:30:56'),
(856,'生产用料清单','09e5c905-9ac4-4d2c-99c7-e80a0a48ba2e','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2236031\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100203\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"480\",\"FEntryID\":101626,\"F_LQKJ_Code\":2839},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101621,\"F_LQKJ_Code\":2840},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"F_LQKJ_Code\":2841},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101625,\"F_LQKJ_Code\":2842},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101623,\"F_LQKJ_Code\":2843},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101629,\"F_LQKJ_Code\":2844},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101624,\"F_LQKJ_Code\":2845},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101627,\"F_LQKJ_Code\":2846},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101628,\"F_LQKJ_Code\":2847},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101630,\"F_LQKJ_Code\":2848},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101620,\"F_LQKJ_Code\":2849}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T15:30:51.3717329+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000178\",\"msg\":null}]}',NULL,800,'2022-09-02 15:31:00','2022-09-02 15:31:00'),
(857,'生产领料单','e686e753-fcf1-4a76-af3f-c5834790e684','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101631\",\"101633\",\"101634\",\"101635\",\"101632\",\"101634\",\"101636\",\"101637\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-02T15:36:54.6857522+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":22.8,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10.32,\"FEntrySrcBillNo\":\"PPBOM00000179\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了7行数据进行下推；\\r\\n2. 有7行数据不满足下推数据筛选条件：单据状态 等于 已审核\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-02T15:36:57.1635525+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了7行数据进行下推；\r\n2. 有7行数据不满足下推数据筛选条件：单据状态 等于 已审核\r\n',2263,'2022-09-02 15:37:08','2022-09-02 15:37:08'),
(858,'生产入库单','2af4e4a5-e7a2-456d-a11c-6e4fed8df539','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100221\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-02T15:43:57.8691105+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2236031\",\"FRealQty\":24.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T15:44:00.9974104+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-02T15:44:01.1380644+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-02T15:44:03.8723883+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000082\",\"msg\":null}]}',NULL,5357,'2022-09-02 15:44:12','2022-09-02 15:44:12'),
(859,'直接调拨单','09b18f4e-cba8-40e4-99a3-f3f46fdaa3a8','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"FL-M2236044\",\"FDate\":\"2022-09-02T17:01:55.225048+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000537\"},\"FSrcStockId\":{\"Fnumber\":\"CK017\"},\"FQty\":24.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T17:01:59.0262045+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-02T17:01:59.0418339+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-02T17:02:00.3464641+08:00\"}],\"resultData\":[{\"code\":\"FL-M2236044\",\"msg\":null}]}',NULL,4503,'2022-09-02 17:02:09','2022-09-02 17:02:09'),
(860,'生产领料单','087e26d2-e165-4ab3-9213-aa46d2fa64bb','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101621\",\"101638\",\"101620\",\"101625\",\"101623\",\"101624\",\"101626\",\"101627\",\"101628\",\"101629\",\"101630\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-02T17:02:10.9117141+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":16.0,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":240.0,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.136,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.136,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000178\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.336,\"FEntrySrcBillNo\":\"PPBOM00000178\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T17:02:15.1424112+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第3行物料编码【0000000438】,第7行物料编码【0000000444】,第10行物料编码【0000000028】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',1093,'2022-09-02 17:02:24','2022-09-02 17:02:24'),
(861,'生产订单','0d9fbcee-04f9-43ab-80cc-2b5960008b27','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236032\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-02T17:28:10.0457982+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-09-02T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-23T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":66},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-09-02T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-23T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":67}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T17:28:11.779346+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-02T17:28:11.8105973+08:00\"}],\"resultData\":[]}',NULL,1300,'2022-09-02 17:28:20','2022-09-02 17:28:20'),
(862,'生产用料清单','891c0e9a-d9be-476b-a693-80b3a3d063d4','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236032\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100206\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101650,\"F_LQKJ_Code\":2850},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101651,\"F_LQKJ_Code\":2851},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101652,\"F_LQKJ_Code\":2852},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.0433\",\"FNeedQty2\":\"0.1299\",\"FMustQty\":\"0.1299\",\"FEntryID\":101653,\"F_LQKJ_Code\":2853},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101654,\"F_LQKJ_Code\":2854},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"0.95\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101655,\"F_LQKJ_Code\":2855},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101656,\"F_LQKJ_Code\":2856}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T17:29:01.8388826+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000181\",\"msg\":null}]}',NULL,633,'2022-09-02 17:29:10','2022-09-02 17:29:10'),
(863,'生产用料清单','796d4612-1106-4cf1-ad2a-ae710cbf3089','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236032\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100205\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"30\",\"FMustQty\":\"30\",\"FEntryID\":101645,\"F_LQKJ_Code\":2857},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101640,\"F_LQKJ_Code\":2858},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"F_LQKJ_Code\":2859},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"2\",\"FMustQty\":\"2\",\"FEntryID\":101644,\"F_LQKJ_Code\":2860},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101642,\"F_LQKJ_Code\":2861},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101648,\"F_LQKJ_Code\":2862},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101643,\"F_LQKJ_Code\":2863},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101646,\"F_LQKJ_Code\":2864},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101647,\"F_LQKJ_Code\":2865},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"0.167\",\"FMustQty\":\"0.167\",\"FEntryID\":101649,\"F_LQKJ_Code\":2866},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"0\",\"FEntryID\":101639,\"F_LQKJ_Code\":2867}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T17:30:36.7539323+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000180\",\"msg\":null}]}',NULL,881,'2022-09-02 17:30:45','2022-09-02 17:30:45'),
(864,'生产订单','9451a93f-dd92-4f50-a6e5-bc088ddec766','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236033\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-02T19:15:42.4772496+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-09-02T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-20T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":68},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-09-02T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-20T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":69}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T19:15:51.0952839+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-02T19:15:51.1421615+08:00\"}],\"resultData\":[]}',NULL,8028,'2022-09-02 19:16:00','2022-09-02 19:16:00'),
(865,'生产用料清单','d27b562d-9c42-46ad-a539-2437e6fdce50','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236033\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100208\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101669,\"F_LQKJ_Code\":2868},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101670,\"F_LQKJ_Code\":2869},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101671,\"F_LQKJ_Code\":2870},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.0433\",\"FNeedQty2\":\"0.1299\",\"FMustQty\":\"0.1299\",\"FEntryID\":101672,\"F_LQKJ_Code\":2871},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101673,\"F_LQKJ_Code\":2872},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"0.95\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101674,\"F_LQKJ_Code\":2873},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101675,\"F_LQKJ_Code\":2874}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T19:21:03.5190042+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000183\",\"msg\":null}]}',NULL,838,'2022-09-02 19:21:12','2022-09-02 19:21:12'),
(866,'生产用料清单','5bd75c1b-f098-4090-8295-759b502ddb94','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236033\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100207\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"30\",\"FMustQty\":\"30\",\"FEntryID\":101664,\"F_LQKJ_Code\":2875},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101659,\"F_LQKJ_Code\":2876},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"F_LQKJ_Code\":2877},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"2\",\"FMustQty\":\"2\",\"FEntryID\":101663,\"F_LQKJ_Code\":2878},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101661,\"F_LQKJ_Code\":2879},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"1\",\"FMustQty\":\"1\",\"FEntryID\":101667,\"F_LQKJ_Code\":2880},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"6\",\"FMustQty\":\"6\",\"FEntryID\":101662,\"F_LQKJ_Code\":2881},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101665,\"F_LQKJ_Code\":2882},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.017\",\"FMustQty\":\"0.017\",\"FEntryID\":101666,\"F_LQKJ_Code\":2883},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"0.167\",\"FMustQty\":\"0.167\",\"FEntryID\":101668,\"F_LQKJ_Code\":2884},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"0\",\"FEntryID\":101658,\"F_LQKJ_Code\":2885}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T19:21:08.679155+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000182\",\"msg\":null}]}',NULL,918,'2022-09-02 19:21:17','2022-09-02 19:21:17'),
(867,'生产订单','04e68f02-4650-484c-8419-65b13b5bc2e6','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2236034\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-02T19:21:54.246669+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":1,\"FPlanStartDate\":\"2022-09-02T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-18T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":70},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":3,\"FPlanStartDate\":\"2022-09-02T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-18T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":71}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T19:21:56.0180168+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-02T19:21:56.0492894+08:00\"}],\"resultData\":[]}',NULL,1368,'2022-09-02 19:22:05','2022-09-02 19:22:05'),
(868,'生产用料清单','3bd2c240-5b3d-413b-b97f-b4bb0c21a19b','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236034\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100210\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101688,\"F_LQKJ_Code\":2886},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"0.43\",\"FMustQty\":\"0.43\",\"FEntryID\":101689,\"F_LQKJ_Code\":2887},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"0.5\",\"FNeedQty2\":\"0.5\",\"FMustQty\":\"0.5\",\"FEntryID\":101690,\"F_LQKJ_Code\":2888},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.0433\",\"FNeedQty2\":\"0.1299\",\"FMustQty\":\"0.1299\",\"FEntryID\":101691,\"F_LQKJ_Code\":2889},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"36\",\"FMustQty\":\"36\",\"FEntryID\":101692,\"F_LQKJ_Code\":2890},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"0.95\",\"FNeedQty2\":\"2.85\",\"FMustQty\":\"2.85\",\"FEntryID\":101693,\"F_LQKJ_Code\":2891},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"1.29\",\"FMustQty\":\"1.29\",\"FEntryID\":101694,\"F_LQKJ_Code\":2892}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-02T19:25:21.8586899+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000185\",\"msg\":null}]}',NULL,559,'2022-09-02 19:25:31','2022-09-02 19:25:31'),
(873,'供应商','726596517264158720','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel, FContactIsDefault\",\"FilterString\":\"FSupplierId=\'114731\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',201,'2022-09-05 10:41:59','2022-09-05 10:41:59'),
(874,'物料清单执行SQL','726596518136573952','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',223,'2022-09-05 10:41:59','2022-09-05 10:41:59'),
(875,'物料','726596519139012608','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount, FBaseUnitId.FNumber, F_ora_Assistant.FNumber, FUseOrgId.FNumber\",\"FilterString\":\"FMATERIALID=\'119439\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',202,'2022-09-05 10:42:00','2022-09-05 10:42:00'),
(876,'仓库','726596520003039232','{\"FormId\":\"BD_STOCK\",\"FieldKeys\":\"FNumber, FName, FStockStatusType\",\"FilterString\":\"FStockId=\'106664\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',211,'2022-09-05 10:42:00','2022-09-05 10:42:00'),
(877,'盘点盘盈单','726596520900620288','{\"FormId\":\"STK_StockCountGain\",\"FieldKeys\":\"FDate, FStockId.FNumber, FMaterialId.FNumber, FCountQty, FStockOrgId, FNoteHead\",\"FilterString\":\"FID=\'100003\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',199,'2022-09-05 10:42:00','2022-09-05 10:42:00'),
(878,'盘点盘亏单','726596521752064000','{\"FormId\":\"STK_StockCountLoss\",\"FieldKeys\":\"FDate, FStockId.FNumber, FMaterialId.FNumber, FCountQty\",\"FilterString\":\"FID=\'100003\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',192,'2022-09-05 10:42:00','2022-09-05 10:42:00'),
(879,'采购订单','726596522569953280','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',211,'2022-09-05 10:42:00','2022-09-05 10:42:00'),
(880,'物料','726596523467534336','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount, FBaseUnitId.FNumber, F_ora_Assistant.FNumber, FUseOrgId.FNumber\",\"FilterString\":\"FMATERIALID=\'119440\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',200,'2022-09-05 10:42:01','2022-09-05 10:42:01'),
(881,'物料清单执行SQL','726596524327366656','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=160787) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',212,'2022-09-05 10:42:01','2022-09-05 10:42:01'),
(882,'物料清单执行SQL','726596525237530624','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=160787) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',192,'2022-09-05 10:42:01','2022-09-05 10:42:01'),
(883,'物料清单执行SQL','726596526059614208','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',203,'2022-09-05 10:42:01','2022-09-05 10:42:01'),
(884,'物料清单执行SQL','726596526932029440','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',223,'2022-09-05 10:42:01','2022-09-05 10:42:01'),
(885,'物料清单执行SQL','726596527884136448','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=160787) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',201,'2022-09-05 10:42:02','2022-09-05 10:42:02'),
(886,'供应商','726596528748163072','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel, FContactIsDefault\",\"FilterString\":\"FSupplierId=\'114731\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',204,'2022-09-05 10:42:02','2022-09-05 10:42:02'),
(887,'供应商','726596529620578304','{\"FormId\":\"BD_Supplier\",\"FieldKeys\":\"FNumber, FName, FCountry, FForbidStatus, FContact, FTel, FContactIsDefault\",\"FilterString\":\"FSupplierId=\'160402\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',213,'2022-09-05 10:42:02','2022-09-05 10:42:02'),
(888,'物料','726596530526547968','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount, FBaseUnitId.FNumber, F_ora_Assistant.FNumber, FUseOrgId.FNumber\",\"FilterString\":\"FMATERIALID=\'119441\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',203,'2022-09-05 10:42:02','2022-09-05 10:42:02'),
(889,'物料清单执行SQL','726596531386380288','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',204,'2022-09-05 10:42:03','2022-09-05 10:42:03'),
(890,'物料清单执行SQL','726596532275572736','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',210,'2022-09-05 10:42:03','2022-09-05 10:42:03'),
(891,'物料清单执行SQL','726596533173153792','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',204,'2022-09-05 10:42:03','2022-09-05 10:42:03'),
(892,'盘点盘盈单','726596534045569024','{\"FormId\":\"STK_StockCountGain\",\"FieldKeys\":\"FDate, FStockId.FNumber, FMaterialId.FNumber, FCountQty, FStockOrgId, FNoteHead\",\"FilterString\":\"FID=\'100005\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',202,'2022-09-05 10:42:03','2022-09-05 10:42:03'),
(893,'物料','726596534905401344','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount, FBaseUnitId.FNumber, F_ora_Assistant.FNumber, FUseOrgId.FNumber\",\"FilterString\":\"FMATERIALID=\'119439\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',199,'2022-09-05 10:42:03','2022-09-05 10:42:03'),
(894,'物料','726596535752650752','{\"FormId\":\"BD_MATERIAL\",\"FieldKeys\":\"FNumber, FOldNumber, FName, FSpecification, FForbidStatus, FMinPackCount, FBaseUnitId.FNumber, F_ora_Assistant.FNumber, FUseOrgId.FNumber\",\"FilterString\":\"FMATERIALID=\'119439\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',208,'2022-09-05 10:42:04','2022-09-05 10:42:04'),
(895,'采购订单','726596536641843200','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',202,'2022-09-05 10:42:04','2022-09-05 10:42:04'),
(896,'采购订单','726596537501675520','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',202,'2022-09-05 10:42:04','2022-09-05 10:42:04'),
(897,'采购订单','726596538361507840','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',193,'2022-09-05 10:42:04','2022-09-05 10:42:04'),
(898,'采购订单','726596539179397120','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',202,'2022-09-05 10:42:04','2022-09-05 10:42:04'),
(899,'采购订单','726596540047618048','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',218,'2022-09-05 10:42:05','2022-09-05 10:42:05'),
(900,'采购订单','726596540987142144','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',218,'2022-09-05 10:42:05','2022-09-05 10:42:05'),
(901,'采购订单','726596541909889024','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',204,'2022-09-05 10:42:05','2022-09-05 10:42:05'),
(902,'采购订单','726596542778109952','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100727\'\"}',0,'[[{\"Result\":{\"ResponseStatus\":{\"ErrorCode\":500,\"IsSuccess\":false,\"Errors\":[{\"FieldName\":null,\"Message\":\"会话信息已丢失，请重新登录\",\"DIndex\":0}],\"SuccessEntitys\":[],\"SuccessMessages\":[],\"MsgCode\":1}}}]]','会话信息已丢失，请重新登录',203,'2022-09-05 10:42:05','2022-09-05 10:42:05'),
(903,'物料清单执行SQL','726596543642136576','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',206,'2022-09-05 10:42:05','2022-09-05 10:42:05'),
(904,'物料清单执行SQL','726596544518746112','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',216,'2022-09-05 10:42:06','2022-09-05 10:42:06'),
(905,'物料清单执行SQL','726596545441492992','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',193,'2022-09-05 10:42:06','2022-09-05 10:42:06'),
(906,'物料清单执行SQL','726596546267770880','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',210,'2022-09-05 10:42:06','2022-09-05 10:42:06'),
(907,'物料清单执行SQL','726596547165351936','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',192,'2022-09-05 10:42:06','2022-09-05 10:42:06'),
(908,'物料清单执行SQL','726596547987435520','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',206,'2022-09-05 10:42:06','2022-09-05 10:42:06'),
(909,'物料清单执行SQL','726596548864045056','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',213,'2022-09-05 10:42:07','2022-09-05 10:42:07'),
(910,'物料清单执行SQL','726596549770014720','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',208,'2022-09-05 10:42:07','2022-09-05 10:42:07'),
(911,'物料清单执行SQL','726596550650818560','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',203,'2022-09-05 10:42:07','2022-09-05 10:42:07'),
(912,'物料清单执行SQL','726596551519039488','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',220,'2022-09-05 10:42:07','2022-09-05 10:42:07'),
(913,'物料清单执行SQL','726596552458563584','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=160787) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',205,'2022-09-05 10:42:08','2022-09-05 10:42:08'),
(914,'物料清单执行SQL','726596553330978816','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=160729) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',189,'2022-09-05 10:42:08','2022-09-05 10:42:08'),
(915,'物料清单执行SQL','726596554136285184','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=160729) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',209,'2022-09-05 10:42:08','2022-09-05 10:42:08'),
(916,'物料清单执行SQL','726596555029671936','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',198,'2022-09-05 10:42:08','2022-09-05 10:42:08'),
(917,'物料清单执行SQL','726596555872727040','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128462) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',195,'2022-09-05 10:42:08','2022-09-05 10:42:08'),
(918,'物料清单执行SQL','726596556707393536','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',223,'2022-09-05 10:42:09','2022-09-05 10:42:09'),
(919,'物料清单执行SQL','726596557659500544','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',211,'2022-09-05 10:42:09','2022-09-05 10:42:09'),
(920,'物料清单执行SQL','726596558561275904','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',199,'2022-09-05 10:42:09','2022-09-05 10:42:09'),
(921,'物料清单执行SQL','726596559408525312','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',203,'2022-09-05 10:42:09','2022-09-05 10:42:09'),
(922,'物料清单执行SQL','726596560276746240','/*dialect*/with stepCTE AS \n( \nselect b.FMATERIALID as f, a.FMATERIALID as z,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE,1 AS Lev from T_ENG_BOMCHILD a inner join ( select * from T_ENG_BOM where fid=128464) b on a.FID=b.FID \ninner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \nunion all\nselect c.f as f ,c.z as z,c.FID,c.FNUMERATOR,c.FDENOMINATOR,c.FPOSITIONNO,c.FUNITID,c.FENTRYID,c.FSEQ,c.FNUMBER,c.FMATERIALTYPE,cte.Lev+1  from \n(\n select a.FMATERIALID z ,b.FMATERIALID f,a.FID,a.FNUMERATOR,a.FDENOMINATOR,a.FPOSITIONNO,a.FUNITID,a.FENTRYID,a.FSEQ,ma.FNUMBER,a.FMATERIALTYPE  from T_ENG_BOMCHILD a inner join T_ENG_BOM b on a.FID=b.FID  inner join T_BD_MATERIAL ma on a.FMATERIALID=ma.FMATERIALID \n) c \ninner join stepCTE cte on cte.z=c.f\n) \nselect  fx.FNUMBER FMATERIALID,bom.FFORBIDSTATUS FForbidStatus,bom.FNUMBER FNumber,stepCTE.FNUMBER FMATERIALIDCHILD,T_ENG_BOMCHILD_l.FMEMO FMEMO,\nzwl.FNUMBER FIskeyItem,stepCTE.FMATERIALTYPE FDENOMINATOR,(stepCTE.FNUMERATOR/stepCTE.FDENOMINATOR) dosage,stepCTE.FPOSITIONNO FPOSITIONNO ,stepCTE.Lev,fx.FOLDNUMBER F_ora_BaseProperty1,zx.FOLDNUMBER F_ora_BaseProperty2\nfrom stepCTE \nleft join (select * from T_ENG_BOMCHILD_l where FLOCALEID=2052)T_ENG_BOMCHILD_l on stepCTE.FENTRYID=T_ENG_BOMCHILD_l.FENTRYID\ninner join T_ENG_BOM bom on bom.FID=stepCTE.FID\ninner join T_BD_MATERIAL fx on fx.FMATERIALID=stepCTE.f\nleft join \n(\n  select t3.FENTRYID,t1.FMATERIALID,twl.FNUMBER,twl.FOLDNUMBER from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n  left join T_BD_MATERIAL twl on t1.FMATERIALID=twl.FMATERIALID\n  left join (\n  select t1.FENTRYID,t1.FMATERIALID,t1.FMATERIALTYPE,t2.FROWID,t2.FPARENTROWID from T_ENG_BOMCHILD t1 \n  left join T_ENG_BOMCHILD_A t2 on t1.FENTRYID=t2.FENTRYID\n ) t3 on t2.FROWID=t3.FPARENTROWID\n) zwl on zwl.FENTRYID=stepCTE.FENTRYID\nleft join T_BD_MATERIAL zx on zx.FMATERIALID=stepCTE.z',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"data\":null}','请重新登录！',200,'2022-09-05 10:42:09','2022-09-05 10:42:09'),
(923,'生产入库单','3a85ac34-5c19-40dc-8ceb-6136ea551dee','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100220\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T10:42:34.1616644+08:00\",\"FCreatorId\":{\"FNumber\":\"\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK001\"},\"FMoBillNo\":\"WO2236031\",\"FRealQty\":8.0}]}}',0,'{\"resultCode\":\"0010\",\"resultMsg\":\"请重新登录！\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T10:42:35.3071834+08:00\"}],\"resultData\":[]}','请重新登录！',224,'2022-09-05 10:42:35','2022-09-05 10:42:35'),
(924,'生产入库单重新登陆请求','3a85ac34-5c19-40dc-8ceb-6136ea551dee','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100220\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T10:42:34.1616644+08:00\",\"FCreatorId\":{\"FNumber\":\"\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK001\"},\"FMoBillNo\":\"WO2236031\",\"FRealQty\":8.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T10:42:35.8784211+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n',1771,'2022-09-05 10:42:37','2022-09-05 10:42:37'),
(925,'生产入库单','eddc563f-4945-4dfa-a7ac-77e6a8e84425','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100220\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T10:46:09.4589167+08:00\",\"FCreatorId\":{\"FNumber\":\"\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK001\"},\"FMoBillNo\":\"WO2236031\",\"FRealQty\":8.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T10:46:11.3675848+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T10:46:11.5081856+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-05T10:46:13.3362618+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000083\",\"msg\":null}]}',NULL,3481,'2022-09-05 10:46:13','2022-09-05 10:46:13'),
(926,'生产领料单','d4edc7c7-d810-4e0d-9536-4a050e9443ef','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101631\",\"101633\",\"101634\",\"101635\",\"101632\",\"101634\",\"101636\",\"101637\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T10:59:28.4617625+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":22.8,\"FEntrySrcBillNo\":\"PPBOM00000179\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10.32,\"FEntrySrcBillNo\":\"PPBOM00000179\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了7行数据进行下推；\\r\\n2. 有7行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T10:59:30.5087236+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了7行数据进行下推；\r\n2. 有7行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\r\n',320,'2022-09-05 10:59:30','2022-09-05 10:59:30'),
(927,'生产入库单','bb77ae6d-9632-4aa7-80ff-f2a6e851f6bd','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100221\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T11:07:17.6629743+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2236031\",\"FRealQty\":24.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T11:07:18.6187866+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T11:07:18.6969021+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000084”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[4:0000000442]\"}]}','提交失败',857,'2022-09-05 11:07:18','2022-09-05 11:07:18'),
(928,'生产用料清单','7f2aa206-408c-41c9e-b8d4-4321e1a6f8e9','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":1,\"FMOBillNO1\":\"WO2236031\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100204\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101634,\"F_LQKJ_Code\":2835}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T11:16:49.2951403+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"不允许删除已经下推的数据行\"}]}','保存失败',417,'2022-09-05 11:16:49','2022-09-05 11:16:49'),
(929,'生产订单','a11c9349-ac33-4c38-8854-749cde85d7b7','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2237001\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-05T13:08:21.822291+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":16,\"FPlanStartDate\":\"2022-09-05T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-21T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":72},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":48,\"FPlanStartDate\":\"2022-09-05T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-21T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":73}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T13:08:34.5157832+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T13:08:34.5626682+08:00\"}],\"resultData\":[]}',NULL,12603,'2022-09-05 13:08:34','2022-09-05 13:08:34'),
(930,'生产用料清单','d85d6bdf-e7c6-4891-bace-d1d0dd5bc984','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2237001\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100213\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"FEntryID\":101710,\"F_LQKJ_Code\":2904},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101711,\"F_LQKJ_Code\":2905},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101712,\"F_LQKJ_Code\":2906},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.0433\",\"FNeedQty2\":\"3\",\"FMustQty\":\"3\",\"FEntryID\":101713,\"F_LQKJ_Code\":2907},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"576\",\"FMustQty\":\"576\",\"FEntryID\":101714,\"F_LQKJ_Code\":2908},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"0.95\",\"FNeedQty2\":\"45.60\",\"FMustQty\":\"45.60\",\"FEntryID\":101715,\"F_LQKJ_Code\":2909},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"20.64\",\"FMustQty\":\"20.64\",\"FEntryID\":101716,\"F_LQKJ_Code\":2910}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T13:12:13.384215+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000188\",\"msg\":null}]}',NULL,876,'2022-09-05 13:12:13','2022-09-05 13:12:13'),
(931,'生产用料清单','da382607-b461-4140-91ba-a7487c36d5f9','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":16,\"FMOBillNO1\":\"WO2237001\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100212\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"480\",\"FMustQty\":\"480\",\"FEntryID\":101705,\"F_LQKJ_Code\":2911},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101700,\"F_LQKJ_Code\":2912},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"F_LQKJ_Code\":2913},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"32\",\"FMustQty\":\"32\",\"FEntryID\":101704,\"F_LQKJ_Code\":2914},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101702,\"F_LQKJ_Code\":2915},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101708,\"F_LQKJ_Code\":2916},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"96\",\"FMustQty\":\"96\",\"FEntryID\":101703,\"F_LQKJ_Code\":2917},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101706,\"F_LQKJ_Code\":2918},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"0.272\",\"FMustQty\":\"0.272\",\"FEntryID\":101707,\"F_LQKJ_Code\":2919},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"2.672\",\"FMustQty\":\"2.672\",\"FEntryID\":101709,\"F_LQKJ_Code\":2920},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101699,\"F_LQKJ_Code\":2921}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T13:14:51.0995416+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000187\",\"msg\":null}]}',NULL,989,'2022-09-05 13:14:51','2022-09-05 13:14:51'),
(932,'生产领料单','a774d0a7-7d62-4cca-b519-7b4039c1e73b','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101710\",\"101712\",\"101713\",\"101714\",\"101711\",\"101713\",\"101715\",\"101716\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:25:10.6221566+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":22.8,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10.32,\"FEntrySrcBillNo\":\"PPBOM00000188\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"同步失败，源单分录主键101713, 未下推成功!\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T13:25:12.866033+08:00\"}],\"resultData\":[]}','同步失败，源单分录主键101713, 未下推成功!',1751,'2022-09-05 13:25:14','2022-09-05 13:25:14'),
(933,'生产入库单','856d60f8-9a04-4766-a841-16a8bb371b1c','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100230\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:25:43.133617+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":24.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T13:25:43.8044973+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n',548,'2022-09-05 13:25:44','2022-09-05 13:25:44'),
(934,'生产入库单','32d3c2a6-cc8a-4f71-95bc-21bd85d9d8f1','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100230\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:28:04.9372873+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":24.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T13:28:06.7992349+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T13:28:06.8929753+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-05T13:28:07.8236077+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000085\",\"msg\":null}]}',NULL,1929,'2022-09-05 13:28:07','2022-09-05 13:28:07'),
(935,'直接调拨单','b7ae99cd-87eb-45d5-9841-1886a476f44e','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"FL-M2237001\",\"FDate\":\"2022-09-05T13:36:24.443597+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000537\"},\"FSrcStockId\":{\"Fnumber\":\"CK017\"},\"FQty\":24.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T13:36:27.5631452+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T13:36:27.594428+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-05T13:36:28.8395366+08:00\"}],\"resultData\":[{\"code\":\"FL-M2237001\",\"msg\":null}]}',NULL,3571,'2022-09-05 13:36:28','2022-09-05 13:36:28'),
(936,'生产领料单','df3c776e-8ee4-4d55-9e1a-d4a022487f7f','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101700\",\"101717\",\"101699\",\"101704\",\"101702\",\"101703\",\"101705\",\"101706\",\"101707\",\"101708\",\"101709\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:36:36.1316723+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":16.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":240.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.136,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.136,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.336,\"FEntrySrcBillNo\":\"PPBOM00000187\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T13:36:39.3589997+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第3行物料编码【0000000438】,第7行物料编码【0000000444】,第10行物料编码【0000000028】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',506,'2022-09-05 13:36:39','2022-09-05 13:36:39'),
(937,'生产入库单','86aaff52-fd56-4bc4-86c5-336b947882d6','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100229\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:40:29.9682011+08:00\",\"FCreatorId\":{\"FNumber\":\"\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK001\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":8.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T13:40:31.2388435+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T13:40:31.3326053+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-05T13:40:31.7701055+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000086\",\"msg\":null}]}',NULL,1254,'2022-09-05 13:40:31','2022-09-05 13:40:31'),
(938,'生产领料单','e9ab4ebd-672d-40b2-b659-65ee64abc9a1','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101710\",\"101712\",\"101713\",\"101714\",\"101711\",\"101713\",\"101715\",\"101716\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:42:41.2864701+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":22.8,\"FEntrySrcBillNo\":\"PPBOM00000188\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10.32,\"FEntrySrcBillNo\":\"PPBOM00000188\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了7行数据进行下推；\\r\\n2. 有7行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T13:42:43.9107732+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了7行数据进行下推；\r\n2. 有7行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\r\n',290,'2022-09-05 13:42:44','2022-09-05 13:42:44'),
(939,'生产入库单','5cd37e43-f908-4069-bf3d-f74711bfb13e','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100230\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:44:01.0966119+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":24.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T13:44:02.2904945+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T13:44:02.4144592+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-05T13:44:02.925225+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000087\",\"msg\":null}]}',NULL,1334,'2022-09-05 13:44:03','2022-09-05 13:44:03'),
(940,'生产入库单','5b02015d-64e6-4f62-a655-332a87559f9d','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100230\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:45:31.2835526+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":24.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T13:45:31.9818581+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \r\n',256,'2022-09-05 13:45:32','2022-09-05 13:45:32'),
(941,'生产入库单','7e2e43ec-78ec-4762-9e90-69bac48a637c','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100230\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T13:46:10.1887262+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":24.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T13:46:10.8666466+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \r\n',369,'2022-09-05 13:46:11','2022-09-05 13:46:11'),
(942,'生产入库单','4b6b0b10-e4b8-4f38-8f75-13f1f176a096','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100230\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:02:54.5831858+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":24.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T14:02:55.7118859+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \r\n',339,'2022-09-05 14:02:56','2022-09-05 14:02:56'),
(943,'生产入库单','81644998-fbfe-48e5-97d7-3f42f6067ad2','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100230\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:06:54.2186699+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":24.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T14:06:55.1785327+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \r\n',255,'2022-09-05 14:06:55','2022-09-05 14:06:55'),
(944,'生产入库单','7adbcefb-9224-45be-b6db-6a26bfc51068','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100230\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:09:34.1565243+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":24.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产入库单的条件：\\r\\n                 \\r\\n1、生产订单已审核；\\r\\n                  \\r\\n2、生产订单单据类型为可直接入库的单据类型；\\r\\n                  \\r\\n3、对应分录状态为开工，且未挂起；\\r\\n                  \\r\\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 \\r\\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  \\r\\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                  \\r\\n7、入库组织下存在该物料；\\r\\n                  \\r\\n8、入库组织下的该物料允许库存。\\r\\n \\r\\n9、首检勾选，生产订单分录首检状态为首检完成；\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了1行数据进行下推；\\r\\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\\r\\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\\r\\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\\r\\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T14:09:35.1423256+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产入库单的条件：\r\n                 \r\n1、生产订单已审核；\r\n                  \r\n2、生产订单单据类型为可直接入库的单据类型；\r\n                  \r\n3、对应分录状态为开工，且未挂起；\r\n                  \r\n4、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 \r\n5、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  \r\n6、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                  \r\n7、入库组织下存在该物料；\r\n                  \r\n8、入库组织下的该物料允许库存。\r\n \r\n9、首检勾选，生产订单分录首检状态为首检完成；\r\n\r\n取数失败原因分析：\r\n1. 共选择了1行数据进行下推；\r\n2. 有1行数据不满足下推数据筛选条件：业务状态 等于 开工\r\n3. 有1行数据不满足下推数据筛选条件：1、产品检验未勾选，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；\r\n                 2、产品检验勾选，非紧急放行时，生产订单合格数量大于合格品入库选单数或不合格数量大于不合格品入库选单数或报废数量大于报废品入库选单数或返工品数量大于返工品入库选单数量；\r\n                  3、产品检验勾选，紧急放行时，生产订单入库上限大于合格品入库选单数+不合格品入库选单数+报废品入库选单数+返工品入库选单数；   \r\n',277,'2022-09-05 14:09:35','2022-09-05 14:09:35'),
(945,'生产订单关闭执行SQL','8c03b129-9971-410a-a41d-c3a08ed55f4c','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 73',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":1}',NULL,205,'2022-09-05 14:09:49','2022-09-05 14:09:49'),
(946,'直接调拨单','a33ab705-f9a6-437d-ba62-80984ea0e0d6','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"FL-M2237002\",\"FDate\":\"2022-09-05T14:17:29.5297683+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000537\"},\"FSrcStockId\":{\"Fnumber\":\"CK017\"},\"FQty\":24.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:17:31.9272407+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T14:17:31.9487458+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-05T14:17:32.5601421+08:00\"}],\"resultData\":[{\"code\":\"FL-M2237002\",\"msg\":null}]}',NULL,2312,'2022-09-05 14:17:32','2022-09-05 14:17:32'),
(947,'生产领料单','3dd47f86-4ef9-49c0-b8db-7e41a3bae9a0','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101700\",\"101717\",\"101699\",\"101704\",\"101702\",\"101703\",\"101705\",\"101706\",\"101707\",\"101708\",\"101709\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:17:40.0070233+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":16.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":240.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.136,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.136,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000187\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.336,\"FEntrySrcBillNo\":\"PPBOM00000187\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"下推失败。生产订单下推生产领料单的条件为：\\r\\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\\r\\n                  2、生产用料清单已审核；\\r\\n                  3、发料方式为直接领料或调拨领料；\\r\\n                  4、子项类型不为返还件；\\r\\n                  5、不为联副产品；\\r\\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\\r\\n                  7、发料组织下存在子项物料；\\r\\n                  8、发料组织下的子项物料允许库存。\\r\\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\\r\\n\\r\\n取数失败原因分析：\\r\\n1. 共选择了11行数据进行下推；\\r\\n2. 有11行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\\r\\n\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T14:17:42.9506973+08:00\"}],\"resultData\":[]}','下推失败。生产订单下推生产领料单的条件为：\r\n                  1、生产订单对应分录下达、开工或完工，且未挂起；\r\n                  2、生产用料清单已审核；\r\n                  3、发料方式为直接领料或调拨领料；\r\n                  4、子项类型不为返还件；\r\n                  5、不为联副产品；\r\n                  6、对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0；\r\n                  7、发料组织下存在子项物料；\r\n                  8、发料组织下的子项物料允许库存。\r\n                  9、生产订单对应的单据类型没有勾选【按工序领料】\r\n\r\n取数失败原因分析：\r\n1. 共选择了11行数据进行下推；\r\n2. 有11行数据不满足下推数据筛选条件：对应生产用料清单的应发数量-领料选单数量+来料不良退料数量+良品退料数量应该大于0\r\n',774,'2022-09-05 14:17:43','2022-09-05 14:17:43'),
(948,'生产入库单','434db3db-1e2d-4cca-87cc-cd3d484abb4f','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100229\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:19:11.2461221+08:00\",\"FCreatorId\":{\"FNumber\":\"\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK001\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":8.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:19:12.944755+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T14:19:13.0541371+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000088”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[7:0000000444,8:0000000445]\"}]}','提交失败',1230,'2022-09-05 14:19:13','2022-09-05 14:19:13'),
(949,'采购订单','726653902729048064','{\"FormId\":\"PUR_PurchaseOrder\",\"FieldKeys\":\"FBillNo, FDate, FSupplierId, FMaterialId.FNumber, FQty, FPlanQty, FUnitID.FNumber, FEntryTaxAmount, FAllAmount, FEntryNote, FMRPCloseStatus, FPOOrderEntry_FEntryID, FModel, F_ora_BaseProperty\",\"FilterString\":\"FID=\'100734\'\"}',1,'[[\"WXCG2209001\",\"2022-09-05T00:00:00\",114731,\"0000000444\",100.0,100.0,\"kg\",0.0,0.0,\" \",\"A\",103713,\"X-32-3439-A,16Kg/can,Shinetsu\",\"260001\"],[\"WXCG2209001\",\"2022-09-05T00:00:00\",114731,\"0000000445\",100.0,100.0,\"kg\",0.0,0.0,\" \",\"A\",103714,\"X-32-3439-B,16Kg/can,Shinetsu\",\"260002\"]]',NULL,214,'2022-09-05 14:30:01','2022-09-05 14:30:01'),
(950,'生产入库单','a1861f27-d1cc-4369-971f-d55feb6f723d','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100229\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:32:26.8067614+08:00\",\"FCreatorId\":{\"FNumber\":\"\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK001\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":8.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:32:28.7705828+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T14:32:28.8330799+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000089”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[7:0000000444,8:0000000445,12:0000000444,13:0000000445]\"}]}','提交失败',1270,'2022-09-05 14:32:29','2022-09-05 14:32:29'),
(951,'生产入库单','9737c281-e6e9-4887-8070-9e5874667fd6','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100229\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:34:13.6839945+08:00\",\"FCreatorId\":{\"FNumber\":\"\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK001\"},\"FMoBillNo\":\"WO2237001\",\"FRealQty\":8.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:34:15.2108891+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T14:34:15.292919+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000090”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[7:0000000444,8:0000000445]\"}]}','提交失败',849,'2022-09-05 14:34:15','2022-09-05 14:34:15'),
(952,'生产订单','d9169afb-2e2a-4b19-b609-b298949aea35','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsInTransaction\":false,\"isAutoSubmit\":\"submit\",\"Model\":{\"FBillNo\":\"WO2237002\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FDate\":\"2022-09-05T14:41:08.5030178+08:00\",\"FTreeEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FQty\":8,\"FPlanStartDate\":\"2022-09-05T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-27T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":74},{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FQty\":24,\"FPlanStartDate\":\"2022-09-05T00:00:00+08:00\",\"FPlanFinishDate\":\"2022-09-27T00:00:00\",\"FUnitId\":{\"FNumber\":\"Pcs\"},\"FWorkShopID\":{\"Fnumber\":\"BM000022\"},\"F_LQKJ_Code\":75}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:41:10.2088088+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T14:41:10.2400286+08:00\"}],\"resultData\":[]}',NULL,1247,'2022-09-05 14:41:10','2022-09-05 14:41:10'),
(953,'生产用料清单','004b2b72-55d7-4f3c-8582-f86f0d7b0c6b','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":8,\"FMOBillNO1\":\"WO2237002\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100215\",\"FMoEntrySeq1\":\"2\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000422\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101731,\"F_LQKJ_Code\":2922},{\"FMaterialID2\":{\"FNumber\":\"0000000423\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101732,\"F_LQKJ_Code\":2923},{\"FMaterialID2\":{\"FNumber\":\"0000000441\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101733,\"F_LQKJ_Code\":2924},{\"FMaterialID2\":{\"FNumber\":\"0000000442\"},\"FStdQty\":\"0.0433\",\"FNeedQty2\":\"3.0392\",\"FMustQty\":\"3.0392\",\"FEntryID\":101734,\"F_LQKJ_Code\":2925},{\"FMaterialID2\":{\"FNumber\":\"0000000443\"},\"FStdQty\":\"12\",\"FNeedQty2\":\"288\",\"FMustQty\":\"288\",\"FEntryID\":101735,\"F_LQKJ_Code\":2926},{\"FMaterialID2\":{\"FNumber\":\"0000000451\"},\"FStdQty\":\"0.95\",\"FNeedQty2\":\"22.80\",\"FMustQty\":\"22.80\",\"FEntryID\":101736,\"F_LQKJ_Code\":2927},{\"FMaterialID2\":{\"FNumber\":\"0000000452\"},\"FStdQty\":\"0.43\",\"FNeedQty2\":\"10.32\",\"FMustQty\":\"10.32\",\"FEntryID\":101737,\"F_LQKJ_Code\":2928}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:52:26.2571999+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000190\",\"msg\":null}]}',NULL,579,'2022-09-05 14:52:26','2022-09-05 14:52:26'),
(954,'生产用料清单','ce293d84-3461-4152-9123-cbfbc889b181','{\"FormId\":\"PRD_PPBOM\",\"IsInTransaction\":true,\"isAutoSubmit\":\"submit\",\"Model\":{\"FQty\":8,\"FMOBillNO1\":\"WO2237002\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FID\":\"100214\",\"FMoEntrySeq1\":\"1\",\"FEntity\":[{\"FMaterialID2\":{\"FNumber\":\"0000000453\"},\"FStdQty\":\"30\",\"FNeedQty2\":\"240\",\"FMustQty\":\"240\",\"FEntryID\":101726,\"F_LQKJ_Code\":2929},{\"FMaterialID2\":{\"FNumber\":\"0000000446\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101721,\"F_LQKJ_Code\":2930},{\"FMaterialID2\":{\"FNumber\":\"0000000449\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"F_LQKJ_Code\":2931},{\"FMaterialID2\":{\"FNumber\":\"0000000437\"},\"FStdQty\":\"2\",\"FNeedQty2\":\"16\",\"FMustQty\":\"16\",\"FEntryID\":101725,\"F_LQKJ_Code\":2932},{\"FMaterialID2\":{\"FNumber\":\"0000000438\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"FEntryID\":101723,\"F_LQKJ_Code\":2933},{\"FMaterialID2\":{\"FNumber\":\"0000000439\"},\"FStdQty\":\"1\",\"FNeedQty2\":\"8\",\"FMustQty\":\"8\",\"FEntryID\":101729,\"F_LQKJ_Code\":2934},{\"FMaterialID2\":{\"FNumber\":\"0000000440\"},\"FStdQty\":\"6\",\"FNeedQty2\":\"48\",\"FMustQty\":\"48\",\"FEntryID\":101724,\"F_LQKJ_Code\":2935},{\"FMaterialID2\":{\"FNumber\":\"0000000444\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"1.136\",\"FMustQty\":\"1.136\",\"FEntryID\":101727,\"F_LQKJ_Code\":2936},{\"FMaterialID2\":{\"FNumber\":\"0000000445\"},\"FStdQty\":\"0.017\",\"FNeedQty2\":\"1.136\",\"FMustQty\":\"1.136\",\"FEntryID\":101728,\"F_LQKJ_Code\":2937},{\"FMaterialID2\":{\"FNumber\":\"0000000028\"},\"FStdQty\":\"0.167\",\"FNeedQty2\":\"1.336\",\"FMustQty\":\"1.336\",\"FEntryID\":101730,\"F_LQKJ_Code\":2938},{\"FMaterialID2\":{\"FNumber\":\"0000000537\"},\"FStdQty\":\"3\",\"FNeedQty2\":\"24\",\"FMustQty\":\"24\",\"FEntryID\":101720,\"F_LQKJ_Code\":2939}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:54:24.4963201+08:00\"}],\"resultData\":[{\"code\":\"PPBOM00000189\",\"msg\":null}]}',NULL,797,'2022-09-05 14:54:24','2022-09-05 14:54:24'),
(955,'生产领料单','5846dc42-f12c-48a7-90dc-fd94d6d404ed','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101731\",\"101733\",\"101734\",\"101735\",\"101732\",\"101734\",\"101736\",\"101737\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:57:10.1835132+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000190\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000190\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000190\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":288.0,\"FEntrySrcBillNo\":\"PPBOM00000190\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000190\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.0392,\"FEntrySrcBillNo\":\"PPBOM00000190\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":22.8,\"FEntrySrcBillNo\":\"PPBOM00000190\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":10.32,\"FEntrySrcBillNo\":\"PPBOM00000190\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"同步失败，源单分录主键101734, 未下推成功!\",\"performances\":[{\"stage\":\"开始\",\"pointTime\":\"2022-09-05T14:57:12.3849994+08:00\"}],\"resultData\":[]}','同步失败，源单分录主键101734, 未下推成功!',326,'2022-09-05 14:57:12','2022-09-05 14:57:12'),
(956,'生产入库单','f64a13c7-9fc7-4776-b6ef-8b48e7266e42','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100232\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:58:18.8395627+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"0386\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000537\"},\"FStockId\":{\"FNumber\":\"CK017\"},\"FMoBillNo\":\"WO2237002\",\"FRealQty\":24.0}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:58:20.1789163+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T14:58:20.2707029+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-05T14:58:21.0363526+08:00\"}],\"resultData\":[{\"code\":\"SCRK00000091\",\"msg\":null}]}',NULL,1584,'2022-09-05 14:58:21','2022-09-05 14:58:21'),
(957,'生产订单关闭执行SQL','31b865af-d882-43a5-bffe-1938db746ae3','UPDATE T_PRD_MOENTRY SET F_LQKJ_MESSTATES = 1 WHERE F_LQKJ_Code = 75',1,'{\"resultCode\":\"0000\",\"resultMsg\":null,\"data\":1}',NULL,198,'2022-09-05 14:58:31','2022-09-05 14:58:31'),
(958,'直接调拨单','44178f84-2f5c-4fc1-be48-aaa47a264e17','{\"FormId\":\"STK_TransferDirect\",\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FBillNo\":\"FL-M2237003\",\"FDate\":\"2022-09-05T14:59:42.1876556+08:00\",\"FCreatorId\":{\"FNumber\":\"0386\"},\"FBillEntry\":[{\"FMaterialId\":{\"Fnumber\":\"0000000537\"},\"FSrcStockId\":{\"Fnumber\":\"CK017\"},\"FQty\":24.0,\"FDestStockId\":{\"Fnumber\":\"CK014\"}}]}}',1,'{\"resultCode\":\"0000\",\"resultMsg\":\"同步成功\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:59:43.9161105+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T14:59:43.9317277+08:00\"},{\"stage\":\"审核\",\"pointTime\":\"2022-09-05T14:59:44.36528+08:00\"}],\"resultData\":[{\"code\":\"FL-M2237003\",\"msg\":null}]}',NULL,1872,'2022-09-05 14:59:44','2022-09-05 14:59:44'),
(959,'生产领料单','972aa855-9d3c-433d-818a-6ab7202ff4c9','{\"FormId\":\"PRD_PickMtrl\",\"ConvertRule\":\"PRD_IssueMtrl2PickMtrl\",\"SrcFormId\":\"PRD_PPBOM\",\"SrcEntryKey\":\"FEntity\",\"SrcIds\":[\"101721\",\"101738\",\"101720\",\"101725\",\"101723\",\"101724\",\"101726\",\"101727\",\"101728\",\"101729\",\"101730\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T14:59:46.0678907+08:00\",\"FCreatorId\":{\"Fnumber\":\"0386\"},\"FEntity\":[{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":24.0,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":16.0,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":48.0,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":240.0,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.136,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":0.136,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":8.0,\"FEntrySrcBillNo\":\"PPBOM00000189\"},{\"FStockId\":{\"FNumber\":\"CK014\"},\"FActualQty\":1.336,\"FEntrySrcBillNo\":\"PPBOM00000189\"}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"保存失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T14:59:49.493226+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"第3行物料编码【0000000438】,第7行物料编码【0000000444】,第10行物料编码【0000000028】分录超出最小发料批量,保存不成功。\\r\\n\"}]}','保存失败',621,'2022-09-05 14:59:49','2022-09-05 14:59:49'),
(960,'生产入库单','f8d88e54-7257-4b4f-a0cf-07707c297a83','{\"FormId\":\"PRD_INSTOCK\",\"ConvertRule\":\"PRD_MO2INSTOCK\",\"SrcFormId\":\"PRD_MO\",\"SrcEntryKey\":\"FTreeEntity\",\"SrcIds\":[\"100231\"],\"IsInTransaction\":true,\"isAutoSubmit\":\"auto\",\"Model\":{\"FDate\":\"2022-09-05T15:01:09.0743854+08:00\",\"FCreatorId\":{\"FNumber\":\"\"},\"FStockOrgId\":{\"FNumber\":\"WX\"},\"FStockerId\":{\"FNumber\":\"\"},\"FEntity\":[{\"FMaterialId\":{\"FNumber\":\"0000000538\"},\"FStockId\":{\"FNumber\":\"CK001\"},\"FMoBillNo\":\"WO2237002\",\"FRealQty\":8.0}]}}',0,'{\"resultCode\":\"0001\",\"resultMsg\":\"提交失败\",\"performances\":[{\"stage\":\"保存\",\"pointTime\":\"2022-09-05T15:01:10.7754196+08:00\"},{\"stage\":\"提交\",\"pointTime\":\"2022-09-05T15:01:10.8467022+08:00\"}],\"resultData\":[{\"code\":null,\"msg\":\"单据编号为“SCRK00000092”的生产入库单，第[1]行分录，存在以下领用套数小于累计入库数。提交是否继续？[1:0000000537,10:0000000028]\"}]}','提交失败',801,'2022-09-05 15:01:11','2022-09-05 15:01:11'),
(961,'生产订单','80364175-781b-4ed6-955b-4c0abe7df134','{\"FormId\":\"PRD_MO\",\"SrcEntryKey\":\"1\",\"IsIn