package com.system.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.entity.DockerImage;
import com.system.entity.DockerImageVersion;
import com.system.serivce.IDockerImageService;
import com.system.serivce.IDockerImageVersionService;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "服务镜像")
@RestController
@RequestMapping("/api/service")
public class DockerImageController {
    @Autowired
    private IDockerImageService imageService;
    @Autowired
    private IDockerImageVersionService versionService;

    @ApiOperation("服务镜像列表")
    @GetMapping("/image")
    public RestResponse list(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                             @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize, @RequestParam(name = "name", required = false) String name) {
        Page<DockerImage> page = new Page<DockerImage>(pageNo, pageSize);
        try {
            LambdaQueryWrapper<DockerImage> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.orderByDesc(DockerImage::getId);
            if (!StringUtils.isEmpty(name)) {
                queryWrapper.like(DockerImage::getName, name);
            }
            IPage<DockerImage> pageList = imageService.page(page, queryWrapper);
            return RestResponse.success(pageList);
        } catch (Exception up) {
            up.printStackTrace();
            return RestResponse.fail(up.getMessage());
        }
    }

    @ApiOperation("服务镜像添加")
    @PostMapping("/image")
    public RestResponse add(@RequestBody DockerImage entity) {
        try {
            boolean save = imageService.save(entity);
            if (save) {
                return RestResponse.success("ok");
            }
            return RestResponse.fail("保存失败");
        } catch (Exception up) {
            up.printStackTrace();
            return RestResponse.fail(up.getMessage());
        }
    }

    @ApiOperation("服务镜像更新")
    @PutMapping("/image")
    public RestResponse update(@RequestBody DockerImage entity) {
        try {
            boolean save = imageService.updateById(entity);
            if (save) {
                return RestResponse.success("ok");
            }
            return RestResponse.fail("更新失败");
        } catch (Exception up) {
            up.printStackTrace();
            return RestResponse.fail(up.getMessage());
        }
    }

    @ApiOperation("服务镜像删除")
    @DeleteMapping("/image/{id}")
    public RestResponse delete(@PathVariable("id") Integer id) {
        try {
            if (imageService.deleteById(id)) {
                return RestResponse.success("ok");
            }
            return RestResponse.fail("删除失败");
        } catch (Exception up) {
            up.printStackTrace();
            return RestResponse.fail(up.getMessage());
        }
    }

    @ApiOperation("服务镜像版本列表")
    @GetMapping("/image/version")
    public RestResponse versionList(@RequestParam(name = "imageId") Integer imageId) {
        try {
            List<DockerImageVersion> dockerImageVersions = versionService.listByImageId(imageId);
            return RestResponse.success(dockerImageVersions);
        } catch (Exception up) {
            up.printStackTrace();
            return RestResponse.fail(up.getMessage());
        }
    }

    @ApiOperation("服务镜像版本添加")
    @PostMapping("/image/version")
    public RestResponse versionAdd(@RequestBody DockerImageVersion entity) {
        try {
            boolean save = versionService.save(entity);
            if (save) {
                return RestResponse.success("ok");
            }
            return RestResponse.fail("添加失败");
        } catch (Exception up) {
            up.printStackTrace();
            return RestResponse.fail(up.getMessage());
        }
    }

    @ApiOperation("服务镜像版本删除")
    @DeleteMapping("/image/version/{id}")
    public RestResponse versionDelete(@PathVariable("id") Integer id) {
        try {
            if (versionService.removeById(id)) {
                return RestResponse.success("ok");
            }
            return RestResponse.fail("删除失败");
        } catch (Exception up) {
            up.printStackTrace();
            return RestResponse.fail(up.getMessage());
        }
    }
}
