package com.system.job;


import com.system.serivce.ILicVerificationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * 数据库定时备份任务
 * 在backup文件夹中备份最近七日的数据库文件
 */
@Component
public class LicVerificationCleanJob {
    @Autowired
    private ILicVerificationService licVerificationService;


    /*
     */
//    @Scheduled(cron = "0 0 4 * * ?")
    @PostConstruct
    public void backupTwo() {
        try {
            LocalDateTime localDateTime = LocalDateTime.now().minusDays(2);
            licVerificationService.licOnlineVerificationLogClean(localDateTime.format(DateTimeFormatter.ISO_DATE_TIME));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
