package com.system.transfer.response;

/**
 * @author Inori
 */
public class LicRestResponse<T> extends RestResponse<T>{

   private String lic;

    public String getLic() {
        return lic;
    }

    public void setLic(String lic) {
        this.lic = lic;
    }


    public static LicRestResponse success() {
        LicRestResponse restResponse = new LicRestResponse();
        restResponse.setCode(200);
        restResponse.setData(new Object());
        return restResponse;
    }

    public static <T>LicRestResponse<T> success(T data) {
        LicRestResponse<T> restResponse = new LicRestResponse<T>();
        restResponse.setCode(200);
        restResponse.setData(data);
        return restResponse;
    }

    public static LicRestResponse fail(int code, String msg) {
        LicRestResponse restResponse = new LicRestResponse();
        restResponse.setCode(code);
        restResponse.setMessage(msg);
        return restResponse;
    }

    public static LicRestResponse fail(String msg) {
        return fail(CODE_PARAM_ERROR, msg);
    }

    public static LicRestResponse fail(String msg, Object data) {
        LicRestResponse restResponse = new LicRestResponse();
        restResponse.setCode(CODE_PARAM_ERROR);
        restResponse.setMessage(msg);
        restResponse.setData(data);
        return restResponse;
    }

    public static LicRestResponse error(String msg) {
        LicRestResponse restResponse = new LicRestResponse();
        restResponse.setCode(CODE_SERVER_ERROR);
        restResponse.setMessage(msg);
        return restResponse;
    }


}
