package com.system.framework.core.exception;

import lombok.Data;

import java.util.List;

@Data
public class MetaDataQueryException extends RuntimeException{

    public List<String> result;
    public int code;
    public MetaDataQueryException(String message, List<String> result, int code) {
        super(message);
        this.result=result;
        this.code=code;
    }
    public MetaDataQueryException(String message) {
        super(message);
    }
    public List<String> getResult() {
        return result;
    }

    public void setResult(List<String> result) {
        this.result = result;
    }
    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}