/*
SQLyog Enterprise v13.1.1 (64 bit)
MySQL - 5.7.25 : Database - db_lic
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`db_lic` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `db_lic`;

/*Table structure for table `oauth_client_details` */

DROP TABLE IF EXISTS `oauth_client_details`;

CREATE TABLE `oauth_client_details` (
  `client_id` varchar(256) NOT NULL,
  `resource_ids` varchar(256) DEFAULT NULL,
  `client_secret` varchar(256) DEFAULT NULL,
  `scope` varchar(256) DEFAULT NULL,
  `authorized_grant_types` varchar(256) DEFAULT NULL,
  `web_server_redirect_uri` varchar(256) DEFAULT NULL,
  `authorities` varchar(256) DEFAULT NULL,
  `access_token_validity` int DEFAULT NULL,
  `refresh_token_validity` int DEFAULT NULL,
  `additional_information` varchar(4096) DEFAULT NULL,
  `autoapprove` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

/*Data for the table `oauth_client_details` */

insert  into `oauth_client_details`(`client_id`,`resource_ids`,`client_secret`,`scope`,`authorized_grant_types`,`web_server_redirect_uri`,`authorities`,`access_token_validity`,`refresh_token_validity`,`additional_information`,`autoapprove`) values
('auth-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,NULL,NULL,NULL,NULL),
('codegenerator-client',NULL,'$2a$10$pKOYERvA7GXe9nsY6arlauD87nnG5OriMJCOlVOOOzqI0AMKDP/hK','all','authorization_code,refresh_token,password',NULL,NULL,3600,36000,NULL,'1'),
('user-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,7200,36000,NULL,'1');

/*Table structure for table `sys_depart` */

DROP TABLE IF EXISTS `sys_depart`;

CREATE TABLE `sys_depart` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '父机构ID',
  `depart_name` varchar(100) NOT NULL COMMENT '机构/部门名称',
  `description` varchar(128) DEFAULT NULL COMMENT '描述',
  `depart_order` int DEFAULT '0' COMMENT '排序',
  `org_category` varchar(10) NOT NULL DEFAULT '1' COMMENT '机构类别 1组织机构，2岗位',
  `org_type` varchar(10) DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) NOT NULL COMMENT '机构编码',
  `status` varchar(1) DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_depart_org_code` (`org_code`) USING BTREE,
  KEY `index_depart_parent_id` (`parent_id`) USING BTREE,
  KEY `index_depart_depart_order` (`depart_order`) USING BTREE,
  KEY `index_depart_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='组织机构表';

/*Data for the table `sys_depart` */

/*Table structure for table `sys_fill_rule` */

DROP TABLE IF EXISTS `sys_fill_rule`;

CREATE TABLE `sys_fill_rule` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_sys_fill_rule_code` (`rule_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_fill_rule` */

insert  into `sys_fill_rule`(`id`,`rule_name`,`rule_code`,`rule_class`,`rule_params`,`update_by`,`update_time`,`create_by`,`create_time`) values
('1202551334738382850','机构编码生成','org_num_role','com.starbos.cloud.oauth.system.rule.OrgCodeRule','{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}','admin','2022-05-18 12:00:20','admin','2022-05-18 12:00:12');

/*Table structure for table `sys_permission` */

DROP TABLE IF EXISTS `sys_permission`;

CREATE TABLE `sys_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编码',
  `fsort` bigint DEFAULT NULL COMMENT '排序',
  `type` int NOT NULL DEFAULT '1' COMMENT '菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)',
  `perm_tag` varchar(128) NOT NULL COMMENT '表单key',
  `path` varchar(258) NOT NULL COMMENT '路径',
  `component` varchar(64) DEFAULT '' COMMENT '组件',
  `title` varchar(32) NOT NULL COMMENT '菜单名称',
  `icon` varchar(32) DEFAULT '' COMMENT '菜单图标',
  `parent_id` bigint NOT NULL DEFAULT '0' COMMENT '父节点',
  `is_leaf` tinyint(1) DEFAULT '1' COMMENT '是否叶子节点:    1:是   0:不是',
  `sort_no` double(8,2) DEFAULT NULL COMMENT '菜单排序',
  `fremarks` varchar(128) DEFAULT '' COMMENT '备注',
  `fstatus` varchar(1) DEFAULT '1' COMMENT '状态',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tag` (`perm_tag`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_permission` */

insert  into `sys_permission`(`id`,`fsort`,`type`,`perm_tag`,`path`,`component`,`title`,`icon`,`parent_id`,`is_leaf`,`sort_no`,`fremarks`,`fstatus`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,0,0,'system','/system','Layout','系统管理','Setting',0,0,0.00,'','','2022-08-01 09:50:54','','2022-03-31 17:21:29',''),
(2,0,1,'menu','/menu','/system/menuManage','菜单管理','',1,1,2.00,'','','2022-08-01 11:27:13','','2022-03-31 18:19:39',''),
(3,0,1,'role','/role','/system/roleManage','角色管理','',1,1,3.00,'','','2022-08-01 11:27:14','','2022-04-02 17:16:42',''),
(4,0,1,'user','/user','/system/userManage','用户管理','',1,1,4.00,'','','2022-08-08 09:47:47','','2022-04-15 10:45:07',''),
(5,NULL,0,'business','/business','Layout','业务管理','Setting',0,0,1.00,'','1','2022-09-16 09:26:17','','2022-09-16 09:24:46',''),
(6,NULL,1,'licInformation','/licInformation','/business/licInformation','Lic信息','',5,1,0.00,'','1','2022-09-16 09:26:17','','2022-09-16 09:26:17',''),
(7,NULL,1,'onlineVerification','/onlineVerification','/business/onlineVerification','Lic在线验证','',5,1,1.00,'','1','2022-09-16 09:28:26','','2022-09-16 09:28:09','');

/*Table structure for table `sys_role` */

DROP TABLE IF EXISTS `sys_role`;

CREATE TABLE `sys_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_code` varchar(64) DEFAULT NULL,
  `role_Name` varchar(64) NOT NULL,
  `role_Desc` varchar(64) NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `sys_role` */

insert  into `sys_role`(`id`,`role_code`,`role_Name`,`role_Desc`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values
(1,'admin','管理员','管理员','2022-04-21 11:32:51','admin','2022-03-31 17:21:29','');

/*Table structure for table `sys_role_permission` */

DROP TABLE IF EXISTS `sys_role_permission`;

CREATE TABLE `sys_role_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_id` bigint NOT NULL,
  `perm_id` bigint NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_role_prem_id` (`role_id`,`perm_id`),
  KEY `idx_perm_id` (`perm_id`),
  KEY `idx_role_id` (`perm_id`),
  CONSTRAINT `sys_role_permission_ibfk_1` FOREIGN KEY (`perm_id`) REFERENCES `sys_permission` (`id`),
  CONSTRAINT `sys_role_permission_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

/*Data for the table `sys_role_permission` */

insert  into `sys_role_permission`(`id`,`role_id`,`perm_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values 
(1,1,1,'2022-08-01 09:52:02','','2022-08-01 09:52:02',''),
(2,1,2,'2022-08-01 09:52:03','','2022-08-01 09:52:03',''),
(3,1,3,'2022-08-01 09:52:05','','2022-08-01 09:52:05',''),
(4,1,4,'2022-08-01 09:52:06','','2022-08-01 09:52:06',''),
(5,1,5,'2022-09-16 09:25:12','','2022-09-16 09:25:12',''),
(6,1,6,'2022-09-16 09:26:49','','2022-09-16 09:26:49',''),
(7,1,7,'2022-09-16 09:28:39','','2022-09-16 09:28:39','');

/*Table structure for table `sys_sms` */

DROP TABLE IF EXISTS `sys_sms`;

CREATE TABLE `sys_sms` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `es_title` varchar(100) DEFAULT NULL COMMENT '消息标题',
  `es_type` varchar(1) DEFAULT NULL COMMENT '发送方式：1短信 2邮件 3微信',
  `es_receiver` varchar(50) DEFAULT NULL COMMENT '接收人',
  `es_param` varchar(1000) DEFAULT NULL COMMENT '发送所需参数Json格式',
  `es_content` longtext COMMENT '推送内容',
  `es_send_time` datetime DEFAULT NULL COMMENT '推送时间',
  `es_send_status` varchar(1) DEFAULT NULL COMMENT '推送状态 0未推送 1推送成功 2推送失败 -1失败不再发送',
  `es_send_num` int DEFAULT NULL COMMENT '发送次数 超过5次不再发送',
  `es_result` varchar(255) DEFAULT NULL COMMENT '推送失败原因',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_type` (`es_type`) USING BTREE,
  KEY `index_receiver` (`es_receiver`) USING BTREE,
  KEY `index_sendtime` (`es_send_time`) USING BTREE,
  KEY `index_status` (`es_send_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms` */

/*Table structure for table `sys_sms_template` */

DROP TABLE IF EXISTS `sys_sms_template`;

CREATE TABLE `sys_sms_template` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `template_name` varchar(50) DEFAULT NULL COMMENT '模板标题',
  `template_code` varchar(32) NOT NULL COMMENT '模板CODE',
  `template_type` varchar(1) NOT NULL COMMENT '模板类型：1短信 2邮件 3微信',
  `template_content` varchar(1000) NOT NULL COMMENT '模板内容',
  `template_test_json` varchar(1000) DEFAULT NULL COMMENT '模板测试json',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_templatecode` (`template_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_sms_template` */

/*Table structure for table `sys_user` */

DROP TABLE IF EXISTS `sys_user`;

CREATE TABLE `sys_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL COMMENT '账号',
  `realname` varchar(50) DEFAULT '' COMMENT '真名',
  `password` varchar(64) NOT NULL COMMENT '密码',
  `create_Date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_Login_Time` date DEFAULT NULL COMMENT '最后登录时间',
  `enabled` int(11) DEFAULT '0',
  `account_Non_Expired` int(11) DEFAULT '0',
  `account_Non_Locked` int(11) DEFAULT '0',
  `credentials_Non_Expired` int(11) DEFAULT '0',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_account_username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `sys_user` */

insert  into `sys_user`(`id`,`username`,`realname`,`password`,`create_Date`,`last_Login_Time`,`enabled`,`account_Non_Expired`,`account_Non_Locked`,`credentials_Non_Expired`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values
(1,'admin','张三','$2a$10$6Lx/bmiLraMqI/MwE3d0y.B7fMjNkS2mN4M8o9sANbxCOw2Js2hiq','2021-11-13 00:00:00','2022-03-01',1,1,1,1,'2022-03-31 17:21:29','','2022-03-31 17:21:29','');

/*Table structure for table `sys_user_depart` */

DROP TABLE IF EXISTS `sys_user_depart`;

CREATE TABLE `sys_user_depart` (
  `ID` bigint NOT NULL COMMENT 'id',
  `user_id` bigint DEFAULT NULL COMMENT '用户id',
  `dep_id` varchar(32) DEFAULT NULL COMMENT '部门id',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_depart_groupk_userid` (`user_id`) USING BTREE,
  KEY `index_depart_groupkorgid` (`dep_id`) USING BTREE,
  KEY `index_depart_groupk_uidanddid` (`user_id`,`dep_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;

/*Data for the table `sys_user_depart` */

/*Table structure for table `sys_user_message` */

DROP TABLE IF EXISTS `sys_user_message`;

CREATE TABLE `sys_user_message` (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `avatar` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71' COMMENT '头像url',
  `introduction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户介绍',
  `fauth_account` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '账号',
  `fenglish_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `fwork_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工号',
  `fdept` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `fphone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机',
  `fmail` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `fwork_addr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工作地点',
  `fposition` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职位',
  `finduction_date` datetime DEFAULT NULL COMMENT '入职日期',
  `fstate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '状态',
  `fdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `fcreator` varchar(67) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `idx_auth_account` (`fauth_account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/*Data for the table `sys_user_message` */

insert  into `sys_user_message`(`user_id`,`name`,`avatar`,`introduction`,`fauth_account`,`fenglish_name`,`fwork_no`,`fdept`,`fphone`,`fmail`,`fwork_addr`,`fposition`,`finduction_date`,`fstate`,`fdate`,`fcreator`) values
(1,'张三','https://ss0.baidu.com/94o3dSag_xI4khGko9WTAnF6hhy/baike/s=220/sign=92f3220861d0f703e2b292de38fb5148/37d3d539b6003af32267a87f362ac65c1138b6cb.jpg','','admin','admin','114514','','','114514@homo.com','123','','2022-04-12 00:00:00','困','2022-04-02 00:00:00','');

/*Table structure for table `sys_user_role` */

DROP TABLE IF EXISTS `sys_user_role`;

CREATE TABLE `sys_user_role` (
  `user_id` bigint(20) DEFAULT NULL,
  `role_id` bigint(20) DEFAULT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  KEY `FK_Reference_1` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `FK_Reference_1` FOREIGN KEY (`user_id`) REFERENCES `sys_user` (`id`),
  CONSTRAINT `sys_user_role_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_user_role` */

insert  into `sys_user_role`(`user_id`,`role_id`,`Fmodify_date`,`Fmodify`,`fdate`,`fcreator`) values
(1,1,'2022-06-08 14:22:02','','2022-06-08 14:22:02','');

/*Table structure for table `undo_log` */

DROP TABLE IF EXISTS `undo_log`;

CREATE TABLE `undo_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `branch_id` bigint NOT NULL,
  `xid` varchar(100) CHARACTER SET utf8mb4 NOT NULL,
  `context` varchar(128) CHARACTER SET utf8mb4 NOT NULL,
  `rollback_info` longblob NOT NULL,
  `log_status` int NOT NULL,
  `log_created` datetime NOT NULL,
  `log_modified` datetime NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `ux_undo_log` (`xid`,`branch_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=385 DEFAULT CHARSET=utf8mb4;

/*Table structure for table `tb_lic_info` */

DROP TABLE IF EXISTS `tb_lic_info`;

CREATE TABLE `tb_lic_info` (
    `lq_lic_name` VARCHAR(128) NOT NULL COMMENT 'lic名称',
    `id` INT(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
    `mac_address` VARCHAR(128) NOT NULL COMMENT 'MAC地址',
    `effective_time` TIMESTAMP NOT NULL COMMENT '导入有效时间',
    `file_effective_time` TIMESTAMP NOT NULL COMMENT '文件有效时间',
    `verification_interval` INT(11) NOT NULL COMMENT '验证间隔时间',
    `module_verification` VARCHAR(128) DEFAULT '' COMMENT '模块验证',
    `remark` TEXT DEFAULT NULL COMMENT '备注',
    `create_time` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='lic信息表';

/*Data for the table `tb_lic_info` */

/*Table structure for table `tb_lic_log` */

DROP TABLE IF EXISTS `tb_lic_log`;

CREATE TABLE `tb_lic_log` (
	`id` INT(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
	`mac_address` VARCHAR(128) NOT NULL COMMENT 'MAC地址',
	`source` VARCHAR(128) NOT NULL COMMENT '来源',
	`request` LONGTEXT DEFAULT NULL COMMENT '请求参数',
	`flag` TINYINT(1) DEFAULT 1 COMMENT '是否成功（0-失败，1-成功）',
	`response` LONGTEXT DEFAULT NULL COMMENT '响应信息',
	`message` LONGTEXT DEFAULT NULL COMMENT '错误原因',
	`create_time` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
	`update_time` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
	PRIMARY KEY (`id`) USING BTREE
) ENGINE=INNODB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='lic日志表';

/*Data for the table `tb_lic_log` */



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
