-- MySQL dump 10.13  Distrib 8.0.27, for Linux (x86_64)
--
-- Host: localhost    Database: db_lic
-- ------------------------------------------------------
-- Server version	8.0.27

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `oauth_client_details`
--

DROP TABLE IF EXISTS `oauth_client_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_client_details` (
  `client_id` varchar(256) NOT NULL,
  `resource_ids` varchar(256) DEFAULT NULL,
  `client_secret` varchar(256) DEFAULT NULL,
  `scope` varchar(256) DEFAULT NULL,
  `authorized_grant_types` varchar(256) DEFAULT NULL,
  `web_server_redirect_uri` varchar(256) DEFAULT NULL,
  `authorities` varchar(256) DEFAULT NULL,
  `access_token_validity` int DEFAULT NULL,
  `refresh_token_validity` int DEFAULT NULL,
  `additional_information` varchar(4096) DEFAULT NULL,
  `autoapprove` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_client_details`
--

LOCK TABLES `oauth_client_details` WRITE;
/*!40000 ALTER TABLE `oauth_client_details` DISABLE KEYS */;
INSERT INTO `oauth_client_details` VALUES ('auth-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,NULL,NULL,NULL,NULL),('codegenerator-client',NULL,'$2a$10$pKOYERvA7GXe9nsY6arlauD87nnG5OriMJCOlVOOOzqI0AMKDP/hK','all','authorization_code,refresh_token,password',NULL,NULL,3600,36000,NULL,'1'),('user-client',NULL,'$2a$10$o2l5kA7z.Caekp72h5kU7uqdTDrlamLq.57M1F6ulJln9tRtOJufq','all','authorization_code,refresh_token,password',NULL,NULL,7200,36000,NULL,'1');
/*!40000 ALTER TABLE `oauth_client_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_depart`
--

DROP TABLE IF EXISTS `sys_depart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_depart` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '父机构ID',
  `depart_name` varchar(100) NOT NULL COMMENT '机构/部门名称',
  `description` varchar(128) DEFAULT NULL COMMENT '描述',
  `depart_order` int DEFAULT '0' COMMENT '排序',
  `org_category` varchar(10) NOT NULL DEFAULT '1' COMMENT '机构类别 1组织机构，2岗位',
  `org_type` varchar(10) DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) NOT NULL COMMENT '机构编码',
  `status` varchar(1) DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_depart_org_code` (`org_code`) USING BTREE,
  KEY `index_depart_parent_id` (`parent_id`) USING BTREE,
  KEY `index_depart_depart_order` (`depart_order`) USING BTREE,
  KEY `index_depart_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='组织机构表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_depart`
--

LOCK TABLES `sys_depart` WRITE;
/*!40000 ALTER TABLE `sys_depart` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_depart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_fill_rule`
--

DROP TABLE IF EXISTS `sys_fill_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_fill_rule` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_sys_fill_rule_code` (`rule_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_fill_rule`
--

LOCK TABLES `sys_fill_rule` WRITE;
/*!40000 ALTER TABLE `sys_fill_rule` DISABLE KEYS */;
INSERT INTO `sys_fill_rule` VALUES ('1202551334738382850','机构编码生成','org_num_role','com.starbos.cloud.oauth.system.rule.OrgCodeRule','{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}','admin','2022-05-18 12:00:20','admin','2022-05-18 12:00:12');
/*!40000 ALTER TABLE `sys_fill_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_permission`
--

DROP TABLE IF EXISTS `sys_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '编码',
  `fsort` bigint DEFAULT NULL COMMENT '排序',
  `type` int NOT NULL DEFAULT '1' COMMENT '菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)',
  `perm_tag` varchar(128) NOT NULL COMMENT '表单key',
  `path` varchar(258) NOT NULL COMMENT '路径',
  `component` varchar(64) DEFAULT '' COMMENT '组件',
  `title` varchar(32) NOT NULL COMMENT '菜单名称',
  `icon` varchar(32) DEFAULT '' COMMENT '菜单图标',
  `parent_id` bigint NOT NULL DEFAULT '0' COMMENT '父节点',
  `is_leaf` tinyint(1) DEFAULT '1' COMMENT '是否叶子节点:    1:是   0:不是',
  `sort_no` double(8,2) DEFAULT NULL COMMENT '菜单排序',
  `fremarks` varchar(128) DEFAULT '' COMMENT '备注',
  `fstatus` varchar(1) DEFAULT '1' COMMENT '状态',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tag` (`perm_tag`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_permission`
--

LOCK TABLES `sys_permission` WRITE;
/*!40000 ALTER TABLE `sys_permission` DISABLE KEYS */;
INSERT INTO `sys_permission` VALUES (1,0,0,'system','/system','Layout','系统管理','Setting',0,0,0.00,'','','2022-08-01 09:50:54','','2022-03-31 17:21:29',''),(2,0,1,'menu','/menu','/system/menuManage','菜单管理','',1,1,2.00,'','','2022-08-01 11:27:13','','2022-03-31 18:19:39',''),(3,0,1,'role','/role','/system/roleManage','角色管理','',1,1,3.00,'','','2022-08-01 11:27:14','','2022-04-02 17:16:42',''),(4,0,1,'user','/user','/system/userManage','用户管理','',1,1,4.00,'','','2022-08-08 09:47:47','','2022-04-15 10:45:07',''),(5,NULL,0,'business','/business','Layout','业务管理','Setting',0,0,1.00,'','1','2022-09-16 09:26:17','','2022-09-16 09:24:46',''),(6,NULL,1,'licInformation','/licInformation','/business/licInformation','Lic信息','',5,1,0.00,'','1','2022-09-16 09:26:17','','2022-09-16 09:26:17',''),(7,NULL,1,'onlineVerification','/onlineVerification','/business/onlineVerification','Lic在线验证','',5,1,1.00,'','1','2022-09-16 09:28:26','','2022-09-16 09:28:09',''),(8,NULL,1,'service/image','/service/image','Layout','系统服务模块','',5,1,0.00,'','1','2023-04-10 15:02:23','','2023-04-10 15:02:02','');
/*!40000 ALTER TABLE `sys_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_role`
--

DROP TABLE IF EXISTS `sys_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_role` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_code` varchar(64) DEFAULT NULL,
  `role_Name` varchar(64) NOT NULL,
  `role_Desc` varchar(64) NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_role`
--

LOCK TABLES `sys_role` WRITE;
/*!40000 ALTER TABLE `sys_role` DISABLE KEYS */;
INSERT INTO `sys_role` VALUES (1,'admin','管理员','管理员','2022-04-21 11:32:51','admin','2022-03-31 17:21:29','');
/*!40000 ALTER TABLE `sys_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_role_permission`
--

DROP TABLE IF EXISTS `sys_role_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_role_permission` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `role_id` bigint NOT NULL,
  `perm_id` bigint NOT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_role_prem_id` (`role_id`,`perm_id`),
  KEY `idx_perm_id` (`perm_id`),
  KEY `idx_role_id` (`perm_id`),
  CONSTRAINT `sys_role_permission_ibfk_1` FOREIGN KEY (`perm_id`) REFERENCES `sys_permission` (`id`),
  CONSTRAINT `sys_role_permission_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_role_permission`
--

LOCK TABLES `sys_role_permission` WRITE;
/*!40000 ALTER TABLE `sys_role_permission` DISABLE KEYS */;
INSERT INTO `sys_role_permission` VALUES (1,1,1,'2022-08-01 09:52:02','','2022-08-01 09:52:02',''),(2,1,2,'2022-08-01 09:52:03','','2022-08-01 09:52:03',''),(3,1,3,'2022-08-01 09:52:05','','2022-08-01 09:52:05',''),(4,1,4,'2022-08-01 09:52:06','','2022-08-01 09:52:06',''),(5,1,5,'2022-09-16 09:25:12','','2022-09-16 09:25:12',''),(6,1,6,'2022-09-16 09:26:49','','2022-09-16 09:26:49',''),(7,1,7,'2022-09-16 09:28:39','','2022-09-16 09:28:39','');
/*!40000 ALTER TABLE `sys_role_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_sms`
--

DROP TABLE IF EXISTS `sys_sms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_sms` (
  `id` varchar(32) NOT NULL COMMENT 'ID',
  `es_title` varchar(100) DEFAULT NULL COMMENT '消息标题',
  `es_type` varchar(1) DEFAULT NULL COMMENT '发送方式：1短信 2邮件 3微信',
  `es_receiver` varchar(50) DEFAULT NULL COMMENT '接收人',
  `es_param` varchar(1000) DEFAULT NULL COMMENT '发送所需参数Json格式',
  `es_content` longtext COMMENT '推送内容',
  `es_send_time` datetime DEFAULT NULL COMMENT '推送时间',
  `es_send_status` varchar(1) DEFAULT NULL COMMENT '推送状态 0未推送 1推送成功 2推送失败 -1失败不再发送',
  `es_send_num` int DEFAULT NULL COMMENT '发送次数 超过5次不再发送',
  `es_result` varchar(255) DEFAULT NULL COMMENT '推送失败原因',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_type` (`es_type`) USING BTREE,
  KEY `index_receiver` (`es_receiver`) USING BTREE,
  KEY `index_sendtime` (`es_send_time`) USING BTREE,
  KEY `index_status` (`es_send_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_sms`
--

LOCK TABLES `sys_sms` WRITE;
/*!40000 ALTER TABLE `sys_sms` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_sms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_sms_template`
--

DROP TABLE IF EXISTS `sys_sms_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_sms_template` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `template_name` varchar(50) DEFAULT NULL COMMENT '模板标题',
  `template_code` varchar(32) NOT NULL COMMENT '模板CODE',
  `template_type` varchar(1) NOT NULL COMMENT '模板类型：1短信 2邮件 3微信',
  `template_content` varchar(1000) NOT NULL COMMENT '模板内容',
  `template_test_json` varchar(1000) DEFAULT NULL COMMENT '模板测试json',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `create_by` varchar(32) DEFAULT NULL COMMENT '创建人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `update_by` varchar(32) DEFAULT NULL COMMENT '更新人登录名称',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_templatecode` (`template_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_sms_template`
--

LOCK TABLES `sys_sms_template` WRITE;
/*!40000 ALTER TABLE `sys_sms_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_sms_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_user`
--

DROP TABLE IF EXISTS `sys_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_user` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL COMMENT '账号',
  `realname` varchar(50) DEFAULT '' COMMENT '真名',
  `password` varchar(64) NOT NULL COMMENT '密码',
  `create_Date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_Login_Time` date DEFAULT NULL COMMENT '最后登录时间',
  `enabled` int DEFAULT '0',
  `account_Non_Expired` int DEFAULT '0',
  `account_Non_Locked` int DEFAULT '0',
  `credentials_Non_Expired` int DEFAULT '0',
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_account_username` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_user`
--

LOCK TABLES `sys_user` WRITE;
/*!40000 ALTER TABLE `sys_user` DISABLE KEYS */;
INSERT INTO `sys_user` VALUES (1,'admin','张三','$2a$10$sfcHMW.wzUOFUgInkZ5Y/ekoGHf7WkHJiTS8GOUwic8lYqsmBHHdi','2021-11-13 00:00:00','2022-03-01',1,1,1,1,'2022-12-15 16:46:24','','2022-03-31 17:21:29','');
/*!40000 ALTER TABLE `sys_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_user_depart`
--

DROP TABLE IF EXISTS `sys_user_depart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_user_depart` (
  `ID` bigint NOT NULL COMMENT 'id',
  `user_id` bigint DEFAULT NULL COMMENT '用户id',
  `dep_id` varchar(32) DEFAULT NULL COMMENT '部门id',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_depart_groupk_userid` (`user_id`) USING BTREE,
  KEY `index_depart_groupkorgid` (`dep_id`) USING BTREE,
  KEY `index_depart_groupk_uidanddid` (`user_id`,`dep_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_user_depart`
--

LOCK TABLES `sys_user_depart` WRITE;
/*!40000 ALTER TABLE `sys_user_depart` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_user_depart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_user_message`
--

DROP TABLE IF EXISTS `sys_user_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_user_message` (
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户名',
  `avatar` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'Signature=44edccd07b4b56cb4a2680e5335ab4bb08cc416bd713fa754d6fe642abe58f71' COMMENT '头像url',
  `introduction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户介绍',
  `fauth_account` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '账号',
  `fenglish_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '英文名称',
  `fwork_no` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工号',
  `fdept` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `fphone` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手机',
  `fmail` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `fwork_addr` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '工作地点',
  `fposition` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '职位',
  `finduction_date` datetime DEFAULT NULL COMMENT '入职日期',
  `fstate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '0' COMMENT '状态',
  `fdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `fcreator` varchar(67) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '创建人',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `idx_auth_account` (`fauth_account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_user_message`
--

LOCK TABLES `sys_user_message` WRITE;
/*!40000 ALTER TABLE `sys_user_message` DISABLE KEYS */;
INSERT INTO `sys_user_message` VALUES (1,'张三','https://ss0.baidu.com/94o3dSag_xI4khGko9WTAnF6hhy/baike/s=220/sign=92f3220861d0f703e2b292de38fb5148/37d3d539b6003af32267a87f362ac65c1138b6cb.jpg','','admin','admin','114514','','','114514@homo.com','123','','2022-04-12 00:00:00','困','2022-04-02 00:00:00','');
/*!40000 ALTER TABLE `sys_user_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_user_role`
--

DROP TABLE IF EXISTS `sys_user_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_user_role` (
  `user_id` bigint DEFAULT NULL,
  `role_id` bigint DEFAULT NULL,
  `Fmodify_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `Fmodify` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '' COMMENT '更新人',
  `fdate` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `fcreator` varchar(64) DEFAULT '' COMMENT '创建人',
  KEY `FK_Reference_1` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `FK_Reference_1` FOREIGN KEY (`user_id`) REFERENCES `sys_user` (`id`),
  CONSTRAINT `sys_user_role_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_user_role`
--

LOCK TABLES `sys_user_role` WRITE;
/*!40000 ALTER TABLE `sys_user_role` DISABLE KEYS */;
INSERT INTO `sys_user_role` VALUES (1,1,'2022-11-26 22:42:13','','2022-11-26 22:42:13','');
/*!40000 ALTER TABLE `sys_user_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `t_docker_image`
--

DROP TABLE IF EXISTS `t_docker_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `t_docker_image` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(64) NOT NULL,
  `context_path` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  `describe` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `t_docker_image`
--

LOCK TABLES `t_docker_image` WRITE;
/*!40000 ALTER TABLE `t_docker_image` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_docker_image` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `t_docker_image_version`
--

DROP TABLE IF EXISTS `t_docker_image_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `t_docker_image_version` (
  `id` int NOT NULL AUTO_INCREMENT,
  `image_id` int NOT NULL,
  `version` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `t_docker_image_version`
--

LOCK TABLES `t_docker_image_version` WRITE;
/*!40000 ALTER TABLE `t_docker_image_version` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_docker_image_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_lic_info`
--

DROP TABLE IF EXISTS `tb_lic_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tb_lic_info` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `mac_address` varchar(128) NOT NULL COMMENT 'MAC地址',
  `effective_time` timestamp NOT NULL COMMENT '导入有效时间',
  `file_effective_time` timestamp NOT NULL COMMENT '文件有效时间',
  `verification_interval` int NOT NULL COMMENT '验证间隔时间',
  `module_verification` varchar(128) DEFAULT '' COMMENT '模块验证',
  `remark` text COMMENT '备注',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `docker_services` json DEFAULT NULL,
  lq_lic_name varchar(128) NOT NULL COMMENT 'lic名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='lic信息表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_lic_info`
--

LOCK TABLES `tb_lic_info` WRITE;
/*!40000 ALTER TABLE `tb_lic_info` DISABLE KEYS */;
INSERT INTO `tb_lic_info` VALUES (1,'00-50-56-C0-00-08','2022-12-14 09:45:09','2022-12-14 09:45:19',86400,'','','2022-12-12 01:43:01','2022-12-22 01:18:13',NULL),(2,'02-42-AC-13-00-02','2022-12-21 10:00:00','2023-01-14 16:00:00',86400,'','','2022-12-13 02:24:30','2022-12-20 02:09:46',NULL),(3,'02-42-ac-14-00-07','2022-12-25 09:43:34','2022-12-31 02:43:50',3600,'','','2022-12-13 09:29:49','2022-12-25 08:45:44',NULL),(6,'02-42-AC-13-00-06','2022-12-28 16:00:00','2023-02-22 16:00:00',86400,'','','2022-12-20 02:49:04','2022-12-28 04:01:02',NULL),(7,'02-42-AC-12-00-03','2022-12-23 16:00:00','2023-01-14 16:00:00',86400,'','','2022-12-20 02:58:06','2022-12-22 11:25:05',NULL),(8,'02-42-AC-14-00-05','2023-02-27 16:00:00','2023-02-27 16:00:00',3600,'','','2022-12-26 01:46:25','2023-02-09 07:36:14',NULL),(9,' 02-42-AC-12-00-05','2023-03-09 16:00:00','2023-03-30 16:00:00',86400,'','','2023-03-09 03:49:55','2023-03-09 03:52:12',NULL);
/*!40000 ALTER TABLE `tb_lic_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_lic_log`
--

DROP TABLE IF EXISTS `tb_lic_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tb_lic_log` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `mac_address` varchar(128) NOT NULL COMMENT 'MAC地址',
  `source` varchar(128) NOT NULL COMMENT '来源',
  `request` longtext COMMENT '请求参数',
  `flag` tinyint(1) DEFAULT '1' COMMENT '是否成功（0-失败，1-成功）',
  `response` longtext COMMENT '响应信息',
  `message` longtext COMMENT '错误原因',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=26956 DEFAULT CHARSET=utf8mb3 ROW_FORMAT=DYNAMIC COMMENT='lic日志表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_lic_log`
--

LOCK TABLES `tb_lic_log` WRITE;
/*!40000 ALTER TABLE `tb_lic_log` DISABLE KEYS */;
INSERT INTO `tb_lic_log` VALUES (1,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-12 01:50:46','2022-12-12 01:50:46'),(2,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-12 01:52:58','2022-12-12 01:52:58'),(3,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 02:44:08','2022-12-13 02:44:08'),(4,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:07:07','2022-12-13 03:07:07'),(5,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:07:59','2022-12-13 03:07:59'),(6,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:10:49','2022-12-13 03:10:49'),(7,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:13:09','2022-12-13 03:13:09'),(8,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:14:15','2022-12-13 03:14:15'),(9,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:17:14','2022-12-13 03:17:14'),(10,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:20:36','2022-12-13 03:20:36'),(11,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:24:17','2022-12-13 03:24:17'),(12,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:25:28','2022-12-13 03:25:28'),(13,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:26:03','2022-12-13 03:26:03'),(14,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:26:33','2022-12-13 03:26:33'),(15,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:27:58','2022-12-13 03:27:58'),(16,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:28:25','2022-12-13 03:28:25'),(17,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:29:44','2022-12-13 03:29:44'),(18,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 03:35:27','2022-12-13 03:35:27'),(19,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 06:59:04','2022-12-13 06:59:04'),(20,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:00:15','2022-12-13 07:00:15'),(21,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:01:51','2022-12-13 07:01:51'),(22,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:02:53','2022-12-13 07:02:53'),(23,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:04:14','2022-12-13 07:04:14'),(24,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:05:25','2022-12-13 07:05:25'),(25,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:05:58','2022-12-13 07:05:58'),(26,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:08:01','2022-12-13 07:08:01'),(27,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:24:11','2022-12-13 07:24:11'),(28,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:38:05','2022-12-13 07:38:05'),(29,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:52:00','2022-12-13 07:52:00'),(30,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:55:35','2022-12-13 07:55:35'),(31,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:56:27','2022-12-13 07:56:27'),(32,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:58:14','2022-12-13 07:58:14'),(33,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 07:59:10','2022-12-13 07:59:10'),(34,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:00:38','2022-12-13 08:00:38'),(35,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:01:48','2022-12-13 08:01:48'),(36,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:07:29','2022-12-13 08:07:29'),(37,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:12:47','2022-12-13 08:12:47'),(38,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:14:00','2022-12-13 08:14:00'),(39,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:15:48','2022-12-13 08:15:48'),(40,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:16:58','2022-12-13 08:16:58'),(41,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:17:34','2022-12-13 08:17:34'),(42,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:19:06','2022-12-13 08:19:06'),(43,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:20:09','2022-12-13 08:20:09'),(44,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:34:59','2022-12-13 08:34:59'),(45,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:41:48','2022-12-13 08:41:48'),(46,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 08:44:58','2022-12-13 08:44:58'),(47,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 09:32:49','2022-12-13 09:32:49'),(48,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 09:42:18','2022-12-13 09:42:18'),(49,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 09:43:42','2022-12-13 09:43:42'),(50,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 09:44:58','2022-12-13 09:44:58'),(51,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 10:01:49','2022-12-13 10:01:49'),(52,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-13 10:02:34','2022-12-13 10:02:34'),(53,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 10:06:43','2022-12-13 10:06:43'),(54,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 11:06:43','2022-12-13 11:06:43'),(55,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 12:06:43','2022-12-13 12:06:43'),(56,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 13:06:43','2022-12-13 13:06:43'),(57,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 14:06:43','2022-12-13 14:06:43'),(58,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 15:06:43','2022-12-13 15:06:43'),(59,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 16:06:43','2022-12-13 16:06:43'),(60,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 17:06:43','2022-12-13 17:06:43'),(61,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 18:06:43','2022-12-13 18:06:43'),(62,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 19:06:43','2022-12-13 19:06:43'),(63,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 20:06:43','2022-12-13 20:06:43'),(64,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 21:06:43','2022-12-13 21:06:43'),(65,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 22:06:43','2022-12-13 22:06:43'),(66,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-13 23:06:43','2022-12-13 23:06:43'),(67,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 00:06:43','2022-12-14 00:06:43'),(68,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 01:06:43','2022-12-14 01:06:43'),(69,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 01:34:20','2022-12-14 01:34:20'),(70,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 01:42:44','2022-12-14 01:42:44'),(71,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 01:56:09','2022-12-14 01:56:09'),(72,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 01:58:22','2022-12-14 01:58:22'),(73,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 02:06:43','2022-12-14 02:06:43'),(74,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 02:10:36','2022-12-14 02:10:36'),(75,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 02:10:42','2022-12-14 02:10:42'),(76,'02-42-AC-13-00-07','integrate','{\"macAddress\":\"02-42-AC-13-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 02:11:09','2022-12-14 02:11:09'),(77,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:12:40','2022-12-14 02:12:40'),(78,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 02:16:59','2022-12-14 02:16:59'),(79,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:17:13','2022-12-14 02:17:13'),(80,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:21:30','2022-12-14 02:21:30'),(81,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:22:08','2022-12-14 02:22:08'),(82,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:26:14','2022-12-14 02:26:14'),(83,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 02:34:48','2022-12-14 02:34:48'),(84,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 02:40:41','2022-12-14 02:40:41'),(85,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:43:25','2022-12-14 02:43:25'),(86,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:45:05','2022-12-14 02:45:05'),(87,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:47:07','2022-12-14 02:47:07'),(88,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:47:55','2022-12-14 02:47:55'),(89,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:49:42','2022-12-14 02:49:42'),(90,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 02:53:46','2022-12-14 02:53:46'),(91,'02-42-AC-13-00-07','integrate','{\"macAddress\":\"02-42-AC-13-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 03:03:46','2022-12-14 03:03:46'),(92,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 03:04:14','2022-12-14 03:04:14'),(93,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:05:52','2022-12-14 03:05:52'),(94,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:06:52','2022-12-14 03:06:52'),(95,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:07:52','2022-12-14 03:07:52'),(96,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:08:52','2022-12-14 03:08:52'),(97,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:09:52','2022-12-14 03:09:52'),(98,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:10:52','2022-12-14 03:10:52'),(99,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:11:52','2022-12-14 03:11:52'),(100,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:12:52','2022-12-14 03:12:52'),(101,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:13:52','2022-12-14 03:13:52'),(102,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:14:52','2022-12-14 03:14:52'),(103,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:15:52','2022-12-14 03:15:52'),(104,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:16:52','2022-12-14 03:16:52'),(105,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:17:52','2022-12-14 03:17:52'),(106,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:18:52','2022-12-14 03:18:52'),(107,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:19:42','2022-12-14 03:19:42'),(108,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:19:52','2022-12-14 03:19:52'),(109,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:20:52','2022-12-14 03:20:52'),(110,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:21:52','2022-12-14 03:21:52'),(111,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:22:52','2022-12-14 03:22:52'),(112,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:23:52','2022-12-14 03:23:52'),(113,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:24:52','2022-12-14 03:24:52'),(114,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:25:52','2022-12-14 03:25:52'),(115,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:26:52','2022-12-14 03:26:52'),(116,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:27:52','2022-12-14 03:27:52'),(117,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:28:52','2022-12-14 03:28:52'),(118,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:29:52','2022-12-14 03:29:52'),(119,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:30:52','2022-12-14 03:30:52'),(120,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:31:52','2022-12-14 03:31:52'),(121,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:32:52','2022-12-14 03:32:52'),(122,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:33:52','2022-12-14 03:33:52'),(123,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:34:45','2022-12-14 03:34:45'),(124,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:34:52','2022-12-14 03:34:52'),(125,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 03:35:52','2022-12-14 03:35:52'),(126,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:36:52','2022-12-14 03:36:52'),(127,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:37:08','2022-12-14 03:37:08'),(128,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:43:08','2022-12-14 03:43:08'),(129,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:45:45','2022-12-14 03:45:45'),(130,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:51:44','2022-12-14 03:51:44'),(131,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:52:44','2022-12-14 03:52:44'),(132,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 03:55:39','2022-12-14 03:55:39'),(133,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:01:39','2022-12-14 04:01:39'),(134,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 04:04:14','2022-12-14 04:04:14'),(135,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:04:45','2022-12-14 04:04:45'),(136,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:07:39','2022-12-14 04:07:39'),(137,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:13:39','2022-12-14 04:13:39'),(138,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:19:39','2022-12-14 04:19:39'),(139,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:25:39','2022-12-14 04:25:39'),(140,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:31:39','2022-12-14 04:31:39'),(141,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:37:39','2022-12-14 04:37:39'),(142,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:43:39','2022-12-14 04:43:39'),(143,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 04:49:39','2022-12-14 04:49:39'),(144,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 04:55:39','2022-12-14 04:55:39'),(145,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:01:39','2022-12-14 05:01:39'),(146,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 05:04:14','2022-12-14 05:04:14'),(147,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:07:39','2022-12-14 05:07:39'),(148,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:13:39','2022-12-14 05:13:39'),(149,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:19:39','2022-12-14 05:19:39'),(150,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:25:39','2022-12-14 05:25:39'),(151,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:31:39','2022-12-14 05:31:39'),(152,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:37:39','2022-12-14 05:37:39'),(153,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:43:39','2022-12-14 05:43:39'),(154,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:49:39','2022-12-14 05:49:39'),(155,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 05:55:39','2022-12-14 05:55:39'),(156,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:01:39','2022-12-14 06:01:39'),(157,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 06:04:14','2022-12-14 06:04:14'),(158,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:07:39','2022-12-14 06:07:39'),(159,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:13:39','2022-12-14 06:13:39'),(160,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:19:39','2022-12-14 06:19:39'),(161,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:25:39','2022-12-14 06:25:39'),(162,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:31:39','2022-12-14 06:31:39'),(163,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:37:39','2022-12-14 06:37:39'),(164,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:43:39','2022-12-14 06:43:39'),(165,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:49:39','2022-12-14 06:49:39'),(166,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:53:11','2022-12-14 06:53:11'),(167,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:54:18','2022-12-14 06:54:18'),(168,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:55:39','2022-12-14 06:55:39'),(169,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:56:16','2022-12-14 06:56:16'),(170,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 06:58:31','2022-12-14 06:58:31'),(171,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:01:39','2022-12-14 07:01:39'),(172,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 07:04:14','2022-12-14 07:04:14'),(173,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:07:39','2022-12-14 07:07:39'),(174,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:13:39','2022-12-14 07:13:39'),(175,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:14:46','2022-12-14 07:14:46'),(176,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:17:44','2022-12-14 07:17:44'),(177,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:18:41','2022-12-14 07:18:41'),(178,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:19:39','2022-12-14 07:19:39'),(179,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:20:02','2022-12-14 07:20:02'),(180,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:20:56','2022-12-14 07:20:56'),(181,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:21:32','2022-12-14 07:21:32'),(182,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:23:26','2022-12-14 07:23:26'),(183,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:25:39','2022-12-14 07:25:39'),(184,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:27:45','2022-12-14 07:27:45'),(185,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:28:37','2022-12-14 07:28:37'),(186,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:31:20','2022-12-14 07:31:20'),(187,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:31:39','2022-12-14 07:31:39'),(188,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:33:31','2022-12-14 07:33:31'),(189,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:35:10','2022-12-14 07:35:10'),(190,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:36:10','2022-12-14 07:36:10'),(191,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:37:10','2022-12-14 07:37:10'),(192,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:37:39','2022-12-14 07:37:39'),(193,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:38:02','2022-12-14 07:38:02'),(194,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:38:59','2022-12-14 07:38:59'),(195,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:39:59','2022-12-14 07:39:59'),(196,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:40:57','2022-12-14 07:40:57'),(197,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:41:57','2022-12-14 07:41:57'),(198,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:42:57','2022-12-14 07:42:57'),(199,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:43:39','2022-12-14 07:43:39'),(200,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:43:57','2022-12-14 07:43:57'),(201,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:44:29','2022-12-14 07:44:29'),(202,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:45:25','2022-12-14 07:45:25'),(203,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:46:25','2022-12-14 07:46:25'),(204,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:47:24','2022-12-14 07:47:24'),(205,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:48:24','2022-12-14 07:48:24'),(206,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:49:24','2022-12-14 07:49:24'),(207,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:49:39','2022-12-14 07:49:39'),(208,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:50:20','2022-12-14 07:50:20'),(209,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:51:20','2022-12-14 07:51:20'),(210,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:52:20','2022-12-14 07:52:20'),(211,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:53:20','2022-12-14 07:53:20'),(212,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:54:20','2022-12-14 07:54:20'),(213,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:55:20','2022-12-14 07:55:20'),(214,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 07:55:39','2022-12-14 07:55:39'),(215,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:56:20','2022-12-14 07:56:20'),(216,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:57:20','2022-12-14 07:57:20'),(217,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:58:20','2022-12-14 07:58:20'),(218,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 07:59:20','2022-12-14 07:59:20'),(219,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:00:20','2022-12-14 08:00:20'),(220,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:01:20','2022-12-14 08:01:20'),(221,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:01:39','2022-12-14 08:01:39'),(222,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:02:20','2022-12-14 08:02:20'),(223,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:03:20','2022-12-14 08:03:20'),(224,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 08:04:14','2022-12-14 08:04:14'),(225,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:04:20','2022-12-14 08:04:20'),(226,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:05:20','2022-12-14 08:05:20'),(227,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:06:20','2022-12-14 08:06:20'),(228,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:07:16','2022-12-14 08:07:16'),(229,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:07:39','2022-12-14 08:07:39'),(230,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:09:18','2022-12-14 08:09:18'),(231,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:10:17','2022-12-14 08:10:17'),(232,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:10:59','2022-12-14 08:10:59'),(233,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:11:50','2022-12-14 08:11:50'),(234,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:12:59','2022-12-14 08:12:59'),(235,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:13:39','2022-12-14 08:13:39'),(236,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:13:59','2022-12-14 08:13:59'),(237,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:14:59','2022-12-14 08:14:59'),(238,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:16:11','2022-12-14 08:16:11'),(239,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:17:11','2022-12-14 08:17:11'),(240,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:18:11','2022-12-14 08:18:11'),(241,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:19:19','2022-12-14 08:19:19'),(242,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:19:39','2022-12-14 08:19:39'),(243,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:20:30','2022-12-14 08:20:30'),(244,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:21:29','2022-12-14 08:21:29'),(245,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:22:11','2022-12-14 08:22:11'),(246,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:23:11','2022-12-14 08:23:11'),(247,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:24:11','2022-12-14 08:24:11'),(248,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:24:52','2022-12-14 08:24:52'),(249,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:25:39','2022-12-14 08:25:39'),(250,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:25:52','2022-12-14 08:25:52'),(251,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:26:52','2022-12-14 08:26:52'),(252,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:27:52','2022-12-14 08:27:52'),(253,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:28:10','2022-12-14 08:28:10'),(254,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:29:10','2022-12-14 08:29:10'),(255,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:30:10','2022-12-14 08:30:10'),(256,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:31:10','2022-12-14 08:31:10'),(257,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:31:36','2022-12-14 08:31:36'),(258,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:31:39','2022-12-14 08:31:39'),(259,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:32:35','2022-12-14 08:32:35'),(260,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:33:07','2022-12-14 08:33:07'),(261,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:34:07','2022-12-14 08:34:07'),(262,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:35:07','2022-12-14 08:35:07'),(263,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:35:49','2022-12-14 08:35:49'),(264,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:36:51','2022-12-14 08:36:51'),(265,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:37:39','2022-12-14 08:37:39'),(266,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:37:51','2022-12-14 08:37:51'),(267,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:38:51','2022-12-14 08:38:51'),(268,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:39:51','2022-12-14 08:39:51'),(269,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:40:51','2022-12-14 08:40:51'),(270,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:41:51','2022-12-14 08:41:51'),(271,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:42:51','2022-12-14 08:42:51'),(272,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:43:39','2022-12-14 08:43:39'),(273,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:43:51','2022-12-14 08:43:51'),(274,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:44:53','2022-12-14 08:44:53'),(275,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:45:09','2022-12-14 08:45:09'),(276,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:45:18','2022-12-14 08:45:18'),(277,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:45:46','2022-12-14 08:45:46'),(278,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:45:54','2022-12-14 08:45:54'),(279,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:46:46','2022-12-14 08:46:46'),(280,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:47:46','2022-12-14 08:47:46'),(281,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:48:46','2022-12-14 08:48:46'),(282,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:49:13','2022-12-14 08:49:13'),(283,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:49:31','2022-12-14 08:49:31'),(284,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:50:13','2022-12-14 08:50:13'),(285,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:50:31','2022-12-14 08:50:31'),(286,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:51:13','2022-12-14 08:51:13'),(287,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:51:31','2022-12-14 08:51:31'),(288,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:52:13','2022-12-14 08:52:13'),(289,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:52:31','2022-12-14 08:52:31'),(290,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:53:26','2022-12-14 08:53:26'),(291,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:53:31','2022-12-14 08:53:31'),(292,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:54:25','2022-12-14 08:54:25'),(293,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:54:31','2022-12-14 08:54:31'),(294,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:55:31','2022-12-14 08:55:31'),(295,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:56:31','2022-12-14 08:56:31'),(296,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:57:19','2022-12-14 08:57:19'),(297,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:57:31','2022-12-14 08:57:31'),(298,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:58:19','2022-12-14 08:58:19'),(299,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:58:31','2022-12-14 08:58:31'),(300,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 08:59:19','2022-12-14 08:59:19'),(301,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 08:59:31','2022-12-14 08:59:31'),(302,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:00:19','2022-12-14 09:00:19'),(303,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:00:31','2022-12-14 09:00:31'),(304,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:00:54','2022-12-14 09:00:54'),(305,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:01:31','2022-12-14 09:01:31'),(306,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:01:54','2022-12-14 09:01:54'),(307,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:02:31','2022-12-14 09:02:31'),(308,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:02:54','2022-12-14 09:02:54'),(309,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:03:31','2022-12-14 09:03:31'),(310,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:03:54','2022-12-14 09:03:54'),(311,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 09:04:14','2022-12-14 09:04:14'),(312,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:04:31','2022-12-14 09:04:31'),(313,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:04:54','2022-12-14 09:04:54'),(314,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:05:31','2022-12-14 09:05:31'),(315,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:05:54','2022-12-14 09:05:54'),(316,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:06:31','2022-12-14 09:06:31'),(317,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:06:54','2022-12-14 09:06:54'),(318,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:07:31','2022-12-14 09:07:31'),(319,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:07:54','2022-12-14 09:07:54'),(320,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:08:31','2022-12-14 09:08:31'),(321,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:08:54','2022-12-14 09:08:54'),(322,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:09:31','2022-12-14 09:09:31'),(323,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:09:54','2022-12-14 09:09:54'),(324,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:10:31','2022-12-14 09:10:31'),(325,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:10:39','2022-12-14 09:10:39'),(326,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:11:31','2022-12-14 09:11:31'),(327,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:12:31','2022-12-14 09:12:31'),(328,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:13:31','2022-12-14 09:13:31'),(329,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:14:31','2022-12-14 09:14:31'),(330,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:15:01','2022-12-14 09:15:01'),(331,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:15:31','2022-12-14 09:15:31'),(332,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:16:01','2022-12-14 09:16:01'),(333,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:16:31','2022-12-14 09:16:31'),(334,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:17:01','2022-12-14 09:17:01'),(335,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:17:31','2022-12-14 09:17:31'),(336,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:17:58','2022-12-14 09:17:58'),(337,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:18:31','2022-12-14 09:18:31'),(338,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:18:57','2022-12-14 09:18:57'),(339,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:19:31','2022-12-14 09:19:31'),(340,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:19:57','2022-12-14 09:19:57'),(341,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:20:31','2022-12-14 09:20:31'),(342,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:20:57','2022-12-14 09:20:57'),(343,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:21:03','2022-12-14 09:21:03'),(344,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:21:57','2022-12-14 09:21:57'),(345,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:22:02','2022-12-14 09:22:02'),(346,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:22:57','2022-12-14 09:22:57'),(347,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:23:02','2022-12-14 09:23:02'),(348,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:23:57','2022-12-14 09:23:57'),(349,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:24:02','2022-12-14 09:24:02'),(350,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:24:46','2022-12-14 09:24:46'),(351,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:24:57','2022-12-14 09:24:57'),(352,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:25:13','2022-12-14 09:25:13'),(353,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:25:57','2022-12-14 09:25:57'),(354,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:26:13','2022-12-14 09:26:13'),(355,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:26:57','2022-12-14 09:26:57'),(356,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:27:13','2022-12-14 09:27:13'),(357,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:27:57','2022-12-14 09:27:57'),(358,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:28:13','2022-12-14 09:28:13'),(359,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:28:57','2022-12-14 09:28:57'),(360,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:29:13','2022-12-14 09:29:13'),(361,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:29:57','2022-12-14 09:29:57'),(362,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:30:13','2022-12-14 09:30:13'),(363,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:30:57','2022-12-14 09:30:57'),(364,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:31:13','2022-12-14 09:31:13'),(365,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:31:57','2022-12-14 09:31:57'),(366,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:32:13','2022-12-14 09:32:13'),(367,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:32:43','2022-12-14 09:32:43'),(368,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:33:13','2022-12-14 09:33:13'),(369,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:33:24','2022-12-14 09:33:24'),(370,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:33:43','2022-12-14 09:33:43'),(371,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:34:24','2022-12-14 09:34:24'),(372,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:34:43','2022-12-14 09:34:43'),(373,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:35:20','2022-12-14 09:35:20'),(374,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:35:43','2022-12-14 09:35:43'),(375,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:36:20','2022-12-14 09:36:20'),(376,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:36:43','2022-12-14 09:36:43'),(377,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:37:20','2022-12-14 09:37:20'),(378,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:37:43','2022-12-14 09:37:43'),(379,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:38:20','2022-12-14 09:38:20'),(380,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:38:43','2022-12-14 09:38:43'),(381,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:39:20','2022-12-14 09:39:20'),(382,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:39:43','2022-12-14 09:39:43'),(383,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:40:20','2022-12-14 09:40:20'),(384,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:40:42','2022-12-14 09:40:42'),(385,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:41:20','2022-12-14 09:41:20'),(386,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:41:42','2022-12-14 09:41:42'),(387,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:42:20','2022-12-14 09:42:20'),(388,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:42:42','2022-12-14 09:42:42'),(389,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:43:20','2022-12-14 09:43:20'),(390,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:43:42','2022-12-14 09:43:42'),(391,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:44:10','2022-12-14 09:44:10'),(392,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:44:20','2022-12-14 09:44:20'),(393,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:45:10','2022-12-14 09:45:10'),(394,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:45:20','2022-12-14 09:45:20'),(395,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:46:10','2022-12-14 09:46:10'),(396,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:46:20','2022-12-14 09:46:20'),(397,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:47:10','2022-12-14 09:47:10'),(398,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:47:20','2022-12-14 09:47:20'),(399,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:48:10','2022-12-14 09:48:10'),(400,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:48:20','2022-12-14 09:48:20'),(401,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:49:10','2022-12-14 09:49:10'),(402,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:49:20','2022-12-14 09:49:20'),(403,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:49:36','2022-12-14 09:49:36'),(404,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:50:10','2022-12-14 09:50:10'),(405,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:50:36','2022-12-14 09:50:36'),(406,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:51:10','2022-12-14 09:51:10'),(407,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:51:36','2022-12-14 09:51:36'),(408,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:52:10','2022-12-14 09:52:10'),(409,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:52:36','2022-12-14 09:52:36'),(410,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:53:10','2022-12-14 09:53:10'),(411,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:53:36','2022-12-14 09:53:36'),(412,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:54:10','2022-12-14 09:54:10'),(413,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:54:36','2022-12-14 09:54:36'),(414,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:55:10','2022-12-14 09:55:10'),(415,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:55:36','2022-12-14 09:55:36'),(416,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:56:10','2022-12-14 09:56:10'),(417,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:56:36','2022-12-14 09:56:36'),(418,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:57:10','2022-12-14 09:57:10'),(419,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:57:36','2022-12-14 09:57:36'),(420,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:58:10','2022-12-14 09:58:10'),(421,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:58:36','2022-12-14 09:58:36'),(422,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 09:59:10','2022-12-14 09:59:10'),(423,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 09:59:35','2022-12-14 09:59:35'),(424,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 10:04:14','2022-12-14 10:04:14'),(425,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 10:59:35','2022-12-14 10:59:35'),(426,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 11:04:14','2022-12-14 11:04:14'),(427,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-14 11:59:35','2022-12-14 11:59:35'),(428,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 12:04:14','2022-12-14 12:04:14'),(429,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 12:59:35','2022-12-14 12:59:35'),(430,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 13:04:14','2022-12-14 13:04:14'),(431,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 13:59:35','2022-12-14 13:59:35'),(432,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 14:04:14','2022-12-14 14:04:14'),(433,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 14:59:35','2022-12-14 14:59:35'),(434,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 15:04:14','2022-12-14 15:04:14'),(435,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 15:59:35','2022-12-14 15:59:35'),(436,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 16:04:14','2022-12-14 16:04:14'),(437,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 16:59:35','2022-12-14 16:59:35'),(438,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 17:04:14','2022-12-14 17:04:14'),(439,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 17:59:35','2022-12-14 17:59:35'),(440,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 18:04:14','2022-12-14 18:04:14'),(441,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 18:59:35','2022-12-14 18:59:35'),(442,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 19:04:14','2022-12-14 19:04:14'),(443,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 19:59:35','2022-12-14 19:59:35'),(444,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 20:04:14','2022-12-14 20:04:14'),(445,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 20:59:35','2022-12-14 20:59:35'),(446,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 21:04:14','2022-12-14 21:04:14'),(447,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 21:59:35','2022-12-14 21:59:35'),(448,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 22:04:14','2022-12-14 22:04:14'),(449,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 22:59:35','2022-12-14 22:59:35'),(450,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-14 23:04:14','2022-12-14 23:04:14'),(451,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-14 23:59:35','2022-12-14 23:59:35'),(452,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 00:04:14','2022-12-15 00:04:14'),(453,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 00:59:35','2022-12-15 00:59:35'),(454,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 01:04:14','2022-12-15 01:04:14'),(455,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 01:15:12','2022-12-15 01:15:12'),(456,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 02:04:14','2022-12-15 02:04:14'),(457,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 02:15:12','2022-12-15 02:15:12'),(458,'02-42-AC-13-00-07','integrate','{\"macAddress\":\"02-42-AC-13-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 02:18:38','2022-12-15 02:18:38'),(459,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 02:46:22','2022-12-15 02:46:22'),(460,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 02:49:17','2022-12-15 02:49:17'),(461,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:01:27','2022-12-15 03:01:27'),(462,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:02:27','2022-12-15 03:02:27'),(463,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:03:27','2022-12-15 03:03:27'),(464,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:04:27','2022-12-15 03:04:27'),(465,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:04:59','2022-12-15 03:04:59'),(466,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:05:59','2022-12-15 03:05:59'),(467,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:06:37','2022-12-15 03:06:37'),(468,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:07:37','2022-12-15 03:07:37'),(469,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:08:37','2022-12-15 03:08:37'),(470,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:09:37','2022-12-15 03:09:37'),(471,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:10:37','2022-12-15 03:10:37'),(472,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:11:37','2022-12-15 03:11:37'),(473,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:12:37','2022-12-15 03:12:37'),(474,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 03:13:37','2022-12-15 03:13:37'),(475,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:14:37','2022-12-15 03:14:37'),(476,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:15:37','2022-12-15 03:15:37'),(477,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:16:37','2022-12-15 03:16:37'),(478,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:17:37','2022-12-15 03:17:37'),(479,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:18:37','2022-12-15 03:18:37'),(480,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:19:37','2022-12-15 03:19:37'),(481,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:20:37','2022-12-15 03:20:37'),(482,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:21:37','2022-12-15 03:21:37'),(483,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:22:37','2022-12-15 03:22:37'),(484,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:23:37','2022-12-15 03:23:37'),(485,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:24:37','2022-12-15 03:24:37'),(486,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:25:37','2022-12-15 03:25:37'),(487,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:26:37','2022-12-15 03:26:37'),(488,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:27:37','2022-12-15 03:27:37'),(489,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:28:37','2022-12-15 03:28:37'),(490,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:29:37','2022-12-15 03:29:37'),(491,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:30:37','2022-12-15 03:30:37'),(492,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:31:37','2022-12-15 03:31:37'),(493,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:32:37','2022-12-15 03:32:37'),(494,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:33:37','2022-12-15 03:33:37'),(495,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:34:37','2022-12-15 03:34:37'),(496,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:35:37','2022-12-15 03:35:37'),(497,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:36:37','2022-12-15 03:36:37'),(498,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:37:37','2022-12-15 03:37:37'),(499,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:38:37','2022-12-15 03:38:37'),(500,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:39:37','2022-12-15 03:39:37'),(501,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:40:37','2022-12-15 03:40:37'),(502,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:41:37','2022-12-15 03:41:37'),(503,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:42:37','2022-12-15 03:42:37'),(504,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:43:37','2022-12-15 03:43:37'),(505,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:44:37','2022-12-15 03:44:37'),(506,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:45:37','2022-12-15 03:45:37'),(507,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:46:37','2022-12-15 03:46:37'),(508,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:47:37','2022-12-15 03:47:37'),(509,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:48:37','2022-12-15 03:48:37'),(510,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 03:49:16','2022-12-15 03:49:16'),(511,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:49:37','2022-12-15 03:49:37'),(512,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:50:37','2022-12-15 03:50:37'),(513,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:51:37','2022-12-15 03:51:37'),(514,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:52:37','2022-12-15 03:52:37'),(515,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:53:37','2022-12-15 03:53:37'),(516,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:54:37','2022-12-15 03:54:37'),(517,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:55:37','2022-12-15 03:55:37'),(518,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:56:37','2022-12-15 03:56:37'),(519,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:57:37','2022-12-15 03:57:37'),(520,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:58:37','2022-12-15 03:58:37'),(521,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 03:59:37','2022-12-15 03:59:37'),(522,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:00:37','2022-12-15 04:00:37'),(523,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:01:37','2022-12-15 04:01:37'),(524,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:02:37','2022-12-15 04:02:37'),(525,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:03:37','2022-12-15 04:03:37'),(526,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:04:37','2022-12-15 04:04:37'),(527,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:05:37','2022-12-15 04:05:37'),(528,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:06:37','2022-12-15 04:06:37'),(529,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:07:37','2022-12-15 04:07:37'),(530,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:08:37','2022-12-15 04:08:37'),(531,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:09:37','2022-12-15 04:09:37'),(532,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:10:37','2022-12-15 04:10:37'),(533,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:11:37','2022-12-15 04:11:37'),(534,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:12:37','2022-12-15 04:12:37'),(535,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:13:37','2022-12-15 04:13:37'),(536,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:14:37','2022-12-15 04:14:37'),(537,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:15:37','2022-12-15 04:15:37'),(538,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:16:37','2022-12-15 04:16:37'),(539,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:17:37','2022-12-15 04:17:37'),(540,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:18:37','2022-12-15 04:18:37'),(541,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:19:37','2022-12-15 04:19:37'),(542,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:20:37','2022-12-15 04:20:37'),(543,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:21:37','2022-12-15 04:21:37'),(544,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:22:37','2022-12-15 04:22:37'),(545,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:23:37','2022-12-15 04:23:37'),(546,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:24:37','2022-12-15 04:24:37'),(547,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:25:37','2022-12-15 04:25:37'),(548,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:26:37','2022-12-15 04:26:37'),(549,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:27:37','2022-12-15 04:27:37'),(550,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:28:37','2022-12-15 04:28:37'),(551,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:29:37','2022-12-15 04:29:37'),(552,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:30:37','2022-12-15 04:30:37'),(553,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:31:37','2022-12-15 04:31:37'),(554,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:32:37','2022-12-15 04:32:37'),(555,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:33:37','2022-12-15 04:33:37'),(556,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:34:37','2022-12-15 04:34:37'),(557,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:35:37','2022-12-15 04:35:37'),(558,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:36:37','2022-12-15 04:36:37'),(559,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:37:37','2022-12-15 04:37:37'),(560,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:38:37','2022-12-15 04:38:37'),(561,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:39:37','2022-12-15 04:39:37'),(562,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:40:37','2022-12-15 04:40:37'),(563,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:41:37','2022-12-15 04:41:37'),(564,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:42:37','2022-12-15 04:42:37'),(565,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:43:37','2022-12-15 04:43:37'),(566,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:44:37','2022-12-15 04:44:37'),(567,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:45:37','2022-12-15 04:45:37'),(568,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:46:37','2022-12-15 04:46:37'),(569,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:47:37','2022-12-15 04:47:37'),(570,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:48:37','2022-12-15 04:48:37'),(571,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 04:49:16','2022-12-15 04:49:16'),(572,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:49:37','2022-12-15 04:49:37'),(573,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:50:37','2022-12-15 04:50:37'),(574,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:51:37','2022-12-15 04:51:37'),(575,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:52:37','2022-12-15 04:52:37'),(576,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:53:37','2022-12-15 04:53:37'),(577,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:54:37','2022-12-15 04:54:37'),(578,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:55:37','2022-12-15 04:55:37'),(579,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:56:37','2022-12-15 04:56:37'),(580,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:57:37','2022-12-15 04:57:37'),(581,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:58:37','2022-12-15 04:58:37'),(582,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 04:59:37','2022-12-15 04:59:37'),(583,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:00:37','2022-12-15 05:00:37'),(584,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:01:37','2022-12-15 05:01:37'),(585,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:02:37','2022-12-15 05:02:37'),(586,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:03:37','2022-12-15 05:03:37'),(587,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:04:37','2022-12-15 05:04:37'),(588,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:05:37','2022-12-15 05:05:37'),(589,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:06:37','2022-12-15 05:06:37'),(590,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:07:37','2022-12-15 05:07:37'),(591,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:08:37','2022-12-15 05:08:37'),(592,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:09:37','2022-12-15 05:09:37'),(593,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:10:37','2022-12-15 05:10:37'),(594,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:11:37','2022-12-15 05:11:37'),(595,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:12:37','2022-12-15 05:12:37'),(596,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:13:37','2022-12-15 05:13:37'),(597,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:14:37','2022-12-15 05:14:37'),(598,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:15:37','2022-12-15 05:15:37'),(599,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:16:37','2022-12-15 05:16:37'),(600,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:17:37','2022-12-15 05:17:37'),(601,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:18:37','2022-12-15 05:18:37'),(602,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:19:37','2022-12-15 05:19:37'),(603,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:20:37','2022-12-15 05:20:37'),(604,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:21:37','2022-12-15 05:21:37'),(605,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:22:37','2022-12-15 05:22:37'),(606,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:23:37','2022-12-15 05:23:37'),(607,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:24:37','2022-12-15 05:24:37'),(608,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:25:37','2022-12-15 05:25:37'),(609,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:26:37','2022-12-15 05:26:37'),(610,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:27:37','2022-12-15 05:27:37'),(611,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:28:37','2022-12-15 05:28:37'),(612,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:29:37','2022-12-15 05:29:37'),(613,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:30:37','2022-12-15 05:30:37'),(614,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:31:37','2022-12-15 05:31:37'),(615,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:32:37','2022-12-15 05:32:37'),(616,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:33:37','2022-12-15 05:33:37'),(617,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:34:37','2022-12-15 05:34:37'),(618,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:35:37','2022-12-15 05:35:37'),(619,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:36:37','2022-12-15 05:36:37'),(620,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:37:37','2022-12-15 05:37:37'),(621,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:38:37','2022-12-15 05:38:37'),(622,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:39:37','2022-12-15 05:39:37'),(623,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:40:37','2022-12-15 05:40:37'),(624,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:41:37','2022-12-15 05:41:37'),(625,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:42:37','2022-12-15 05:42:37'),(626,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:43:37','2022-12-15 05:43:37'),(627,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:44:37','2022-12-15 05:44:37'),(628,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:45:37','2022-12-15 05:45:37'),(629,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:46:37','2022-12-15 05:46:37'),(630,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:47:37','2022-12-15 05:47:37'),(631,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:48:37','2022-12-15 05:48:37'),(632,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 05:49:16','2022-12-15 05:49:16'),(633,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:49:37','2022-12-15 05:49:37'),(634,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:50:37','2022-12-15 05:50:37'),(635,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:51:37','2022-12-15 05:51:37'),(636,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:52:37','2022-12-15 05:52:37'),(637,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:53:37','2022-12-15 05:53:37'),(638,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:54:37','2022-12-15 05:54:37'),(639,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:55:37','2022-12-15 05:55:37'),(640,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:56:37','2022-12-15 05:56:37'),(641,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:57:37','2022-12-15 05:57:37'),(642,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:58:37','2022-12-15 05:58:37'),(643,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 05:59:37','2022-12-15 05:59:37'),(644,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:00:37','2022-12-15 06:00:37'),(645,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:01:37','2022-12-15 06:01:37'),(646,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:02:37','2022-12-15 06:02:37'),(647,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:03:37','2022-12-15 06:03:37'),(648,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:04:37','2022-12-15 06:04:37'),(649,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:05:37','2022-12-15 06:05:37'),(650,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:06:37','2022-12-15 06:06:37'),(651,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:07:37','2022-12-15 06:07:37'),(652,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:08:37','2022-12-15 06:08:37'),(653,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:09:37','2022-12-15 06:09:37'),(654,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:10:37','2022-12-15 06:10:37'),(655,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:11:37','2022-12-15 06:11:37'),(656,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:12:37','2022-12-15 06:12:37'),(657,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:13:37','2022-12-15 06:13:37'),(658,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:14:37','2022-12-15 06:14:37'),(659,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:15:37','2022-12-15 06:15:37'),(660,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:16:37','2022-12-15 06:16:37'),(661,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:17:37','2022-12-15 06:17:37'),(662,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:18:37','2022-12-15 06:18:37'),(663,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:19:37','2022-12-15 06:19:37'),(664,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:20:37','2022-12-15 06:20:37'),(665,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:21:37','2022-12-15 06:21:37'),(666,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:22:37','2022-12-15 06:22:37'),(667,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:23:37','2022-12-15 06:23:37'),(668,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:24:37','2022-12-15 06:24:37'),(669,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:25:37','2022-12-15 06:25:37'),(670,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:26:37','2022-12-15 06:26:37'),(671,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:27:37','2022-12-15 06:27:37'),(672,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:28:37','2022-12-15 06:28:37'),(673,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:29:37','2022-12-15 06:29:37'),(674,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:30:37','2022-12-15 06:30:37'),(675,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:31:37','2022-12-15 06:31:37'),(676,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:32:37','2022-12-15 06:32:37'),(677,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 06:33:37','2022-12-15 06:33:37'),(678,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:34:27','2022-12-15 06:34:27'),(679,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:35:27','2022-12-15 06:35:27'),(680,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:36:27','2022-12-15 06:36:27'),(681,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:37:27','2022-12-15 06:37:27'),(682,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:38:27','2022-12-15 06:38:27'),(683,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:39:27','2022-12-15 06:39:27'),(684,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:40:27','2022-12-15 06:40:27'),(685,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:41:27','2022-12-15 06:41:27'),(686,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:42:27','2022-12-15 06:42:27'),(687,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:43:27','2022-12-15 06:43:27'),(688,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:44:27','2022-12-15 06:44:27'),(689,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:45:27','2022-12-15 06:45:27'),(690,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:46:27','2022-12-15 06:46:27'),(691,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:47:27','2022-12-15 06:47:27'),(692,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:48:27','2022-12-15 06:48:27'),(693,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 06:49:16','2022-12-15 06:49:16'),(694,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:49:27','2022-12-15 06:49:27'),(695,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:50:27','2022-12-15 06:50:27'),(696,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:51:27','2022-12-15 06:51:27'),(697,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:52:27','2022-12-15 06:52:27'),(698,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:53:27','2022-12-15 06:53:27'),(699,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:54:28','2022-12-15 06:54:28'),(700,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:55:27','2022-12-15 06:55:27'),(701,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:56:27','2022-12-15 06:56:27'),(702,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:57:28','2022-12-15 06:57:28'),(703,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:58:27','2022-12-15 06:58:27'),(704,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 06:59:27','2022-12-15 06:59:27'),(705,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:00:27','2022-12-15 07:00:27'),(706,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:01:27','2022-12-15 07:01:27'),(707,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:02:27','2022-12-15 07:02:27'),(708,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:03:27','2022-12-15 07:03:27'),(709,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:04:27','2022-12-15 07:04:27'),(710,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:05:27','2022-12-15 07:05:27'),(711,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:06:27','2022-12-15 07:06:27'),(712,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:07:27','2022-12-15 07:07:27'),(713,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:08:27','2022-12-15 07:08:27'),(714,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:09:27','2022-12-15 07:09:27'),(715,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:10:27','2022-12-15 07:10:27'),(716,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:11:27','2022-12-15 07:11:27'),(717,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:12:27','2022-12-15 07:12:27'),(718,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:13:27','2022-12-15 07:13:27'),(719,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:14:27','2022-12-15 07:14:27'),(720,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:15:27','2022-12-15 07:15:27'),(721,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:16:27','2022-12-15 07:16:27'),(722,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:17:27','2022-12-15 07:17:27'),(723,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:18:27','2022-12-15 07:18:27'),(724,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:19:27','2022-12-15 07:19:27'),(725,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:20:27','2022-12-15 07:20:27'),(726,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:21:27','2022-12-15 07:21:27'),(727,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:22:27','2022-12-15 07:22:27'),(728,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:23:27','2022-12-15 07:23:27'),(729,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:24:27','2022-12-15 07:24:27'),(730,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:25:27','2022-12-15 07:25:27'),(731,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:26:27','2022-12-15 07:26:27'),(732,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:27:27','2022-12-15 07:27:27'),(733,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 07:28:27','2022-12-15 07:28:27'),(734,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:29:27','2022-12-15 07:29:27'),(735,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 07:29:35','2022-12-15 07:29:35'),(736,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 07:49:16','2022-12-15 07:49:16'),(737,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:29:35','2022-12-15 08:29:35'),(738,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:33:10','2022-12-15 08:33:10'),(739,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:34:10','2022-12-15 08:34:10'),(740,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:35:09','2022-12-15 08:35:09'),(741,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:36:09','2022-12-15 08:36:09'),(742,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:37:09','2022-12-15 08:37:09'),(743,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:38:09','2022-12-15 08:38:09'),(744,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:39:09','2022-12-15 08:39:09'),(745,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:40:09','2022-12-15 08:40:09'),(746,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:41:09','2022-12-15 08:41:09'),(747,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:42:09','2022-12-15 08:42:09'),(748,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:43:09','2022-12-15 08:43:09'),(749,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:44:09','2022-12-15 08:44:09'),(750,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:45:09','2022-12-15 08:45:09'),(751,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:46:09','2022-12-15 08:46:09'),(752,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:47:09','2022-12-15 08:47:09'),(753,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:48:09','2022-12-15 08:48:09'),(754,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:49:09','2022-12-15 08:49:09'),(755,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 08:49:16','2022-12-15 08:49:16'),(756,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:50:09','2022-12-15 08:50:09'),(757,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:51:09','2022-12-15 08:51:09'),(758,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:52:09','2022-12-15 08:52:09'),(759,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:53:09','2022-12-15 08:53:09'),(760,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:54:09','2022-12-15 08:54:09'),(761,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:55:09','2022-12-15 08:55:09'),(762,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:56:09','2022-12-15 08:56:09'),(763,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:57:09','2022-12-15 08:57:09'),(764,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:58:09','2022-12-15 08:58:09'),(765,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 08:59:09','2022-12-15 08:59:09'),(766,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:00:09','2022-12-15 09:00:09'),(767,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:01:09','2022-12-15 09:01:09'),(768,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:02:09','2022-12-15 09:02:09'),(769,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:03:09','2022-12-15 09:03:09'),(770,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:04:09','2022-12-15 09:04:09'),(771,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:05:09','2022-12-15 09:05:09'),(772,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:06:09','2022-12-15 09:06:09'),(773,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:07:09','2022-12-15 09:07:09'),(774,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:08:09','2022-12-15 09:08:09'),(775,'02-42-AC-12-00-03','integrate','{\"macAddress\":\"02-42-AC-12-00-03\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:08:15','2022-12-15 09:08:15'),(776,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:09:09','2022-12-15 09:09:09'),(777,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:10:09','2022-12-15 09:10:09'),(778,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:11:09','2022-12-15 09:11:09'),(779,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:12:09','2022-12-15 09:12:09'),(780,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:16:10','2022-12-15 09:16:10'),(781,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:17:09','2022-12-15 09:17:09'),(782,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:18:09','2022-12-15 09:18:09'),(783,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:19:09','2022-12-15 09:19:09'),(784,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:20:09','2022-12-15 09:20:09'),(785,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:21:09','2022-12-15 09:21:09'),(786,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:22:09','2022-12-15 09:22:09'),(787,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:23:09','2022-12-15 09:23:09'),(788,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:24:09','2022-12-15 09:24:09'),(789,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:25:09','2022-12-15 09:25:09'),(790,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:26:09','2022-12-15 09:26:09'),(791,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:27:09','2022-12-15 09:27:09'),(792,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:28:09','2022-12-15 09:28:09'),(793,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:29:09','2022-12-15 09:29:09'),(794,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:29:35','2022-12-15 09:29:35'),(795,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:30:09','2022-12-15 09:30:09'),(796,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:31:09','2022-12-15 09:31:09'),(797,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:32:09','2022-12-15 09:32:09'),(798,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:33:09','2022-12-15 09:33:09'),(799,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:34:09','2022-12-15 09:34:09'),(800,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 09:35:09','2022-12-15 09:35:09'),(801,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:36:35','2022-12-15 09:36:35'),(802,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:37:35','2022-12-15 09:37:35'),(803,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:38:35','2022-12-15 09:38:35'),(804,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:39:35','2022-12-15 09:39:35'),(805,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:40:35','2022-12-15 09:40:35'),(806,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:41:35','2022-12-15 09:41:35'),(807,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:42:35','2022-12-15 09:42:35'),(808,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:43:35','2022-12-15 09:43:35'),(809,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:44:35','2022-12-15 09:44:35'),(810,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:45:35','2022-12-15 09:45:35'),(811,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:46:35','2022-12-15 09:46:35'),(812,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:47:35','2022-12-15 09:47:35'),(813,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:48:35','2022-12-15 09:48:35'),(814,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:49:16','2022-12-15 09:49:16'),(815,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:49:35','2022-12-15 09:49:35'),(816,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:50:35','2022-12-15 09:50:35'),(817,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:51:35','2022-12-15 09:51:35'),(818,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:52:35','2022-12-15 09:52:35'),(819,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:53:35','2022-12-15 09:53:35'),(820,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:54:35','2022-12-15 09:54:35'),(821,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:55:35','2022-12-15 09:55:35'),(822,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:56:35','2022-12-15 09:56:35'),(823,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:57:35','2022-12-15 09:57:35'),(824,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:58:35','2022-12-15 09:58:35'),(825,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 09:59:35','2022-12-15 09:59:35'),(826,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:00:35','2022-12-15 10:00:35'),(827,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:01:35','2022-12-15 10:01:35'),(828,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:02:35','2022-12-15 10:02:35'),(829,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:03:35','2022-12-15 10:03:35'),(830,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:04:35','2022-12-15 10:04:35'),(831,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:05:35','2022-12-15 10:05:35'),(832,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:06:35','2022-12-15 10:06:35'),(833,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:07:35','2022-12-15 10:07:35'),(834,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:08:35','2022-12-15 10:08:35'),(835,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:09:35','2022-12-15 10:09:35'),(836,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:10:35','2022-12-15 10:10:35'),(837,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:11:35','2022-12-15 10:11:35'),(838,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:12:35','2022-12-15 10:12:35'),(839,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:13:35','2022-12-15 10:13:35'),(840,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:14:35','2022-12-15 10:14:35'),(841,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:15:35','2022-12-15 10:15:35'),(842,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:16:35','2022-12-15 10:16:35'),(843,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:17:35','2022-12-15 10:17:35'),(844,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:18:35','2022-12-15 10:18:35'),(845,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:19:35','2022-12-15 10:19:35'),(846,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:20:35','2022-12-15 10:20:35'),(847,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:21:35','2022-12-15 10:21:35'),(848,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:22:35','2022-12-15 10:22:35'),(849,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:23:35','2022-12-15 10:23:35'),(850,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:24:35','2022-12-15 10:24:35'),(851,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:25:35','2022-12-15 10:25:35'),(852,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:26:35','2022-12-15 10:26:35'),(853,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:27:35','2022-12-15 10:27:35'),(854,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:28:35','2022-12-15 10:28:35'),(855,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:29:35','2022-12-15 10:29:35'),(856,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 10:29:35','2022-12-15 10:29:35'),(857,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:30:35','2022-12-15 10:30:35'),(858,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:31:35','2022-12-15 10:31:35'),(859,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:32:35','2022-12-15 10:32:35'),(860,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:33:35','2022-12-15 10:33:35'),(861,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:34:35','2022-12-15 10:34:35'),(862,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:35:35','2022-12-15 10:35:35'),(863,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:36:35','2022-12-15 10:36:35'),(864,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:37:35','2022-12-15 10:37:35'),(865,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:38:35','2022-12-15 10:38:35'),(866,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:39:35','2022-12-15 10:39:35'),(867,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:40:35','2022-12-15 10:40:35'),(868,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:41:35','2022-12-15 10:41:35'),(869,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 10:42:10','2022-12-15 10:42:10'),(870,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:42:35','2022-12-15 10:42:35'),(871,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 10:43:11','2022-12-15 10:43:11'),(872,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:43:35','2022-12-15 10:43:35'),(873,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:44:35','2022-12-15 10:44:35'),(874,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:45:35','2022-12-15 10:45:35'),(875,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:46:35','2022-12-15 10:46:35'),(876,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:47:35','2022-12-15 10:47:35'),(877,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 10:48:07','2022-12-15 10:48:07'),(878,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 10:48:27','2022-12-15 10:48:27'),(879,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:48:35','2022-12-15 10:48:35'),(880,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:49:16','2022-12-15 10:49:16'),(881,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:49:35','2022-12-15 10:49:35'),(882,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:50:35','2022-12-15 10:50:35'),(883,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 10:50:51','2022-12-15 10:50:51'),(884,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:51:35','2022-12-15 10:51:35'),(885,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:52:35','2022-12-15 10:52:35'),(886,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:53:35','2022-12-15 10:53:35'),(887,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:54:35','2022-12-15 10:54:35'),(888,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:55:35','2022-12-15 10:55:35'),(889,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 10:56:04','2022-12-15 10:56:04'),(890,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:56:35','2022-12-15 10:56:35'),(891,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:57:35','2022-12-15 10:57:35'),(892,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 10:58:13','2022-12-15 10:58:13'),(893,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:58:35','2022-12-15 10:58:35'),(894,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 10:59:35','2022-12-15 10:59:35'),(895,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-15 11:00:24','2022-12-15 11:00:24'),(896,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 11:00:35','2022-12-15 11:00:35'),(897,'02-42-AC-13-00-06','null','{\"macAddress\":\"02-42-AC-13-00-06\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 11:01:35','2022-12-15 11:01:35'),(898,'02-42-AC-13-00-07','null','{\"macAddress\":\"02-42-AC-13-00-07\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 11:03:24','2022-12-15 11:03:24'),(899,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:04:16','2022-12-15 11:04:16'),(900,'02-42-AC-13-00-07','null','{\"macAddress\":\"02-42-AC-13-00-07\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 11:04:24','2022-12-15 11:04:24'),(901,'02-42-AC-13-00-07','null','{\"macAddress\":\"02-42-AC-13-00-07\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 11:05:24','2022-12-15 11:05:24'),(902,'02-42-AC-13-00-07','null','{\"macAddress\":\"02-42-AC-13-00-07\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 11:06:24','2022-12-15 11:06:24'),(903,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:07:23','2022-12-15 11:07:23'),(904,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:08:22','2022-12-15 11:08:22'),(905,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:09:22','2022-12-15 11:09:22'),(906,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:10:22','2022-12-15 11:10:22'),(907,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:11:22','2022-12-15 11:11:22'),(908,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:12:22','2022-12-15 11:12:22'),(909,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:13:22','2022-12-15 11:13:22'),(910,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:14:04','2022-12-15 11:14:04'),(911,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:14:22','2022-12-15 11:14:22'),(912,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:15:22','2022-12-15 11:15:22'),(913,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:16:22','2022-12-15 11:16:22'),(914,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:17:22','2022-12-15 11:17:22'),(915,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:18:22','2022-12-15 11:18:22'),(916,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:19:22','2022-12-15 11:19:22'),(917,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:20:22','2022-12-15 11:20:22'),(918,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:21:22','2022-12-15 11:21:22'),(919,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:22:02','2022-12-15 11:22:02'),(920,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:22:22','2022-12-15 11:22:22'),(921,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:23:22','2022-12-15 11:23:22'),(922,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:24:22','2022-12-15 11:24:22'),(923,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:25:22','2022-12-15 11:25:22'),(924,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:26:22','2022-12-15 11:26:22'),(925,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:27:22','2022-12-15 11:27:22'),(926,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:28:22','2022-12-15 11:28:22'),(927,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:29:22','2022-12-15 11:29:22'),(928,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:30:22','2022-12-15 11:30:22'),(929,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:31:22','2022-12-15 11:31:22'),(930,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:32:22','2022-12-15 11:32:22'),(931,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:33:22','2022-12-15 11:33:22'),(932,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:34:22','2022-12-15 11:34:22'),(933,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:35:22','2022-12-15 11:35:22'),(934,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:36:22','2022-12-15 11:36:22'),(935,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:37:22','2022-12-15 11:37:22'),(936,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:38:22','2022-12-15 11:38:22'),(937,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:39:22','2022-12-15 11:39:22'),(938,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:40:22','2022-12-15 11:40:22'),(939,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:41:22','2022-12-15 11:41:22'),(940,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:42:22','2022-12-15 11:42:22'),(941,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:43:22','2022-12-15 11:43:22'),(942,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:44:22','2022-12-15 11:44:22'),(943,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:45:22','2022-12-15 11:45:22'),(944,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:46:22','2022-12-15 11:46:22'),(945,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:47:22','2022-12-15 11:47:22'),(946,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:48:22','2022-12-15 11:48:22'),(947,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 11:49:16','2022-12-15 11:49:16'),(948,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:49:22','2022-12-15 11:49:22'),(949,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:50:22','2022-12-15 11:50:22'),(950,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:51:22','2022-12-15 11:51:22'),(951,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:52:22','2022-12-15 11:52:22'),(952,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:53:22','2022-12-15 11:53:22'),(953,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:54:22','2022-12-15 11:54:22'),(954,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:55:22','2022-12-15 11:55:22'),(955,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:56:22','2022-12-15 11:56:22'),(956,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:57:22','2022-12-15 11:57:22'),(957,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:58:22','2022-12-15 11:58:22'),(958,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 11:59:22','2022-12-15 11:59:22'),(959,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:00:22','2022-12-15 12:00:22'),(960,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:01:22','2022-12-15 12:01:22'),(961,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:02:22','2022-12-15 12:02:22'),(962,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:03:22','2022-12-15 12:03:22'),(963,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:04:22','2022-12-15 12:04:22'),(964,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:05:22','2022-12-15 12:05:22'),(965,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:06:22','2022-12-15 12:06:22'),(966,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:07:22','2022-12-15 12:07:22'),(967,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:08:22','2022-12-15 12:08:22'),(968,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:09:22','2022-12-15 12:09:22'),(969,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:10:22','2022-12-15 12:10:22'),(970,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:11:22','2022-12-15 12:11:22'),(971,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:12:22','2022-12-15 12:12:22'),(972,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:13:22','2022-12-15 12:13:22'),(973,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:14:22','2022-12-15 12:14:22'),(974,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:15:22','2022-12-15 12:15:22'),(975,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:16:22','2022-12-15 12:16:22'),(976,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:17:22','2022-12-15 12:17:22'),(977,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:18:22','2022-12-15 12:18:22'),(978,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:19:22','2022-12-15 12:19:22'),(979,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:20:22','2022-12-15 12:20:22'),(980,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:21:22','2022-12-15 12:21:22'),(981,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:22:01','2022-12-15 12:22:01'),(982,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:22:22','2022-12-15 12:22:22'),(983,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:23:22','2022-12-15 12:23:22'),(984,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:24:22','2022-12-15 12:24:22'),(985,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:25:22','2022-12-15 12:25:22'),(986,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:26:22','2022-12-15 12:26:22'),(987,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:27:22','2022-12-15 12:27:22'),(988,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:28:22','2022-12-15 12:28:22'),(989,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:29:22','2022-12-15 12:29:22'),(990,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:30:22','2022-12-15 12:30:22'),(991,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:31:22','2022-12-15 12:31:22'),(992,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:32:22','2022-12-15 12:32:22'),(993,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:33:22','2022-12-15 12:33:22'),(994,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:34:22','2022-12-15 12:34:22'),(995,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:35:22','2022-12-15 12:35:22'),(996,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:36:22','2022-12-15 12:36:22'),(997,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:37:22','2022-12-15 12:37:22'),(998,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:38:22','2022-12-15 12:38:22'),(999,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:39:22','2022-12-15 12:39:22'),(1000,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:40:22','2022-12-15 12:40:22'),(1001,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:41:22','2022-12-15 12:41:22'),(1002,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:42:22','2022-12-15 12:42:22'),(1003,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:43:22','2022-12-15 12:43:22'),(1004,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:44:22','2022-12-15 12:44:22'),(1005,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:45:22','2022-12-15 12:45:22'),(1006,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:46:22','2022-12-15 12:46:22'),(1007,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:47:22','2022-12-15 12:47:22'),(1008,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:48:22','2022-12-15 12:48:22'),(1009,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 12:49:16','2022-12-15 12:49:16'),(1010,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:49:22','2022-12-15 12:49:22'),(1011,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:50:22','2022-12-15 12:50:22'),(1012,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:51:22','2022-12-15 12:51:22'),(1013,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:52:22','2022-12-15 12:52:22'),(1014,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:53:22','2022-12-15 12:53:22'),(1015,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:54:22','2022-12-15 12:54:22'),(1016,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:55:22','2022-12-15 12:55:22'),(1017,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:56:22','2022-12-15 12:56:22'),(1018,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:57:22','2022-12-15 12:57:22'),(1019,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:58:22','2022-12-15 12:58:22'),(1020,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 12:59:22','2022-12-15 12:59:22'),(1021,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:00:22','2022-12-15 13:00:22'),(1022,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:01:22','2022-12-15 13:01:22'),(1023,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:02:22','2022-12-15 13:02:22'),(1024,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:03:22','2022-12-15 13:03:22'),(1025,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:04:22','2022-12-15 13:04:22'),(1026,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:05:22','2022-12-15 13:05:22'),(1027,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:06:22','2022-12-15 13:06:22'),(1028,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:07:22','2022-12-15 13:07:22'),(1029,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:08:22','2022-12-15 13:08:22'),(1030,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:09:22','2022-12-15 13:09:22'),(1031,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:10:22','2022-12-15 13:10:22'),(1032,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:11:22','2022-12-15 13:11:22'),(1033,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:12:22','2022-12-15 13:12:22'),(1034,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:13:22','2022-12-15 13:13:22'),(1035,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:14:22','2022-12-15 13:14:22'),(1036,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:15:22','2022-12-15 13:15:22'),(1037,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:16:22','2022-12-15 13:16:22'),(1038,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:17:22','2022-12-15 13:17:22'),(1039,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:18:22','2022-12-15 13:18:22'),(1040,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:19:22','2022-12-15 13:19:22'),(1041,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:20:22','2022-12-15 13:20:22'),(1042,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:21:22','2022-12-15 13:21:22'),(1043,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:22:01','2022-12-15 13:22:01'),(1044,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:22:22','2022-12-15 13:22:22'),(1045,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:23:22','2022-12-15 13:23:22'),(1046,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:24:22','2022-12-15 13:24:22'),(1047,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:25:22','2022-12-15 13:25:22'),(1048,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:26:22','2022-12-15 13:26:22'),(1049,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:27:22','2022-12-15 13:27:22'),(1050,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:28:22','2022-12-15 13:28:22'),(1051,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:29:22','2022-12-15 13:29:22'),(1052,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:30:22','2022-12-15 13:30:22'),(1053,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:31:22','2022-12-15 13:31:22'),(1054,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:32:22','2022-12-15 13:32:22'),(1055,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:33:22','2022-12-15 13:33:22'),(1056,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:34:22','2022-12-15 13:34:22'),(1057,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:35:22','2022-12-15 13:35:22'),(1058,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:36:22','2022-12-15 13:36:22'),(1059,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:37:22','2022-12-15 13:37:22'),(1060,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:38:22','2022-12-15 13:38:22'),(1061,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:39:22','2022-12-15 13:39:22'),(1062,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:40:22','2022-12-15 13:40:22'),(1063,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:41:22','2022-12-15 13:41:22'),(1064,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:42:22','2022-12-15 13:42:22'),(1065,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:43:22','2022-12-15 13:43:22'),(1066,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:44:22','2022-12-15 13:44:22'),(1067,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:45:22','2022-12-15 13:45:22'),(1068,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:46:22','2022-12-15 13:46:22'),(1069,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:47:22','2022-12-15 13:47:22'),(1070,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:48:22','2022-12-15 13:48:22'),(1071,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 13:49:16','2022-12-15 13:49:16'),(1072,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:49:22','2022-12-15 13:49:22'),(1073,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:50:22','2022-12-15 13:50:22'),(1074,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:51:22','2022-12-15 13:51:22'),(1075,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:52:22','2022-12-15 13:52:22'),(1076,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:53:22','2022-12-15 13:53:22'),(1077,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:54:22','2022-12-15 13:54:22'),(1078,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:55:22','2022-12-15 13:55:22'),(1079,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:56:22','2022-12-15 13:56:22'),(1080,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:57:22','2022-12-15 13:57:22'),(1081,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:58:22','2022-12-15 13:58:22'),(1082,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 13:59:22','2022-12-15 13:59:22'),(1083,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:00:22','2022-12-15 14:00:22'),(1084,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:01:22','2022-12-15 14:01:22'),(1085,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:02:22','2022-12-15 14:02:22'),(1086,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:03:22','2022-12-15 14:03:22'),(1087,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:04:22','2022-12-15 14:04:22'),(1088,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:05:22','2022-12-15 14:05:22'),(1089,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:06:22','2022-12-15 14:06:22'),(1090,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:07:22','2022-12-15 14:07:22'),(1091,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:08:31','2022-12-15 14:08:31'),(1092,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:09:31','2022-12-15 14:09:31'),(1093,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:10:31','2022-12-15 14:10:31'),(1094,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:11:31','2022-12-15 14:11:31'),(1095,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:12:31','2022-12-15 14:12:31'),(1096,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:13:31','2022-12-15 14:13:31'),(1097,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:14:31','2022-12-15 14:14:31'),(1098,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:15:31','2022-12-15 14:15:31'),(1099,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:16:31','2022-12-15 14:16:31'),(1100,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:17:31','2022-12-15 14:17:31'),(1101,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:18:31','2022-12-15 14:18:31'),(1102,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:19:31','2022-12-15 14:19:31'),(1103,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:20:31','2022-12-15 14:20:31'),(1104,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:21:31','2022-12-15 14:21:31'),(1105,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:22:01','2022-12-15 14:22:01'),(1106,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:22:31','2022-12-15 14:22:31'),(1107,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:23:31','2022-12-15 14:23:31'),(1108,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:24:31','2022-12-15 14:24:31'),(1109,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:25:31','2022-12-15 14:25:31'),(1110,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:26:31','2022-12-15 14:26:31'),(1111,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:27:31','2022-12-15 14:27:31'),(1112,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:28:31','2022-12-15 14:28:31'),(1113,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:29:31','2022-12-15 14:29:31'),(1114,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:30:31','2022-12-15 14:30:31'),(1115,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:31:31','2022-12-15 14:31:31'),(1116,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:32:31','2022-12-15 14:32:31'),(1117,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:33:31','2022-12-15 14:33:31'),(1118,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:34:31','2022-12-15 14:34:31'),(1119,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:35:31','2022-12-15 14:35:31'),(1120,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:36:31','2022-12-15 14:36:31'),(1121,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:37:31','2022-12-15 14:37:31'),(1122,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:38:31','2022-12-15 14:38:31'),(1123,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:39:31','2022-12-15 14:39:31'),(1124,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:40:31','2022-12-15 14:40:31'),(1125,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:41:31','2022-12-15 14:41:31'),(1126,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:42:31','2022-12-15 14:42:31'),(1127,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:43:31','2022-12-15 14:43:31'),(1128,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:44:31','2022-12-15 14:44:31'),(1129,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:45:31','2022-12-15 14:45:31'),(1130,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:46:31','2022-12-15 14:46:31'),(1131,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:47:31','2022-12-15 14:47:31'),(1132,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:48:31','2022-12-15 14:48:31'),(1133,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 14:49:16','2022-12-15 14:49:16'),(1134,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:49:31','2022-12-15 14:49:31'),(1135,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:50:31','2022-12-15 14:50:31'),(1136,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:51:31','2022-12-15 14:51:31'),(1137,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:52:31','2022-12-15 14:52:31'),(1138,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:53:31','2022-12-15 14:53:31'),(1139,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:54:31','2022-12-15 14:54:31'),(1140,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:55:31','2022-12-15 14:55:31'),(1141,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:56:31','2022-12-15 14:56:31'),(1142,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:57:31','2022-12-15 14:57:31'),(1143,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:58:31','2022-12-15 14:58:31'),(1144,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 14:59:31','2022-12-15 14:59:31'),(1145,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:00:31','2022-12-15 15:00:31'),(1146,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:01:31','2022-12-15 15:01:31'),(1147,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:02:31','2022-12-15 15:02:31'),(1148,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:03:31','2022-12-15 15:03:31'),(1149,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:04:31','2022-12-15 15:04:31'),(1150,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:05:31','2022-12-15 15:05:31'),(1151,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:06:31','2022-12-15 15:06:31'),(1152,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:07:31','2022-12-15 15:07:31'),(1153,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:08:31','2022-12-15 15:08:31'),(1154,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:09:31','2022-12-15 15:09:31'),(1155,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:10:31','2022-12-15 15:10:31'),(1156,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:11:31','2022-12-15 15:11:31'),(1157,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:12:31','2022-12-15 15:12:31'),(1158,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:13:31','2022-12-15 15:13:31'),(1159,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:14:31','2022-12-15 15:14:31'),(1160,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:15:31','2022-12-15 15:15:31'),(1161,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:16:31','2022-12-15 15:16:31'),(1162,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:17:31','2022-12-15 15:17:31'),(1163,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:18:31','2022-12-15 15:18:31'),(1164,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:19:31','2022-12-15 15:19:31'),(1165,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:20:31','2022-12-15 15:20:31'),(1166,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:21:31','2022-12-15 15:21:31'),(1167,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:22:01','2022-12-15 15:22:01'),(1168,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:22:31','2022-12-15 15:22:31'),(1169,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:23:31','2022-12-15 15:23:31'),(1170,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:24:31','2022-12-15 15:24:31'),(1171,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:25:31','2022-12-15 15:25:31'),(1172,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:26:31','2022-12-15 15:26:31'),(1173,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:27:31','2022-12-15 15:27:31'),(1174,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:28:31','2022-12-15 15:28:31'),(1175,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:29:31','2022-12-15 15:29:31'),(1176,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:30:31','2022-12-15 15:30:31'),(1177,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:31:31','2022-12-15 15:31:31'),(1178,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:32:31','2022-12-15 15:32:31'),(1179,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:33:31','2022-12-15 15:33:31'),(1180,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:34:31','2022-12-15 15:34:31'),(1181,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:35:31','2022-12-15 15:35:31'),(1182,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:36:31','2022-12-15 15:36:31'),(1183,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:37:31','2022-12-15 15:37:31'),(1184,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:38:31','2022-12-15 15:38:31'),(1185,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:39:31','2022-12-15 15:39:31'),(1186,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:40:31','2022-12-15 15:40:31'),(1187,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:41:31','2022-12-15 15:41:31'),(1188,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:42:31','2022-12-15 15:42:31'),(1189,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:43:31','2022-12-15 15:43:31'),(1190,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:44:31','2022-12-15 15:44:31'),(1191,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:45:31','2022-12-15 15:45:31'),(1192,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:46:31','2022-12-15 15:46:31'),(1193,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:47:31','2022-12-15 15:47:31'),(1194,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:48:31','2022-12-15 15:48:31'),(1195,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 15:49:16','2022-12-15 15:49:16'),(1196,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:49:31','2022-12-15 15:49:31'),(1197,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:50:31','2022-12-15 15:50:31'),(1198,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:51:31','2022-12-15 15:51:31'),(1199,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:52:31','2022-12-15 15:52:31'),(1200,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:53:31','2022-12-15 15:53:31'),(1201,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:54:31','2022-12-15 15:54:31'),(1202,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:55:31','2022-12-15 15:55:31'),(1203,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:56:31','2022-12-15 15:56:31'),(1204,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:57:31','2022-12-15 15:57:31'),(1205,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:58:31','2022-12-15 15:58:31'),(1206,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 15:59:31','2022-12-15 15:59:31'),(1207,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:00:31','2022-12-15 16:00:31'),(1208,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:01:31','2022-12-15 16:01:31'),(1209,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:02:31','2022-12-15 16:02:31'),(1210,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:03:31','2022-12-15 16:03:31'),(1211,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:04:31','2022-12-15 16:04:31'),(1212,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:05:31','2022-12-15 16:05:31'),(1213,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:06:31','2022-12-15 16:06:31'),(1214,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:07:31','2022-12-15 16:07:31'),(1215,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:08:31','2022-12-15 16:08:31'),(1216,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:09:31','2022-12-15 16:09:31'),(1217,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:10:31','2022-12-15 16:10:31'),(1218,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:11:31','2022-12-15 16:11:31'),(1219,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:12:31','2022-12-15 16:12:31'),(1220,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:13:31','2022-12-15 16:13:31'),(1221,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:14:31','2022-12-15 16:14:31'),(1222,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:15:31','2022-12-15 16:15:31'),(1223,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:16:31','2022-12-15 16:16:31'),(1224,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:17:31','2022-12-15 16:17:31'),(1225,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:18:31','2022-12-15 16:18:31'),(1226,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:19:31','2022-12-15 16:19:31'),(1227,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:20:31','2022-12-15 16:20:31'),(1228,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:21:31','2022-12-15 16:21:31'),(1229,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:22:01','2022-12-15 16:22:01'),(1230,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:22:31','2022-12-15 16:22:31'),(1231,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:23:31','2022-12-15 16:23:31'),(1232,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:24:31','2022-12-15 16:24:31'),(1233,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:25:31','2022-12-15 16:25:31'),(1234,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:26:31','2022-12-15 16:26:31'),(1235,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:27:31','2022-12-15 16:27:31'),(1236,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:28:31','2022-12-15 16:28:31'),(1237,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:29:31','2022-12-15 16:29:31'),(1238,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:30:31','2022-12-15 16:30:31'),(1239,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:31:31','2022-12-15 16:31:31'),(1240,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:32:31','2022-12-15 16:32:31'),(1241,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:33:31','2022-12-15 16:33:31'),(1242,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:34:31','2022-12-15 16:34:31'),(1243,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:35:31','2022-12-15 16:35:31'),(1244,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:36:31','2022-12-15 16:36:31'),(1245,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:37:31','2022-12-15 16:37:31'),(1246,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:38:31','2022-12-15 16:38:31'),(1247,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:39:31','2022-12-15 16:39:31'),(1248,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:40:31','2022-12-15 16:40:31'),(1249,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:41:31','2022-12-15 16:41:31'),(1250,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:42:31','2022-12-15 16:42:31'),(1251,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:43:31','2022-12-15 16:43:31'),(1252,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:44:31','2022-12-15 16:44:31'),(1253,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:45:31','2022-12-15 16:45:31'),(1254,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:46:31','2022-12-15 16:46:31'),(1255,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:47:31','2022-12-15 16:47:31'),(1256,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:48:31','2022-12-15 16:48:31'),(1257,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 16:49:16','2022-12-15 16:49:16'),(1258,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:49:31','2022-12-15 16:49:31'),(1259,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:50:31','2022-12-15 16:50:31'),(1260,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:51:31','2022-12-15 16:51:31'),(1261,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:52:31','2022-12-15 16:52:31'),(1262,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:53:31','2022-12-15 16:53:31'),(1263,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:54:31','2022-12-15 16:54:31'),(1264,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:55:31','2022-12-15 16:55:31'),(1265,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:56:31','2022-12-15 16:56:31'),(1266,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:57:31','2022-12-15 16:57:31'),(1267,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:58:31','2022-12-15 16:58:31'),(1268,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 16:59:31','2022-12-15 16:59:31'),(1269,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:00:31','2022-12-15 17:00:31'),(1270,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:01:31','2022-12-15 17:01:31'),(1271,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:02:31','2022-12-15 17:02:31'),(1272,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:03:31','2022-12-15 17:03:31'),(1273,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:04:31','2022-12-15 17:04:31'),(1274,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:05:31','2022-12-15 17:05:31'),(1275,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:06:31','2022-12-15 17:06:31'),(1276,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:07:31','2022-12-15 17:07:31'),(1277,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:08:31','2022-12-15 17:08:31'),(1278,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:09:31','2022-12-15 17:09:31'),(1279,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:10:31','2022-12-15 17:10:31'),(1280,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:11:31','2022-12-15 17:11:31'),(1281,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:12:31','2022-12-15 17:12:31'),(1282,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:13:31','2022-12-15 17:13:31'),(1283,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:14:31','2022-12-15 17:14:31'),(1284,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:15:31','2022-12-15 17:15:31'),(1285,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:16:31','2022-12-15 17:16:31'),(1286,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:17:31','2022-12-15 17:17:31'),(1287,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:18:31','2022-12-15 17:18:31'),(1288,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:19:31','2022-12-15 17:19:31'),(1289,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:20:31','2022-12-15 17:20:31'),(1290,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:21:31','2022-12-15 17:21:31'),(1291,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:22:02','2022-12-15 17:22:02'),(1292,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:22:31','2022-12-15 17:22:31'),(1293,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:23:31','2022-12-15 17:23:31'),(1294,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:24:31','2022-12-15 17:24:31'),(1295,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:25:31','2022-12-15 17:25:31'),(1296,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:26:31','2022-12-15 17:26:31'),(1297,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:27:31','2022-12-15 17:27:31'),(1298,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:28:31','2022-12-15 17:28:31'),(1299,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:29:31','2022-12-15 17:29:31'),(1300,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:30:31','2022-12-15 17:30:31'),(1301,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:31:31','2022-12-15 17:31:31'),(1302,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:32:31','2022-12-15 17:32:31'),(1303,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:33:31','2022-12-15 17:33:31'),(1304,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:34:31','2022-12-15 17:34:31'),(1305,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:35:31','2022-12-15 17:35:31'),(1306,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:36:31','2022-12-15 17:36:31'),(1307,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:37:31','2022-12-15 17:37:31'),(1308,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:38:31','2022-12-15 17:38:31'),(1309,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:39:31','2022-12-15 17:39:31'),(1310,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:40:31','2022-12-15 17:40:31'),(1311,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:41:31','2022-12-15 17:41:31'),(1312,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:42:31','2022-12-15 17:42:31'),(1313,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:43:31','2022-12-15 17:43:31'),(1314,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:44:31','2022-12-15 17:44:31'),(1315,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:45:31','2022-12-15 17:45:31'),(1316,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:46:31','2022-12-15 17:46:31'),(1317,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:47:31','2022-12-15 17:47:31'),(1318,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:48:31','2022-12-15 17:48:31'),(1319,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 17:49:16','2022-12-15 17:49:16'),(1320,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:49:31','2022-12-15 17:49:31'),(1321,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:50:31','2022-12-15 17:50:31'),(1322,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:51:31','2022-12-15 17:51:31'),(1323,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:52:31','2022-12-15 17:52:31'),(1324,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:53:31','2022-12-15 17:53:31'),(1325,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:54:31','2022-12-15 17:54:31'),(1326,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:55:31','2022-12-15 17:55:31'),(1327,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:56:31','2022-12-15 17:56:31'),(1328,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:57:31','2022-12-15 17:57:31'),(1329,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:58:31','2022-12-15 17:58:31'),(1330,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 17:59:31','2022-12-15 17:59:31'),(1331,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:00:31','2022-12-15 18:00:31'),(1332,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:01:31','2022-12-15 18:01:31'),(1333,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:02:31','2022-12-15 18:02:31'),(1334,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:03:31','2022-12-15 18:03:31'),(1335,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:04:31','2022-12-15 18:04:31'),(1336,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:05:31','2022-12-15 18:05:31'),(1337,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:06:31','2022-12-15 18:06:31'),(1338,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:07:31','2022-12-15 18:07:31'),(1339,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:08:31','2022-12-15 18:08:31'),(1340,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:09:31','2022-12-15 18:09:31'),(1341,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:10:31','2022-12-15 18:10:31'),(1342,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:11:31','2022-12-15 18:11:31'),(1343,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:12:31','2022-12-15 18:12:31'),(1344,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:13:31','2022-12-15 18:13:31'),(1345,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:14:31','2022-12-15 18:14:31'),(1346,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:15:31','2022-12-15 18:15:31'),(1347,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:16:31','2022-12-15 18:16:31'),(1348,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:17:31','2022-12-15 18:17:31'),(1349,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:18:31','2022-12-15 18:18:31'),(1350,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:19:31','2022-12-15 18:19:31'),(1351,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:20:31','2022-12-15 18:20:31'),(1352,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:21:31','2022-12-15 18:21:31'),(1353,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:22:01','2022-12-15 18:22:01'),(1354,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:22:31','2022-12-15 18:22:31'),(1355,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:23:31','2022-12-15 18:23:31'),(1356,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:24:31','2022-12-15 18:24:31'),(1357,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:25:31','2022-12-15 18:25:31'),(1358,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:26:31','2022-12-15 18:26:31'),(1359,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:27:31','2022-12-15 18:27:31'),(1360,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:28:31','2022-12-15 18:28:31'),(1361,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:29:31','2022-12-15 18:29:31'),(1362,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:30:31','2022-12-15 18:30:31'),(1363,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:31:31','2022-12-15 18:31:31'),(1364,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:32:31','2022-12-15 18:32:31'),(1365,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:33:31','2022-12-15 18:33:31'),(1366,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:34:31','2022-12-15 18:34:31'),(1367,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:35:31','2022-12-15 18:35:31'),(1368,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:36:31','2022-12-15 18:36:31'),(1369,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:37:31','2022-12-15 18:37:31'),(1370,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:38:31','2022-12-15 18:38:31'),(1371,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:39:31','2022-12-15 18:39:31'),(1372,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:40:31','2022-12-15 18:40:31'),(1373,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:41:31','2022-12-15 18:41:31'),(1374,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:42:31','2022-12-15 18:42:31'),(1375,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:43:31','2022-12-15 18:43:31'),(1376,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:44:31','2022-12-15 18:44:31'),(1377,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:45:31','2022-12-15 18:45:31'),(1378,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:46:31','2022-12-15 18:46:31'),(1379,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:47:31','2022-12-15 18:47:31'),(1380,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:48:31','2022-12-15 18:48:31'),(1381,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 18:49:16','2022-12-15 18:49:16'),(1382,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:49:31','2022-12-15 18:49:31'),(1383,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:50:31','2022-12-15 18:50:31'),(1384,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:51:31','2022-12-15 18:51:31'),(1385,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:52:31','2022-12-15 18:52:31'),(1386,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:53:31','2022-12-15 18:53:31'),(1387,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:54:31','2022-12-15 18:54:31'),(1388,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:55:31','2022-12-15 18:55:31'),(1389,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:56:31','2022-12-15 18:56:31'),(1390,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:57:31','2022-12-15 18:57:31'),(1391,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:58:31','2022-12-15 18:58:31'),(1392,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 18:59:31','2022-12-15 18:59:31'),(1393,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:00:31','2022-12-15 19:00:31'),(1394,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:01:31','2022-12-15 19:01:31'),(1395,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:02:31','2022-12-15 19:02:31'),(1396,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:03:31','2022-12-15 19:03:31'),(1397,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:04:31','2022-12-15 19:04:31'),(1398,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:05:31','2022-12-15 19:05:31'),(1399,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:06:31','2022-12-15 19:06:31'),(1400,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:07:31','2022-12-15 19:07:31'),(1401,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:08:31','2022-12-15 19:08:31'),(1402,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:09:31','2022-12-15 19:09:31'),(1403,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:10:31','2022-12-15 19:10:31'),(1404,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:11:31','2022-12-15 19:11:31'),(1405,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:12:31','2022-12-15 19:12:31'),(1406,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:13:31','2022-12-15 19:13:31'),(1407,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:14:31','2022-12-15 19:14:31'),(1408,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:15:31','2022-12-15 19:15:31'),(1409,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:16:31','2022-12-15 19:16:31'),(1410,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:17:31','2022-12-15 19:17:31'),(1411,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:18:31','2022-12-15 19:18:31'),(1412,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:19:31','2022-12-15 19:19:31'),(1413,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:20:31','2022-12-15 19:20:31'),(1414,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:21:31','2022-12-15 19:21:31'),(1415,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:22:01','2022-12-15 19:22:01'),(1416,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:22:31','2022-12-15 19:22:31'),(1417,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:23:31','2022-12-15 19:23:31'),(1418,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:24:31','2022-12-15 19:24:31'),(1419,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:25:31','2022-12-15 19:25:31'),(1420,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:26:31','2022-12-15 19:26:31'),(1421,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:27:31','2022-12-15 19:27:31'),(1422,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:28:31','2022-12-15 19:28:31'),(1423,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:29:31','2022-12-15 19:29:31'),(1424,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:30:31','2022-12-15 19:30:31'),(1425,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:31:31','2022-12-15 19:31:31'),(1426,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:32:31','2022-12-15 19:32:31'),(1427,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:33:31','2022-12-15 19:33:31'),(1428,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:34:31','2022-12-15 19:34:31'),(1429,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:35:31','2022-12-15 19:35:31'),(1430,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:36:31','2022-12-15 19:36:31'),(1431,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:37:31','2022-12-15 19:37:31'),(1432,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:38:31','2022-12-15 19:38:31'),(1433,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:39:31','2022-12-15 19:39:31'),(1434,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:40:31','2022-12-15 19:40:31'),(1435,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:41:31','2022-12-15 19:41:31'),(1436,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:42:31','2022-12-15 19:42:31'),(1437,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:43:31','2022-12-15 19:43:31'),(1438,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:44:31','2022-12-15 19:44:31'),(1439,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:45:31','2022-12-15 19:45:31'),(1440,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:46:31','2022-12-15 19:46:31'),(1441,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:47:31','2022-12-15 19:47:31'),(1442,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:48:31','2022-12-15 19:48:31'),(1443,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 19:49:16','2022-12-15 19:49:16'),(1444,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:49:31','2022-12-15 19:49:31'),(1445,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:50:31','2022-12-15 19:50:31'),(1446,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:51:31','2022-12-15 19:51:31'),(1447,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:52:31','2022-12-15 19:52:31'),(1448,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:53:31','2022-12-15 19:53:31'),(1449,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:54:31','2022-12-15 19:54:31'),(1450,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:55:31','2022-12-15 19:55:31'),(1451,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:56:31','2022-12-15 19:56:31'),(1452,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:57:31','2022-12-15 19:57:31'),(1453,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:58:31','2022-12-15 19:58:31'),(1454,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 19:59:31','2022-12-15 19:59:31'),(1455,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:00:31','2022-12-15 20:00:31'),(1456,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:01:31','2022-12-15 20:01:31'),(1457,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:02:31','2022-12-15 20:02:31'),(1458,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:03:31','2022-12-15 20:03:31'),(1459,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:04:31','2022-12-15 20:04:31'),(1460,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:05:31','2022-12-15 20:05:31'),(1461,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:06:31','2022-12-15 20:06:31'),(1462,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:07:31','2022-12-15 20:07:31'),(1463,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:08:31','2022-12-15 20:08:31'),(1464,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:09:31','2022-12-15 20:09:31'),(1465,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:10:31','2022-12-15 20:10:31'),(1466,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:11:31','2022-12-15 20:11:31'),(1467,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:12:31','2022-12-15 20:12:31'),(1468,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:13:31','2022-12-15 20:13:31'),(1469,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:14:31','2022-12-15 20:14:31'),(1470,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:15:31','2022-12-15 20:15:31'),(1471,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:16:31','2022-12-15 20:16:31'),(1472,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:17:31','2022-12-15 20:17:31'),(1473,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:18:31','2022-12-15 20:18:31'),(1474,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:19:31','2022-12-15 20:19:31'),(1475,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:20:31','2022-12-15 20:20:31'),(1476,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:21:31','2022-12-15 20:21:31'),(1477,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:22:01','2022-12-15 20:22:01'),(1478,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:22:31','2022-12-15 20:22:31'),(1479,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:23:31','2022-12-15 20:23:31'),(1480,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:24:31','2022-12-15 20:24:31'),(1481,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:25:31','2022-12-15 20:25:31'),(1482,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:26:31','2022-12-15 20:26:31'),(1483,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:27:31','2022-12-15 20:27:31'),(1484,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:28:31','2022-12-15 20:28:31'),(1485,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:29:31','2022-12-15 20:29:31'),(1486,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:30:31','2022-12-15 20:30:31'),(1487,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:31:31','2022-12-15 20:31:31'),(1488,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:32:31','2022-12-15 20:32:31'),(1489,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:33:31','2022-12-15 20:33:31'),(1490,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:34:31','2022-12-15 20:34:31'),(1491,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:35:31','2022-12-15 20:35:31'),(1492,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:36:31','2022-12-15 20:36:31'),(1493,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:37:31','2022-12-15 20:37:31'),(1494,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:38:31','2022-12-15 20:38:31'),(1495,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:39:31','2022-12-15 20:39:31'),(1496,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:40:31','2022-12-15 20:40:31'),(1497,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:41:31','2022-12-15 20:41:31'),(1498,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:42:31','2022-12-15 20:42:31'),(1499,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:43:31','2022-12-15 20:43:31'),(1500,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:44:31','2022-12-15 20:44:31'),(1501,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:45:31','2022-12-15 20:45:31'),(1502,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:46:31','2022-12-15 20:46:31'),(1503,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:47:31','2022-12-15 20:47:31'),(1504,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:48:31','2022-12-15 20:48:31'),(1505,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 20:49:16','2022-12-15 20:49:16'),(1506,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:49:31','2022-12-15 20:49:31'),(1507,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:50:31','2022-12-15 20:50:31'),(1508,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:51:31','2022-12-15 20:51:31'),(1509,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:52:31','2022-12-15 20:52:31'),(1510,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:53:31','2022-12-15 20:53:31'),(1511,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:54:31','2022-12-15 20:54:31'),(1512,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:55:31','2022-12-15 20:55:31'),(1513,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:56:31','2022-12-15 20:56:31'),(1514,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:57:31','2022-12-15 20:57:31'),(1515,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:58:31','2022-12-15 20:58:31'),(1516,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 20:59:31','2022-12-15 20:59:31'),(1517,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:00:31','2022-12-15 21:00:31'),(1518,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:01:31','2022-12-15 21:01:31'),(1519,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:02:31','2022-12-15 21:02:31'),(1520,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:03:31','2022-12-15 21:03:31'),(1521,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:04:31','2022-12-15 21:04:31'),(1522,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:05:31','2022-12-15 21:05:31'),(1523,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:06:31','2022-12-15 21:06:31'),(1524,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:07:31','2022-12-15 21:07:31'),(1525,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:08:31','2022-12-15 21:08:31'),(1526,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:09:31','2022-12-15 21:09:31'),(1527,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:10:31','2022-12-15 21:10:31'),(1528,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:11:31','2022-12-15 21:11:31'),(1529,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:12:31','2022-12-15 21:12:31'),(1530,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:13:31','2022-12-15 21:13:31'),(1531,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:14:31','2022-12-15 21:14:31'),(1532,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:15:31','2022-12-15 21:15:31'),(1533,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:16:31','2022-12-15 21:16:31'),(1534,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:17:31','2022-12-15 21:17:31'),(1535,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:18:31','2022-12-15 21:18:31'),(1536,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:19:31','2022-12-15 21:19:31'),(1537,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:20:31','2022-12-15 21:20:31'),(1538,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:21:31','2022-12-15 21:21:31'),(1539,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:22:01','2022-12-15 21:22:01'),(1540,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:22:31','2022-12-15 21:22:31'),(1541,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:23:31','2022-12-15 21:23:31'),(1542,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:24:31','2022-12-15 21:24:31'),(1543,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:25:31','2022-12-15 21:25:31'),(1544,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:26:31','2022-12-15 21:26:31'),(1545,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:27:31','2022-12-15 21:27:31'),(1546,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:28:31','2022-12-15 21:28:31'),(1547,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:29:31','2022-12-15 21:29:31'),(1548,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:30:31','2022-12-15 21:30:31'),(1549,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:31:31','2022-12-15 21:31:31'),(1550,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:32:31','2022-12-15 21:32:31'),(1551,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:33:31','2022-12-15 21:33:31'),(1552,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:34:31','2022-12-15 21:34:31'),(1553,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:35:31','2022-12-15 21:35:31'),(1554,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:36:31','2022-12-15 21:36:31'),(1555,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:37:31','2022-12-15 21:37:31'),(1556,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:38:31','2022-12-15 21:38:31'),(1557,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:39:31','2022-12-15 21:39:31'),(1558,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:40:31','2022-12-15 21:40:31'),(1559,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:41:31','2022-12-15 21:41:31'),(1560,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:42:31','2022-12-15 21:42:31'),(1561,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:43:31','2022-12-15 21:43:31'),(1562,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:44:31','2022-12-15 21:44:31'),(1563,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:45:31','2022-12-15 21:45:31'),(1564,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:46:31','2022-12-15 21:46:31'),(1565,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:47:31','2022-12-15 21:47:31'),(1566,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:48:31','2022-12-15 21:48:31'),(1567,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 21:49:16','2022-12-15 21:49:16'),(1568,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:49:31','2022-12-15 21:49:31'),(1569,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:50:31','2022-12-15 21:50:31'),(1570,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:51:31','2022-12-15 21:51:31'),(1571,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:52:31','2022-12-15 21:52:31'),(1572,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:53:31','2022-12-15 21:53:31'),(1573,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:54:31','2022-12-15 21:54:31'),(1574,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:55:31','2022-12-15 21:55:31'),(1575,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:56:31','2022-12-15 21:56:31'),(1576,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:57:31','2022-12-15 21:57:31'),(1577,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:58:31','2022-12-15 21:58:31'),(1578,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 21:59:31','2022-12-15 21:59:31'),(1579,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:00:31','2022-12-15 22:00:31'),(1580,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:01:31','2022-12-15 22:01:31'),(1581,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:02:31','2022-12-15 22:02:31'),(1582,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:03:31','2022-12-15 22:03:31'),(1583,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:04:31','2022-12-15 22:04:31'),(1584,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:05:31','2022-12-15 22:05:31'),(1585,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:06:31','2022-12-15 22:06:31'),(1586,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:07:31','2022-12-15 22:07:31'),(1587,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:08:31','2022-12-15 22:08:31'),(1588,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:09:31','2022-12-15 22:09:31'),(1589,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:10:31','2022-12-15 22:10:31'),(1590,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:11:31','2022-12-15 22:11:31'),(1591,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:12:31','2022-12-15 22:12:31'),(1592,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:13:31','2022-12-15 22:13:31'),(1593,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:14:31','2022-12-15 22:14:31'),(1594,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:15:31','2022-12-15 22:15:31'),(1595,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:16:31','2022-12-15 22:16:31'),(1596,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:17:31','2022-12-15 22:17:31'),(1597,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:18:31','2022-12-15 22:18:31'),(1598,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:19:31','2022-12-15 22:19:31'),(1599,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:20:31','2022-12-15 22:20:31'),(1600,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:21:31','2022-12-15 22:21:31'),(1601,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:22:01','2022-12-15 22:22:01'),(1602,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:22:31','2022-12-15 22:22:31'),(1603,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:23:31','2022-12-15 22:23:31'),(1604,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:24:31','2022-12-15 22:24:31'),(1605,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:25:31','2022-12-15 22:25:31'),(1606,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:26:31','2022-12-15 22:26:31'),(1607,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:27:31','2022-12-15 22:27:31'),(1608,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:28:31','2022-12-15 22:28:31'),(1609,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:29:31','2022-12-15 22:29:31'),(1610,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:30:31','2022-12-15 22:30:31'),(1611,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:31:31','2022-12-15 22:31:31'),(1612,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:32:31','2022-12-15 22:32:31'),(1613,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:33:31','2022-12-15 22:33:31'),(1614,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:34:31','2022-12-15 22:34:31'),(1615,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:35:31','2022-12-15 22:35:31'),(1616,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:36:31','2022-12-15 22:36:31'),(1617,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:37:31','2022-12-15 22:37:31'),(1618,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:38:31','2022-12-15 22:38:31'),(1619,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:39:31','2022-12-15 22:39:31'),(1620,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:40:31','2022-12-15 22:40:31'),(1621,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:41:31','2022-12-15 22:41:31'),(1622,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:42:31','2022-12-15 22:42:31'),(1623,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:43:31','2022-12-15 22:43:31'),(1624,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:44:31','2022-12-15 22:44:31'),(1625,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:45:31','2022-12-15 22:45:31'),(1626,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:46:31','2022-12-15 22:46:31'),(1627,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:47:31','2022-12-15 22:47:31'),(1628,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:48:31','2022-12-15 22:48:31'),(1629,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 22:49:16','2022-12-15 22:49:16'),(1630,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:49:31','2022-12-15 22:49:31'),(1631,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:50:31','2022-12-15 22:50:31'),(1632,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:51:31','2022-12-15 22:51:31'),(1633,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:52:31','2022-12-15 22:52:31'),(1634,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:53:31','2022-12-15 22:53:31'),(1635,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:54:31','2022-12-15 22:54:31'),(1636,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:55:31','2022-12-15 22:55:31'),(1637,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:56:31','2022-12-15 22:56:31'),(1638,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:57:31','2022-12-15 22:57:31'),(1639,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:58:31','2022-12-15 22:58:31'),(1640,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 22:59:31','2022-12-15 22:59:31'),(1641,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:00:31','2022-12-15 23:00:31'),(1642,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:01:31','2022-12-15 23:01:31'),(1643,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:02:31','2022-12-15 23:02:31'),(1644,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:03:31','2022-12-15 23:03:31'),(1645,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:04:31','2022-12-15 23:04:31'),(1646,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:05:31','2022-12-15 23:05:31'),(1647,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:06:31','2022-12-15 23:06:31'),(1648,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:07:31','2022-12-15 23:07:31'),(1649,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:08:31','2022-12-15 23:08:31'),(1650,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:09:31','2022-12-15 23:09:31'),(1651,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:10:31','2022-12-15 23:10:31'),(1652,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:11:31','2022-12-15 23:11:31'),(1653,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:12:31','2022-12-15 23:12:31'),(1654,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:13:31','2022-12-15 23:13:31'),(1655,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:14:31','2022-12-15 23:14:31'),(1656,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:15:31','2022-12-15 23:15:31'),(1657,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:16:31','2022-12-15 23:16:31'),(1658,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:17:31','2022-12-15 23:17:31'),(1659,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:18:31','2022-12-15 23:18:31'),(1660,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:19:31','2022-12-15 23:19:31'),(1661,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:20:31','2022-12-15 23:20:31'),(1662,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:21:31','2022-12-15 23:21:31'),(1663,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:22:01','2022-12-15 23:22:01'),(1664,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:22:31','2022-12-15 23:22:31'),(1665,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:23:31','2022-12-15 23:23:31'),(1666,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:24:31','2022-12-15 23:24:31'),(1667,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:25:31','2022-12-15 23:25:31'),(1668,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:26:31','2022-12-15 23:26:31'),(1669,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:27:31','2022-12-15 23:27:31'),(1670,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:28:31','2022-12-15 23:28:31'),(1671,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:29:31','2022-12-15 23:29:31'),(1672,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:30:31','2022-12-15 23:30:31'),(1673,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:31:31','2022-12-15 23:31:31'),(1674,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:32:31','2022-12-15 23:32:31'),(1675,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:33:31','2022-12-15 23:33:31'),(1676,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:34:31','2022-12-15 23:34:31'),(1677,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:35:31','2022-12-15 23:35:31'),(1678,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:36:31','2022-12-15 23:36:31'),(1679,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:37:31','2022-12-15 23:37:31'),(1680,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:38:31','2022-12-15 23:38:31'),(1681,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:39:31','2022-12-15 23:39:31'),(1682,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:40:31','2022-12-15 23:40:31'),(1683,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:41:31','2022-12-15 23:41:31'),(1684,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:42:31','2022-12-15 23:42:31'),(1685,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:43:31','2022-12-15 23:43:31'),(1686,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:44:31','2022-12-15 23:44:31'),(1687,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:45:31','2022-12-15 23:45:31'),(1688,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:46:31','2022-12-15 23:46:31'),(1689,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:47:31','2022-12-15 23:47:31'),(1690,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:48:31','2022-12-15 23:48:31'),(1691,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-15 23:49:16','2022-12-15 23:49:16'),(1692,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:49:31','2022-12-15 23:49:31'),(1693,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:50:31','2022-12-15 23:50:31'),(1694,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:51:31','2022-12-15 23:51:31'),(1695,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:52:31','2022-12-15 23:52:31'),(1696,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:53:31','2022-12-15 23:53:31'),(1697,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:54:31','2022-12-15 23:54:31'),(1698,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:55:31','2022-12-15 23:55:31'),(1699,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:56:31','2022-12-15 23:56:31'),(1700,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:57:31','2022-12-15 23:57:31'),(1701,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:58:31','2022-12-15 23:58:31'),(1702,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-15 23:59:31','2022-12-15 23:59:31'),(1703,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:00:31','2022-12-16 00:00:31'),(1704,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:01:31','2022-12-16 00:01:31'),(1705,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:02:31','2022-12-16 00:02:31'),(1706,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:03:31','2022-12-16 00:03:31'),(1707,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:04:31','2022-12-16 00:04:31'),(1708,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:05:31','2022-12-16 00:05:31'),(1709,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:06:31','2022-12-16 00:06:31'),(1710,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:07:31','2022-12-16 00:07:31'),(1711,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:08:31','2022-12-16 00:08:31'),(1712,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:09:31','2022-12-16 00:09:31'),(1713,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:10:31','2022-12-16 00:10:31'),(1714,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:11:31','2022-12-16 00:11:31'),(1715,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:12:31','2022-12-16 00:12:31'),(1716,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:13:31','2022-12-16 00:13:31'),(1717,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:14:31','2022-12-16 00:14:31'),(1718,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:15:31','2022-12-16 00:15:31'),(1719,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:16:31','2022-12-16 00:16:31'),(1720,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:17:31','2022-12-16 00:17:31'),(1721,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:18:31','2022-12-16 00:18:31'),(1722,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:19:31','2022-12-16 00:19:31'),(1723,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:20:31','2022-12-16 00:20:31'),(1724,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:21:31','2022-12-16 00:21:31'),(1725,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:22:01','2022-12-16 00:22:01'),(1726,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:22:31','2022-12-16 00:22:31'),(1727,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:23:31','2022-12-16 00:23:31'),(1728,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:24:31','2022-12-16 00:24:31'),(1729,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:25:31','2022-12-16 00:25:31'),(1730,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:26:31','2022-12-16 00:26:31'),(1731,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:27:31','2022-12-16 00:27:31'),(1732,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:28:31','2022-12-16 00:28:31'),(1733,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:29:31','2022-12-16 00:29:31'),(1734,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:30:31','2022-12-16 00:30:31'),(1735,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:31:31','2022-12-16 00:31:31'),(1736,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:32:31','2022-12-16 00:32:31'),(1737,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:33:31','2022-12-16 00:33:31'),(1738,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:34:31','2022-12-16 00:34:31'),(1739,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:35:31','2022-12-16 00:35:31'),(1740,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:36:31','2022-12-16 00:36:31'),(1741,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:37:31','2022-12-16 00:37:31'),(1742,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:38:31','2022-12-16 00:38:31'),(1743,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:39:31','2022-12-16 00:39:31'),(1744,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:40:31','2022-12-16 00:40:31'),(1745,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:41:31','2022-12-16 00:41:31'),(1746,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:42:31','2022-12-16 00:42:31'),(1747,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:43:31','2022-12-16 00:43:31'),(1748,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:44:31','2022-12-16 00:44:31'),(1749,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:45:31','2022-12-16 00:45:31'),(1750,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:46:31','2022-12-16 00:46:31'),(1751,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:47:31','2022-12-16 00:47:31'),(1752,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:48:31','2022-12-16 00:48:31'),(1753,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 00:49:17','2022-12-16 00:49:17'),(1754,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:49:31','2022-12-16 00:49:31'),(1755,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:50:31','2022-12-16 00:50:31'),(1756,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:51:31','2022-12-16 00:51:31'),(1757,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:52:31','2022-12-16 00:52:31'),(1758,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:53:31','2022-12-16 00:53:31'),(1759,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:54:31','2022-12-16 00:54:31'),(1760,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:55:31','2022-12-16 00:55:31'),(1761,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:56:31','2022-12-16 00:56:31'),(1762,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:57:31','2022-12-16 00:57:31'),(1763,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:58:31','2022-12-16 00:58:31'),(1764,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 00:59:31','2022-12-16 00:59:31'),(1765,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:00:31','2022-12-16 01:00:31'),(1766,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:01:31','2022-12-16 01:01:31'),(1767,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:02:31','2022-12-16 01:02:31'),(1768,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:03:31','2022-12-16 01:03:31'),(1769,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:04:31','2022-12-16 01:04:31'),(1770,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:05:31','2022-12-16 01:05:31'),(1771,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:06:31','2022-12-16 01:06:31'),(1772,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:07:31','2022-12-16 01:07:31'),(1773,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:08:31','2022-12-16 01:08:31'),(1774,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:09:31','2022-12-16 01:09:31'),(1775,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:10:31','2022-12-16 01:10:31'),(1776,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:11:31','2022-12-16 01:11:31'),(1777,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:12:31','2022-12-16 01:12:31'),(1778,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:13:31','2022-12-16 01:13:31'),(1779,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:14:31','2022-12-16 01:14:31'),(1780,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:15:31','2022-12-16 01:15:31'),(1781,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:16:31','2022-12-16 01:16:31'),(1782,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:17:31','2022-12-16 01:17:31'),(1783,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:18:31','2022-12-16 01:18:31'),(1784,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:19:31','2022-12-16 01:19:31'),(1785,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:20:31','2022-12-16 01:20:31'),(1786,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:21:31','2022-12-16 01:21:31'),(1787,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:22:01','2022-12-16 01:22:01'),(1788,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:22:31','2022-12-16 01:22:31'),(1789,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:23:31','2022-12-16 01:23:31'),(1790,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:24:31','2022-12-16 01:24:31'),(1791,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:25:31','2022-12-16 01:25:31'),(1792,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:26:31','2022-12-16 01:26:31'),(1793,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:27:31','2022-12-16 01:27:31'),(1794,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:28:31','2022-12-16 01:28:31'),(1795,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:29:31','2022-12-16 01:29:31'),(1796,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:30:31','2022-12-16 01:30:31'),(1797,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:31:31','2022-12-16 01:31:31'),(1798,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:32:31','2022-12-16 01:32:31'),(1799,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:33:31','2022-12-16 01:33:31'),(1800,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:34:31','2022-12-16 01:34:31'),(1801,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:35:31','2022-12-16 01:35:31'),(1802,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:36:31','2022-12-16 01:36:31'),(1803,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:37:31','2022-12-16 01:37:31'),(1804,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:38:19','2022-12-16 01:38:19'),(1805,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:38:31','2022-12-16 01:38:31'),(1806,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:39:31','2022-12-16 01:39:31'),(1807,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:40:31','2022-12-16 01:40:31'),(1808,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:41:31','2022-12-16 01:41:31'),(1809,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:42:31','2022-12-16 01:42:31'),(1810,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:43:31','2022-12-16 01:43:31'),(1811,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:44:31','2022-12-16 01:44:31'),(1812,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:45:31','2022-12-16 01:45:31'),(1813,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:46:31','2022-12-16 01:46:31'),(1814,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:47:31','2022-12-16 01:47:31'),(1815,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:48:31','2022-12-16 01:48:31'),(1816,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 01:49:16','2022-12-16 01:49:16'),(1817,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:49:31','2022-12-16 01:49:31'),(1818,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:50:31','2022-12-16 01:50:31'),(1819,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:51:31','2022-12-16 01:51:31'),(1820,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:52:31','2022-12-16 01:52:31'),(1821,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:53:31','2022-12-16 01:53:31'),(1822,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:54:31','2022-12-16 01:54:31'),(1823,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:55:31','2022-12-16 01:55:31'),(1824,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:56:31','2022-12-16 01:56:31'),(1825,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:57:31','2022-12-16 01:57:31'),(1826,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:58:31','2022-12-16 01:58:31'),(1827,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 01:59:31','2022-12-16 01:59:31'),(1828,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:00:31','2022-12-16 02:00:31'),(1829,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:01:31','2022-12-16 02:01:31'),(1830,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:02:31','2022-12-16 02:02:31'),(1831,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:03:31','2022-12-16 02:03:31'),(1832,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:04:31','2022-12-16 02:04:31'),(1833,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:05:31','2022-12-16 02:05:31'),(1834,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:06:31','2022-12-16 02:06:31'),(1835,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:07:31','2022-12-16 02:07:31'),(1836,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:08:31','2022-12-16 02:08:31'),(1837,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:09:31','2022-12-16 02:09:31'),(1838,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:10:31','2022-12-16 02:10:31'),(1839,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:11:31','2022-12-16 02:11:31'),(1840,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:12:31','2022-12-16 02:12:31'),(1841,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:13:31','2022-12-16 02:13:31'),(1842,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:14:31','2022-12-16 02:14:31'),(1843,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:15:31','2022-12-16 02:15:31'),(1844,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:16:31','2022-12-16 02:16:31'),(1845,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:17:31','2022-12-16 02:17:31'),(1846,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:18:31','2022-12-16 02:18:31'),(1847,'02-42-AC-13-00-07','integrate','{\"macAddress\":\"02-42-AC-13-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 02:18:38','2022-12-16 02:18:38'),(1848,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:19:31','2022-12-16 02:19:31'),(1849,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:20:31','2022-12-16 02:20:31'),(1850,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:21:31','2022-12-16 02:21:31'),(1851,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:22:31','2022-12-16 02:22:31'),(1852,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:23:31','2022-12-16 02:23:31'),(1853,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:24:31','2022-12-16 02:24:31'),(1854,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:25:31','2022-12-16 02:25:31'),(1855,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:26:31','2022-12-16 02:26:31'),(1856,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:27:31','2022-12-16 02:27:31'),(1857,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:28:31','2022-12-16 02:28:31'),(1858,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:29:31','2022-12-16 02:29:31'),(1859,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:30:31','2022-12-16 02:30:31'),(1860,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:31:31','2022-12-16 02:31:31'),(1861,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:32:31','2022-12-16 02:32:31'),(1862,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:33:31','2022-12-16 02:33:31'),(1863,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:34:31','2022-12-16 02:34:31'),(1864,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:35:31','2022-12-16 02:35:31'),(1865,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:36:31','2022-12-16 02:36:31'),(1866,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:37:31','2022-12-16 02:37:31'),(1867,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:38:16','2022-12-16 02:38:16'),(1868,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:38:31','2022-12-16 02:38:31'),(1869,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:39:31','2022-12-16 02:39:31'),(1870,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:40:31','2022-12-16 02:40:31'),(1871,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:41:31','2022-12-16 02:41:31'),(1872,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:42:31','2022-12-16 02:42:31'),(1873,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:43:31','2022-12-16 02:43:31'),(1874,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:44:31','2022-12-16 02:44:31'),(1875,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:45:31','2022-12-16 02:45:31'),(1876,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:46:31','2022-12-16 02:46:31'),(1877,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:47:31','2022-12-16 02:47:31'),(1878,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:48:31','2022-12-16 02:48:31'),(1879,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 02:49:16','2022-12-16 02:49:16'),(1880,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:49:31','2022-12-16 02:49:31'),(1881,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:50:31','2022-12-16 02:50:31'),(1882,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:51:31','2022-12-16 02:51:31'),(1883,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:52:31','2022-12-16 02:52:31'),(1884,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:53:31','2022-12-16 02:53:31'),(1885,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:54:31','2022-12-16 02:54:31'),(1886,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:55:31','2022-12-16 02:55:31'),(1887,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:56:31','2022-12-16 02:56:31'),(1888,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:57:31','2022-12-16 02:57:31'),(1889,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:58:31','2022-12-16 02:58:31'),(1890,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 02:59:31','2022-12-16 02:59:31'),(1891,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:00:31','2022-12-16 03:00:31'),(1892,'02-42-AC-13-00-07','integrate','{\"macAddress\":\"02-42-AC-13-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 03:00:50','2022-12-16 03:00:50'),(1893,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:01:31','2022-12-16 03:01:31'),(1894,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:02:31','2022-12-16 03:02:31'),(1895,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:03:31','2022-12-16 03:03:31'),(1896,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:04:31','2022-12-16 03:04:31'),(1897,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:05:31','2022-12-16 03:05:31'),(1898,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:06:31','2022-12-16 03:06:31'),(1899,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:07:31','2022-12-16 03:07:31'),(1900,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:08:31','2022-12-16 03:08:31'),(1901,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:09:31','2022-12-16 03:09:31'),(1902,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:10:31','2022-12-16 03:10:31'),(1903,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:11:31','2022-12-16 03:11:31'),(1904,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:12:31','2022-12-16 03:12:31'),(1905,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:13:31','2022-12-16 03:13:31'),(1906,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:14:31','2022-12-16 03:14:31'),(1907,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:15:31','2022-12-16 03:15:31'),(1908,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:16:31','2022-12-16 03:16:31'),(1909,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:17:31','2022-12-16 03:17:31'),(1910,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:18:31','2022-12-16 03:18:31'),(1911,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:19:31','2022-12-16 03:19:31'),(1912,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:20:31','2022-12-16 03:20:31'),(1913,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:21:31','2022-12-16 03:21:31'),(1914,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:22:31','2022-12-16 03:22:31'),(1915,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:23:31','2022-12-16 03:23:31'),(1916,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:24:31','2022-12-16 03:24:31'),(1917,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:25:31','2022-12-16 03:25:31'),(1918,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:26:31','2022-12-16 03:26:31'),(1919,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:27:31','2022-12-16 03:27:31'),(1920,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:28:31','2022-12-16 03:28:31'),(1921,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:29:31','2022-12-16 03:29:31'),(1922,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:30:31','2022-12-16 03:30:31'),(1923,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:30:42','2022-12-16 03:30:42'),(1924,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:31:31','2022-12-16 03:31:31'),(1925,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:32:31','2022-12-16 03:32:31'),(1926,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:33:31','2022-12-16 03:33:31'),(1927,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:34:31','2022-12-16 03:34:31'),(1928,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:35:31','2022-12-16 03:35:31'),(1929,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:36:31','2022-12-16 03:36:31'),(1930,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:37:31','2022-12-16 03:37:31'),(1931,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:38:31','2022-12-16 03:38:31'),(1932,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:39:31','2022-12-16 03:39:31'),(1933,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:40:31','2022-12-16 03:40:31'),(1934,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:41:31','2022-12-16 03:41:31'),(1935,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:42:31','2022-12-16 03:42:31'),(1936,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:43:31','2022-12-16 03:43:31'),(1937,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:44:31','2022-12-16 03:44:31'),(1938,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:45:31','2022-12-16 03:45:31'),(1939,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:46:31','2022-12-16 03:46:31'),(1940,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:47:31','2022-12-16 03:47:31'),(1941,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:48:31','2022-12-16 03:48:31'),(1942,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 03:49:16','2022-12-16 03:49:16'),(1943,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:49:31','2022-12-16 03:49:31'),(1944,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:50:31','2022-12-16 03:50:31'),(1945,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:51:31','2022-12-16 03:51:31'),(1946,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:52:31','2022-12-16 03:52:31'),(1947,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:53:31','2022-12-16 03:53:31'),(1948,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:54:31','2022-12-16 03:54:31'),(1949,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:55:31','2022-12-16 03:55:31'),(1950,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:56:31','2022-12-16 03:56:31'),(1951,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:57:31','2022-12-16 03:57:31'),(1952,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:58:31','2022-12-16 03:58:31'),(1953,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 03:59:31','2022-12-16 03:59:31'),(1954,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:00:31','2022-12-16 04:00:31'),(1955,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:01:31','2022-12-16 04:01:31'),(1956,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:02:31','2022-12-16 04:02:31'),(1957,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:03:31','2022-12-16 04:03:31'),(1958,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:04:31','2022-12-16 04:04:31'),(1959,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:05:31','2022-12-16 04:05:31'),(1960,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:06:31','2022-12-16 04:06:31'),(1961,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:07:31','2022-12-16 04:07:31'),(1962,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:08:31','2022-12-16 04:08:31'),(1963,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:09:31','2022-12-16 04:09:31'),(1964,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:10:31','2022-12-16 04:10:31'),(1965,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:11:31','2022-12-16 04:11:31'),(1966,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:12:31','2022-12-16 04:12:31'),(1967,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:13:31','2022-12-16 04:13:31'),(1968,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:14:31','2022-12-16 04:14:31'),(1969,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:15:31','2022-12-16 04:15:31'),(1970,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:16:31','2022-12-16 04:16:31'),(1971,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:17:31','2022-12-16 04:17:31'),(1972,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:18:31','2022-12-16 04:18:31'),(1973,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:19:31','2022-12-16 04:19:31'),(1974,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:20:31','2022-12-16 04:20:31'),(1975,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:21:31','2022-12-16 04:21:31'),(1976,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:22:31','2022-12-16 04:22:31'),(1977,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:23:31','2022-12-16 04:23:31'),(1978,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:24:31','2022-12-16 04:24:31'),(1979,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:25:31','2022-12-16 04:25:31'),(1980,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:26:31','2022-12-16 04:26:31'),(1981,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:27:31','2022-12-16 04:27:31'),(1982,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:28:31','2022-12-16 04:28:31'),(1983,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:29:31','2022-12-16 04:29:31'),(1984,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:30:31','2022-12-16 04:30:31'),(1985,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:30:41','2022-12-16 04:30:41'),(1986,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:31:31','2022-12-16 04:31:31'),(1987,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:32:31','2022-12-16 04:32:31'),(1988,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:33:31','2022-12-16 04:33:31'),(1989,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:34:31','2022-12-16 04:34:31'),(1990,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:35:31','2022-12-16 04:35:31'),(1991,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:36:31','2022-12-16 04:36:31'),(1992,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:37:31','2022-12-16 04:37:31'),(1993,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:38:31','2022-12-16 04:38:31'),(1994,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:39:31','2022-12-16 04:39:31'),(1995,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:40:31','2022-12-16 04:40:31'),(1996,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:41:31','2022-12-16 04:41:31'),(1997,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:42:31','2022-12-16 04:42:31'),(1998,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:43:31','2022-12-16 04:43:31'),(1999,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:44:31','2022-12-16 04:44:31'),(2000,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:45:31','2022-12-16 04:45:31'),(2001,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:46:31','2022-12-16 04:46:31'),(2002,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:47:31','2022-12-16 04:47:31'),(2003,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:48:31','2022-12-16 04:48:31'),(2004,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 04:49:16','2022-12-16 04:49:16'),(2005,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:49:31','2022-12-16 04:49:31'),(2006,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:50:31','2022-12-16 04:50:31'),(2007,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:51:31','2022-12-16 04:51:31'),(2008,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:52:31','2022-12-16 04:52:31'),(2009,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:53:31','2022-12-16 04:53:31'),(2010,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:54:31','2022-12-16 04:54:31'),(2011,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:55:31','2022-12-16 04:55:31'),(2012,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:56:31','2022-12-16 04:56:31'),(2013,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:57:31','2022-12-16 04:57:31'),(2014,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:58:31','2022-12-16 04:58:31'),(2015,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 04:59:31','2022-12-16 04:59:31'),(2016,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:00:31','2022-12-16 05:00:31'),(2017,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:01:31','2022-12-16 05:01:31'),(2018,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:02:31','2022-12-16 05:02:31'),(2019,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:03:31','2022-12-16 05:03:31'),(2020,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:04:31','2022-12-16 05:04:31'),(2021,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:05:31','2022-12-16 05:05:31'),(2022,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:06:31','2022-12-16 05:06:31'),(2023,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:07:31','2022-12-16 05:07:31'),(2024,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:08:31','2022-12-16 05:08:31'),(2025,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:09:31','2022-12-16 05:09:31'),(2026,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:10:31','2022-12-16 05:10:31'),(2027,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:11:31','2022-12-16 05:11:31'),(2028,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:12:31','2022-12-16 05:12:31'),(2029,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:13:31','2022-12-16 05:13:31'),(2030,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:14:31','2022-12-16 05:14:31'),(2031,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:15:31','2022-12-16 05:15:31'),(2032,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:16:31','2022-12-16 05:16:31'),(2033,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:17:31','2022-12-16 05:17:31'),(2034,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:18:31','2022-12-16 05:18:31'),(2035,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:19:31','2022-12-16 05:19:31'),(2036,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:20:31','2022-12-16 05:20:31'),(2037,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:21:31','2022-12-16 05:21:31'),(2038,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:22:31','2022-12-16 05:22:31'),(2039,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:23:31','2022-12-16 05:23:31'),(2040,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:24:31','2022-12-16 05:24:31'),(2041,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:25:31','2022-12-16 05:25:31'),(2042,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:26:31','2022-12-16 05:26:31'),(2043,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:27:31','2022-12-16 05:27:31'),(2044,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:28:31','2022-12-16 05:28:31'),(2045,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:29:31','2022-12-16 05:29:31'),(2046,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:30:31','2022-12-16 05:30:31'),(2047,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:30:41','2022-12-16 05:30:41'),(2048,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:31:31','2022-12-16 05:31:31'),(2049,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:32:31','2022-12-16 05:32:31'),(2050,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:33:31','2022-12-16 05:33:31'),(2051,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:34:31','2022-12-16 05:34:31'),(2052,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:35:31','2022-12-16 05:35:31'),(2053,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:36:31','2022-12-16 05:36:31'),(2054,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:37:31','2022-12-16 05:37:31'),(2055,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:38:31','2022-12-16 05:38:31'),(2056,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:39:31','2022-12-16 05:39:31'),(2057,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:40:31','2022-12-16 05:40:31'),(2058,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:41:31','2022-12-16 05:41:31'),(2059,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:42:31','2022-12-16 05:42:31'),(2060,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:43:31','2022-12-16 05:43:31'),(2061,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:44:31','2022-12-16 05:44:31'),(2062,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:45:31','2022-12-16 05:45:31'),(2063,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:46:31','2022-12-16 05:46:31'),(2064,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:47:31','2022-12-16 05:47:31'),(2065,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:48:31','2022-12-16 05:48:31'),(2066,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 05:49:16','2022-12-16 05:49:16'),(2067,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:49:31','2022-12-16 05:49:31'),(2068,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:50:31','2022-12-16 05:50:31'),(2069,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:51:31','2022-12-16 05:51:31'),(2070,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:52:31','2022-12-16 05:52:31'),(2071,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:53:31','2022-12-16 05:53:31'),(2072,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:54:31','2022-12-16 05:54:31'),(2073,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:55:31','2022-12-16 05:55:31'),(2074,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:56:31','2022-12-16 05:56:31'),(2075,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:57:31','2022-12-16 05:57:31'),(2076,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:58:31','2022-12-16 05:58:31'),(2077,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 05:59:31','2022-12-16 05:59:31'),(2078,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:00:31','2022-12-16 06:00:31'),(2079,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:01:31','2022-12-16 06:01:31'),(2080,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:02:31','2022-12-16 06:02:31'),(2081,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:03:31','2022-12-16 06:03:31'),(2082,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:04:31','2022-12-16 06:04:31'),(2083,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:05:31','2022-12-16 06:05:31'),(2084,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:06:31','2022-12-16 06:06:31'),(2085,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:07:31','2022-12-16 06:07:31'),(2086,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:08:31','2022-12-16 06:08:31'),(2087,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:09:31','2022-12-16 06:09:31'),(2088,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 06:10:23','2022-12-16 06:10:23'),(2089,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:10:31','2022-12-16 06:10:31'),(2090,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:11:31','2022-12-16 06:11:31'),(2091,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:12:31','2022-12-16 06:12:31'),(2092,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:13:31','2022-12-16 06:13:31'),(2093,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:14:31','2022-12-16 06:14:31'),(2094,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:15:31','2022-12-16 06:15:31'),(2095,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:16:31','2022-12-16 06:16:31'),(2096,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:17:31','2022-12-16 06:17:31'),(2097,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:18:31','2022-12-16 06:18:31'),(2098,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:19:31','2022-12-16 06:19:31'),(2099,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:20:31','2022-12-16 06:20:31'),(2100,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:21:31','2022-12-16 06:21:31'),(2101,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:22:31','2022-12-16 06:22:31'),(2102,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 06:22:40','2022-12-16 06:22:40'),(2103,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 06:23:17','2022-12-16 06:23:17'),(2104,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:23:31','2022-12-16 06:23:31'),(2105,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 06:23:35','2022-12-16 06:23:35'),(2106,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:24:31','2022-12-16 06:24:31'),(2107,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:25:31','2022-12-16 06:25:31'),(2108,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 06:26:19','2022-12-16 06:26:19'),(2109,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:26:31','2022-12-16 06:26:31'),(2110,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:27:31','2022-12-16 06:27:31'),(2111,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:28:31','2022-12-16 06:28:31'),(2112,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:29:31','2022-12-16 06:29:31'),(2113,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:30:31','2022-12-16 06:30:31'),(2114,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:30:41','2022-12-16 06:30:41'),(2115,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 06:31:05','2022-12-16 06:31:05'),(2116,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:31:31','2022-12-16 06:31:31'),(2117,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:32:31','2022-12-16 06:32:31'),(2118,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:33:31','2022-12-16 06:33:31'),(2119,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:34:31','2022-12-16 06:34:31'),(2120,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:35:31','2022-12-16 06:35:31'),(2121,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:36:31','2022-12-16 06:36:31'),(2122,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:37:31','2022-12-16 06:37:31'),(2123,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:38:31','2022-12-16 06:38:31'),(2124,'02-42-AC-13-00-07','integrate','{\"macAddress\":\"02-42-AC-13-00-07\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 06:39:26','2022-12-16 06:39:26'),(2125,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:39:31','2022-12-16 06:39:31'),(2126,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:40:31','2022-12-16 06:40:31'),(2127,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:41:31','2022-12-16 06:41:31'),(2128,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:42:31','2022-12-16 06:42:31'),(2129,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:43:31','2022-12-16 06:43:31'),(2130,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 06:44:03','2022-12-16 06:44:03'),(2131,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:44:31','2022-12-16 06:44:31'),(2132,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:45:31','2022-12-16 06:45:31'),(2133,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:46:31','2022-12-16 06:46:31'),(2134,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:47:31','2022-12-16 06:47:31'),(2135,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:48:31','2022-12-16 06:48:31'),(2136,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:49:31','2022-12-16 06:49:31'),(2137,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:50:31','2022-12-16 06:50:31'),(2138,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:51:31','2022-12-16 06:51:31'),(2139,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 06:52:09','2022-12-16 06:52:09'),(2140,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:52:31','2022-12-16 06:52:31'),(2141,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:53:31','2022-12-16 06:53:31'),(2142,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:54:31','2022-12-16 06:54:31'),(2143,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:55:31','2022-12-16 06:55:31'),(2144,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:56:31','2022-12-16 06:56:31'),(2145,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:57:31','2022-12-16 06:57:31'),(2146,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:58:31','2022-12-16 06:58:31'),(2147,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 06:59:31','2022-12-16 06:59:31'),(2148,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:00:31','2022-12-16 07:00:31'),(2149,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:01:31','2022-12-16 07:01:31'),(2150,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:02:31','2022-12-16 07:02:31'),(2151,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:03:31','2022-12-16 07:03:31'),(2152,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:04:31','2022-12-16 07:04:31'),(2153,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:05:31','2022-12-16 07:05:31'),(2154,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:06:31','2022-12-16 07:06:31'),(2155,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:07:31','2022-12-16 07:07:31'),(2156,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:08:31','2022-12-16 07:08:31'),(2157,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:09:31','2022-12-16 07:09:31'),(2158,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:10:31','2022-12-16 07:10:31'),(2159,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:11:31','2022-12-16 07:11:31'),(2160,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:12:31','2022-12-16 07:12:31'),(2161,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:13:31','2022-12-16 07:13:31'),(2162,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:14:31','2022-12-16 07:14:31'),(2163,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:15:31','2022-12-16 07:15:31'),(2164,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 07:15:55','2022-12-16 07:15:55'),(2165,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:16:31','2022-12-16 07:16:31'),(2166,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:17:31','2022-12-16 07:17:31'),(2167,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:18:31','2022-12-16 07:18:31'),(2168,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:19:31','2022-12-16 07:19:31'),(2169,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 07:20:12','2022-12-16 07:20:12'),(2170,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:20:31','2022-12-16 07:20:31'),(2171,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:21:31','2022-12-16 07:21:31'),(2172,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:22:31','2022-12-16 07:22:31'),(2173,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 07:22:56','2022-12-16 07:22:56'),(2174,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 07:23:17','2022-12-16 07:23:17'),(2175,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 07:23:27','2022-12-16 07:23:27'),(2176,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:23:31','2022-12-16 07:23:31'),(2177,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:24:31','2022-12-16 07:24:31'),(2178,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:25:31','2022-12-16 07:25:31'),(2179,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:26:31','2022-12-16 07:26:31'),(2180,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:27:31','2022-12-16 07:27:31'),(2181,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:28:31','2022-12-16 07:28:31'),(2182,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:29:31','2022-12-16 07:29:31'),(2183,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:30:31','2022-12-16 07:30:31'),(2184,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:30:41','2022-12-16 07:30:41'),(2185,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:31:31','2022-12-16 07:31:31'),(2186,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:32:31','2022-12-16 07:32:31'),(2187,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:33:31','2022-12-16 07:33:31'),(2188,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:34:31','2022-12-16 07:34:31'),(2189,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:35:31','2022-12-16 07:35:31'),(2190,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:36:31','2022-12-16 07:36:31'),(2191,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:37:31','2022-12-16 07:37:31'),(2192,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:38:31','2022-12-16 07:38:31'),(2193,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:39:31','2022-12-16 07:39:31'),(2194,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:40:31','2022-12-16 07:40:31'),(2195,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:41:31','2022-12-16 07:41:31'),(2196,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:42:31','2022-12-16 07:42:31'),(2197,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:43:31','2022-12-16 07:43:31'),(2198,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 07:44:03','2022-12-16 07:44:03'),(2199,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:44:31','2022-12-16 07:44:31'),(2200,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:45:31','2022-12-16 07:45:31'),(2201,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:46:31','2022-12-16 07:46:31'),(2202,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:47:31','2022-12-16 07:47:31'),(2203,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:48:31','2022-12-16 07:48:31'),(2204,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:49:31','2022-12-16 07:49:31'),(2205,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:50:31','2022-12-16 07:50:31'),(2206,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:51:31','2022-12-16 07:51:31'),(2207,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:52:31','2022-12-16 07:52:31'),(2208,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:53:31','2022-12-16 07:53:31'),(2209,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:54:31','2022-12-16 07:54:31'),(2210,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:55:31','2022-12-16 07:55:31'),(2211,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:56:31','2022-12-16 07:56:31'),(2212,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:57:31','2022-12-16 07:57:31'),(2213,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:58:31','2022-12-16 07:58:31'),(2214,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 07:59:31','2022-12-16 07:59:31'),(2215,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:00:31','2022-12-16 08:00:31'),(2216,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:01:31','2022-12-16 08:01:31'),(2217,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:02:31','2022-12-16 08:02:31'),(2218,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:03:31','2022-12-16 08:03:31'),(2219,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:04:31','2022-12-16 08:04:31'),(2220,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:05:31','2022-12-16 08:05:31'),(2221,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:06:31','2022-12-16 08:06:31'),(2222,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:07:31','2022-12-16 08:07:31'),(2223,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:08:31','2022-12-16 08:08:31'),(2224,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:09:31','2022-12-16 08:09:31'),(2225,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:10:31','2022-12-16 08:10:31'),(2226,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:11:31','2022-12-16 08:11:31'),(2227,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:12:31','2022-12-16 08:12:31'),(2228,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:13:31','2022-12-16 08:13:31'),(2229,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:14:31','2022-12-16 08:14:31'),(2230,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:15:31','2022-12-16 08:15:31'),(2231,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:16:31','2022-12-16 08:16:31'),(2232,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:17:31','2022-12-16 08:17:31'),(2233,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:18:31','2022-12-16 08:18:31'),(2234,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:19:31','2022-12-16 08:19:31'),(2235,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:20:31','2022-12-16 08:20:31'),(2236,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:21:31','2022-12-16 08:21:31'),(2237,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:22:31','2022-12-16 08:22:31'),(2238,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 08:23:17','2022-12-16 08:23:17'),(2239,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:23:31','2022-12-16 08:23:31'),(2240,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:24:31','2022-12-16 08:24:31'),(2241,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:25:31','2022-12-16 08:25:31'),(2242,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:26:31','2022-12-16 08:26:31'),(2243,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:27:31','2022-12-16 08:27:31'),(2244,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 08:28:17','2022-12-16 08:28:17'),(2245,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:28:31','2022-12-16 08:28:31'),(2246,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:29:31','2022-12-16 08:29:31'),(2247,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 08:29:47','2022-12-16 08:29:47'),(2248,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:30:31','2022-12-16 08:30:31'),(2249,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:30:41','2022-12-16 08:30:41'),(2250,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:31:31','2022-12-16 08:31:31'),(2251,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:32:31','2022-12-16 08:32:31'),(2252,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:33:31','2022-12-16 08:33:31'),(2253,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:34:31','2022-12-16 08:34:31'),(2254,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:35:31','2022-12-16 08:35:31'),(2255,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:36:31','2022-12-16 08:36:31'),(2256,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:37:31','2022-12-16 08:37:31'),(2257,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:38:31','2022-12-16 08:38:31'),(2258,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:39:31','2022-12-16 08:39:31'),(2259,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:40:31','2022-12-16 08:40:31'),(2260,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:41:31','2022-12-16 08:41:31'),(2261,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:42:31','2022-12-16 08:42:31'),(2262,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:43:31','2022-12-16 08:43:31'),(2263,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 08:44:03','2022-12-16 08:44:03'),(2264,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:44:31','2022-12-16 08:44:31'),(2265,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:45:31','2022-12-16 08:45:31'),(2266,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:46:31','2022-12-16 08:46:31'),(2267,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:47:31','2022-12-16 08:47:31'),(2268,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:48:31','2022-12-16 08:48:31'),(2269,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:49:31','2022-12-16 08:49:31'),(2270,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:50:31','2022-12-16 08:50:31'),(2271,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:51:31','2022-12-16 08:51:31'),(2272,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:52:31','2022-12-16 08:52:31'),(2273,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:53:31','2022-12-16 08:53:31'),(2274,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:54:31','2022-12-16 08:54:31'),(2275,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:55:31','2022-12-16 08:55:31'),(2276,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:56:31','2022-12-16 08:56:31'),(2277,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:57:31','2022-12-16 08:57:31'),(2278,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:58:31','2022-12-16 08:58:31'),(2279,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 08:59:31','2022-12-16 08:59:31'),(2280,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:00:31','2022-12-16 09:00:31'),(2281,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:01:31','2022-12-16 09:01:31'),(2282,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:02:31','2022-12-16 09:02:31'),(2283,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:03:31','2022-12-16 09:03:31'),(2284,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:04:31','2022-12-16 09:04:31'),(2285,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:05:31','2022-12-16 09:05:31'),(2286,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:06:31','2022-12-16 09:06:31'),(2287,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:07:31','2022-12-16 09:07:31'),(2288,'02-42-AC-12-00-03','integrate','{\"macAddress\":\"02-42-AC-12-00-03\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 09:08:14','2022-12-16 09:08:14'),(2289,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:08:31','2022-12-16 09:08:31'),(2290,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:09:31','2022-12-16 09:09:31'),(2291,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:10:31','2022-12-16 09:10:31'),(2292,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:11:31','2022-12-16 09:11:31'),(2293,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:12:31','2022-12-16 09:12:31'),(2294,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:13:31','2022-12-16 09:13:31'),(2295,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:14:31','2022-12-16 09:14:31'),(2296,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:15:31','2022-12-16 09:15:31'),(2297,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:16:31','2022-12-16 09:16:31'),(2298,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:17:31','2022-12-16 09:17:31'),(2299,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:18:31','2022-12-16 09:18:31'),(2300,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:19:31','2022-12-16 09:19:31'),(2301,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:20:31','2022-12-16 09:20:31'),(2302,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:21:31','2022-12-16 09:21:31'),(2303,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:22:31','2022-12-16 09:22:31'),(2304,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:23:17','2022-12-16 09:23:17'),(2305,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:23:31','2022-12-16 09:23:31'),(2306,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:24:31','2022-12-16 09:24:31'),(2307,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:25:31','2022-12-16 09:25:31'),(2308,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:26:31','2022-12-16 09:26:31'),(2309,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:27:31','2022-12-16 09:27:31'),(2310,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:28:31','2022-12-16 09:28:31'),(2311,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:29:31','2022-12-16 09:29:31'),(2312,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:30:31','2022-12-16 09:30:31'),(2313,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:30:41','2022-12-16 09:30:41'),(2314,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:31:07','2022-12-16 09:31:07'),(2315,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:31:31','2022-12-16 09:31:31'),(2316,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:32:15','2022-12-16 09:32:15'),(2317,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:32:31','2022-12-16 09:32:31'),(2318,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:33:31','2022-12-16 09:33:31'),(2319,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:34:31','2022-12-16 09:34:31'),(2320,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:35:31','2022-12-16 09:35:31'),(2321,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:36:31','2022-12-16 09:36:31'),(2322,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:36:50','2022-12-16 09:36:50'),(2323,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:37:31','2022-12-16 09:37:31'),(2324,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:37:55','2022-12-16 09:37:55'),(2325,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:38:31','2022-12-16 09:38:31'),(2326,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:39:31','2022-12-16 09:39:31'),(2327,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:39:56','2022-12-16 09:39:56'),(2328,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:40:31','2022-12-16 09:40:31'),(2329,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:41:31','2022-12-16 09:41:31'),(2330,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:42:01','2022-12-16 09:42:01'),(2331,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:42:31','2022-12-16 09:42:31'),(2332,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:43:31','2022-12-16 09:43:31'),(2333,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 09:44:03','2022-12-16 09:44:03'),(2334,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:44:31','2022-12-16 09:44:31'),(2335,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:45:31','2022-12-16 09:45:31'),(2336,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:46:31','2022-12-16 09:46:31'),(2337,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:47:31','2022-12-16 09:47:31'),(2338,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:48:31','2022-12-16 09:48:31'),(2339,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:49:31','2022-12-16 09:49:31'),(2340,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:50:31','2022-12-16 09:50:31'),(2341,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:51:31','2022-12-16 09:51:31'),(2342,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:51:54','2022-12-16 09:51:54'),(2343,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:52:31','2022-12-16 09:52:31'),(2344,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:53:24','2022-12-16 09:53:24'),(2345,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:53:31','2022-12-16 09:53:31'),(2346,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:54:31','2022-12-16 09:54:31'),(2347,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:54:50','2022-12-16 09:54:50'),(2348,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:55:31','2022-12-16 09:55:31'),(2349,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:55:35','2022-12-16 09:55:35'),(2350,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:56:31','2022-12-16 09:56:31'),(2351,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:57:12','2022-12-16 09:57:12'),(2352,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:57:31','2022-12-16 09:57:31'),(2353,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 09:58:21','2022-12-16 09:58:21'),(2354,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:58:31','2022-12-16 09:58:31'),(2355,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 09:59:31','2022-12-16 09:59:31'),(2356,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:00:31','2022-12-16 10:00:31'),(2357,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:01:31','2022-12-16 10:01:31'),(2358,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:02:31','2022-12-16 10:02:31'),(2359,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:03:13','2022-12-16 10:03:13'),(2360,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:03:31','2022-12-16 10:03:31'),(2361,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:04:31','2022-12-16 10:04:31'),(2362,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:05:31','2022-12-16 10:05:31'),(2363,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:06:31','2022-12-16 10:06:31'),(2364,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:07:31','2022-12-16 10:07:31'),(2365,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:08:31','2022-12-16 10:08:31'),(2366,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:09:15','2022-12-16 10:09:15'),(2367,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:09:31','2022-12-16 10:09:31'),(2368,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:10:31','2022-12-16 10:10:31'),(2369,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:10:49','2022-12-16 10:10:49'),(2370,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:11:31','2022-12-16 10:11:31'),(2371,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:12:31','2022-12-16 10:12:31'),(2372,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:13:30','2022-12-16 10:13:30'),(2373,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:13:31','2022-12-16 10:13:31'),(2374,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:14:31','2022-12-16 10:14:31'),(2375,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:15:31','2022-12-16 10:15:31'),(2376,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:15:55','2022-12-16 10:15:55'),(2377,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:16:31','2022-12-16 10:16:31'),(2378,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:17:31','2022-12-16 10:17:31'),(2379,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:18:31','2022-12-16 10:18:31'),(2380,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:18:58','2022-12-16 10:18:58'),(2381,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:19:31','2022-12-16 10:19:31'),(2382,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:20:31','2022-12-16 10:20:31'),(2383,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:20:48','2022-12-16 10:20:48'),(2384,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:21:31','2022-12-16 10:21:31'),(2385,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:22:16','2022-12-16 10:22:16'),(2386,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:22:31','2022-12-16 10:22:31'),(2387,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:23:31','2022-12-16 10:23:31'),(2388,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:24:31','2022-12-16 10:24:31'),(2389,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:25:18','2022-12-16 10:25:18'),(2390,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:25:31','2022-12-16 10:25:31'),(2391,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:26:31','2022-12-16 10:26:31'),(2392,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:27:31','2022-12-16 10:27:31'),(2393,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:28:09','2022-12-16 10:28:09'),(2394,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:28:31','2022-12-16 10:28:31'),(2395,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:28:46','2022-12-16 10:28:46'),(2396,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:29:31','2022-12-16 10:29:31'),(2397,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:30:31','2022-12-16 10:30:31'),(2398,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:30:41','2022-12-16 10:30:41'),(2399,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:31:31','2022-12-16 10:31:31'),(2400,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:32:31','2022-12-16 10:32:31'),(2401,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:33:31','2022-12-16 10:33:31'),(2402,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:34:04','2022-12-16 10:34:04'),(2403,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:34:31','2022-12-16 10:34:31'),(2404,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:34:39','2022-12-16 10:34:39'),(2405,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:35:31','2022-12-16 10:35:31'),(2406,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:35:36','2022-12-16 10:35:36'),(2407,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:36:31','2022-12-16 10:36:31'),(2408,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:36:49','2022-12-16 10:36:49'),(2409,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:37:24','2022-12-16 10:37:24'),(2410,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:37:31','2022-12-16 10:37:31'),(2411,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:38:31','2022-12-16 10:38:31'),(2412,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:39:31','2022-12-16 10:39:31'),(2413,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:40:31','2022-12-16 10:40:31'),(2414,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:41:31','2022-12-16 10:41:31'),(2415,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:42:31','2022-12-16 10:42:31'),(2416,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:43:31','2022-12-16 10:43:31'),(2417,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 10:44:03','2022-12-16 10:44:03'),(2418,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:44:31','2022-12-16 10:44:31'),(2419,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:45:31','2022-12-16 10:45:31'),(2420,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:46:31','2022-12-16 10:46:31'),(2421,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:47:31','2022-12-16 10:47:31'),(2422,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:48:31','2022-12-16 10:48:31'),(2423,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:49:31','2022-12-16 10:49:31'),(2424,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:50:31','2022-12-16 10:50:31'),(2425,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:51:31','2022-12-16 10:51:31'),(2426,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:52:31','2022-12-16 10:52:31'),(2427,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:53:02','2022-12-16 10:53:02'),(2428,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:53:31','2022-12-16 10:53:31'),(2429,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:54:31','2022-12-16 10:54:31'),(2430,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:55:31','2022-12-16 10:55:31'),(2431,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:56:31','2022-12-16 10:56:31'),(2432,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:57:31','2022-12-16 10:57:31'),(2433,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:58:31','2022-12-16 10:58:31'),(2434,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 10:59:13','2022-12-16 10:59:13'),(2435,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 10:59:31','2022-12-16 10:59:31'),(2436,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:00:31','2022-12-16 11:00:31'),(2437,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 11:00:56','2022-12-16 11:00:56'),(2438,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:01:31','2022-12-16 11:01:31'),(2439,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:02:31','2022-12-16 11:02:31'),(2440,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 11:03:08','2022-12-16 11:03:08'),(2441,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:03:31','2022-12-16 11:03:31'),(2442,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:04:31','2022-12-16 11:04:31'),(2443,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:05:31','2022-12-16 11:05:31'),(2444,'00-50-56-C0-00-08','integrate','{\"macAddress\":\"00-50-56-C0-00-08\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"bZdlfxFlQFLB7ZcEHQgq8BG7luIgoTRMFyWOPYwVCFx8WNdnRKDHsbrFayyUlxW3gEvOcu4/8+2Fb2aS624th7x8w5q9v1xJYdqEUp2TeJZlDCrk8y+/aGDAfXQn9GzFpk8TNPriEJ6IhCu0bCV2vhPICVZ/x/NaiGAOqGaRJHk=\",\"message\":\"Lic文件已过期\",\"success\":false}','Lic文件已过期','2022-12-16 11:05:38','2022-12-16 11:05:38'),(2445,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:06:31','2022-12-16 11:06:31'),(2446,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:07:31','2022-12-16 11:07:31'),(2447,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:08:31','2022-12-16 11:08:31'),(2448,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:09:31','2022-12-16 11:09:31'),(2449,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:10:31','2022-12-16 11:10:31'),(2450,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:11:31','2022-12-16 11:11:31'),(2451,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:12:08','2022-12-16 11:12:08'),(2452,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:12:31','2022-12-16 11:12:31'),(2453,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:13:31','2022-12-16 11:13:31'),(2454,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:14:31','2022-12-16 11:14:31'),(2455,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:15:31','2022-12-16 11:15:31'),(2456,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:16:31','2022-12-16 11:16:31'),(2457,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:17:31','2022-12-16 11:17:31'),(2458,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:18:31','2022-12-16 11:18:31'),(2459,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:19:31','2022-12-16 11:19:31'),(2460,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:20:31','2022-12-16 11:20:31'),(2461,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:20:50','2022-12-16 11:20:50'),(2462,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:21:31','2022-12-16 11:21:31'),(2463,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:22:31','2022-12-16 11:22:31'),(2464,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:23:31','2022-12-16 11:23:31'),(2465,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:24:31','2022-12-16 11:24:31'),(2466,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:24:46','2022-12-16 11:24:46'),(2467,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:25:31','2022-12-16 11:25:31'),(2468,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:26:31','2022-12-16 11:26:31'),(2469,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:27:31','2022-12-16 11:27:31'),(2470,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:28:31','2022-12-16 11:28:31'),(2471,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:29:31','2022-12-16 11:29:31'),(2472,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:30:31','2022-12-16 11:30:31'),(2473,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:31:31','2022-12-16 11:31:31'),(2474,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:32:31','2022-12-16 11:32:31'),(2475,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:33:31','2022-12-16 11:33:31'),(2476,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:34:31','2022-12-16 11:34:31'),(2477,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:35:31','2022-12-16 11:35:31'),(2478,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:36:31','2022-12-16 11:36:31'),(2479,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:37:31','2022-12-16 11:37:31'),(2480,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:38:31','2022-12-16 11:38:31'),(2481,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:39:31','2022-12-16 11:39:31'),(2482,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:40:31','2022-12-16 11:40:31'),(2483,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:41:31','2022-12-16 11:41:31'),(2484,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:42:31','2022-12-16 11:42:31'),(2485,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:43:31','2022-12-16 11:43:31'),(2486,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 11:44:03','2022-12-16 11:44:03'),(2487,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:44:31','2022-12-16 11:44:31'),(2488,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:45:31','2022-12-16 11:45:31'),(2489,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:46:31','2022-12-16 11:46:31'),(2490,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:47:31','2022-12-16 11:47:31'),(2491,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:48:31','2022-12-16 11:48:31'),(2492,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:49:31','2022-12-16 11:49:31'),(2493,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:50:31','2022-12-16 11:50:31'),(2494,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:51:31','2022-12-16 11:51:31'),(2495,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:52:31','2022-12-16 11:52:31'),(2496,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:53:31','2022-12-16 11:53:31'),(2497,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:54:31','2022-12-16 11:54:31'),(2498,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:55:31','2022-12-16 11:55:31'),(2499,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:56:31','2022-12-16 11:56:31'),(2500,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:57:31','2022-12-16 11:57:31'),(2501,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:58:31','2022-12-16 11:58:31'),(2502,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 11:59:31','2022-12-16 11:59:31'),(2503,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:00:31','2022-12-16 12:00:31'),(2504,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:01:31','2022-12-16 12:01:31'),(2505,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:02:31','2022-12-16 12:02:31'),(2506,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:03:31','2022-12-16 12:03:31'),(2507,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:04:31','2022-12-16 12:04:31'),(2508,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:05:31','2022-12-16 12:05:31'),(2509,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:06:31','2022-12-16 12:06:31'),(2510,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:07:31','2022-12-16 12:07:31'),(2511,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:08:31','2022-12-16 12:08:31'),(2512,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:09:31','2022-12-16 12:09:31'),(2513,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:10:31','2022-12-16 12:10:31'),(2514,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:11:31','2022-12-16 12:11:31'),(2515,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:12:31','2022-12-16 12:12:31'),(2516,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:13:31','2022-12-16 12:13:31'),(2517,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:14:31','2022-12-16 12:14:31'),(2518,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:15:31','2022-12-16 12:15:31'),(2519,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:16:31','2022-12-16 12:16:31'),(2520,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:17:31','2022-12-16 12:17:31'),(2521,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:18:31','2022-12-16 12:18:31'),(2522,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:19:31','2022-12-16 12:19:31'),(2523,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:20:31','2022-12-16 12:20:31'),(2524,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:21:31','2022-12-16 12:21:31'),(2525,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:22:31','2022-12-16 12:22:31'),(2526,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:23:31','2022-12-16 12:23:31'),(2527,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:24:31','2022-12-16 12:24:31'),(2528,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:24:45','2022-12-16 12:24:45'),(2529,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:25:31','2022-12-16 12:25:31'),(2530,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:26:31','2022-12-16 12:26:31'),(2531,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:27:31','2022-12-16 12:27:31'),(2532,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:28:31','2022-12-16 12:28:31'),(2533,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:29:31','2022-12-16 12:29:31'),(2534,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:30:32','2022-12-16 12:30:32'),(2535,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:31:31','2022-12-16 12:31:31'),(2536,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:32:31','2022-12-16 12:32:31'),(2537,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:33:31','2022-12-16 12:33:31'),(2538,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:34:31','2022-12-16 12:34:31'),(2539,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:35:31','2022-12-16 12:35:31'),(2540,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:36:31','2022-12-16 12:36:31'),(2541,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:37:31','2022-12-16 12:37:31'),(2542,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:38:31','2022-12-16 12:38:31'),(2543,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:39:31','2022-12-16 12:39:31'),(2544,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:40:31','2022-12-16 12:40:31'),(2545,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:41:31','2022-12-16 12:41:31'),(2546,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:42:31','2022-12-16 12:42:31'),(2547,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:43:31','2022-12-16 12:43:31'),(2548,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 12:44:03','2022-12-16 12:44:03'),(2549,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:44:31','2022-12-16 12:44:31'),(2550,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:45:31','2022-12-16 12:45:31'),(2551,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:46:31','2022-12-16 12:46:31'),(2552,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:47:31','2022-12-16 12:47:31'),(2553,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:48:31','2022-12-16 12:48:31'),(2554,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:49:31','2022-12-16 12:49:31'),(2555,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:50:31','2022-12-16 12:50:31'),(2556,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:51:31','2022-12-16 12:51:31'),(2557,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:52:31','2022-12-16 12:52:31'),(2558,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:53:31','2022-12-16 12:53:31'),(2559,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:54:31','2022-12-16 12:54:31'),(2560,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:55:31','2022-12-16 12:55:31'),(2561,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:56:31','2022-12-16 12:56:31'),(2562,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:57:31','2022-12-16 12:57:31'),(2563,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:58:31','2022-12-16 12:58:31'),(2564,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 12:59:31','2022-12-16 12:59:31'),(2565,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:00:31','2022-12-16 13:00:31'),(2566,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:01:31','2022-12-16 13:01:31'),(2567,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:02:31','2022-12-16 13:02:31'),(2568,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:03:31','2022-12-16 13:03:31'),(2569,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:04:31','2022-12-16 13:04:31'),(2570,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:05:31','2022-12-16 13:05:31'),(2571,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:06:31','2022-12-16 13:06:31'),(2572,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:07:31','2022-12-16 13:07:31'),(2573,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:08:31','2022-12-16 13:08:31'),(2574,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:09:31','2022-12-16 13:09:31'),(2575,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:10:31','2022-12-16 13:10:31'),(2576,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:11:31','2022-12-16 13:11:31'),(2577,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:12:31','2022-12-16 13:12:31'),(2578,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:13:31','2022-12-16 13:13:31'),(2579,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:14:31','2022-12-16 13:14:31'),(2580,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:15:31','2022-12-16 13:15:31'),(2581,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:16:31','2022-12-16 13:16:31'),(2582,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:17:31','2022-12-16 13:17:31'),(2583,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:18:31','2022-12-16 13:18:31'),(2584,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:19:31','2022-12-16 13:19:31'),(2585,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:20:31','2022-12-16 13:20:31'),(2586,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:21:31','2022-12-16 13:21:31'),(2587,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:22:31','2022-12-16 13:22:31'),(2588,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:23:31','2022-12-16 13:23:31'),(2589,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:24:31','2022-12-16 13:24:31'),(2590,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:24:45','2022-12-16 13:24:45'),(2591,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:25:31','2022-12-16 13:25:31'),(2592,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:26:31','2022-12-16 13:26:31'),(2593,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:27:31','2022-12-16 13:27:31'),(2594,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:28:31','2022-12-16 13:28:31'),(2595,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:29:31','2022-12-16 13:29:31'),(2596,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:30:31','2022-12-16 13:30:31'),(2597,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:31:31','2022-12-16 13:31:31'),(2598,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:32:31','2022-12-16 13:32:31'),(2599,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:33:31','2022-12-16 13:33:31'),(2600,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:34:31','2022-12-16 13:34:31'),(2601,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:35:31','2022-12-16 13:35:31'),(2602,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:36:31','2022-12-16 13:36:31'),(2603,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:37:31','2022-12-16 13:37:31'),(2604,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:38:31','2022-12-16 13:38:31'),(2605,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:39:31','2022-12-16 13:39:31'),(2606,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:40:31','2022-12-16 13:40:31'),(2607,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:41:31','2022-12-16 13:41:31'),(2608,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:42:31','2022-12-16 13:42:31'),(2609,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:43:31','2022-12-16 13:43:31'),(2610,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 13:44:03','2022-12-16 13:44:03'),(2611,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:44:31','2022-12-16 13:44:31'),(2612,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:45:31','2022-12-16 13:45:31'),(2613,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:46:31','2022-12-16 13:46:31'),(2614,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:47:31','2022-12-16 13:47:31'),(2615,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:48:31','2022-12-16 13:48:31'),(2616,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:49:31','2022-12-16 13:49:31'),(2617,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:50:31','2022-12-16 13:50:31'),(2618,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:51:31','2022-12-16 13:51:31'),(2619,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:52:31','2022-12-16 13:52:31'),(2620,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:53:31','2022-12-16 13:53:31'),(2621,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:54:31','2022-12-16 13:54:31'),(2622,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:55:31','2022-12-16 13:55:31'),(2623,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:56:31','2022-12-16 13:56:31'),(2624,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:57:31','2022-12-16 13:57:31'),(2625,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:58:31','2022-12-16 13:58:31'),(2626,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 13:59:31','2022-12-16 13:59:31'),(2627,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:00:31','2022-12-16 14:00:31'),(2628,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:01:31','2022-12-16 14:01:31'),(2629,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:02:31','2022-12-16 14:02:31'),(2630,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:03:31','2022-12-16 14:03:31'),(2631,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:04:31','2022-12-16 14:04:31'),(2632,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:05:31','2022-12-16 14:05:31'),(2633,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:06:31','2022-12-16 14:06:31'),(2634,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:07:31','2022-12-16 14:07:31'),(2635,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:08:31','2022-12-16 14:08:31'),(2636,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:09:31','2022-12-16 14:09:31'),(2637,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:10:31','2022-12-16 14:10:31'),(2638,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:11:31','2022-12-16 14:11:31'),(2639,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:12:31','2022-12-16 14:12:31'),(2640,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:13:31','2022-12-16 14:13:31'),(2641,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:14:31','2022-12-16 14:14:31'),(2642,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:15:31','2022-12-16 14:15:31'),(2643,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:16:31','2022-12-16 14:16:31'),(2644,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:17:31','2022-12-16 14:17:31'),(2645,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:18:31','2022-12-16 14:18:31'),(2646,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:19:31','2022-12-16 14:19:31'),(2647,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:20:31','2022-12-16 14:20:31'),(2648,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:21:31','2022-12-16 14:21:31'),(2649,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:22:31','2022-12-16 14:22:31'),(2650,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:23:31','2022-12-16 14:23:31'),(2651,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:24:31','2022-12-16 14:24:31'),(2652,'02-42-AC-14-00-07','integrate','{\"macAddress\":\"02-42-AC-14-00-07\",\"source\":\"integrate\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:24:45','2022-12-16 14:24:45'),(2653,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:25:31','2022-12-16 14:25:31'),(2654,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:26:31','2022-12-16 14:26:31'),(2655,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:27:31','2022-12-16 14:27:31'),(2656,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:28:31','2022-12-16 14:28:31'),(2657,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:29:31','2022-12-16 14:29:31'),(2658,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:30:31','2022-12-16 14:30:31'),(2659,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:31:31','2022-12-16 14:31:31'),(2660,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:32:31','2022-12-16 14:32:31'),(2661,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:33:31','2022-12-16 14:33:31'),(2662,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:34:31','2022-12-16 14:34:31'),(2663,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:35:31','2022-12-16 14:35:31'),(2664,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:36:31','2022-12-16 14:36:31'),(2665,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:37:31','2022-12-16 14:37:31'),(2666,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:38:31','2022-12-16 14:38:31'),(2667,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:39:31','2022-12-16 14:39:31'),(2668,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:40:31','2022-12-16 14:40:31'),(2669,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:41:31','2022-12-16 14:41:31'),(2670,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:42:31','2022-12-16 14:42:31'),(2671,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:43:31','2022-12-16 14:43:31'),(2672,'02-42-AC-14-00-06','integrate','{\"macAddress\":\"02-42-AC-14-00-06\",\"source\":\"integrate\"}',0,'{\"code\":400,\"data\":\"HBuggdOyt1mz6SLtK3txQwgWigTYwN4t1DP1w5GD86Ul3w9lV+lmu5mPcR/MXs8KlHvZjJTnUxKzXXyOj95/o82dX/b3p4OS4nIyLc1hjRK9nbhGbI1L0pXD7AGEBph220wPnz17sUZG7s6duIvEIHs3XfN4mFmSrOtbKDrFxQo=\",\"message\":\"MAC地址不存在\",\"success\":false}','MAC地址不存在','2022-12-16 14:44:04','2022-12-16 14:44:04'),(2673,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:44:31','2022-12-16 14:44:31'),(2674,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:45:31','2022-12-16 14:45:31'),(2675,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:46:31','2022-12-16 14:46:31'),(2676,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:47:31','2022-12-16 14:47:31'),(2677,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:48:31','2022-12-16 14:48:31'),(2678,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:49:31','2022-12-16 14:49:31'),(2679,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:50:31','2022-12-16 14:50:31'),(2680,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:51:31','2022-12-16 14:51:31'),(2681,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:52:31','2022-12-16 14:52:31'),(2682,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:53:31','2022-12-16 14:53:31'),(2683,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:54:31','2022-12-16 14:54:31'),(2684,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D36qydqVTrFbkUN55Qp1MO5D/FOxhAI+a+NwGaHCjArnv6Ocz5yIV7IG4v5067pXSvLRLLt9fU7ykFg9Us/7Tk5HqxMMCfoMYBIs8V5iv8qYuaRw7QSEXEydvambXZYzE/lRXBo=\",\"success\":true}',NULL,'2022-12-16 14:55:31','2022-12-16 14:55:31'),(2685,'02-42-AC-13-00-02','null','{\"macAddress\":\"02-42-AC-13-00-02\"}',1,'{\"code\":200,\"data\":\"PwWZNr/uLvPwIJqqdFNFMoT7dA2skDb99jo6D