package com.system.controller;

import com.system.dao.LicInfoMapper;
import com.system.serivce.ILicInfoService;
import com.system.transfer.lic.*;
import com.system.transfer.response.RestResponse;
import com.system.utils.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * @author Inori
 */
@Api(tags = "Lic信息")
@RestController
@RequestMapping("/api")
public class LicInfoController {

    @Autowired
    private ILicInfoService locInfoService;
    @Autowired
    private LicInfoMapper licInfoMapper;

    @ApiOperation("Lic信息列表")
    @GetMapping("/lic/info/list")
    public RestResponse<LicInfoListOutVo> licInfoList(@ModelAttribute LicInfoListInVo inVo) {
        LicInfoListOutVo outVo = locInfoService.licInfoList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("Lic信息创建")
    @PostMapping("/lic/info/create")
    public RestResponse licInfoCreate(@RequestBody LicInfoCreateInVo inVo) {
        LicInfoListOutVoRecords mac = licInfoMapper.getLicInfoByMacAddress(inVo.getMacAddress());
        if (!StringUtil.isNull(mac)) {
            return RestResponse.fail("MAC地址已存在");
        }
        locInfoService.licInfoCreate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("Lic信息更新")
    @PutMapping("/lic/info/update")
    public RestResponse licInfoUpdate(@RequestBody LicInfoUpdateInVo inVo) {
        LicInfoListOutVoRecords mac = licInfoMapper.getLicInfoByMacAddress(inVo.getMacAddress());
        if (!StringUtil.isNull(mac)) {
            if (!mac.getId().equals(inVo.getId())) {
                return RestResponse.fail("MAC地址已存在");
            }
        }
        locInfoService.licInfoUpdate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("Lic信息删除")
    @DeleteMapping("/lic/info/delete")
    public RestResponse licInfoDelete(@ModelAttribute LicInfoDeleteInVo inVo) {
        locInfoService.licInfoDelete(inVo);
        return RestResponse.success();
    }

    @ApiOperation("Lic信息文件创建")
    @PostMapping("/lic/info/file/create")
    public RestResponse licInfoFileCreate(@RequestBody LicInfoFileCreateInVo inVo, HttpServletResponse response) {
        return locInfoService.licInfoFileCreate(inVo, response);
    }


}
