package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.system.dao.DockerImageMapper;
import com.system.entity.DockerImage;
import com.system.serivce.IDockerImageService;
import com.system.serivce.IDockerImageVersionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class DockerImageServiceImpl extends ServiceImpl<DockerImageMapper, DockerImage> implements IDockerImageService {
    @Autowired
    private IDockerImageVersionService versionService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteById(Integer id) {
        boolean r = this.removeById(id);
        if (r) {
            boolean b = versionService.deleteByImageId(id);
            if (!b) {
                r = b;
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        return r;
    }
}


