package com.system.controller;

import com.system.transfer.response.RestResponse;
import com.system.serivce.ILicVerificationService;
import com.system.transfer.verification.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "在线验证")
@RestController
@RequestMapping("/api")
public class LicVerificationController {

    @Autowired
    private ILicVerificationService licVerificationService;


    @ApiOperation("Lic在线验证列表")
    @GetMapping("/lic/online/verification/log/list")
    public RestResponse licOnlineVerificationLogList(@ModelAttribute LicOnlineVerificationLogListInVo inVo) {
        LicOnlineVerificationLogListOutVo outVo = licVerificationService.licOnlineVerificationLogList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("Lic在线验证详情")
    @GetMapping("/lic/online/verification/log/detail")
    public RestResponse licOnlineVerificationLogDetail(@ModelAttribute LicOnlineVerificationLogDetailInVo inVo) {
        LicOnlineVerificationLogDetailOutVo outVo = licVerificationService.licOnlineVerificationLogDetail(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("Lic在线验证删除")
    @DeleteMapping("/lic/online/verification/log/delete")
    public RestResponse licOnlineVerificationLogDelete(@ModelAttribute LicOnlineVerificationLogDeleteInVo inVo) {
        licVerificationService.licOnlineVerificationLogDelete(inVo);
        return RestResponse.success();
    }

    @ApiOperation("Lic在线验证")
    @PostMapping("/lic/online/verification")
    public String licOnlineVerification(@RequestBody LicOnlineVerificationInVo inVo) {
        return licVerificationService.licOnlineVerification(inVo);
    }


}
