package com.system.oauth.system.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

// 角色信息表
@Data
@TableName("sys_role")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "sys_role对象", description = "角色")
public class SysRole implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId(type = IdType.AUTO)
    private String id;

    @ApiModelProperty(value = "编码")
    private String roleCode;


    @ApiModelProperty(value = "角色名称")
    private String roleName;


    @ApiModelProperty(value = "角色描述")
    private String roleDesc;


    @ApiModelProperty(value = "创建日期")
    private String fdate;


    @ApiModelProperty(value = "创建人")
    private String fcreator;


    @ApiModelProperty(value = "更新日期")
    private String fmodifyDate;


    @ApiModelProperty(value = "更新人")
    private String Fmodify;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleDesc() {
        return roleDesc;
    }

    public void setRoleDesc(String roleDesc) {
        this.roleDesc = roleDesc;
    }

    public String getFdate() {
        return fdate;
    }

    public void setFdate(String fdate) {
        this.fdate = fdate;
    }

    public String getFcreator() {
        return fcreator;
    }

    public void setFcreator(String fcreator) {
        this.fcreator = fcreator;
    }

    public String getFmodifyDate() {
        return fmodifyDate;
    }

    public void setFmodifyDate(String fmodifyDate) {
        this.fmodifyDate = fmodifyDate;
    }

    public String getFmodify() {
        return Fmodify;
    }

    public void setFmodify(String fmodify) {
        Fmodify = fmodify;
    }
}
