package com.system.utils;

import org.apache.commons.io.FileUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * @author Lnori
 */
public class FileUtil {

    /**
     * 写文件
     */
    public static void write(File file, String data) throws IOException {
        FileUtils.write(file, data, "UTF-8", true);
    }

    /**
     * 一行一行写文件
     */
    public static void writeLine(File file, List<String> dataList) throws IOException {
        FileUtils.writeLines(file, dataList, true);
    }

    /**
     * 读文件
     */
    public static String read(File file) throws IOException {
        return FileUtils.readFileToString(file, "UTF-8");
    }

    /**
     * 读文件
     */
    public static String read(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.close();
        return new String(outputStream.toByteArray());
    }

    /**
     * 一行一行读文件
     */
    public static List<String> readLine(File file) throws IOException {
        return FileUtils.readLines(file, "UTF-8");
    }

    /**
     * 移动文件
     */
    public static void move(File file, File fileMkdir) throws IOException {
        FileUtils.moveToDirectory(file, fileMkdir, true);

    }

    /**
     * 删除文件
     */
    public static void deleteFile(File file) {
        FileUtils.deleteQuietly(file);
    }

    /**
     * 删除文件夹
     */
    public static void deleteMkdir(File fileMkdir) {
        FileUtils.deleteQuietly(fileMkdir);
    }


}
