package com.system.framework.core.exception;


import com.system.framework.core.response.StarBosResultEnum;

public class StarBosException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public StarBosException(String message){
        super(message);
    }

    private Object object;

    private StarBosResultEnum starBosResultEnum;


    public StarBosException(String msg, Object object) {
        super(msg);
        this.object = object;
    }

    public StarBosException(String msg, Throwable cause) {
        super(msg, cause);
    }


    public StarBosException(StarBosResultEnum starBosResultEnum) {
        super(starBosResultEnum.getMsg());
        this.starBosResultEnum = starBosResultEnum;
    }

    public StarBosException(StarBosResultEnum starBosResultEnum, Object object) {
        super(starBosResultEnum.getMsg());
        this.starBosResultEnum = starBosResultEnum;
        this.object = object;
    }


    public Object getObject() {
        return object;
    }

    public StarBosResultEnum getResponseEnum() {
        return starBosResultEnum;
    }
}
