package com.system.serivce.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.system.dao.DockerImageVersionMapper;
import com.system.entity.DockerImageVersion;
import com.system.serivce.IDockerImageVersionService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class DockerImageVersionServiceImpl extends ServiceImpl<DockerImageVersionMapper, DockerImageVersion> implements IDockerImageVersionService {

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteByImageId(Integer imageId) {
        LambdaQueryWrapper<DockerImageVersion> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(DockerImageVersion::getImageId, imageId);
        if (count(wrapper) == 0) {
            return true;
        }
        return this.remove(wrapper);
    }

    @Override
    public List<DockerImageVersion> listByImageId(Integer imagesId) {
        LambdaQueryWrapper<DockerImageVersion> qw = new LambdaQueryWrapper<>();
        qw.eq(DockerImageVersion::getImageId, imagesId);
        return list(qw);
    }
}


