package com.system.serivce.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.constants.Constants;
import com.system.constants.RsaKeyConstant;
import com.system.dao.LicInfoMapper;
import com.system.dao.LicVerificationMapper;
import com.system.serivce.ILicInfoService;
import com.system.serivce.ILicVerificationService;
import com.system.transfer.lic.LicInfoListOutVoRecords;
import com.system.transfer.response.LicRestResponse;
import com.system.transfer.response.RestResponse;
import com.system.transfer.verification.*;
import com.system.utils.JsonUtil;
import com.system.utils.RsaUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class LicVerificationServiceImpl implements ILicVerificationService {

    @Autowired
    private LicVerificationMapper licVerificationMapper;

    @Autowired
    private LicInfoMapper licInfoMapper;
    @Autowired
    private ILicInfoService locInfoService;
    @Autowired
    private RsaKeyConstant rsaKeyConstant;


    @Override
    public LicOnlineVerificationLogListOutVo licOnlineVerificationLogList(LicOnlineVerificationLogListInVo inVo) {
        Page<LicOnlineVerificationLogListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<LicOnlineVerificationLogListOutVoRecords> recordsList = licVerificationMapper.licOnlineVerificationLogList(page, inVo);

        LicOnlineVerificationLogListOutVo outVo = new LicOnlineVerificationLogListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public LicOnlineVerificationLogDetailOutVo licOnlineVerificationLogDetail(LicOnlineVerificationLogDetailInVo inVo) {
        return licVerificationMapper.licOnlineVerificationLogDetail(inVo);
    }

    @Override
    public void licOnlineVerificationLogDelete(LicOnlineVerificationLogDeleteInVo inVo) {
        licVerificationMapper.licOnlineVerificationLogDelete(inVo);
    }

    @Override
    public String licOnlineVerification(LicOnlineVerificationInVo inVo) {
        String result;
        try {
            result = RsaUtil.decryptByPrivateKeyToLong(inVo.getData(), rsaKeyConstant.getPrivateKey());
        } catch (Exception e) {
            e.printStackTrace();
            try {
                return RsaUtil.encryptByPrivateKeyToLong(JSON.toJSONString(RestResponse.fail("Lic文件信息解密失败")), rsaKeyConstant.getPrivateKey());
            } catch (Exception ex) {
                return "";
            }
        }

        LicOnlineVerificationLogCreateInVo request = new LicOnlineVerificationLogCreateInVo();
        LicRestResponse response;

        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        request.setMacAddress(String.valueOf(map.get("macAddress")));
        request.setSource(String.valueOf(map.get("source")));
        request.setRequest(result);
        if (!CollectionUtils.isEmpty(map)) {
            response = this.purchaseToResult(map);

            if (response.getCode() == LicRestResponse.CODE_SUCCESS) {
                request.setFlag(1);
            } else {
                request.setFlag(0);
                request.setMessage(response.getMessage());
            }
        } else {
            response = LicRestResponse.fail("Lic文件信息错误");

            request.setFlag(0);
            request.setMessage(response.getMessage());
            request.setResponse(JsonUtil.toString(response));
        }

        try {
            response.setData(RsaUtil.sign(rsaKeyConstant.getPrivateKey(), JSON.toJSONString(response)));
        } catch (Exception e) {
            e.printStackTrace();
            try {
                return RsaUtil.encryptByPrivateKeyToLong(JSON.toJSONString(RestResponse.fail("Lic文件信息签名失败")), rsaKeyConstant.getPrivateKey());
            } catch (Exception ex) {
                return "";
            }
        }

        request.setResponse(JSON.toJSONString(response));
        licVerificationMapper.licOnlineVerificationLogCreate(request);

        try {
            if (Boolean.TRUE.equals(map.get("newLic"))) {
                String string = locInfoService.licInfoCreate(request.getMacAddress());
                response.setLic(string);
            }
        } catch (Exception e) {
            e.printStackTrace();
            try {
                return RsaUtil.encryptByPrivateKeyToLong(JSON.toJSONString(RestResponse.fail("Lic信息生成失败")), rsaKeyConstant.getPrivateKey());
            } catch (Exception ex) {
                return "";
            }
        }

        try {
            return RsaUtil.encryptByPrivateKeyToLong(JSON.toJSONString(response), rsaKeyConstant.getPrivateKey());
        } catch (Exception ex) {
            return "";
        }
    }

    private LicRestResponse purchaseToResult(Map<String, Object> map) {
        LicInfoListOutVoRecords records = licInfoMapper.getLicInfoByMacAddress(String.valueOf(map.get("macAddress")));
        if (StringUtil.isNull(records)) {
            return LicRestResponse.fail("MAC地址不存在");
        }

        try {
            if (new Date().after(new SimpleDateFormat(Constants.TIME_FORMAT).parse(records.getFileEffectiveTime()))) {
                return LicRestResponse.fail("Lic文件已过期");
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return LicRestResponse.success();
    }
    @Override
    public void licOnlineVerificationLogClean(String nodeTime){
        try {
            Integer deleteNodeId = licVerificationMapper.findDeleteNodeId(nodeTime);
            if (deleteNodeId!=null) {
                licVerificationMapper.licOnlineVerificationLogClean(deleteNodeId);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

}

}
