package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.verification.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface LicVerificationMapper {

    /**
     * Lic在线验证列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<LicOnlineVerificationLogListOutVoRecords> licOnlineVerificationLogList(@Param("page") Page<LicOnlineVerificationLogListOutVoRecords> page, @Param("inVo") LicOnlineVerificationLogListInVo inVo);

    /**
     * Lic在线验证详情
     *
     * @param inVo 条件
     * @return 详情
     */
    LicOnlineVerificationLogDetailOutVo licOnlineVerificationLogDetail(LicOnlineVerificationLogDetailInVo inVo);

    Integer findDeleteNodeId(String createTime);

    void licOnlineVerificationLogClean(Integer id);
    /**
     * Lic在线验证创建
     *
     * @param inVo 条件
     */
    void licOnlineVerificationLogCreate(LicOnlineVerificationLogCreateInVo inVo);

    /**
     * Lic在线验证删除
     *
     * @param inVo 条件
     */
    void licOnlineVerificationLogDelete(LicOnlineVerificationLogDeleteInVo inVo);


}
