package com.system.api;

import com.system.constants.Constants;
import com.system.transfer.form.MallFieldMappingListOutVoRecords;
import com.system.utils.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Component
public class CommonPostApi {

    @Autowired
    private MallLogUtil mallLogUtil;

    public String commonPost(Map<String, String> config, String queueId, List<Map<String, Object>> dataList) {
        Map<String, Object> result = new HashMap<>(3);

        try {
            List<MallFieldMappingListOutVoRecords> fieldList = FormFieldMappingUtil.encapsulationMapping(config.get("formFieldMappingDetail"));

            Map<String, Object> request = new HashMap<>();
            request.put("formId", config.get("docType"));
            request.put("model", CommonApi.encapsulationData(config, dataList, fieldList));

            String response = HttpUtil.httpPost(config.get("requestAddress"), JsonUtil.toString(request)).getBody();
            Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
            if (!CollectionUtils.isEmpty(map)) {
                if (Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
                    result.put("success", true);
                }
            } else if (!Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME))) && map.containsKey(Constants.ERROR_MESSAGE)) {
                result.put("success", false);
                result.put("message", map.get(Constants.ERROR_MESSAGE));
            } else {
                result.put("message", "");
                result.put("success", false);
            }

            mallLogUtil.mallLogCreate(config.get("name"), config.get("docType"), queueId, Integer.valueOf(config.get("operation")), JsonUtil.toString(request), response);
            return JsonUtil.toString(result);
        } catch (Exception e) {
            result.put("message", e.getMessage());
            result.put("success", false);
            return JsonUtil.toString(result);
        }
    }


}
