package com.system.constants;

import com.system.dao.MallCommonConfigMapper;
import com.system.transfer.form.MallCommonConfigListOutVoRecords;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Inori
 */
@Component
public class MallCommonGetConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private MallCommonConfigMapper mallCommonConfigMapper;


    @PostConstruct
    public void init() {
        List<MallCommonConfigListOutVoRecords> recordsList = mallCommonConfigMapper.mallCommonConfigGetList();
        if (!CollectionUtils.isEmpty(recordsList)) {
            List<Integer> idList = recordsList.stream().map(MallCommonConfigListOutVoRecords::getId).collect(Collectors.toList());
            List<Map<String, Object>> fieldMappingList = mallCommonConfigMapper.mallFieldMappingList(idList);
            for (MallCommonConfigListOutVoRecords records : recordsList) {
                List<Map<String, Object>> tempList = fieldMappingList.stream().filter(m -> records.getId().equals(m.get("id"))).collect(Collectors.toList());
                this.map.put(records.getDocType(), this.encapsulationMallFieldConfig(records, tempList));
            }
        }
    }

    public Map<String, String> get(String docType) {
        if (CollectionUtils.isEmpty(this.map)) {
            return new HashMap<>(1);
        }
        return this.map.get(docType);
    }

    public void refresh(Integer id, String docType) {
        this.map.remove(docType);

        MallCommonConfigListOutVoRecords records = mallCommonConfigMapper.getMallCommonConfigById(id);
        if (StringUtil.isNotNull(records)) {
            List<Map<String, Object>> tempList = mallCommonConfigMapper.mallFieldMappingList(Stream.of(records.getId()).collect(Collectors.toList()));
            this.map.put(records.getSFormId(), this.encapsulationMallFieldConfig(records, tempList));
        }
    }

    /**
     * 封装自定义表单配置
     */
    private Map<String, String> encapsulationMallFieldConfig(MallCommonConfigListOutVoRecords records, List<Map<String, Object>> tempList) {
        Map<String, String> temp = new HashMap<>(10);
        temp.put("productId", records.getPlatformProductRelationId().toString());
        temp.put("docType", records.getDocType());
        temp.put("sFormId", records.getSFormId());
        temp.put("name", records.getName());
        temp.put("direction", records.getDirection());
        temp.put("operation", String.valueOf(records.getOperation()));
        temp.put("encapsulationFormat", String.valueOf(records.getEncapsulationFormat()));
        temp.put("entryName", records.getEntryName());
        temp.put("customSql", records.getCustomSql());
        temp.put("plugInUrl", records.getPlugInUrl());
        temp.put("formFieldMappingDetail", JsonUtil.toString(tempList));
        return temp;
    }


}
