package com.system.constants;

import com.system.dao.SynchronizationOperationMapper;
import com.system.transfer.synchronization.SynchronizationOperationListOutVoRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class SynchronizationOperationConstants {

    private Map<Integer, Map<String, Map<String, String>>> map = new ConcurrentHashMap<>();

    @Autowired
    private SynchronizationOperationMapper synchronizationOperationMapper;


    @PostConstruct
    public void init() {
        List<SynchronizationOperationListOutVoRecords> recordsList = synchronizationOperationMapper.synchronizationOperationList();
        if (!CollectionUtils.isEmpty(recordsList)) {
            List<Integer> keyList = recordsList.stream().map(SynchronizationOperationListOutVoRecords::getPlatformProductRelationId).distinct().collect(Collectors.toList());
            for (Integer key : keyList) {
                this.map.put(key, new ConcurrentHashMap<>(5));
                Map<String, Map<String, String>> config = this.map.get(key);

                List<SynchronizationOperationListOutVoRecords> tempList = recordsList.stream().filter(m -> key.equals(m.getPlatformProductRelationId())).collect(Collectors.toList());
                for (SynchronizationOperationListOutVoRecords records : tempList) {
                    config.put(records.getSFormId(), this.encapsulationSynchronizationOperation(records));
                }
            }
        }
    }

    public Map<String, String> get(Integer platformProductRelationId, String sFormId) {
        Map<String, Map<String, String>> config = this.map.get(platformProductRelationId);
        if (CollectionUtils.isEmpty(config)) {
            return new HashMap<>(1);
        }
        return config.get(sFormId);
    }

    public void refresh(Integer id, String sFormId) {
        SynchronizationOperationListOutVoRecords records = synchronizationOperationMapper.getSynchronizationOperationById(id);

        Map<String, Map<String, String>> temp = this.map.get(records.getPlatformProductRelationId());
        if (!CollectionUtils.isEmpty(temp)) {
            temp.remove(sFormId);
            temp.put(records.getSFormId(), this.encapsulationSynchronizationOperation(records));
        }
    }

    private Map<String, String> encapsulationSynchronizationOperation(SynchronizationOperationListOutVoRecords records) {
        Map<String, String> temp = new HashMap<>(6);
        temp.put("productId", records.getPlatformProductRelationId().toString());
        temp.put("jobClassName", records.getJobClassName());
        temp.put("sFormId", records.getSFormId());
        temp.put("docType", records.getDocType());
        temp.put("receiveAddress", records.getReceiveAddress());
        return temp;
    }


}
