package com.system.controller;

import com.system.serivce.ISynchronizationService;
import com.system.transfer.mall.MallTriggerSynchronizationInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "商城同步")
@RestController
@RequestMapping("/api")
public class MallCommonSyncController {

    @Autowired
    private ISynchronizationService synchronizationService;


    @ApiOperation("触发同步")
    @PostMapping("/mall/trigger/synchronization")
    public RestResponse mallTriggerSynchronization(@RequestBody MallTriggerSynchronizationInVo inVo) {
        synchronizationService.mallTriggerSynchronization(inVo);
        return RestResponse.success();
    }

    @ApiOperation("自动同步")
    @GetMapping("/mall/synchronization")
    public RestResponse mallSynchronization() {
        synchronizationService.mallSynchronization();
        return RestResponse.success();
    }


}
