package com.system.dao;

import com.system.transfer.configure.TableStructureListOutVoRecords;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Mapper
public interface DatabaseTableMapper {

    /**
     * 表单表结构列表
     *
     * @return 列表
     */
    List<TableStructureListOutVoRecords> tableStructureList();

    /**
     * 表单配置
     *
     * @param formId 表单标识
     * @return 表单配置
     */
    TableStructureListOutVoRecords tableStructureOne(String formId);

    /**
     * 数据库表数据创建
     *
     * @param dbTableName 数据库表名称
     * @param dbFiledList 数据库表字段列表
     * @param dataList    数据库表数据列表
     */
    void databaseTableDataCreate(@Param("dbTableName") String dbTableName, @Param("dbFiledList") List<String> dbFiledList, @Param("dataList") List<Map<String, Object>> dataList);

    /**
     * 数据库表数据删除
     *
     * @param dbTableName 数据库表名称
     * @param queueId     唯一标识
     */
    void databaseTableDataDelete(@Param("dbTableName") String dbTableName, @Param("queueId") String queueId);


}
