package com.system.mall;

import com.system.api.CommonHttpApi;
import com.system.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class MallCommonApi {

    @Autowired
    private CommonHttpApi commonHttpApi;


    public List<Map<String, Object>> getSynchronizationRecords(List<Integer> idList) {
        try {
            String response = commonHttpApi.commonHttpSync(idList);
            System.out.println("同步记录: " + response);

            List<Object> objectList = JsonUtil.toList(response, Object.class);
            if (!CollectionUtils.isEmpty(objectList)) {
                return objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class)).collect(Collectors.toList());
            }

            return new ArrayList<>();
        } catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<>();
        }
    }

    public void mallSynchronizedRecordsUpdate(List<Map<String, Object>> tempList) {
        List<Integer> idList = tempList.stream().filter(m -> !"LQKJ_IMSSync".equals(m.get("formId"))).map(m -> Integer.valueOf(String.valueOf(m.get("id")))).collect(Collectors.toList());

        if (!CollectionUtils.isEmpty(idList)) {
            //修改商城是否同步
            String response = commonHttpApi.commonHttpPostByUpdate(JsonUtil.toString(idList));
        }
    }


}
