package com.system.mall;

import com.system.api.CommonApi;
import com.system.api.CommonHttpApi;
import com.system.constants.Constants;
import com.system.constants.MallConstants;
import com.system.dao.DatabaseTableMapper;
import com.system.transfer.configure.TableStructureCreateInVoRecords;
import com.system.transfer.configure.TableStructureListOutVoRecords;
import com.system.transfer.form.MallFieldMappingListOutVoRecords;
import com.system.utils.FormFieldMappingUtil;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import com.system.utils.TableStructureUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class MallCommonSyncApi {

    @Autowired
    private CommonHttpApi commonHttpApi;

    @Autowired
    private DatabaseTableMapper databaseTableMapper;

    @Autowired
    private CommonApi commonApi;


    public Map<String, Object> synchronization(Map<String, String> config, String queueId, String name, Map<String, Object> where) {
        Map<String, Object> result = new HashMap<>(3);

        List<MallFieldMappingListOutVoRecords> fieldList = FormFieldMappingUtil.encapsulationMapping(config.get("formFieldMappingDetail"));
        List<String> keyList = fieldList.stream().map(MallFieldMappingListOutVoRecords::getFieldBeforeMapping).collect(Collectors.toList());
        String response = commonHttpApi.commonHttpSyncData(config, queueId, name, keyList, where);
        System.out.println("同步记录详细数据: " + response);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map)) {
            if (MallConstants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.CODE_NAME)))) {
                List<Object> objectList = JsonUtil.toList(JsonUtil.toString(map.get("data")), Object.class);
                List<Map<String, Object>> dataList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class)).collect(Collectors.toList());

                this.databaseTableDataCreate(config.get("docType"), queueId, dataList);
                result.put("data", dataList);
                result.put("success", true);
            }
        } else if (!MallConstants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.CODE_NAME))) && map.containsKey(Constants.ERROR_MESSAGE)) {
            result.put("message", map.get(Constants.ERROR_MESSAGE));
            result.put("success", false);
        } else {
            result.put("message", "");
            result.put("success", false);
        }

        return result;
    }

    private void databaseTableDataCreate(String docType, String queueId, List<Map<String, Object>> dataList) {
        TableStructureListOutVoRecords records = databaseTableMapper.tableStructureOne(docType);
        if (StringUtil.isNotNull(records)) {
            List<TableStructureCreateInVoRecords> recordsList = TableStructureUtil.getFieldList(records.getFormJson());
            List<String> dbFieldList = recordsList.stream().map(TableStructureCreateInVoRecords::getDbFieldName).collect(Collectors.toList());

            List<Map<String, Object>> tempList = new ArrayList<>();
            for (Map<String, Object> data : dataList) {
                Map<String, Object> map = new LinkedHashMap<>();
                for (String fieldName : dbFieldList) {
                    map.put(fieldName, data.get(fieldName));
                }
                tempList.add(map);
            }

            if (!CollectionUtils.isEmpty(tempList)) {
                try {
                    databaseTableMapper.databaseTableDataCreate(records.getDbTableName(), dbFieldList, tempList);
                } catch (Exception e) {
                    System.out.println("数据库表: " + records.getDbTableName() + " 唯一标识: " + queueId + " 的数据创建失败");
                }
            }
        }
    }

    /**
     * SQL查询结果: 数据库表数据创建
     */
    public void databaseTableDataCreateBySql(String docType, String queueId, List<Object> dataList, List<Map<String, String>> fieldList) {
        TableStructureListOutVoRecords records = databaseTableMapper.tableStructureOne(docType);
        if (StringUtil.isNotNull(records)) {
            List<Map<String, Object>> response = new ArrayList<>();

            for (Object object : dataList) {
                Map<String, Object> map = JsonUtil.toMap(JsonUtil.toString(object), String.class, Object.class);

                Map<String, Object> request = new LinkedHashMap<>();
                for (Map<String, String> temp : fieldList) {
                    request.put(temp.get("thirdPartyField"), map.get(temp.get("kingdeeField")));
                }
                request.put("queue_id", queueId);
                response.add(request);
            }

            this.createData(queueId, records, response);
        }
    }

    private void createData(String queueId, TableStructureListOutVoRecords records, List<Map<String, Object>> dataList) {
        List<TableStructureCreateInVoRecords> recordsList = TableStructureUtil.getFieldList(records.getFormJson());
        List<String> dbFieldList = recordsList.stream().map(TableStructureCreateInVoRecords::getDbFieldName).collect(Collectors.toList());

        List<Map<String, Object>> tempList = new ArrayList<>();
        for (Map<String, Object> data : dataList) {
            Map<String, Object> map = new LinkedHashMap<>();
            for (String fieldName : dbFieldList) {
                map.put(fieldName, data.get(fieldName));
            }
            tempList.add(map);
        }
        if (!CollectionUtils.isEmpty(tempList)) {
            try {
                databaseTableMapper.databaseTableDataCreate(records.getDbTableName(), dbFieldList, tempList);
            } catch (Exception e) {
                System.out.println("数据库表: " + records.getDbTableName() + " 唯一标识: " + queueId + " 的数据创建失败");
            }
        }
    }

    /**
     * 同步至第三方
     */
    public String sendThirdParty(String data) {
        return commonHttpApi.sendThirdParty(data, 1);
    }

    /**
     * 删除表数据
     */
    public void databaseTableDataDelete(String dbTableName, String queueId) {
        databaseTableMapper.databaseTableDataDelete(dbTableName, queueId);
    }

    public String sendPlugInUnit(String plugInUrl, String data) {
        return commonApi.sendPlugInUnit(plugInUrl, data, 1);
    }

    public String mallGetBySql(Map<String, String> config, String queueId, String name, String request) {
        return commonApi.mallSelectBySql(config, queueId, request);
    }


}
