package com.system.serivce.impl;

import com.system.constants.Constants;
import com.system.constants.MallCommonSyncConstants;
import com.system.constants.MallConstants;
import com.system.dao.DatabaseTableMapper;
import com.system.dao.SynchronizationRecordsMapper;
import com.system.mall.MallCommonSyncApi;
import com.system.order.Order;
import com.system.serivce.IMallSyncService;
import com.system.transfer.configure.TableStructureListOutVoRecords;
import com.system.transfer.mall.SynchronizationRecordsListOutVoRecords;
import com.system.transfer.mall.SynchronizationRecordsUpdateInVo;
import com.system.utils.*;
import io.swagger.models.auth.In;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Inori
 */
@Service
public class IMallSyncServiceImpl implements IMallSyncService {

    @Autowired
    private MallCommonSyncConstants mallCommonSyncConstants;

    @Autowired
    private MallCommonSyncApi mallCommonSyncApi;

    @Autowired
    private DatabaseTableMapper databaseTableMapper;

    @Autowired
    private SynchronizationRecordsMapper synchronizationRecordsMapper;

    @Autowired
    private ProductLogUtil productLogUtil;


    @Override
    public void synchronization(Integer id, String sFormId, Integer dataId, List<Integer> entryId) {
        List<Map<String, String>> configList = mallCommonSyncConstants.get(sFormId);
        if (CollectionUtils.isEmpty(configList)) {
            synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, SnowFlakeIdUtil.generateId().toString(), "商城同步失败! sFormId为: " + sFormId + " 的商城表单不存在", 2));
            return;
        }

        for (Map<String, String> config : configList) {
            String queueId = SnowFlakeIdUtil.generateId().toString();

            Map<String, Object> map = new HashMap<>();
            String customSql = config.get("customSql");
            if (StringUtil.isNotBlank(customSql)) {
                //TODO SQL查询
            } else {
                //TODO 重组List传值
                Map<String, Object> where = new HashMap<>(3);
                where.put("dataId", dataId);
                if (StringUtil.isNotNull(entryId)) {
                    where.put("entryId", entryId);
                }

              map = mallCommonSyncApi.synchronization(config, queueId, config.get("name"), where);
                if (!Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
                    synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, queueId, String.valueOf(map.get(Constants.ERROR_MESSAGE)), 2));
                    return;
                }
            }
            
            //TODO 循环调用前先筛选分组
            List<Object> objects = JsonUtil.toList(JsonUtil.toString(map.get(Constants.DATE_NAME)), Object.class);
            Map<String,List<Object>> map2=new HashMap<>();

            for(Object list:objects){
                Object bom_code = ((LinkedHashMap) list).get("bom_code");
                Object parent_code = ((LinkedHashMap) list).get("parent_code");
                if(parent_code == null)
                {
	                if(!map2.containsKey(bom_code)){
	                    List<Object> item=new ArrayList<>();
	                    map2.put((String)bom_code,item);
	                }
                    List<Object> bomCodes = map2.get(bom_code);
                    bomCodes.add(list);
                }
                else
                {
	                if(!map2.containsKey(parent_code)){
	                    List<Object> item=new ArrayList<>();
	                    map2.put((String)parent_code,item);
	                }
                    List<Object> bomCodes = map2.get(parent_code);
                    bomCodes.add(list);
                }
            }

            for(Map.Entry<String,List<Object>> maps:map2.entrySet()){
                this.encapsulationRequest(config, queueId, id, maps.getValue());
            }
        }
    }


    /**
     * 查询SQL
     */
    private List<Object> encapsulationGetBySql(Map<String, String> config, String queueId, Integer id, String customSql, Integer dataId, Integer entryId) {
        customSql = customSql.replaceAll("@" + config.get("primaryKeyField"), String.valueOf(dataId));
        customSql = customSql.replaceAll("@" + config.get("entryPrimaryKeyField"), String.valueOf(entryId));
        //DES加密
        String request = DesHelperUtil.encrypt(customSql, StandardCharsets.UTF_8, "MES&&DES");
        String customSqlResult = mallCommonSyncApi.mallGetBySql(config, queueId, config.get("name") + "执行SQL", request);

        Map<String, Object> temp = JsonUtil.toMap(customSqlResult, String.class, Object.class);
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(temp)) {
            if (temp.containsKey(MallConstants.CODE_NAME) && MallConstants.SUCCESS_CODE.equals(temp.get(MallConstants.CODE_NAME))) {
                List<Object> dataList = JsonUtil.toList(JsonUtil.toString(temp.get("data")), Object.class);
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(dataList)) {
                    return dataList;
                }
            } else {
                synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, queueId, customSqlResult, 2));
                return new ArrayList<>();
            }
        } else {
            synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, queueId, customSqlResult, 2));
            return new ArrayList<>();
        }

        return new ArrayList<>();
    }

    /**
     * 查询 HTTP
     */
    private List<Map<String, Object>> encapsulationGetByHttp(Map<String, String> config, String queueId, Integer id, String plugInUrl, List<Map<String, Object>> request, List<Object> dataList) {
        Map<String, Object> data = new HashMap<>(1);
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(dataList)) {
            data.put("data", dataList);
        } else {
            data.put("data", request);
        }
        String response = mallCommonSyncApi.sendPlugInUnit(plugInUrl, JsonUtil.toString(data));
        productLogUtil.productHttpLogCreate(Integer.valueOf(config.get("productId")), queueId, id, config.get("name") + "执行插件", config.get("docType"), config.get("direction"), JsonUtil.toString(data), response);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(map) && MallConstants.SUCCESS_CODE.equals(map.get(MallConstants.CODE_NAME))) {
            List<Object> tempList = JsonUtil.toList(JsonUtil.toString(map.get(MallConstants.DATA_NAME)), Object.class);
            return tempList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class)).collect(Collectors.toList());
        }

        return new ArrayList<>();
    }


    private void encapsulationRequest(Map<String, String> config, String queueId, Integer id, List<Object> data) {
        String qId = SnowFlakeIdUtil.generateId().toString();
    	for(Object curData:data)
    	{
    		((Map<String, Object>)curData).put("QUEUE_ID", qId);
    	}
        Map<String, Object> request = new HashMap<>(3);
        request.put("docType", config.get("docType"));
        request.put("updateType", "update");
        request.put("data", data);

        String response = mallCommonSyncApi.sendThirdParty(JsonUtil.toString(request));
        //记录第三方日志
        productLogUtil.productHttpLogCreate(Integer.valueOf(config.get("productId")), queueId, id, config.get("name"), config.get("docType"), config.get("direction"), JsonUtil.toString(request), response);

        TableStructureListOutVoRecords records = databaseTableMapper.tableStructureOne(config.get("docType"));
        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map)) {
            if (!MallConstants.SUCCESS_CODE.equals(map.get(MallConstants.CODE_NAME))) {
                if (StringUtil.isNotNull(records)) {
                    mallCommonSyncApi.databaseTableDataDelete(records.getDbTableName(), queueId);
                }
            }
            if (MallConstants.OVERTIME_CODE.equals(map.get(MallConstants.CODE_NAME))) {
                Thread.currentThread().interrupt();
            }
        } else {
            if (StringUtil.isNotNull(records)) {
                mallCommonSyncApi.databaseTableDataDelete(records.getDbTableName(), queueId);
            }
        }
    }


}
