package com.system.serivce.impl;

import com.system.api.CommonHttpApi;
import com.system.constants.Constants;
import com.system.constants.MallCommonGetConstants;
import com.system.constants.MallCommonPostConstants;
import com.system.constants.MallCommonSyncConstants;
import com.system.serivce.IMallCommonSyncConfigService;
import com.system.transfer.configure.CommonConfigRefreshInVo;
import com.system.transfer.configure.InitConnectParamCheckInVo;
import com.system.transfer.configure.InitConnectParamRefreshInVo;
import com.system.transfer.response.RestResponse;
import com.system.utils.HttpUtil;
import com.system.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class MallCommonSyncConfigServiceImpl implements IMallCommonSyncConfigService {

    @Autowired
    private CommonHttpApi commonHttpApi;

    @Autowired
    private MallCommonGetConstants mallCommonGetConstants;

    @Autowired
    private MallCommonPostConstants mallCommonPostConstants;

    @Autowired
    private MallCommonSyncConstants mallCommonSyncConstants;


    @Override
    public RestResponse initConnectParamRefresh(InitConnectParamRefreshInVo inVo) {
        Map<String, Object> request = new HashMap<>(2);
        request.put("mobile", inVo.getAccount());
        request.put("password", inVo.getPassword());
        String response = HttpUtil.httpPost(inVo.getMallAddress() + "wx/auth/login_by_mobile", JsonUtil.toString(request)).getBody();

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map)) {
            if (map.containsKey(Constants.CODE_NAME) && HttpStatus.OK.value() == Integer.parseInt(String.valueOf(map.get(Constants.CODE_NAME)))) {
                Map<String, Object> data = JsonUtil.toMap(JsonUtil.toString(map.get(Constants.DATE_NAME)), String.class, Object.class);
                Map<String, Object> header = new HashMap<>(1);
                header.put("Authorization", data.get("token"));
                commonHttpApi.setHeader(header);
                commonHttpApi.setFlag(true);
            }
        } else {
            commonHttpApi.setFlag(false);
            return RestResponse.fail("商城配置错误!");
        }

        return RestResponse.success();
    }

    @Override
    public RestResponse initConnectParamCheck(InitConnectParamCheckInVo inVo) {
        Map<String, Object> request = new HashMap<>(2);
        request.put("mobile", inVo.getAccount());
        request.put("password", inVo.getPassword());
        String response = HttpUtil.httpPost(inVo.getMallAddress() + "wx/auth/login_by_mobile", JsonUtil.toString(request)).getBody();

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (CollectionUtils.isEmpty(map) || HttpStatus.OK.value() != Integer.parseInt(String.valueOf(map.get(Constants.CODE_NAME)))) {
            return RestResponse.fail("商城配置错误!");
        }
        return RestResponse.success();
    }

    @Override
    public void commonConfigRefresh(CommonConfigRefreshInVo inVo) {
        if (Constants.TWO.equals(inVo.getOperation())) {
            mallCommonPostConstants.refresh(inVo.getId(), inVo.getDocType());
        } else {
            mallCommonSyncConstants.refresh(inVo.getId(), inVo.getSFormId());
            mallCommonGetConstants.refresh(inVo.getId(), inVo.getDocType());
        }
    }


}
