package com.system.utils;

import com.system.config.ThreadLocalConfig;
import com.system.constants.Constants;
import com.system.constants.MallConstants;
import com.system.dao.ProductLogMapper;
import com.system.dao.SynchronizationRecordsMapper;
import com.system.transfer.log.ProductLogCreateInVo;
import com.system.transfer.mall.SynchronizationRecordsDeleteInVo;
import com.system.transfer.mall.SynchronizationRecordsUpdateInVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
public class ProductLogUtil {

    @Autowired
    private ProductLogMapper productLogMapper;

    @Autowired
    private SynchronizationRecordsMapper synchronizationRecordsMapper;


    public Integer isExist(String queueId) {
        return productLogMapper.getProductLogByQueueId(queueId);
    }

    public Integer productLogCreate(Integer productId, String queueId, String name, String code, String direction, String request, String response, Integer flag, Integer costTime) {
        ProductLogCreateInVo inVo = this.encapsulationInVo(productId, queueId, name, code, direction, request, response);
        inVo.setFlag(flag);
        if (costTime != 0) {
            inVo.setCostTime(costTime);
        }

        productLogMapper.productLogCreate(inVo);
        return inVo.getId();
    }

    public void productLogUpdate(Integer id, String response, Integer costTime) {
        ProductLogCreateInVo inVo = new ProductLogCreateInVo();
        inVo.setId(id);
        inVo.setResponse(response);
        if (costTime != 0) {
            inVo.setCostTime(costTime);
        }

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (MallConstants.SUCCESS_CODE.equals(map.get(MallConstants.CODE_NAME))) {
            inVo.setFlag(1);
        } else {
            inVo.setFlag(0);
            String message = String.valueOf(map.get("resultMsg"));
            List<Object> tempList = JsonUtil.toList(JsonUtil.toString(map.get("resultData")), Object.class);
            if (!CollectionUtils.isEmpty(tempList)) {
                message = message + " " + tempList.stream()
                        .map(m -> (String) JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class).get("Msg"))
                        .collect(Collectors.joining(", "));
            }
            inVo.setMessage(message);
        }

        productLogMapper.productLogUpdate(inVo);
    }

    public void productLogUpdate(Integer id, String response, String message, Integer costTime) {
        ProductLogCreateInVo inVo = new ProductLogCreateInVo();
        inVo.setId(id);
        inVo.setResponse(response);
        inVo.setMessage(message);
        inVo.setCostTime(costTime);
        if (StringUtil.isNotBlank(message)) {
            inVo.setFlag(0);
        } else {
            inVo.setFlag(1);
        }

        productLogMapper.productLogUpdate(inVo);
    }

    public void productHttpLogCreate(Integer productId, String queueId, Integer id, String name, String code, String direction, String request, String response) {
        ProductLogCreateInVo inVo = this.encapsulationInVo(productId, queueId, name, code, direction, request, response);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map)) {
            if (map.containsKey(MallConstants.CODE_NAME) && MallConstants.SUCCESS_CODE.equals(map.get(MallConstants.CODE_NAME))) {
                inVo.setFlag(1);
                synchronizationRecordsMapper.synchronizationRecordsDelete(new SynchronizationRecordsDeleteInVo(id));
            } else {
                inVo.setFlag(0);
                if (map.containsKey(MallConstants.MSG_NAME)) {
                    inVo.setMessage(map.get("resultMsg").toString());
                }
                synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, queueId, inVo.getMessage(), 2));
            }
        } else {
            inVo.setFlag(0);
            inVo.setMessage("请求响应信息错误");
            synchronizationRecordsMapper.synchronizationRecordsUpdate(new SynchronizationRecordsUpdateInVo(id, queueId, inVo.getMessage(), 2));
        }

        productLogMapper.productLogCreate(inVo);
    }

    public void productPushLogCreate(Integer productId, String queueId, String name, String code, String direction, String request, String response) {
        ProductLogCreateInVo inVo = this.encapsulationInVo(productId, queueId, name, code, direction, request, response);

        encapsulationOperation(response, inVo);
    }

    public void productSqlLogCreate(Integer productId, String queueId, String name, String code, String direction, String request, String response) {
        ProductLogCreateInVo inVo = this.encapsulationInVo(productId, queueId, name, code, direction, request, response);
        try {
            inVo.setRequest(DesHelperUtil.decrypt(request, StandardCharsets.UTF_8, "MES&&DES"));
        } catch (Exception e) {
            e.printStackTrace();
        }

        encapsulationOperation(response, inVo);
    }

    public void productSyncLogCreate(Integer productId, String queueId, String name, String code, String direction, String request, String response) {
        ProductLogCreateInVo inVo = this.encapsulationInVo(productId, queueId, name, code, direction, request, response);

        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map)) {
            if (MallConstants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.CODE_NAME)))) {
                inVo.setFlag(1);
            }
        } else {
            inVo.setFlag(0);
            inVo.setMessage(String.valueOf(map.get(Constants.ERROR_MESSAGE)));
        }
        productLogMapper.productLogCreate(inVo);
    }

    public void productSyncErrorLogCreate(Integer productId, String queueId, String name, String code, String direction, String request, String message) {
        ProductLogCreateInVo inVo = this.encapsulationInVo(productId, queueId, name, code, direction, request, message);

        inVo.setFlag(0);
        inVo.setMessage(message);

        productLogMapper.productLogCreate(inVo);
    }

    private ProductLogCreateInVo encapsulationInVo(Integer productId, String queueId, String name, String code, String direction, String request, String response) {
        ProductLogCreateInVo inVo = new ProductLogCreateInVo();
        inVo.setPlatformProductRelationId(productId);
        inVo.setName(name);
        inVo.setCode(code);
        inVo.setDirection(direction);
        inVo.setQueueId(queueId);
        inVo.setRequest(request);
        inVo.setResponse(response);

        Map<String, Object> map = ThreadLocalConfig.get();
        if (!CollectionUtils.isEmpty(map)) {
            int costTime = StringUtil.isNotNull(map.get("costTime")) ? Integer.parseInt(map.get("costTime").toString()) : 0;
            inVo.setCostTime(costTime);
        } else {
            inVo.setCostTime(0);
        }
        return inVo;
    }

    private void encapsulationOperation(String response, ProductLogCreateInVo inVo) {
        Map<String, Object> map = JsonUtil.toMap(response, String.class, Object.class);
        if (StringUtil.isNotBlank(response) && !CollectionUtils.isEmpty(map)) {
            if (map.containsKey(MallConstants.CODE_NAME) && MallConstants.SUCCESS_CODE.equals(map.get(MallConstants.CODE_NAME))) {
                inVo.setFlag(1);
            } else {
                inVo.setFlag(0);
                inVo.setMessage(String.valueOf(map.get("resultMsg")));
            }
        } else {
            inVo.setFlag(0);
        }

        productLogMapper.productLogCreate(inVo);
    }


}
